/*
Copyright (c) 2005, Jiye Zeng (http://www.zegraph.com/)

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

[1] Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer. 

[2] Neither the name of the organization nor the names of its contributors
may be used to endorse or promote products derived from this software
without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __ZS_TOKEN__
#define __ZS_TOKEN__

#ifdef _WIN32
#pragma warning(disable: 4786)
#pragma warning(disable: 4018)
#endif

#include <cassert>
#include <vector>
#include <string>
#include <stack>

//!Token scaner.
//
class zsTokens
{
public:
	//! Constructor.
	zsTokens() { }

	//! Destructor.
	~zsTokens() { }

	//! Scan script file or code string.
	void scan(const char *pname, const char *fname, bool codestring);

	//! Throw compile/run time error.
	void error(int idx, const char *msg=0, const char *msg2=0) const;

	//! Member access functions.

	int id(int idx) const { return _id[idx]; }

	const std::string& str(int idx) const { return _str[idx]; }

	int line(int idx) const { return _line[idx]; }

	const int size() const { return _id.size(); }

	const std::string& fname() const { return _fname; }

private:

	/// add a token
	void add(int id, const std::string& str, int line);

	std::string					_fname;			// script file name or code string

	std::vector<int>			_id, _line;		// token ID and line number

	std::vector<std::string>	_str;			// token string
};


#endif
