/*
Portable thread based on the source code of ...? I forgot.
Please inform me if your know the URL.
*/
#ifndef __THREAD_H__
#define __THREAD_H__

#ifdef _WIN32
#include <windows.h>
#include <process.h>
#else
#define WAIT_OBJECT_0 0x00000000L
#define WAIT_TIMEOUT 0x00000102L
#define INFINITE 0xFFFFFFFF
#include "pthread.h"
#include <sys/time.h>
#endif

#ifndef _WIN32
inline int Sleep(long msec )
{
	timeval delay;
	delay.tv_sec = msec/1000L;
	delay.tv_usec = (msec%1000L)*1000L;
	select(0, NULL, NULL, NULL, &delay);
}
#endif

class zsMutex
{
	zsMutex(const zsMutex& src);
	zsMutex& operator=(const zsMutex& src);
public:
	zsMutex()
	{
#ifdef _WIN32
		InitializeCriticalSection(&_handle);
#else
		pthread_mutex_init(&_handle, 0);
#endif
	}

	~zsMutex()
	{
#ifdef _WIN32
		DeleteCriticalSection(&_handle);
#else
		pthread_mutex_destroy(&_handle);
#endif
	}

	void lock()
	{
#ifdef _WIN32
		EnterCriticalSection(&_handle);
#else
		pthread_mutex_lock(&_handle);
#endif
	}

#ifndef _WIN32
	pthread_mutex_t &handle()
	{
		return _handle;
	}
#endif
	
	void unlock()
	{
#ifdef _WIN32
		LeaveCriticalSection(&_handle);
#else
		pthread_mutex_unlock(&_handle);
#endif
	}

private:
#ifdef _WIN32
	CRITICAL_SECTION _handle;
#else
	pthread_mutex_t _handle;
#endif
};

class zsAutoLock
{
public:
	zsAutoLock(zsMutex &mutex) : _mutex(mutex), _flag(true)
	{
		_mutex.lock();
	}

	zsAutoLock(zsMutex &mutex, bool flag) : _mutex(mutex), _flag(flag)
	{
		if (flag) _mutex.lock();
	}

	~zsAutoLock()
	{
		if (_flag) _mutex.unlock();
	}

private:
	zsMutex &_mutex;
	bool _flag;
};

class zsEvent
{
public:
	zsEvent()
	{
#ifdef _WIN32
		_handle = CreateEvent(0, false, false, 0);
#else
		pthread_cond_init(&_cond, 0);
		_signaled = false;
#endif
	}

	~zsEvent()
	{
#ifdef _WIN32
		CloseHandle(_handle);
#else
		pthread_cond_destroy(&_cond);
#endif
	}

	void set()
	{
#ifdef _WIN32
		SetEvent(_handle);
#else
		zsAutoLock lock(_mutex);
		pthread_cond_signal(&_cond);
		_signaled = true;
#endif
	}

	void reset()
	{
#ifdef _WIN32
		ResetEvent(_handle);
#else
		zsAutoLock lock(_mutex);
		_signaled = false;
#endif
	}

	int wait(size_t timeout=INFINITE)
	{
#ifdef _WIN32
		return WaitForSingleObject(_handle, timeout);
#else
		zsAutoLock lock(_mutex);
		if (_signaled) {
			_signaled = false;
			return WAIT_OBJECT_0;
		}
		_signaled = false;
		if (timeout == INFINITE) {
			pthread_cond_wait(&_cond, &_mutex.handle());
			return WAIT_OBJECT_0;
		}
		timespec ts;
		timeval tp;
		gettimeofday(&tp, NULL);
		ts.tv_sec  = tp.tv_sec + timeout/1000;
		ts.tv_nsec = tp.tv_usec*1000 + (timeout%1000)*1000000;
		if (pthread_cond_timedwait(&_cond, &_mutex.handle(), &ts) == 0) {
			return WAIT_OBJECT_0;
		}
		return WAIT_TIMEOUT;
#endif
	}

private:

#ifdef _WIN32
	mutable HANDLE _handle;
#else
	zsMutex _mutex;
	pthread_cond_t _cond;
	bool _signaled;
#endif
};

class zsThread;

class zsThreadJob
{
public:
	zsThreadJob() { }

	virtual ~zsThreadJob() { }

	virtual void do_job(zsThread *ptr) = 0;
};

class zsThread
{
public:
	zsThread();

	~zsThread();

	bool do_job(zsThreadJob*);

	void suspend() { _flag = FLAG_SUSPEND; }

	void resume() { _flag = FLAG_NORMAL; }

	bool busy() const { return _status!=THR_WAITING; }

	bool error() const { return _status==THR_ERROR; }

	void set_job(zsThreadJob *job) { _job = job; }

	zsThreadJob *get_job() { return _job; }

private:

#ifdef _WIN32
	static unsigned int __stdcall thread_func(void* data);
	HANDLE _handle;
#else
	static void* thread_func(void* data);
	pthread_t _handle;
#endif
	enum { THR_WAITING, THR_RUNNING, THR_END, THR_ERROR };
	enum { FLAG_NORMAL, FLAG_SUSPEND, FLAG_EXIT };
	zsThreadJob		*_job;
	zsEvent			_event;
	int				_status;
	int				_flag;
};


#endif
