/*
Portable thread based on the source code of ...? I forgot.
Please inform me if your know the URL.
*/

#include "thread.h"
#include <string>
#ifdef _DEBUG
#include <stdio.h>
#endif

#ifdef _WIN32
unsigned int __stdcall
#else
static void*
#endif
zsThread::thread_func(void* data)
{
	zsThread *t = (zsThread*)data;
try {
	for (;;) {
		t->_status = THR_WAITING;
		t->_event.wait();
		if (t->_flag == FLAG_EXIT) return 0;
		if (t->_flag == FLAG_SUSPEND) continue;
		t->_status = THR_RUNNING;
		if (t->_job) t->_job->do_job(t);
		if (t->_flag == FLAG_EXIT) return 0;
		t->_status = THR_END;
	}
}
catch(...) {
	t->_status = THR_ERROR;
}
	return 0;
}

zsThread::zsThread() : _handle(0), _job(0), _status(THR_END), _flag(FLAG_NORMAL)
{
#ifdef _WIN32
	unsigned int threadID = 0;
	_handle = (void*)_beginthreadex(0, 0, thread_func, this, 0, &threadID);
#else
	pthread_create(&_handle, 0, start_thread, this);
#endif
	while (_status != THR_WAITING) {
		Sleep(100);
	}
}

zsThread::~zsThread()
{
	_flag = FLAG_EXIT;
	_event.set();
#ifdef _WIN32
	WaitForSingleObject(_handle, 3000);
	if (!CloseHandle(_handle))
		TerminateThread(_handle, 0);
#else
	if (pthread_detach(_handle))
		pthread_cancel(_handle);
#endif
}

bool zsThread::do_job(zsThreadJob *job)
{
	if (_status == THR_WAITING) {
		_job = job;
		_event.set();
		return true;
	}
	return false;
}