#include <stdlib.h>
#include <string.h>

#include "scan.h"

#define	BSIZE	8192

#define	YYCTYPE		uchar
#define	YYCURSOR	cursor
#define	YYLIMIT		s->lim
#define	YYMARKER	s->ptr
#define	YYFILL(n)	{cursor = fill(s, cursor);}

#define	RET(i)	{s->cur = cursor; return i;}

uchar *fill(Scanner *s, uchar *cursor){
    if(!s->fd) return cursor;
	if(!s->eof) {
    	uint cnt = s->tok - s->bot;
	    if(cnt){
		    memcpy(s->bot, s->tok, s->lim - s->tok);
		    s->tok = s->bot;
		    s->ptr -= cnt;
		    cursor -= cnt;
		    s->pos -= cnt;
		    s->lim -= cnt;
	    }
    	if((s->top - s->lim) < BSIZE){
	    	uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
		    memcpy(buf, s->tok, s->lim - s->tok);
    		s->tok = buf;
	    	s->ptr = &buf[s->ptr - s->bot];
		    cursor = &buf[cursor - s->bot];
    		s->pos = &buf[s->pos - s->bot];
	    	s->lim = &buf[s->lim - s->bot];
		    s->top = &s->lim[BSIZE];
	    	free(s->bot);
		    s->bot = buf;
    	}
	    if((cnt = fread((char*)s->lim, 1, BSIZE, s->fd)) != BSIZE){
		    s->eof = &s->lim[cnt];
            *(s->eof)++ = '\n';
	    }
	    s->lim += cnt;
    }
   	return cursor;
}

int zs_scan(Scanner *s){
	uchar *cursor = s->cur;
std:
	s->tok = cursor;
/*!re2c
any	= [\000-\377];
D	= [0-9];
L	= [a-zA-Z_];
H	= [a-fA-F0-9];
E	= [Ee] [+-]? D+;
ESC	= [\\] [\001-\377];
*/

/*!re2c
	"/*"			{ goto comment1; }
	"//"			{ goto comment2; }
	
	"null"			{ RET(TOK_NIL); }
	"false"			{ RET(TOK_FALSE); }
	"true"          { RET(TOK_TRUE); }
	"break"			{ RET(TOK_BREAK); }
	"continue"		{ RET(TOK_CONTINUE); }
	"return"		{ RET(TOK_RETURN); }
	"if"			{ RET(TOK_IF); }
	"else"			{ RET(TOK_ELSE); }
	"for"			{ RET(TOK_FOR); }
    "do"  		    { RET(TOK_DO); }
	"while"			{ RET(TOK_WHILE); }
	"function"		{ RET(TOK_FUNCTION); }
	"import"		{ RET(TOK_IMPORT); }
	"try"   		{ RET(TOK_TRY); }
	"catch"   		{ RET(TOK_CATCH); }
	"new"   		{ RET(TOK_NEW); }
	"class"   		{ RET(TOK_CLASS); }
	"switch"   		{ RET(TOK_SWITCH); }
	"case"   		{ RET(TOK_CASE); }
	"goto"   		{ RET(TOK_GOTO); }
    "default"  		{ RET(TOK_DEFAULT); }
    "::"  		    { RET(TOK_GLOBAL); }
	
	("else" [" "\t\n\r]+ "if")
				    { RET(TOK_ELSEIF); }
				    
	L (L|D)*	    { RET(TOK_ID); }
	
	D+              { RET(TOK_INTEGER); }

    "0" [xX] H+     { RET(TOK_HEX); }
	
	(D+ E) | (D* "." D+ E?) | (D+ "." D* E?)
				    { RET(TOK_REAL); }
				    
	(['] (ESC | any\['\\])* ['])
				    { RET(TOK_STRING); }
	(["] (ESC | any\["\\])* ["])
				    { RET(TOK_STRING); }
	
	">>="			{ RET(TOK_RSHIFTEQ); }
	"<<="			{ RET(TOK_LSHIFTEQ); }
	"+="			{ RET(TOK_ADDEQ); }
	"-="			{ RET(TOK_SUBEQ); }
	"*="			{ RET(TOK_MULEQ); }
	"/="			{ RET(TOK_DIVEQ); }
	"%="			{ RET(TOK_MODEQ); }
	"&="			{ RET(TOK_ANDEQ); }
	"^="			{ RET(TOK_XOREQ); }
	"|="			{ RET(TOK_OREQ); }
	
	">>"			{ RET(TOK_RSHIFT); }
	"<<"			{ RET(TOK_LSHIFT); }
	"++"			{ RET(TOK_INCR); }
	"--"			{ RET(TOK_DECR); }
	"<="			{ RET(TOK_LEQ); }
	">="			{ RET(TOK_GEQ); }
	"=="			{ RET(TOK_EQL); }
	"!="			{ RET(TOK_NEQ); }
	
	"&&"			{ RET(TOK_LAND); }
	"||"			{ RET(TOK_LOR); }

	("*" [" "]* ":")    { RET(TOK_NIL_COL); }
	(":" [" "]* "*")    { RET(TOK_COL_NIL); }
	("*" [" "]* "]")    { RET(TOK_NIL_BRA); }
	("[" [" "]* "*")    { RET(TOK_BRA_NIL); }
	("*" [" "]* ",")    { RET(TOK_NIL_COM); }
	("," [" "]* "*")    { RET(TOK_COM_NIL); }

	"?"		    	{ RET('?'); }
	":"		    	{ RET(':'); }
	"."		    	{ RET('.'); }
	";" 			{ RET(';'); }
	"{"		    	{ RET('{'); }
	"}"		    	{ RET('}'); }
	","	    		{ RET(','); }
	"="		    	{ RET('='); }
	"("		    	{ RET('('); }
	")"		    	{ RET(')'); }
	"["		    	{ RET('['); }
	"]"		    	{ RET(']'); }
	"&"		    	{ RET('&'); }
	"!"		    	{ RET('!'); }
	"~"		    	{ RET('~'); }
	"-"		    	{ RET('-'); }
	"+"		    	{ RET('+'); }
	"*"		    	{ RET('*'); }
	"/"		    	{ RET('/'); }
	"%"		    	{ RET('%'); }
	"<"		    	{ RET('<'); }
	">"		    	{ RET('>'); }
	"^"		    	{ RET('^'); }
	"|"		    	{ RET('|'); }

	[ \t\v\f]+		{ goto std; }

	"\n"
	    {
		if(cursor == s->eof) RET(TOK_EOI);
		s->pos = cursor; s->line++;
		goto std;
	    }

	any
	    {
		{ RET(TOK_ANY); }
		goto std;
	    }
*/

comment1:
/*!re2c
	"*/"			{ goto std; }
	"\n"
	    {
		if(cursor == s->eof) RET(TOK_EOI);
		s->tok = s->pos = cursor; s->line++;
		goto comment1;
	    }
        any			{ goto comment1; }
*/

comment2:
/*!re2c
	"\n"
	    {
		if(cursor == s->eof) RET(TOK_EOI);
		s->tok = s->pos = cursor; s->line++;
		goto std;
	    }
        any			{ goto comment2; }
*/
}
