#ifndef __ZS_SCAN__
#define __ZS_SCAN__

typedef unsigned int uint;
typedef unsigned char uchar;

#include <stdio.h>

enum {
    TOK_EOI = 257,
    TOK_ANY,
    TOK_NIL,
	TOK_FALSE,
	TOK_TRUE,
    TOK_INTEGER,
    TOK_HEX,
    TOK_REAL,
    TOK_STRING,
    TOK_ID,
    TOK_BREAK,
    TOK_CONTINUE,
    TOK_RETURN,
    TOK_IF,
    TOK_ELSE,
    TOK_ELSEIF,
    TOK_FOR,
    TOK_WHILE,
    TOK_DO,
	TOK_NEGATE,			// unary -
    TOK_DECR,
    TOK_INCR,
    TOK_EQL,
    TOK_NEQ,
    TOK_GEQ,
    TOK_LEQ,
    TOK_LSHIFT,
    TOK_RSHIFT,
    TOK_ADDEQ,
    TOK_SUBEQ,
    TOK_MULEQ,
    TOK_DIVEQ,
    TOK_MODEQ,
    TOK_LSHIFTEQ,
    TOK_RSHIFTEQ,
    TOK_ANDEQ,          // &=
    TOK_OREQ,           // |=
    TOK_XOREQ,
    TOK_FUNCTION,
    TOK_IMPORT,
    TOK_TRY,
    TOK_CATCH,
    TOK_NEW,
    TOK_CLASS,
    TOK_SWITCH,
    TOK_CASE,
    TOK_DEFAULT,
    TOK_GOTO,
    TOK_GLOBAL,           
    TOK_LAND,           // &&
    TOK_LOR,            // ||
    TOK_DIV2,           // o1/o2 ->	(1.0/o2)*o1
	TOK_MOD2,			// o1%o2 -> fmod(o2, o1)
	TOK_SUB2,			// o1-o2 -> (-o2)+o1
    TOK_NIL_COL,        // *:
    TOK_COL_NIL,        // :*
    TOK_NIL_BRA,        // *]
    TOK_BRA_NIL,        // [*
    TOK_NIL_COM,        // *,
    TOK_COM_NIL         // ,*
};

typedef unsigned int uint;
typedef unsigned char uchar;

typedef struct Scanner {
    FILE*		fd;
    uchar		*bot, *tok, *ptr, *cur, *pos, *lim, *top, *eof;
    uint		line;
} Scanner;

int zs_scan(Scanner *s);

#endif
