#ifndef __ZS_REFCOUNT__
#define __ZS_REFCOUNT__

#include "pool.h"

template <class T> class zsRCP;

//! Reference counted base class.
//
template <class T> class rcBase
{
	friend class	zsRCP<T>;
public:
	rcBase() : _count(0) { }

	long		_count;
};

//! Reference counted pointer class.
/*!
 This code is based on C++ FAQ, CodeProject, and other sources.
*/

template <class T> class zsRCP  
{
	T*		_ptr;
        
public:

	//! Default constructor.
	zsRCP() : _ptr(0) {}

	//! Initializing constructor.
	zsRCP(T* ptr) : _ptr(ptr) { if (_ptr) _ptr->_count++; }

	//! Copy constructor.
	zsRCP(const zsRCP<T>& src) { copyfrom(src); }
        
	//! Destructor.
	virtual ~zsRCP() { release(); }
        
	//! Assigment operator.
	zsRCP<T>& operator= (const zsRCP<T>& src)
	{
		if (&src != this)
		{
			release();
			copyfrom(src);
		}
		return *this;
	}

	//! Equal comparison.
	bool operator== (const zsRCP<T>& rhs) const {return _ptr == rhs._ptr;}

	//! Convenient pointer operator.
	const T* operator->() const {return _ptr;}
		  T* operator->()		{return _ptr;}

	//! Convenient pointer operator.
	const T& operator*() const {return *_ptr;}
		  T& operator*()	   {return *_ptr;}
        
	//! Convenient pointer operator.
	const T* get() const {return _ptr;}
		  T* get()		 {return _ptr;}

	//! Convenient pointer operator.
	bool isNull() const {return _ptr == 0;}
        
	//! Release the reference.
	void release()    
	{ 
		if (!_ptr) return;
		_ptr->_count--;
		if (_ptr->_count == 0) zs_destroy(_ptr);
	}
        
private:
	// make a copy of the source object.
	void copyfrom(const zsRCP<T>& src)
	{
		_ptr = src._ptr;
		if (_ptr) _ptr->_count++;
	}
};


#endif
