/*
Copyright (c) 2005, Jiye Zeng (http://www.zegraph.com/)

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

[1] Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer. 

[2] Neither the name of the organization nor the names of its contributors
may be used to endorse or promote products derived from this software
without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __ZS_POOL__
#define __ZS_POOL__

#include "config.h"
#include <string>

class zoObject;
class zoNumber;
class zoString;
class zoUser;
class zoClass;
class zoArray;
class zsContext;
class zsClassExpr;

typedef void (*zsDestroyFunc)(void*);

typedef zoObject* (*zsPrimitiveFunc)(zsContext* ctx, int nargs, zoObject** args);

zoObject *zs_create_null(zsContext *ctx);

zoNumber *zs_create_integer(zsContext *ctx, integer_t value);

zoNumber *zs_create_real(zsContext *ctx, real_t value);

zoString *zs_create_string(zsContext *ctx, const std::string& s);

zoClass *zs_create_class(zsContext *ctx, zsClassExpr *cls);

zoUser *zs_create_user(zsContext *ctx, void *ptr, zsPrimitiveFunc opfunc, zsDestroyFunc destroy, int type);

zoArray *zs_create_array(zsContext *ctx, int size);

void zs_destroy(zoObject *o);

#endif
