/*
Copyright (c) 2005, Jiye Zeng (http://www.zegraph.com/)

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

[1] Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer. 

[2] Neither the name of the organization nor the names of its contributors
may be used to endorse or promote products derived from this software
without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __ZS_PARSE__
#define __ZS_PARSE__

#include "scan.h"

class zsBaseExpr;
class zsModuleExpr;

/// string representation of operators
inline const char* zs_operator_symbol(int op)
{
	switch (op) {
	case '.':				return ".";
	case TOK_NEGATE:		return " - ";
	case TOK_INCR:			return " ++ ";
	case TOK_DECR:			return " -- ";
	case '!':				return " ! ";
	case '~':				return " ~ ";
	case '*':				return " * ";
	case '/':				return " / ";
	case '%':				return " % ";
	case '-':				return " - ";
	case '+':				return " + ";
	case TOK_RSHIFT:		return " >> ";
	case TOK_LSHIFT:		return " << ";
	case TOK_LEQ:			return " <= ";
	case TOK_GEQ:			return " >= ";
	case '<':				return " < ";
	case '>':				return " > ";
	case TOK_EQL:			return " == ";
	case TOK_NEQ:			return " != ";
	case '^':				return " ^ ";
	case '&':				return " & ";
	case '|':				return " | ";
	case TOK_LAND:			return " && ";
	case TOK_LOR:			return " || ";
	case ':':				return " : ";
	case '?':				return " ? ";
	case TOK_RSHIFTEQ:		return " >>= ";
	case TOK_LSHIFTEQ:		return " <<= ";
	case TOK_ADDEQ:			return " += ";
	case TOK_SUBEQ:			return " -= ";
	case TOK_MULEQ:			return " *= ";
	case TOK_DIVEQ:			return " /= ";
	case TOK_MODEQ:			return " %= ";
	case TOK_ANDEQ:			return " &= ";
	case TOK_XOREQ:			return " ^= ";
	case TOK_OREQ:			return " |= ";
	case '=':				return " = ";
	}
	return " ";
}

/// operator precedence
inline int zs_precedence(int op)
{
	switch (op) {
	case '.':
		return 0;
	case TOK_NEGATE:			// unary -
	case TOK_INCR:				// ++
	case TOK_DECR:				// --
	case '!':
	case '~':
		return 1;
	case '*':
	case '/':
	case '%':
		return 2;
	case '-':
	case '+':
		return 3;
	case TOK_RSHIFT:			// >>
	case TOK_LSHIFT:			// <<
		return 4;
	case TOK_LEQ:				// <=
	case TOK_GEQ:				// >=
	case '<':
	case '>':
		return 5;
	case TOK_EQL:				// ==
	case TOK_NEQ:				// !=
		return 6;
	case '^':
	case '&':
	case '|':
		return 7;
	case TOK_LAND:				// &&
	case TOK_LOR:				// ||
		return 8;
	case ':':
		return 9;
	case '?':
		return 10;
	case TOK_RSHIFTEQ:			// >>=
	case TOK_LSHIFTEQ:			// <<=
	case TOK_ADDEQ:				// +=
	case TOK_SUBEQ:				// -=
	case TOK_MULEQ:				// *=
	case TOK_DIVEQ:				// /=
	case TOK_MODEQ:				// %=
	case TOK_ANDEQ:				// &=
	case TOK_XOREQ:				// ^=
	case TOK_OREQ:				// |=
	case '=':
		return 11;
	}
	return -1;
}

/// the parser function
zsBaseExpr* zs_parse(zsBaseExpr* caller, int &idx, int opening, int closure);


#endif
