/*
Copyright (c) 2005, Jiye Zeng (http://www.zegraph.com/)

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

[1] Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer. 

[2] Neither the name of the organization nor the names of its contributors
may be used to endorse or promote products derived from this software
without specific prior written permission. 

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __ZS_CONFIG__
#define __ZS_CONFIG__

#ifdef _WIN32

#pragma warning(disable: 4786)
#pragma warning(disable: 4251)
#pragma warning(disable: 4275)
#pragma warning(disable: 4996)
#pragma warning(disable: 4244)
#pragma warning(disable: 4199)

#include <windows.h>
#define DLL_EXTENSION	".dll"
#define LoadError() printf("Load error code: %d\n",GetLastError())

#else   // _WIN32

#include <dirent.h>
#include <dlfcn.h>
#include <sys/stat.h>
#define DLL_EXTENSION	".so"
typedef void* HINSTANCE;
#define LoadLibrary(path) dlopen(path,RTLD_NOW|RTLD_LOCAL)
#define FreeLibrary(lib)
#define LoadError() printf("%s\n",dlerror())

#endif	// _WIND32

//Define to use memory pool 
//#define USE_POOL

#define POOL_SIZE				32

#define DEFAULT_TABLE_SIZE		13
#define PRIMITIVE_TABLE_SIZE	1013

//Define to use syslib.cpp
//#define USE_SYSLIB

#include "api.h"

#endif  // __ZS_CONFIG__
