#ifndef __ZS_BUFFER__
#define __ZS_BUFFER__

#include <cstdlib>

class zsBuffer
{
public:
	zsBuffer(size_t size=0)
    {
        u.ptr = 0;
        if (size > 0) u.ptr = malloc(size);
    }

	~zsBuffer()
    {
        if(u.ptr) free(u.ptr);
    }

    void resize(size_t size)
    {
        if(u.ptr) free(u.ptr);
        u.ptr = 0;
        if (size > 0) u.ptr = malloc(size);
    }

	union {
		void			*ptr;
		char			*pchar;
		signed char		*pschar;
		unsigned char	*puchar;
		short			*pshort;
		unsigned short	*pushort;
		int				*pint;
		unsigned int	*puint;
		float			*pfloat;
		double			*pdouble;
	} u;
};

#endif
