#ifndef __ZE_VERTEX__
#define __ZE_VERTEX__

#include "object.h"
#include <vector>
#include <math.h>

///
/// The zeVertex class is used to assign vertex and normal coordinates to shapes.
///
class zeVertex : public zeObject
{
public:
	/// Constructor.
	zeVertex() { setType(ZE_VERTEX); }

	/// Destructor.
	virtual ~zeVertex() { };

	/// Add a vertex to the end. 
	void add(const ZExyz &xyz) { _xyz.push_back(xyz); }

	void add(GLfloat x, GLfloat y, GLfloat z)
	{
		ZExyz xyz = { x, y, z };
		_xyz.push_back(xyz);
	}

	/// Remvoe a vertex frome the end. 
	void pop() { _xyz.pop_back(); }

	/// Clear vertex vector.
	void clear() { _xyz.clear(); }

	/// Resize vertex vector.
	void resize(size_t size) { _xyz.resize(size); }

	/// Reserve vertex vector size.
	void reserve(size_t size) { _xyz.reserve(size); }

	/// Vertex vector size.
	size_t size() const { return _xyz.size(); }

	/// Set/get data at the index.
	void set(size_t idx, const ZExyz &xyz) { _xyz[idx] = xyz; }

	// Member access
	const ZExyz & get(size_t idx) const { return _xyz[idx]; }

	const GLfloat & x(size_t idx) const { return _xyz[idx].x; }
  	      GLfloat & x(size_t idx)       { return _xyz[idx].x; }

	const GLfloat & y(size_t idx) const { return _xyz[idx].y; }
	      GLfloat & y(size_t idx)       { return _xyz[idx].y; }

	const GLfloat & z(size_t idx) const { return _xyz[idx].z; }
	      GLfloat & z(size_t idx)       { return _xyz[idx].z; }

	const void *ptr() const { return &_xyz[0]; }
	      void *ptr()       { return &_xyz[0]; }

private:

	std::vector<ZExyz>	_xyz;
};

#endif	// __ZE_VERTEX__