#ifndef __ZE_UTILITY__
#define __ZE_UTILITY__

#include "gd.h"

#include <cassert>
#include <sstream>
#include <string>
#include <vector>

#define PI				3.14159265358979
#define DEG_TO_RAD		0.01745329251994 
#define RAD_TO_DEG		57.2957795130823 
#define PI2				6.28318530717959
#define EPS				1.e-9

#ifndef max
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#endif

/// Closest texture size.
size_t texture_size(size_t size);

/// Parse hex number.
int
axtoi(char *hexStg, int len);

/// Convert longitude-latitude to x-y-z spherical surface.
void
ll2xyz(double &x, double &y, double &z, double lon, double lat, double r);

/// Convert x-y-z spherical surface to longitude-latitude.
void
xyz2ll(double &lon, double &lat, double x, double y, double z);

/// Convert movement on spherical surface.
void
dxdy2ll(double &lon, double &lat, double dx, double dy, double re);

/********************************************************************
 * Aitoff projection.
 *
 * Based on the equations
 *      x = 2 * a * cos(lat) * sin(0.5 *lon) / sin(a)
 *      y = a * sin(lat) / sin(a)
 *      cos(a) = cos(lat) * cos(0.5 * lon)
 *       
 * of Cartographic Projection Procedures
 * by G.I. Evenden, September 24, 1995
 *  
 * lon and lat are expected to vary from -180 to 180 and
 * from -90 to 90, respectively. Resulted lon varies from
 * -3.06 to 3.10 and lat from -1.48 to 1.54.
 ********************************************************************/
void
aitoff(double &x, double &y, double lon, double lat);

/********************************************************************
 * Denoyer projection.
 *    
 * Based on the equations:
 *      x = lon * cos((0.95 - lon/12 + lon^3/600) * lat)
 *       y = lat
 * of Cartographic Projection Procedures by
 * G.I. Evenden, September 24, 1995
 *  
 * lon and lat are expected to vary from -180 to 180 and
 * from -90 to 90, respectively. Resulted lon varies from
 * -3.07 to 3.10 and lat from -1.37 to 1.46.
 ********************************************************************/
void
denoyer(double &x, double &y, double lon, double lat);

/********************************************************************
 * Eckert V projection.
 *
 * Based on the equations
 *      x = lon * (1 + cos(lat)) / sqrt(2 + pi)
 *      y = 2 * lat / sqrt(2 + pi)
 * of Cartographic Projection Procedures
 * by G.I. Evenden, September 24, 1995
 *   
 * lon and lat are expected to vary from -180 to 180 and
 * from -90 to 90, respectively. Resulted lon varies from
 * -2.71 to 2.74 and lat from -1.21 to 1.28.
 ********************************************************************/
void
echert(double &x, double &y, double lon, double lat);

/********************************************************************
 * Wagner II projection.
 *
 * Based on the equations:
 *      x = 0.92483 * lon * cos(theta)
 *      y = 1.38725 * theta
 *      sin(theta) = 0.88022 * sin(0.8855 * lat)
 * of Cartographic Projection Procedures
 * by G.I. Evenden, September 24, 1995
 *   
 * lon and lat are expected to vary from -180 to 180 and
 * from -90 to 90, respectively. Resulted lon varies from
 * -2.84 to 2.84 and lat from -1.34 to 1.34.
 ********************************************************************************/
void
wagner(double &x, double &y, double lon, double lat);


/********************************************************************
 * Load/save image using GD lib.
 ********************************************************************************/
gdImagePtr
load_image(const char *fname);

bool
save_image(const char *fname, gdImagePtr img);


FILE *open_file(const char *fname, const char *mode);

void close_file(FILE *fp);

void error_msg(const char *msg1, const char *msg2=0, const char *msg3=0);

#endif	// __ZE_UTILITY__