#ifndef __ZE_TRANSFORM__
#define __ZE_TRANSFORM__

#include "object.h"

enum { NONE, ROTATEX, ROTATEY, ROTATEZ, TRANSLATE, SCALE };

///
/// This pure abstract class is for construcion of objects that need to be transform in rendering.
/// The transform order is determined by the sequence of setting rotation, scaling, and translation.
///
class zeTransform : public zeObject
{
public:
	/// Constructor
	zeTransform();

	/// Destructor
	~zeTransform() {}

	/// Perform tranforms.
	virtual void render(ZEoption & option);

	/// Draw function to be extended derived class.
	virtual void drawFunc(ZEoption & option) { }

	/// Set/get transforms.
	void rotateX(GLfloat angle);

	void rotateY(GLfloat angle);

	void rotateZ(GLfloat angle);

	void translate(const ZExyz &xyz);

	void scale(const ZExyz &xyz);

	/// Reset transform to none
	void reset();

	/// For VMRL callback;
	const int* getRST() const { return _rst; }

	const ZExyz& getRotate() const { return _rotate; }

	const ZExyz& getTranslate() const { return _trans; }

	const ZExyz& getScale() const { return _scale; }

protected:
	int			_rst[5];

	bool		_rstOn;

	ZExyz		_rotate, _trans, _scale;
};

#endif	// __ZE_TRANSFORM__