#include "transform.h"


zeTransform::zeTransform() : _rstOn(false)
{
	reset();
	_scale.x = _scale.y = _scale.z = 1.0;
	_rotate.x = _rotate.y = _rotate.z = 0;
	_trans.x = _trans.y = _trans.z = 0;
}

void
zeTransform::render(ZEoption & option)
{
	if (!enabled()) return;

	if (_rstOn) {
		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		for (int i = 4; i >= 0; i--) {
			switch (_rst[i]) {
			case ROTATEX:
				glRotated(_rotate.x, 1, 0, 0);
				break;
			case ROTATEY:
				glRotated(_rotate.y, 0, 1, 0);
				break;
			case ROTATEZ:
				glRotated(_rotate.z, 0, 0, 1);
				break;
			case TRANSLATE:
				glTranslated(_trans.x, _trans.y, _trans.z);
				break;
			case SCALE:
				glScaled(_scale.x, _scale.y, _scale.z);
				glEnable(GL_NORMALIZE);
				break;
			}
		}
		drawFunc(option);
		glMatrixMode(GL_MODELVIEW);
		glPopMatrix();
	}
	else {
		drawFunc(option);
	}
}

void
zeTransform::rotateX(GLfloat angle)
{
	_rotate.x = angle;
	_rstOn = true;
	for (int i = 0; i < 5; i++) {
		if (_rst[i] == ROTATEX) return;
		if (_rst[i] == NONE) {
			_rst[i] = ROTATEX;
			return;
		}
	}
}

void
zeTransform::rotateY(GLfloat angle)
{
	_rotate.y = angle;
	_rstOn = true;
	for (int i = 0; i < 5; i++) {
		if (_rst[i] == ROTATEY) return;
		if (_rst[i] == NONE) {
			_rst[i] = ROTATEY;
			return;
		}
	}
}

void
zeTransform::rotateZ(GLfloat angle)
{
	_rotate.z = angle;
	_rstOn = true;
	for (int i = 0; i < 5; i++) {
		if (_rst[i] == ROTATEZ) return;
		if (_rst[i] == NONE) {
			_rst[i] = ROTATEZ;
			return;
		}
	}
}

void
zeTransform::translate(const ZEvertex &xyz)
{
	_trans = xyz;
	_rstOn = true;
	for (int i = 0; i < 5; i++) {
		if (_rst[i] == TRANSLATE) return;
		if (_rst[i] == NONE) {
			_rst[i] = TRANSLATE;
			return;
		}
	}
}

void
zeTransform::scale(const ZEvertex &xyz)
{
	_scale = xyz;
	if (_scale.x <= 0) _scale.x = 1;
	if (_scale.y <= 0) _scale.y = 1;
	if (_scale.z <= 0) _scale.z = 1;
	_rstOn = true;
	for (int i = 0; i < 5; i++) {
		if (_rst[i] == SCALE) return;
		if (_rst[i] == NONE) {
			_rst[i] = SCALE;
			return;
		}
	}
}

void
zeTransform::reset()
{
	_rstOn = false;
	_rst[0] = _rst[1] = _rst[2] = _rst[3] = _rst[4] = NONE;
}