#ifndef __ZE_TEXTURE__
#define __ZE_TEXTURE__

#include "object.h"
#include <vector>
#include <string>


class zeColorBar;

///
/// All object in this node will be textured when rendered.
///
class zeTexture : public zeObject
{
public:
	/// Constructor.
	zeTexture();

	/// Destructor.
	virtual ~zeTexture();

	/// Extended render function.
	virtual void render(ZEoption & option);

	/// Set the image file to be used as the texture source.
	bool setImage(const char* fname, int R, int G, int B);

	/// Set image in RGBA
	void setImage(GLubyte *ptr, size_t nrow, size_t ncol);

	/// Set image according to data.
	void setImage(double *data, size_t nrow, size_t ncol, zeColorBar *cbar);

	GLsizei  width()  const { return _width; }

	GLsizei  height() const { return _height; }

	double s() const { return _s; }
	double t() const { return _t; }

private:
	void fill(int nrow, int ncol);

private:
	std::vector<GLubyte>	_image;
	GLsizei					_width;
	GLsizei					_height;
	double					_s, _t;
	GLuint					_id;
};

#endif	// __ZE_TEXTURE__