#include "colorbar.h"
#include "texture.h"
#include "utility.h"

using namespace std;


zeTexture::zeTexture() : _width(0), _height(0), _s(0), _t(0)
{
	setType(ZE_TEXTURE);
	glGenTextures(1, &_id);
}

zeTexture::~zeTexture()
{
	glDeleteTextures(1, &_id);
}

void
zeTexture::render(ZEoption & option)
{
	if (!enabled()) {
		glDisable(GL_TEXTURE_2D);
		return;
	}

	glBindTexture(GL_TEXTURE_2D, _id);
	glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
	glTexImage2D(GL_TEXTURE_2D, 0, 4, _width, _height, 0, GL_RGBA, GL_UNSIGNED_BYTE, &_image[0]);

	glEnable(GL_TEXTURE_2D);
	glEnable(GL_COLOR_MATERIAL);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
}

bool
zeTexture::setImage(const char* fname, int R, int G, int B)
{
	gdImagePtr img = load_image(fname);
	if (!img) error_msg("failed to load image");

	int ncol = gdImageSX(img);
	int nrow = gdImageSY(img);

	_width = texture_size(ncol);
	_height = texture_size(nrow);
	_s = double(ncol)/_width;
	_t = double(nrow)/_height;

	if (nrow > _height || ncol > _width) {
		gdImageDestroy(img);
		return false;
	}

	_image.resize(_height * _width * 4);

	int row, col, k;

	for (row = 0; row < nrow; row++) {
		k = (nrow-row-1) * _width * 4;
		for (col = 0; col < ncol; col++) {
			int rgb = gdImageGetPixel(img, col, row);
			unsigned char r = gdImageRed(img, rgb);
			unsigned char g = gdImageGreen(img, rgb);
			unsigned char b = gdImageBlue(img, rgb);
			_image[k++] = r;
			_image[k++] = g;
			_image[k++] = b;
			if (r == R && g == G && b == B) {
				_image[k++] = 0;
			}
			else {
				_image[k++] = 255;
			}
		}
	}

	gdImageDestroy(img);

	fill(nrow, ncol);

	return true;
}

void
zeTexture::setImage(double *data, size_t nrow, size_t ncol, zeColorBar *cbar)
{
	_height = texture_size(nrow);
	_t = double(nrow)/_height;
	_width = texture_size(ncol);
	_s = double(ncol)/_width;

	_image.resize(_width * _height * 4);

	for (int row = 0; row < nrow; row++) {
		int k = row * ncol;
		int l = row * _width * 4;
		for (int col = 0; col < ncol; col++) {
			ZEcolor color = cbar->getColor(data[k+col]);
			_image[l++] = color.r*255;
			_image[l++] = color.g*255;
			_image[l++] = color.b*255;
			_image[l++] = 255;
		}
	}

	fill(nrow, ncol);
}

void
zeTexture::setImage(GLubyte *ptr, size_t nrow, size_t ncol)
{
	_height = texture_size(nrow);
	_t = double(nrow)/_height;
	_width = texture_size(ncol);
	_s = double(ncol)/_width;

	_image.resize(_width * _height * 4);

	int k = 0;
	for (int row = 0; row < nrow; row++) {
		int l = row * _width * 4;
		for (int col = 0; col < ncol; col++) {
			_image[l++] = ptr[k++];
			_image[l++] = ptr[k++];
			_image[l++] = ptr[k++];
			_image[l++] = ptr[k++];
		}
	}

	fill(nrow, ncol);
}

void
zeTexture::fill(int nrow, int ncol)
{
	if (nrow <= 0 || ncol <= 0) return;

	for (int row = 0; row < nrow; row++) {
		int l = (row*_width + ncol-1) * 4;
		GLubyte r = _image[l++];
		GLubyte g = _image[l++];
		GLubyte b = _image[l++];
		GLubyte a = _image[l++];
		for (int col = ncol; col < _width; col++) {
			_image[l++] = r;
			_image[l++] = g;
			_image[l++] = b;
			_image[l++] = a;
		}
	}

	for (int col = 0; col < _width; col++) {
		int l = ((nrow-1)*_width + col) * 4;
		GLubyte r = _image[l++];
		GLubyte g = _image[l++];
		GLubyte b = _image[l++];
		GLubyte a = _image[l++];
		for (int row = nrow; row < _height; row++) {
			l = (row*_width + col) * 4;
			_image[l++] = r;
			_image[l++] = g;
			_image[l++] = b;
			_image[l++] = a;
		}
	}
}