#ifndef __ZE_TEXT__
#define __ZE_TEXT__

#define ST_OFF		2

#include "freefont.h"
#include "transform.h"
#include "utility.h"


#include <vector>

///
/// Texture text using freetype library.
///
class zeText : public zeTransform
{
public:
	/// Constructor.
	zeText();

	/// Destructor.
	virtual ~zeText();

	/// Extended render function.
	virtual void drawFunc(ZEoption & option);

	/// Set font size in point.
	void setFontSize(size_t point) { _fontSize = max(point, 6); }

	/// Set the text to be rendered.
	void setText(const char *str);

	/// Text color;
	void setColor(const ZEcolor &color) {_color = color;}

	/// Image with of the render text string.
	int width() const { return _texWidth; }

	/// Image height of the render text string.
	int height() const { return _texHeight; }

	/// Set font engine
	void setFont(zeFreetype *font) { _font = font; }
	
	/// Get font engine
	zeFreetype *getFont() { return _font; }

	size_t fontSize() const { return _fontSize; }

	int top() const { return _top; }
	int bottom() const { return _bottom; }
	int left() const { return _left; }
	int right() const { return _right; }


private:
	void add_string(const std::string &str, int flag, std::vector<GLubyte> &bmp, int bmpH, int bmpW, int &row1, int &row2);

	void add_unicode(unsigned short code, int flag, std::vector<GLubyte> &bmp, int bmpH, int bmpW, int &row1, int &row2);

	int font_size(int flag);

private:
	zeFreetype				*_font;

	size_t					_fontSize;

	std::vector<GLubyte>	_bmp;
	size_t					_bmpW, _bmpH;

	int						_texWidth, _texHeight;
	int						_left, _right, _top, _bottom;

	GLfloat					_s, _t;

	ZEcolor					_color;

	int						_dpi;
};

#endif	// __ZE_TEXT__