#ifndef __ZE_TEXCOORD__
#define __ZE_TEXCOORD__

#include "object.h"
#include <vector>

#define ST_MIN 0.00001
#define ST_MAX 0.99999

#define MIN(a,b) ((a)<(b)?(a):(b));
#define MAX(a,b) ((a)>(b)?(a):(b));

///
/// The zeTexcoord class is used to assign texture coordinates to shapes. 
///
class zeTexCoord : public zeObject
{
public:
	/// Constructor.
	zeTexCoord() { setType(ZE_TEXCOORD); }

	/// Destructor.
	virtual ~zeTexCoord() { };

	/// Add a texture coordinate. 
	void add(GLfloat s, GLfloat t)
	{
		s = MAX(s, ST_MIN);
		s = MIN(s, ST_MAX);
		t = MAX(t, ST_MIN);
		t = MIN(t, ST_MAX);
		ZEtexcoord st = { s, t };
		_st.push_back(st);
	}

	/// Clear texture coordinate vector.
	void clear() { _st.clear(); }

	/// Resize texture coordinate vector.
	void resize(size_t size) { _st.resize(size); }

	/// Reserve texture coordinate vector.
	void reserve(size_t size) { _st.reserve(size); }

	/// Vertex vector size.
	size_t size() const { return _st.size(); }

	/// Set/get data at the index.
	void set(size_t idx, GLfloat s, GLfloat t)
	{
		if (idx < _st.size()) {
			s = MAX(s, ST_MIN);
			s = MIN(s, ST_MAX);
			t = MAX(t, ST_MIN);
			t = MIN(t, ST_MAX);
			ZEtexcoord st = { s, t };
			_st[idx] = st;
		}
	}

	const ZEtexcoord & get(size_t idx) const { return _st[idx]; }

	const void *ptr() const { return &_st[0]; }
	      void *ptr()       { return &_st[0]; }

	const GLfloat & s(size_t idx) const { return _st[idx].s; }
  	      GLfloat & s(size_t idx)       { return _st[idx].s; }

	const GLfloat & t(size_t idx) const { return _st[idx].t; }
  	      GLfloat & t(size_t idx)       { return _st[idx].t; }

private:

	std::vector<ZEtexcoord>	_st;
};

#endif	// __ZE_TEXCOORD__