#ifndef __ZE_SCENE__
#define __ZE_SCENE__

#include "node.h"

///
/// A scene containd a root node, which in turn contains nodes or objects to form
/// a complete graph tree of objects.
///
class zeScene : public zeObject
{
public:
	/// Constructor.
	zeScene();

	/// Destructor.
	virtual ~zeScene() { }

	/// Render function to be called by the render object.
	void render();

	/// Set/get default color for all object in this scene
	void setColor(const ZEcolor &color) { _option.color = color; }

	/// Set the root node.
	void setNode(zeNode *node) { _node = zeRCP<zeNode>(node); node->setParent(this); }

	/// Set OpenGL view port.
	void setViewport(int x, int y, size_t w, size_t h, GLfloat scale = 1);

	/// Set camera.
	void setLookAt(GLfloat ex, GLfloat ey, GLfloat ez, GLfloat cx, GLfloat cy, GLfloat cz, GLfloat ux, GLfloat uy, GLfloat uz)
	{
		_ex=ex; _ey=ey; _ez=ez; _cx=cx; _cy=cy; _cz=cz; _ux=ux; _uy=uy; _uz=uz;
	}

	/// Use orthogonal projection.
	void ortho();
	
	/// Use perspective projection.
	void perspective(GLfloat scale);

	/// Add an object to the scene.
	zeNode *add(zeObject *obj);

	/// Set view port unit.
	void unit(int unit) { _option.unit = unit; }

	int width() const { return _viewportW; }
	int height() const { return _viewportH; }

private:
	zeRCP<zeNode>		_node;

	ZEoption			_option;

	int 				_viewportX;
	int 				_viewportY;
	size_t				_viewportW;
	size_t				_viewportH;

	GLfloat				_ex, _ey, _ez, _cx, _cy, _cz, _ux, _uy, _uz;
};

#endif	// __ZE_SCENE__