#include "scene.h"
#include "utility.h"
#include <cmath>
#include <vector>

zeScene::zeScene()
{
	setType(ZE_SCENE);
	_option.perspective = false;
	_option.color.r = _option.color.g = _option.color.b = 0;
	_option.color.a = 1;
	_option.unit = 1;
	_ex = _ey = _ez = _cx = _cy = _cz = _ux = _uy = _uz = 0;
	setViewport(0, 0, 512, 512);
}

void
zeScene::render()
{
	if (!enabled() || _node.isNull()) return;

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	if (_option.perspective) {
		if (_option.unit == 1) {
			GLfloat fovy = 2.0*atan2(0.5*min(_viewportW, _viewportH), 0.5*(_option.zmax - _option.zmin));
			fovy *= RAD_TO_DEG;
			gluPerspective(fovy, _viewportW / _viewportH, _option.zmin, _option.zmax);
			glTranslated(0.0, 0.0, -0.5*(_option.zmax - _option.zmin));
		}
		else {
			// experimental
			GLfloat fovy = 2.0*atan2(0.5*min(_viewportW, _viewportH), 0.5*(_option.zmax - _option.zmin));
			fovy *= RAD_TO_DEG;
			gluPerspective(fovy, _viewportW / _viewportH, 0.01, _option.zmax-_option.zmin);
			glTranslated(0.0, 0.0, -0.5*(_option.zmax - _option.zmin));
		}
	}
	else {
		if (_option.unit == 1) {
			glOrtho(_option.xmin, _option.xmax, _option.ymin, _option.ymax, _option.zmin, _option.zmax);
		}
		else {
			// experimental
			glOrtho(-1, 1, _option.xmin/float(_option.ymin), _option.xmax/float(_option.ymax), -1, 1);
		}
	}

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	if (_ex != _cx || _ey != _cy || _ez != _cz) gluLookAt(_ex, _ey, _ez, _cx, _cy, _cz, _ux, _uy, _uz);
	
	glViewport(_viewportX, _viewportY, _viewportW, _viewportH);

	glColor4f(_option.color.r, _option.color.g, _option.color.b, _option.color.a);
	
	glRenderMode(GL_RENDER);

	_node->render(_option);
}

void
zeScene::setViewport(int x, int y, size_t w, size_t h, GLfloat scale)
{
	_viewportX = x;
	_viewportY = y;
	_viewportW = max(w, 32);
	_viewportH = max(h, 32);

	_option.xmax =  0.5 * _viewportW;
	_option.xmin = -_option.xmax;
	_option.ymax =  0.5 * _viewportH;
	_option.ymin = -_option.ymax;

	if (_option.perspective) {
		_option.zmin = 1.0;
		scale = max(scale, 1);
		_option.zmax = _option.zmin + scale*(_viewportW + _viewportH);
	}
	else {
		_option.zmax = 0.5*max(_viewportW, _viewportH);
		_option.zmin = -_option.zmax;
	}
}

void
zeScene::ortho()
{
	_option.perspective = false;
	setViewport(_viewportX, _viewportY, _viewportW, _viewportH);
}
	
void
zeScene::perspective(GLfloat scale)
{
	_option.perspective = true;
	setViewport(_viewportX, _viewportY, _viewportW, _viewportH, scale);
}


zeNode*
zeScene::add(zeObject *obj)
{
	if (!_node.get()) setNode(new zeNode);
	_node.get()->add(obj);
	obj->setParent(this);
	return _node.get();
}