#define YYCTYPE char
#define YYCURSOR p
#define YYLIMIT p
#define YYMARKER q
#define YYFILL(n)

#define RET(n) { *code = (n);  return YYCURSOR;}

enum TOK_ZGTEXT {
    TOK_UNICODE = 257,
    TOK_SUB1,
    TOK_SUB2,
    TOK_SUP1,
    TOK_SUP2,
    TOK_alpha  =0x03B1,
    TOK_beta   =0x03B2,
    TOK_gamma  =0x03B3,
    TOK_delta  =0x03B4,
    TOK_epsilon=0x03B5,
    TOK_zeta   =0x03B6,
    TOK_eta    =0x03B7,
    TOK_theta  =0x03B8,
    TOK_iota   =0x03B9,
    TOK_kappa  =0x03BA,
    TOK_lambda =0x03BB,
    TOK_mu     =0x03BC,
    TOK_nu     =0x03BD,
    TOK_xi     =0x03BE,
    TOK_o      =0x03BF,
    TOK_pi     =0x03C0,
    TOK_rho    =0x03C1,
    TOK_sigma  =0x03C3,
    TOK_tau    =0x03C4,
    TOK_upsilon=0x03C5,
    TOK_phi    =0x03C6,
    TOK_chi    =0x03C7,
    TOK_psi    =0x03C8,
    TOK_omega  =0x03C9,
    TOK_Gamma  =0x0393,
    TOK_Delta  =0x0394,
    TOK_Theta  =0x0398,
    TOK_Lambda =0x039B,
    TOK_Xi     =0x039E,
    TOK_Pi     =0x03A0,
    TOK_Sigma  =0x03A3,
    TOK_Phi    =0x03A6,
    TOK_Psi    =0x03A8,
    TOK_Omega  =0x03A9
};


char *scan_zgtext(char *p, int *code)
{
    char *q;
/*!re2c
H	= [a-fA-F0-9];
*/

/*!re2c
"<sym>alpha</sym>"      { RET(TOK_alpha); }
"<sym>beta</sym>"       { RET(TOK_beta); }
"<sym>gamma</sym>"      { RET(TOK_gamma); }
"<sym>delta</sym>"      { RET(TOK_delta); }
"<sym>epsilon</sym>"    { RET(TOK_epsilon); }
"<sym>zeta</sym>"       { RET(TOK_zeta); }
"<sym>eta</sym>"        { RET(TOK_eta); }
"<sym>theta</sym>"      { RET(TOK_theta); }
"<sym>iota</sym>"       { RET(TOK_iota); }
"<sym>kappa</sym>"      { RET(TOK_kappa); }
"<sym>lambda</sym>"     { RET(TOK_lambda); }
"<sym>mu</sym>"         { RET(TOK_mu); }
"<sym>nu</sym>"         { RET(TOK_nu); }
"<sym>xi</sym>"         { RET(TOK_xi); }
"<sym>o</sym>"          { RET(TOK_o); }
"<sym>pi</sym>"         { RET(TOK_pi); }
"<sym>rho</sym>"        { RET(TOK_rho); }
"<sym>sigma</sym>"      { RET(TOK_sigma); }
"<sym>tau</sym>"        { RET(TOK_tau); }
"<sym>upsilon</sym>"    { RET(TOK_upsilon); }
"<sym>phi</sym>"        { RET(TOK_phi); }
"<sym>chi</sym>"        { RET(TOK_chi); }
"<sym>psi</sym>"        { RET(TOK_psi); }
"<sym>omega</sym>"      { RET(TOK_omega); }
"<sym>Gamma</sym>"      { RET(TOK_Gamma); }
"<sym>Delta</sym>"      { RET(TOK_Delta); }
"<sym>Theta</sym>"      { RET(TOK_Theta); }
"<sym>Lambda</sym>"     { RET(TOK_Lambda); }
"<sym>Xi</sym>"         { RET(TOK_Xi); }
"<sym>Pi</sym>"         { RET(TOK_Pi); }
"<sym>Sigma</sym>"      { RET(TOK_Sigma); }
"<sym>Phi</sym>"        { RET(TOK_Phi); }
"<sym>Psi</sym>"        { RET(TOK_Psi); }
"<sym>Omega</sym>"      { RET(TOK_Omega); }
"<sym>0x" H{4} "</sym>" { RET(TOK_UNICODE); }
"<sub>"                 { RET(TOK_SUB1); }
"</sub>"                { RET(TOK_SUB2); }
"<sup>"                 { RET(TOK_SUP1); }
"</sup>"                { RET(TOK_SUP2); }
[\000-\377]             { RET(*p); }
*/

}
