#ifndef __ZE_RENDER__
#define __ZE_RENDER__

#include "config.h"
#include "scene.h"
#include "node.h"
#include "texture.h"
#include "freefont.h"
#include "gd.h"
#include "GL/osmesa.h"

///
/// Render object is the root of ZeGraph. A render can contain multiple scenes, which
/// makes it simple to produce multiple plot in a single page or view window. The render
/// always render the image to an offline stream first, and then to a file or a window.
///
class zeRender : public zeObject
{
public:
	/// Constructor.
	zeRender();

	/// Destructor.
	virtual ~zeRender();

	/// Initialize OpenGL render.
	void initialize(size_t width, size_t height, size_t depth);

	/// Render image to a file or byte-stream in PNG, JPG, TIF, BMP, GIF format.
	long  render2File(const char* fname);

	/// Render image to GIF animation
	void render2GifAnimation(const char* fname, int delay);

	/// Render image to a zeTexture object.
	void render2Texture(zeTexture *obj);

	/// Render image to array objects.
	void render2Array(unsigned char *R, unsigned char *G, unsigned char *B, size_t size);

#ifdef _WIN32
	/// Render image to a window.
	void render2Window(HWND hWnd, bool paint=false);

	/// Create a window and render scenes on it. If node is not NULL, animate the node.
	void show(zeTransform *obj=0, int ms=0, RenderCallBack call=0, void *ctx=0, void *func=0);
#endif
	/// Get the scene.
	zeScene *getScene() { return &_scene; }
	
	/// Get the font.
	zeFreetype *getFont() { return &_font; }
	
	/// Set background.
	void setColor(const ZEcolor &color) {_color = color;}

	size_t width()  const {return _width;}
	size_t height() const {return _height;}

	const void *buffer() const { return _bufferGD; }
	      void *buffer()       { return _bufferGD; }

private:
	void render(bool flag);

	void reset();

private:
	zeFreetype			_font;

	zeScene				_scene;

	ZEcolor				_color;

	size_t				_width, _height, _depth;

	OSMesaContext		_ctx;
	gdImagePtr			_img;
	GLubyte*			_bufferGL;		// mesa bufer
	void*				_bufferGD;		// GD buffer

	FILE*				_fp;
#ifdef _WIN32
	HDC					_hMemDC;
#endif
};

#endif  //__ZE_RENDER__
