#ifndef __ZE_REFCOUNT__
#define __ZE_REFCOUNT__

template <class T> class zeRCP;

/// Reference counted base class.
template <class T> class rcBase
{
	friend class	zeRCP<T>;
public:
	rcBase() : _count(0) {}
	int		_count;
};

/// Reference counted ZeGraphe class. This implementation is based on serval sources.
/// I will trace back to original authors, but for now please forgive me for not
/// having credited to them.
///
template <class T> class zeRCP  
{
	T*		_ptr;
        
public:

	/// Default constructor.
	zeRCP() : _ptr(0) {}

	/// Initializing constructor.
	zeRCP(T* ptr) : _ptr(ptr) {if (_ptr) _ptr->_count++;}

	/// Copy constructor.
	zeRCP(const zeRCP<T>& src) {copyfrom(src);}
        
	/// Destructor.
	virtual ~zeRCP() {release();}
        
	/// Assigment operator.
	zeRCP<T>& operator= (const zeRCP<T>& src)
	{
		if (&src != this)
		{
			release();
			copyfrom(src);
		}
		return *this;
	}

	/// Equal comparison.
	bool operator== (const zeRCP<T>& rhs) const {return _ptr == rhs._ptr;}

	/// Release the current reference and make reference to the new object.
	zeRCP<T>& attach(T* p)
	{
		release();
		_ptr = p;
		if (_ptr) _ptr->_count++;
		return *this;
	}
        
	/// Convenient pointer operator.
	const T* operator->() const {return _ptr;}
		  T* operator->()		{return _ptr;}

	/// Convenient pointer operator.
	const T& operator*() const {return *_ptr;}
		  T& operator*()	   {return *_ptr;}
        
	/// Convenient pointer operator.
	const T* get() const {return _ptr;}
		  T* get()		 {return _ptr;}

	/// Convenient pointer operator.
	bool isNull() const {return _ptr == 0;}
        
	/// Release the reference.
	void release()    
	{ 
		if (!_ptr) return;
		_ptr->_count--;
		if (_ptr->_count == 0) {
			delete _ptr;
			_ptr = 0;
		}
	}
        
private:
	// make a copy of the source object.
	void copyfrom(const zeRCP<T>& src)
	{
		_ptr = src._ptr;
		if (_ptr) _ptr->_count++;
	}
};


#endif	// __ZE_REFCOUNT__