#ifndef __ZE_POLYGON__
#define __ZE_POLYGON__

#include "material.h"
#include "texture.h"
#include "transform.h"
#include "vertex.h"
#include "color.h"
#include "texcoord.h"

///
/// GL polygons. Filled 3D polygons should have normal and be used with zeLight.
///
class zePolygon : public zeTransform
{
public:
	/// Constructor.
	zePolygon();

	/// Destructor.
	virtual ~zePolygon();

	/// Extended render function.
	virtual void drawFunc(ZEoption & option);

	/// Set the default color for all vertex.
	void setColor(const ZEcolor &color) { _color = color; }

	/// Set antialias mode.
	void setAntialias( bool antialias) { _antialias = antialias; }

	/// Set/get vertices.
	void setVertex(zeVertex *vertex) { _vertex = zeRCP<zeVertex>(vertex); }

	zeVertex * getVertex() { return _vertex.get(); }

	/// Set/get vertex colors.
	void setVertexColor(zeColor *color) { _vertexColor = zeRCP<zeColor>(color); }

	zeColor * getVertexColor() { return _vertexColor.get(); }

	/// Set/get vertex normals.
	void setVertexNormal(zeVertex *normal) { _vertexNormal = zeRCP<zeVertex>(normal); }

	zeVertex * getVertexNormal() { return _vertexNormal.get(); }

	/// Set/get texture coordinates.
	void setTexCoord(zeTexCoord *coord) { _texCoord = zeRCP<zeTexCoord>(coord); }

	zeTexCoord * getTexCoord() { return _texCoord.get(); }

	/// Set/get surface material.
	void setMaterial(zeMaterial *material) { _material = zeRCP<zeMaterial>(material); }

	zeMaterial * getMaterial() { return _material.get(); }

	/// Set/get surface texture.
	void setTexture(zeTexture *texture) { _color.r = _color.g = _color.b = _color.a = 1; _texture = zeRCP<zeTexture>(texture); }

	zeTexture * getTexture() { return _texture.get(); }

	/// Set polygon type.
	void asTriangles() { _glType = GL_TRIANGLES; }
	void asTriangleStrip() { _glType = GL_TRIANGLE_STRIP; }
	void asTriangleFan() { _glType = GL_TRIANGLE_FAN; }
	void asQuads() { _glType = GL_QUADS; }
	void asQuadStrip() { _glType = GL_QUAD_STRIP; }
	void asPolygon() { _glType = GL_POLYGON; }

	/// Set polygon fill mode.
	void asFilled() { _glMode = GL_FILL; }
	void asPoints() { _glMode = GL_POINT; }
	void asLines() { _glMode = GL_LINE; }

	/// Set polygon line width.
	void lineWidth(GLfloat width) {	_width = width; }

	/// Set face orientation.
	void clockWise() { _glOrient = GL_CW; }
	void counterClockWise() { _glOrient = GL_CCW; }

	/// Set cullface.
	void cullFront() { _glCull = GL_FRONT; }
	void cullBack() { _glCull = GL_BACK; }
	void cullNone() { _glCull = GL_FRONT_AND_BACK; }

	/// For CSG use
	GLenum cull() const { return _glCull; }
	void cull(GLenum cull) { _glCull = cull; }

	/// Set polygon fil pattern
	void setStiple(const char *s);

	/// For VMRL callback
	GLfloat width() const { return _width; }

	GLubyte	*stipple() const { return _stipple; }

	GLenum glType() const { return _glType; }

	bool isClockwise() const { return _glOrient == GL_CW; }

protected:
	zeRCP<zeVertex>	_vertex;

	zeRCP<zeColor>	_vertexColor;

	zeRCP<zeVertex>	_vertexNormal;

	zeRCP<zeTexCoord>	_texCoord;

	zeRCP<zeMaterial>	_material;

	zeRCP<zeTexture>	_texture;

	ZEcolor			_color;

	bool			_antialias;

	GLfloat			_width;

	GLenum			_glType;

	GLenum			_glOrient;

	GLenum			_glCull;

	GLenum			_glMode;

	GLubyte			*_stipple;
};

#endif	// __ZE_POLYGONS__