#include "polygon.h"
#include "factory.h"


zePolygon::zePolygon()
 : _antialias(false), _glCull(GL_FRONT_AND_BACK), _glMode(GL_FILL), _glOrient(GL_CCW),
 _width(1), _stipple(0), _glType(GL_POLYGON)
{
	setType(ZE_POLYGON);
	_color.a = -1;
}

zePolygon::~zePolygon()
{
	delete[] _stipple;
}

void
zePolygon::drawFunc(ZEoption & option)
{
	if (!enabled() || _vertex.isNull() || _vertex->size() == 0) return;

	ZEcolor color = option.color;
	if (_color.a > 0) color = _color;
	glColor4f(color.r, color.g, color.b, color.a);

	if (_glCull != GL_FRONT_AND_BACK) {
		glEnable(GL_CULL_FACE);
		glCullFace(_glCull);
	}
	else {
		glDisable(GL_CULL_FACE);
	}

	if (_stipple) {
		glEnable(GL_POLYGON_STIPPLE);
		glPolygonStipple(_stipple);
	}
	else {
		glDisable(GL_POLYGON_STIPPLE);
	}

	if (_antialias) {
		glEnable(GL_POLYGON_SMOOTH);
		glHint(GL_POLYGON_SMOOTH_HINT, GL_NICEST);
		glEnable(GL_POINT_SMOOTH);
		glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
		glEnable(GL_LINE_SMOOTH);
		glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
		glEnable(GL_BLEND);
		glDisable(GL_DEPTH_TEST);
		glDepthMask(GL_FALSE);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	}
	else {
		glDisable(GL_POLYGON_SMOOTH);
		glDisable(GL_POINT_SMOOTH);
		glDisable(GL_LINE_SMOOTH);
		glDisable(GL_BLEND);
		glEnable(GL_DEPTH_TEST);
		glDepthMask(GL_TRUE);
	}

	if (!_material.isNull()) {
		_material->render(option);
	}
	else {
		glEnable(GL_COLOR_MATERIAL);
	}

	if (!_texture.isNull()) {
		_texture->render(option);
	}
	else {
		glDisable(GL_TEXTURE_2D);
	}

	glLineWidth(_width);
	glPolygonMode(GL_FRONT_AND_BACK, _glMode);
	glFrontFace(_glOrient);

	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(3, GL_FLOAT, 0, _vertex->ptr());

	if (!_vertexNormal.isNull() && _vertexNormal->size() >= _vertex->size()) {
		glEnableClientState(GL_NORMAL_ARRAY);
		glNormalPointer(GL_FLOAT, 0, _vertexNormal->ptr());
	}
	else {
		glDisableClientState(GL_NORMAL_ARRAY);
	}

	if (!_vertexColor.isNull() && _vertexColor->size() >= _vertex->size()) {
		glEnableClientState(GL_COLOR_ARRAY);
		glColorPointer(4, GL_FLOAT, 0, _vertexColor->ptr());
	}
	else {
		glDisableClientState(GL_COLOR_ARRAY);
	}

	if (!_texCoord.isNull() && _texCoord->size() >= _vertex->size()) {
		glEnableClientState(GL_TEXTURE_COORD_ARRAY);
		glTexCoordPointer(2, GL_FLOAT, 0, _texCoord->ptr());
	}
	else {
		glDisableClientState(GL_TEXTURE_COORD_ARRAY);
	}

	glDrawArrays(_glType, 0, _vertex->size());

}

void
zePolygon::setStiple(const char *s)
{
	int i, j, k = 0, n = strlen(s), m = n/8;
	if (n < 8) return;
	if (!_stipple) _stipple = new GLubyte[128];
	for (i = 0; i < 128; i++) {
		GLubyte b = 0;
		for (j = 0; j < 8; j++) {
			if (s[k] == 'x') b |= (1<<(7-j));
			k++;
			if (k >= m*8) k=0;
		}
		_stipple[i] = b;
	}
}
