#ifndef __ZE_POINT__
#define __ZE_POINT__

#include "transform.h"
#include "vertex.h"
#include "color.h"

///
/// GL points. The maximal size is 10 in Windows implementation.
///
class zePoint : public zeTransform
{
public:
	/// Constructor.
	zePoint();

	/// Destructor.
	virtual ~zePoint() {}

	/// Extended drawFunc fucntion of zeTransform.
	virtual void drawFunc(ZEoption &option);

	/// Set the default color for all vertex.
	void setColor(const ZEcolor &color) { _color = color; }

	/// Set antialias mode.
	void setAntialias( bool antialias) { _antialias = antialias; }

	/// Set/get vertices.
	void setVertex(zeVertex *vertex) { _vertex = zeRCP<zeVertex>(vertex); }

	zeVertex * getVertex() { return _vertex.get(); }

	/// Set/get vertex colors.
	void setVertexColor(zeColor *color) { _vertexColor = zeRCP<zeColor>(color); }

	zeColor * getVertexColor() { return _vertexColor.get(); }

	/// Set/get vertex normals.
	void setVertexNormal(zeVertex *normal) { _vertexNormal = zeRCP<zeVertex>(normal); }

	zeVertex * getVertexNormal() { return _vertexNormal.get(); }

	/// Set point size.
	void setSize(GLfloat size) { _size = size; }

	/// For VMRL callback
	bool antialias() const { return _antialias; }

	GLfloat size() const { return _size; }

	const ZEcolor & getColor() const { return _color; }

private:
	zeRCP<zeVertex>	_vertex;

	zeRCP<zeColor>	_vertexColor;

	zeRCP<zeVertex>	_vertexNormal;

	ZEcolor			_color;

	bool			_antialias;

	GLfloat			_size;
};

#endif	// __ZE_POINT__