#include "point.h"


zePoint::zePoint() : _size(1.0), _antialias(true)
{
	setType(ZE_POINT);
	_color.a = -1;
}

void
zePoint::drawFunc(ZEoption & option)
{
	if (!enabled() || _vertex.isNull() || _vertex->size() == 0) return;

	ZEcolor color = option.color;
	if (_color.a > 0) color = _color;
	glColor4f(color.r, color.g, color.b, color.a);

	if (_antialias) {
		glEnable(GL_POINT_SMOOTH);
		glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
		glEnable(GL_BLEND);
		glDisable(GL_DEPTH_TEST);
		glDepthMask(GL_FALSE);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	}
	else {
		glDisable(GL_POINT_SMOOTH);
		glDisable(GL_BLEND);
		glEnable(GL_DEPTH_TEST);
		glDepthMask(GL_TRUE);
	}

	glPointSize(_size);
	glEnable(GL_COLOR_MATERIAL);

	glEnableClientState(GL_VERTEX_ARRAY);
	glVertexPointer(3, GL_FLOAT, 0, _vertex->ptr());

	if (!_vertexNormal.isNull() && _vertexNormal->size() >= _vertex->size()) {
		glEnableClientState(GL_NORMAL_ARRAY);
		glNormalPointer(GL_FLOAT, 0, _vertexNormal->ptr());
	}
	else {
		glDisableClientState(GL_NORMAL_ARRAY);
	}

	if (!_vertexColor.isNull() && _vertexColor->size() >= _vertex->size()) {
		glEnableClientState(GL_COLOR_ARRAY);
		glColorPointer(4, GL_FLOAT, 0, _vertexColor->ptr());
	}
	else {
		glDisableClientState(GL_COLOR_ARRAY);
	}

	glDisableClientState(GL_TEXTURE_COORD_ARRAY);

	glDrawArrays(GL_POINTS, 0, _vertex->size());
}
