#ifndef __ZE_PLOT__
#define __ZE_PLOT__

#include "axis.h"
#include "node.h"

#include <vector>

///
/// Plot object
///

class zePlot : public zeTransform
{
public:
	/// Constructor.
	zePlot();

	/// Destructor.
	virtual ~zePlot() { };

	/// Extended render function.
	virtual void drawFunc(ZEoption & option);

	/// Add object.
	zeNode* add(zeObject *obj);
	
	/// Anchor object.
	zeNode* anchor(zeObject *obj, const ZExyz& xyz);

	/// Set axis color.
	void setColor(const ZEcolor &color) { _color = color; }

	/// Anchor axis.
	void anchorXAxis(const ZExyz& anchor);
	void anchorYAxis(const ZExyz& anchor);
	void anchorZAxis(const ZExyz& anchor);

	/// Coordinate convertion.
	ZExyz global2plot(double w, double h, double x, double y, double z) const;
	ZExyz plot2global(double w, double h, double x, double y, double z) const;

	/// Enable/disable clipping.
	void setClip(bool yn) { _clip = yn; }

	/// Clear objects in the plot.
	void clear();

	/// Set axis ranges.
	bool setXrange(double xmin, double xmax);
	bool setYrange(double ymin, double ymax);
	bool setZrange(double zmin, double zmax);

	/// Member access.
	zeAxis *xaxis() { return &_xaxis; }
	zeAxis *yaxis() { return &_yaxis; }
	zeAxis *zaxis() { return &_zaxis; }

	GLfloat getRotx() const { return _rotate.x; }
	GLfloat getRotz() const { return _rotate.y; }

private:

	void renderAxises(ZEoption & option);
	void renderTextNode(ZEoption & option);
	void renderNodeNode(ZEoption & option);
	void renderPlotNode(ZEoption & option);

protected:

	ZEcolor				_color;

	ZExyz				_rmax, _rmin;

	ZExyz				_xanchor, _yanchor, _zanchor;

	zeAxis				_xaxis, _yaxis, _zaxis;

	zeNode				_plotNode, _nodeNode, _textNode, _axisNode;

	std::vector<ZExyz>	_nodeXYZ, _textXYZ;

	bool				_clip;
};

#endif	// __ZE_PLOT__