 #ifndef __ZE_OBJECT__
#define __ZE_OBJECT__

#include "refcount.h"
#include "config.h"

/// Color has four components.
typedef struct {
	GLfloat r, g, b, a;
} ZEcolor ;

/// A point or vertex has three components.
typedef struct {
	GLfloat x, y, z;
} ZExyz;

typedef ZExyz ZEvertex;

/// Texture coordinate has two components.
typedef struct {
	GLfloat s, t;
} ZEtexcoord;

/// Volume structure for iso-surface
typedef struct {
	GLfloat x, y, z, w;
} ZEvolume;

/// Triangle comprises three vertices.
typedef struct {
	ZExyz p1, p2, p3;
} ZEtriangle;

/// Tetrahedron structure for iso-surface
typedef struct {
	ZEvolume p1, p2, p3, p4;
} ZEtetra;

/// Optional parameters to be passed from scene to nodes and leafs.
struct ZEoption {
	ZEcolor color;
	GLfloat	xmin, xmax, ymin, ymax, zmin, zmax;
	bool perspective;
	int unit;
};

/// Predefined ZeGraph object types.
enum {
	ZE_UNKNOWN = 'ZGP',
	ZE_RENDER, ZE_SCENE,
	ZE_NODE,
	ZE_POINT, ZE_LINE, ZE_POLYGON,
	ZE_VERTEX, ZE_COLOR, ZE_TEXCOORD,
	ZE_TEXT, ZE_FREETYPE, ZE_TEXTURE,
	ZE_LIGHT, ZE_MATERIAL,
	ZE_AXIS, ZE_COLOR_BAR, ZE_PLOT,
	ZE_GLOBE,
	ZE_TOP
};

class zeObject;

///
/// Abstract base class of the graphic library.
/// All objects in a graph tree structure are reference counted.
/// This abstract class is not made pure for lua binding.
///
class zeObject : public rcBase<zeObject>
{
public:
	/// Constructor.
	zeObject() 	: _parent(0), _type(ZE_UNKNOWN), _enabled(true) { }

	/// Destructor.
	virtual ~zeObject() { }

	/// Render function to be extended in derived classes.
	virtual void render(ZEoption & option) { }

	/// Set/get object type.
	void setType(int type) { _type = type; }
	
	int getType() const { return _type; }

	/// Set/get parent.
	void setParent(zeObject *parent) { _parent = parent; }
	
	zeObject *getParent() const { return _parent; }

	/// Show or hide the object.
	void enable() { _enabled = true; }
	
	void disable() { _enabled = false; }

	bool enabled() const { return _enabled; }

	bool isTransform() const
	{
		switch (_type) {
		case ZE_NODE:
		case ZE_POLYGON:
		case ZE_LINE:
		case ZE_POINT:
		case ZE_GLOBE:
		case ZE_AXIS:
		case ZE_TEXT:
		case ZE_PLOT:
			return true;
		}
		return false;
	}

private:

	zeObject	*_parent;

	int		_type;

	bool	_enabled;
};

#endif	// __ZE_OBJECT__