#ifndef __ZE_NODE__
#define __ZE_NODE__

#include "transform.h"
#include <vector>

///
/// The node class is for building the tree structure of a graph.
/// Any zeObject can be added to the node , including a node.
/// Objects with similar attributes should be grouped in the same node.
///
class zeNode : public zeTransform
{
public:
	/// Constructor.
	zeNode();

	/// Destructor.
	virtual ~zeNode();

	/// implement drawFunc of zeTransform 
	virtual void drawFunc(ZEoption & option);

	/// Set default color for all object in this node
	void setColor(const ZEcolor &color) { _color = color; }

	/// Add an object to the list.
	void add(zeObject *obj);

	/// Remove this object from the list.
	void remove(zeObject *obj);

	/// Remove all objects from the list.
	void clear();

	/// Number of objects in the list.
	size_t size() const { return _objects.size(); }

	/// Get the object at the position in the list.
	zeObject *get(size_t pos);

	void test(bool yn) { _test=yn; }
	void mask(bool yn) { _mask=yn; }

private:

	bool find(zeObject* obj);

private:
	std::vector<zeRCP<zeObject> > _objects;

	ZEcolor			_color;

	bool		_mask, _test;
};


#endif	// __ZE_NODE__