#include "node.h"

using namespace std;

zeNode::zeNode() : _test(true), _mask(true)
{
	setType(ZE_NODE);
	_color.a = -1;
}

zeNode::~zeNode()
{
}

void
zeNode::drawFunc(ZEoption & option)
{
	if (!enabled() || _objects.empty()) return;

	if (!_test) glDisable(GL_DEPTH_TEST);
	if (!_mask) glDepthMask(GL_FALSE);

	ZEcolor color = option.color;
	for (int i = 0; i < _objects.size(); i++) {
		// pass node color to children if necessary
		// bcause a child may change option's color
		// do this for every loop
		if (_color.a > 0) option.color = _color;
		_objects[i].get()->render(option);
	}
	option.color = color;

	glEnable(GL_DEPTH_TEST);
	glDepthMask(GL_TRUE);

}

void
zeNode::add(zeObject *obj)
{
	if (obj == this ||
		obj->getType() == ZE_RENDER ||
		obj->getType() == ZE_SCENE) return;

	if (obj->getType() == ZE_NODE) {
		zeNode *node = (zeNode*) obj;
		if (node->find(this)) return;	// "circular reference counting prohibited.";
	}

	_objects.push_back(zeRCP<zeObject>(obj));

	obj->setParent(this);
}

void
zeNode::clear()
{
	_objects.clear();
}

bool
zeNode::find(zeObject* obj)
{
	for (int i = 0; i < _objects.size(); i++) {
		if (_objects[i].get() == obj) return true;
	}
	return false;
}

zeObject*
zeNode::get(size_t pos)
{
	if (_objects.size() < pos) return NULL;
	return _objects[pos].get();
}

void
zeNode::remove(zeObject *obj)
{
	std::vector<zeRCP<zeObject> >::iterator iter;
	for (iter = _objects.begin(); iter != _objects.end(); iter++) {
		if (iter->get() == obj) {
			_objects.erase(iter);
			break;
		}
	}
}