#ifndef __ZE_MATERIAL__
#define __ZE_MATERIAL__

#include "object.h"

///
/// Material object to be added to a light node.
///
class zeMaterial : public zeObject
{
public:
	/// Constructor.
	zeMaterial();

	/// Destructor.
    virtual ~zeMaterial() {}

	/// Extended rander function.
	virtual void render(ZEoption & option);

	/// Set ambient light.
	void setAmbient(const ZEcolor &color) {	_ambient = color; }

	/// Set diffusion light.
	void setDiffuse(const ZEcolor &color) { _diffuse = color; }

	/// Set specular light.
	void setSpecular(const ZEcolor &color) { _specular = color; }

	/// Set emmision light.
	void setEmission(const ZEcolor &color) { _emission = color; }

	/// Set shininess.
	void setShininess(GLfloat shininess) { _shininess = shininess; }

	/// For export callback
	const ZEcolor &ambient() const { return _ambient; }
	const ZEcolor &diffuse() const { return _diffuse; }
	const ZEcolor &specular() const { return _specular; }
	const ZEcolor &emission() const { return _emission; }
	GLfloat shininess() const { return _shininess; }

private:
	ZEcolor		_ambient;
	ZEcolor		_diffuse;
	ZEcolor		_specular;
	ZEcolor		_emission;
	GLfloat		_shininess;
};

#endif	// __ZE_MATERIAL__