#include "material.h"

zeMaterial::zeMaterial()
{
	setType(ZE_MATERIAL);
	ZEcolor color = { 0.2, 0.2, 0.2, 1 };
	setAmbient(color);
	color.r = color.g = color.b = 0.5;
	setDiffuse(color);
	color.r = color.g = color.b = 1;
	setSpecular(color);
	color.r = color.g = color.b = 0;
	setEmission(color);
}

void
zeMaterial::render(ZEoption & option)
{
	if (!enabled()) return;

	glDisable(GL_COLOR_MATERIAL);
	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, (GLfloat*)&_ambient);
	glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, (GLfloat*)&_diffuse);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, (GLfloat*)& _specular);
	glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, (GLfloat*)&_emission);
	glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, _shininess);
}
