#ifndef __ZE_LINE__
#define __ZE_LINE__

#include "transform.h"
#include "vertex.h"
#include "color.h"

#define LINE0x0000	0x0000
#define LINE0x1111	0x1111
#define LINE0xAAAA	0xAAAA
#define LINE0x2727	0x2727

///
/// OpenGL lines.
///
class zeLine : public zeTransform
{
public:
	/// Constructor.
	zeLine();

	/// Destructor.
	virtual ~zeLine() {};

	/// Extended render function.
	virtual void drawFunc(ZEoption & option);

	/// Set the default color for all vertex.
	void setColor(const ZEcolor &color) { _color = color; }

	/// Set antialias mode.
	void setAntialias( bool antialias) { _antialias = antialias; }

	/// Set/get vertices.
	void setVertex(zeVertex *vertex) { _vertex = zeRCP<zeVertex>(vertex); }

	zeVertex * getVertex() { return _vertex.get(); }

	/// Set/get vertex colors.
	void setVertexColor(zeColor *color) { _vertexColor = zeRCP<zeColor>(color); }

	zeColor * getVertexColor() { return _vertexColor.get(); }

	/// Set/get vertex normals.
	void setVertexNormal(zeVertex *normal) { _vertexNormal = zeRCP<zeVertex>(normal); }

	zeVertex * getVertexNormal() { return _vertexNormal.get(); }

	/// Set line styles.
	void asSolidLine(GLint factor = 1, GLfloat width = 1.0) { _factor = factor; _width = width; _stipple = LINE0x0000; }
	void asDotLine(GLint factor = 1, GLfloat width = 1.0) { _factor = factor; _width = width; _stipple = LINE0x1111; }
	void asDashLine(GLint factor = 1, GLfloat width = 1.0) { _factor = factor; _width = width; _stipple = LINE0xAAAA; }
	void asDotDashLine(GLint factor = 1, GLfloat width = 1.0) { _factor = factor; _width = width; _stipple = LINE0x2727; }

	/// set OpenGL line types.
	void asLines() { _glType = GL_LINES; }
	void asLineLoop() { _glType = GL_LINE_LOOP; }
	void asLineStrip() { _glType = GL_LINE_STRIP; }

	/// FOR VMRL callback
	GLfloat width() const { return _width; }

	GLushort stipple() const { return _stipple; }
	
	GLenum glType() const { return _glType; }

protected:
	zeRCP<zeVertex>	_vertex;

	zeRCP<zeColor>	_vertexColor;

	zeRCP<zeVertex>	_vertexNormal;

	ZEcolor			_color;

	bool			_antialias;

	GLushort		_stipple;

	GLint			_factor;

	GLfloat			_width;

	GLenum			_glType;
};

#endif	// __ZE_LINE__