#ifndef __ZE_LIGHT__
#define __ZE_LIGHT__

#include "node.h"

///
/// The light object is necessary for 3D polygons.
/// Rich light effects can be produced using it with zeLightModel and zeMaterial.
///
class zeLight : public zeObject
{
public:
	/// Constructor.
    zeLight();

	/// Destructor.
    virtual ~zeLight();

	/// Extended render function.
	virtual void render(ZEoption & option);

	/// Add object to be lit
	zeNode& add(zeObject *obj);

	/// Set light position. Use w = 0 to have directional lingt.
	void setPosition(const ZEvertex &xyz) 
	{
		_position[0] = xyz.x;
		_position[1] = xyz.y;
		_position[2] = xyz.z;
	}

	/// Set light colors.
	void setAmbient(const ZEcolor &color) { _ambient = color; }

	/// For VMRL callback
	const GLfloat* position() const { return _position; }

	/// clear objects
	void clear() { _node.clear(); }

	/// Set light on.
	GLenum on();

	/// Set light off.
	void off(GLenum k);

private:
	zeNode		_node;

	ZEcolor		_ambient;

	GLfloat		_position[4];
};

#endif	// __ZE_LIGHT__