#include "light.h"

zeLight::zeLight()
{
	setType(ZE_LIGHT);
	_ambient.r = _ambient.g = _ambient.b = 0.2;
	_ambient.a = 1;
	_position[0] = _position[1] = _position[2] = 1;
	_position[3] = 0;
	_node.setParent(this);
}

zeLight::~zeLight()
{
}

void
zeLight::render(ZEoption & option)
{
	if (_node.size() == 0) return;

	GLenum k;
	if (enabled()) k = on();
	_node.render(option);
	if (enabled()) off(k);
}

zeNode&
zeLight::add(zeObject *obj)
{
	_node.add(obj);
	obj->setParent(this);
	return _node;
}

GLenum
zeLight::on()
{
	GLenum k;
	for (k = GL_LIGHT0; k <= GL_LIGHT7; k++) {
		if (!glIsEnabled(k)) {
			glEnable(GL_LIGHTING);
			glEnable(k);
			glEnable(GL_COLOR_MATERIAL);
			glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
			glLightfv(k, GL_AMBIENT, (GLfloat*)&_ambient);
			glLightfv(k, GL_POSITION, _position);
			return k;
		}
	}
	return k;
}

void
zeLight::off(GLenum k)
{

	if (k <= GL_LIGHT7) glDisable(k);
	bool flag = false;
	for (k = GL_LIGHT0; k <= GL_LIGHT7; k++) {
		if (glIsEnabled(k)) {
			flag = true;
			break;
		}
	}
	if (!flag) glDisable(GL_LIGHTING);
}