#ifndef __ZE_GLOBE__
#define __ZE_GLOBE__

#include "node.h"
#include "line.h"
#include "light.h"
#include "polygon.h"
#include "colorbar.h"
#include <vector>

///
/// Globe object
///

class zeGlobe : public zeTransform
{
public:
	zeGlobe();

	virtual ~zeGlobe() { }

	/// implement drawFunc of zeTransform 
	virtual void drawFunc(ZEoption & option);

	/// Make globe surface
	zePolygon* surface(GLfloat radius, int iters);

	/// Make globe surface with texture
	zePolygon* texture(GLfloat radius, const char* fname, bool atlantic);

	/// Make globe surface with texture
	zePolygon* texture(GLfloat radius, double *data, int nrow, int ncol, bool atlantic, zeColorBar *cbar);

	/// Draw grid lines
	zeNode* grid(int deg, GLfloat width);

	/// Set view focus point
	void focus(GLfloat lon, GLfloat lat);

	/// Add object
	zeNode* add(zeObject *obj);

	/// Anchor object at given longitude and latitude
	zeNode* anchor(zeObject *obj, GLfloat lon, GLfloat lat, GLfloat alt=0.0);

	/// Draw a line on the surface
	zeLine* line(double lon1, double lat1, double lon2, double lat2);

	/// Make cones for wind field
	zeNode* field(const double *U, const double *V,
				const double *X, int nx, const double *Y, int ny,
				double size, const zeColorBar *colorbar);

	/// Read GSHHS coastline
	zeNode* gshhs(const char *fname, GLfloat width, bool smooth);

	/// Get node
	zeNode* node() { return &_node; }

	/// Get light
	zeLight* light() { return &_light; }

	/// clear objects
	void clear();

	/// Set radius
	double radius() const { return _radius; }

	/// Set look at center and position
	void lookAt(GLfloat eLon, GLfloat eLat, GLfloat eAlt, GLfloat cLon, GLfloat cLat, GLfloat cAlt);

private:

	zeLight			_light;

	zeNode			_node, _map, _grid;

	zePolygon		_surface;

	double			_radius;
};

#endif	// __ZE_GLOBE__