#include "freefont.h"

zeFreetype::zeFreetype() : _library(0), _face(0)
{
	setType(ZE_FREETYPE);
#ifdef _WIN32
	char fname[MAX_PATH];
	GetWindowsDirectory(fname, MAX_PATH);
	strcat_s(fname, "\\Fonts\\ARIAL.TTF");
	setFont(fname);
#else
	//???
#endif
}

zeFreetype::~zeFreetype()
{
	if (_face) {
		FT_Done_Face(_face);
		_face = 0;
	}
	if (_library) {
		FT_Done_FreeType(_library);
		_library = 0;
	}
}

bool
zeFreetype::setFont(const char *fname)
{
	if (_face) {
		FT_Done_Face(_face);
		_face = 0;
	}
	if (_library) {
		FT_Done_FreeType(_library);
		_library = 0;
	}
	if (FT_Init_FreeType(&_library) != 0 ||
		FT_New_Face(_library, fname, 0, &_face) != 0 ||
		FT_Select_Charmap(_face, FT_ENCODING_UNICODE) != 0) return false;
	return true;
}
