#ifndef __FACTORY_H__
#define __FACTORY_H__

#include "plot.h"
#include "line.h"
#include "polygon.h"
#include "utility.h"

typedef struct { GLdouble x, y; } xy_t;
typedef struct { GLdouble x, y, z; } xyz_t;
typedef struct { GLdouble left, bottom, right, top; } rect_t;

int contour3_line(zeVertex *vertex, GLfloat isoValue, const ZExyz &p0, const ZExyz &p1, const ZExyz &p2);

int contour4_line(zeVertex *vertex, GLfloat isoValue, const ZExyz &p0, const ZExyz &p1, const ZExyz &p2, const ZExyz &p3);

int iso_surface(zeVertex *vertex, GLfloat isoValue, const ZEvolume &p0, const ZEvolume &p1, const ZEvolume &p2, const ZEvolume &p3);

void make_box(zePolygon *poly, double size);

void make_circle(zeLine *line, double r);

void make_disk(zePolygon *poly, double r);

void make_cylinder(zePolygon *poly, double h,  double r);

void make_torus(zePolygon *poly, double R, double r);

void make_cone(zePolygon *poly, double h, double r);

void make_cone_vector1(zePolygon *poly, double u, double v, double w, double r);

void make_cone_vector2(zePolygon *poly, double R, double lon, double lat, double u, double v, double r);

void make_vector(zeLine *line, double u, double v, double size);

void make_sphere(zePolygon *poly, double r, int iterations);

void make_sphere2(zePolygon *poly, double r, int grid, bool atlantic);

void spherical_curve(zeLine *line, double r, double lon1, double lat1, double lon2, double lat2);

void latitude_grid(zeLine *line, double r, int lat);

void longitude_grid(zeLine *line, double r, int lon, int offset);

ZExyz vertex_interp2D(const ZExyz &p1, const ZExyz &p2, GLfloat isoValue);

ZExyz vertex_interp3D(const ZEvolume &v1, const ZEvolume &v2, GLfloat isoValue);

void normalize_vertex(ZExyz &p);

ZExyz cross_product2(const ZExyz &p1, const ZExyz &p2);

ZExyz cross_product3(const ZExyz &p0, const ZExyz &p1, const ZExyz &p2);

ZExyz mid_point(const ZExyz &p1, const ZExyz &p2);

bool gshhs_coastline(zeLine *line, int level,
					 const char *fname, double west, double east, double south, double north);

bool gshhs_filled(zePolygon *poly, int level,
				  const char *fname, double west, double east, double south, double north, int winding);

void vertex_triangulate(zeVertex *out, zeVertex *in, rect_t* rect, int winding);

void contour_labels(zePlot *plot, zeLine *line, zeText *label, int density, int width, int height, double offset);

#endif