#ifndef __ZE_COLORBAR__
#define __ZE_COLORBAR__

#include "line.h"
#include "polygon.h"
#include "freefont.h"
#include "text_tex.h"

///
/// Colorbar for 2D and 3D graph. The colorbar is always 2D.
/// Its coordinate is relative to the page layout.
///
class zeColorBar : public zeTransform
{
public:
	/// Constructor.
	zeColorBar();

	/// Destructor.
	virtual ~zeColorBar();

	/// Extended drawFunc fucntion of zeTransform.
	virtual void drawFunc(ZEoption &option);

	/// Interpolate between pre-set colors.
	void interpolate(size_t n);

	/// Gradient or discrete type.
	void gradientType(bool yn);

	/// Set label format.
	void setLabelFormat(size_t digit, bool scientific = false);

	/// Add color to the data; clear previous setting if reset is true.
	void addColor(const ZEcolor& color, GLfloat data);

	/// Get color for the data.
	ZEcolor getColor(GLfloat data) const;

	/// Set color for labels.
	void setColor(const ZEcolor &color) { _color = color; }

	/// Clear contour colors and data.
	void clear();

	/// Set line width.
	void lineWidth(GLfloat width) { _lines.asSolidLine(1, width); }

	/// Set font engine
	void setFont(zeFreetype *font) { _font = font; }
	
	/// Get font engine
	zeFreetype *getFont() { return _font; }

	/// Set font size in point.
	void setFontSize(size_t point) { _fontSize = point; }

	/// Set width and height
	void setSize(GLfloat w, GLfloat h) { _width=w; _height=h; }

private:
	void render_colors(ZEoption & option);

	void render_labels(ZEoption & option);

	void clearLabels();

protected:
	ZEcolor					_color;

	zeFreetype				*_font;
	size_t					_fontSize;

	zeLine					_lines;
	zePolygon				_polys;
	std::vector<zeText*>	_labels;

	bool					_gradient;

	GLfloat					_width;
	GLfloat					_height;

	size_t					_digit;
	bool					_scientific;
	
	std::vector<ZEcolor>	_barColor;
	std::vector<GLfloat>	_data;
};

#endif	// __ZE_COLORBAR__