#ifndef __ZE_COLOR__
#define __ZE_COLOR__

#include "object.h"
#include <vector>

///
/// The zeColor class is used to assgin colors to shapes. 
///
class zeColor : public zeObject
{
public:
	/// Constructor.
	zeColor() { setType(ZE_COLOR); }

	/// Destructor.
	virtual ~zeColor() { };

	/// Add a color to the end. 
	void add(const ZEcolor &rgba) { _rgba.push_back(rgba); }

	void add(GLfloat r, GLfloat g, GLfloat b, GLfloat a=1)
	{
		ZEcolor rgba = { r, g, b, a };
		_rgba.push_back(rgba);
	}

	/// Clear color vector.
	void clear() { _rgba.clear(); }

	/// Resize color vector.
	void resize(size_t size) { _rgba.resize(size); }

	/// Reserve color vector size.
	void reserve(size_t size) { _rgba.reserve(size); }

	/// Color vector size.
	size_t size() const { return _rgba.size(); }

	/// Set/get color at the index.
	void set(size_t idx, const ZEcolor &rgba) { _rgba[idx] = rgba; }

	const ZEcolor & get(size_t idx) const { return _rgba[idx]; }

	const GLfloat & r(size_t idx) const { return _rgba[idx].r; }
  	      GLfloat & r(size_t idx)       { return _rgba[idx].r; }

	const GLfloat & g(size_t idx) const { return _rgba[idx].g; }
  	      GLfloat & g(size_t idx)       { return _rgba[idx].g; }

	const GLfloat & b(size_t idx) const { return _rgba[idx].b; }
  	      GLfloat & b(size_t idx)       { return _rgba[idx].b; }

	const GLfloat & a(size_t idx) const { return _rgba[idx].a; }
  	      GLfloat & a(size_t idx)       { return _rgba[idx].a; }

	const void *ptr() const { return &_rgba[0]; }
	      void *ptr()       { return &_rgba[0]; }

private:

	std::vector<ZEcolor>		_rgba;
};

#endif	// __ZE_COLOR__