#ifndef __ZE_AXIS__
#define __ZE_AXIS__

#include "node.h"
#include "line.h"
#include "text_tex.h"
#include "freefont.h"

enum { X_AXIS, Y_AXIS, Z_AXIS };

class zePlot;

///
/// Abstract axis class for scientific plot.
///
class zeAxis : public zeTransform
{
public:
	/// Constructor.
	zeAxis();

	/// Destructor.
	virtual ~zeAxis();

	/// Extended render function.
	virtual void drawFunc(ZEoption & option);

	/// Set axis color.
	void setColor(const ZEcolor &color) { _color = color; }

	/// Set antialias mode.
	void setAntialias( bool antialias) { _axisLines.setAntialias(antialias); }

	/// Axis type. 	Use tickDownLeft to control tick direction.
	void asXAxis(bool tickDown = true);

	void asYAxis(bool tickLeft = true);

	void asZAxis(bool tickLeft = true);

	/// Set axis label.
	bool setAxisLabel(const char *label);

	/// Set the range of viewable data.
	bool setAxisRange(double amin, double amax, bool setplot = true);

	/// Add a custom tick label.
	bool addTickLabel(const char *label, bool center = false);

	/// Control tick appearance.
	bool setTickMarks(double start, double end, double step, size_t minor = 0);

	/// Scale the default tick length.
	void setTickLength(double lengthScale);

	/// Number of decimal point for labeling ticks.
	void setTickLabelDigit(size_t digit, bool scientific = false);

	/// Set line properties.
	void setLineWidth(GLfloat width) { _axisLines.asSolidLine(1, width); }

	/// Show/hide ticks and labels.
	void showTicks(bool yn) { _tickEnabled = yn; }
	void showLabels(bool yn) { _tickLabelEnabled = yn;}

	/// Get axis-type
	int getAxisType() const { return _axisType; }

	/// Set label scale
	void setLabelScale(const ZExyz &scale) { _labelScale = scale; }

	/// Set font engine
	void setFont(zeFreetype *font) { _font = font; }
	
	/// Get font engine
	zeFreetype *getFont() { return _font; }

	/// Set font size in point (axis label has slightly larger font than tick label does).
	void setFontSize(size_t point) { _fontSize = max(point, 6); }

private:

	void render_ticks(ZEoption & option);

	void render_ticklabels(ZEoption & option);

	void render_axislabel(ZEoption & option);

	void clear_tickLabels();

private:
	zeFreetype			*_font;
	size_t				_fontSize;

	ZEcolor				_color;
	int					_axisType;

	zeText					_axisLabel;
	zeLine					_axisLines;
	std::vector<zeText*>	_tickLabels;
	ZExyz					_labelScale;

	double 				_axisMin, _axisMax;
	
	bool				_tickLabelAlignCenter;
	bool				_tickEnabled;
	bool				_tickLabelEnabled;
	double				_tickStart, _tickEnd, _tickStep;
	size_t				_tickMinor;
	double				_tickLengthScale;
	double				_tickDirection;
	size_t				_tickLabelDigit;
	bool				_tickLabelScientific;
	double				_tickLabelTop, _tickLabelBottom, _tickLabelLeft, _tickLabelRight;
};

#endif	// __ZE_AXIS__