#include "api.h"
#include "ze_script.h"
#include <string.h>
#include <stdio.h>
#include <windows.h>

/*
Run buildconf.bat and configure in php source

Include php src header and compile

Copy
zs.dll to Apache\bin and php
and
ze_scrpt.dll to php\ext

In php.ini
1) load ze_scrpt.dll
2) change ext and include paths

test.php example
<?php
require("ze_script.php");
$ze=new ZeScript();
$ze->load("c:/apache2/htdocs/test.zs");
$ze->set("A",10);
$ze->set("B",10.0);
$ze->set("C","Name");
$ze->exec();
?>

test.zs example
php_write("OK");
php_write(ptr,n);
*/

/*
	Cairo seems to be trouble some. Use critical section to controll it.
*/

static CRITICAL_SECTION CriticalSection;


extern void ze_write(void *ptr, size_t n);


static void* php_write(void *ctx, int nargs, void** args)
{
	if (nargs<1) api_input_error(ctx);
	if (nargs<2) {
		const char *str=api_get_string(ctx,args[0]);
		ze_write((void*)str,strlen(str));
	}
	else {
		void *ptr=api_get_ptr(ctx,args[0]);
		int n=api_get_integer(ctx,args[1]);
		if (ptr && n>0) ze_write(ptr,n);
	}
	return 0;
}

ZeScript::ZeScript()
{
	InitializeCriticalSectionAndSpinCount(&CriticalSection,0x00000400);
	_module=0;
	_ctx=0;
	_arr=0;
	_error[0]=0;
	api_add_primitive("php_write",	0,	php_write);
}

ZeScript::~ZeScript()
{
	DeleteCriticalSection(&CriticalSection);
	if (_module) api_delete_module(_module);
}

bool ZeScript::load(const char *fname)
{
	try {
		_error[0]=0;
		if (_module) api_delete_module(_module);
		_module=api_parse_file(fname,_error);
		if (_module) {
			_ctx=api_get_context(_module);
			_arr=api_create_array(0,32);
			api_set_object(_ctx,"PHP_CGI",_arr);
			return true;
		}
	}
	catch (...) {
		strcpy(_error,"Failed to load ZS module!");	
	}
	return false;
}


bool ZeScript::set(const char *key, const char *value)
{
	if (!check()) return false;
	try {
		api_set_array_object(_ctx,_arr,key,api_create_string(0,value));
		return true;
	}
	catch (...) {
		strcpy(_error,"Failed to set string value to a parameter!");	
	}
	return false;
}

bool ZeScript::set(const char *key, int value)
{
	if (!check()) return false;
	try {
		api_set_array_object(_ctx,_arr,key,api_create_integer(0,value));
		return true;
	}
	catch (...) {
		strcpy(_error,"Failed to set integer to a parameter!");	
	}
	return false;
}

bool ZeScript::set(const char *key, double value)
{
	if (!check()) return false;
	try {
		api_set_array_object(_ctx,_arr,key,api_create_real(0,value));
		return true;
	}
	catch (...) {
		strcpy(_error,"Failed to set real value to a parameter!");	
	}
	return false;
}

bool ZeScript::exec()
{
	if (!check()) return false;
	int count=0;
	while (!TryEnterCriticalSection(&CriticalSection)) {
		Sleep(1000);
		count++;
		if (count>=0) {
			strcpy(_error,"Failed to enter critical section!");
			return false;
		}
	}
	try {
		int status=api_exec_module(_module,_error);
		LeaveCriticalSection(&CriticalSection);
		return status;
	}
	catch (...) {
		strcpy(_error,"Failed to execute ZS module!");	
	}
	LeaveCriticalSection(&CriticalSection);
	return false;
}

bool ZeScript::check()
{
	_error[0]=0;
	if (!_module || !_ctx || !_arr) {
		strcpy(_error,"ZS module not loaded yet!");
		return false;
	}
	return true;
}

bool ZeScript::error()
{
	if (_error[0]!=0) {
		int n=strlen(_error);
		for (int i=1; i<n; i++) {
			if (_error[i]=='\\') _error[i]='/';
			if (_error[i-1]==':') {
				if (_error[i]=='/') _error[i-1]='/';
			}
		}
		ze_write(_error,n);
		return true;
	}
	return false;
}

