/* toms752.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static integer c__1 = 1;
static integer c__0 = 0;
static real c_b114 = 1.f;

/* Subroutine */ int arcint_752(real *b, real *x1, real *x2, real *y1, real *y2, 
	real *h1, real *h2, real *hx1, real *hx2, real *hy1, real *hy2, real *
	sigma, logical *dflag, real *hp, real *hxp, real *hyp, integer *ier)
{
    /* Initialized data */

    static real sbig = 85.f;

    /* Builtin functions */
    double exp(doublereal);

    /* Local variables */
    real sinh2, e, s, b1, b2, d1, d2, e1, e2, dummy, s1, s2, cm, gn, ds, gt, 
	    dx, dy, sm, tm, ts;
    extern /* Subroutine */ int snhcsh_752(real *, real *, real *, real *);
    real cm2, sb1, sb2, sm2, tm1, tm2, tp1, tp2, cmm, sig, ems;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   11/18/96 */

/*   Gigen a line segment P1-P2 containing a point P = */
/* (XP,YP), along with function values and partial deriva- */
/* tives at the endpoints, this subroutine computes an */
/* interpolated value and, optionally, a gradient at P.  The */
/* value and tangential gradient component at P are taken to */
/* be the value and derivative of the Hermite interpolatory */
/* tension spline H defined by the endpoint values and tan- */
/* gential gradient components.  The normal gradient compo- */
/* nent at P is obtained by linear interpolation applied to */
/* the normal components at the endpoints. */

/* On input: */

/*       B = Local coordinate of P with respect to P1-P2: */
/*           P = B*P1 + (1-B)*P2.  Note that B may be comput- */
/*           ed from the coordinates of P as <P2-P1,P2-P>/ */
/*           <P2-P1,P2-P1>. */

/*       X1,X2,Y1,Y2 = Coordinates of a pair of distinct */
/*                     points P1 and P2. */

/*       H1,H2 = Values of the interpolant H at P1 and P2, */
/*               respectively. */

/*       HX1,HX2,HY1,HY2 = x and y partial derivatives of H */
/*                         at P1 and P2. */

/*       SIGMA = Tension factor associated with P1-P2. */

/*       DFLAG = Logical flag which specifies whether first */
/*               partial derivatives at P are to be computed: */
/*               DFLAG = .TRUE. if and only if partials are */
/*               to be returned. */

/* Input parameters are not altered by this routine. */

/* On output: */

/*       HP = Interpolated value at P unless IER < 0, in */
/*            which case HP is not defined. */

/*       HXP,HYP = x and y partial derivatives at P unless */
/*                 DFLAG = FALSE or IER < 0. */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered. */
/*             IER = 1 if B < 0 or B > 1 and thus HP is an */
/*                     extrapolated value. */
/*             IER = -1 if P1 and P2 coincide. */

/* SRFPACK module required by ARCINT:  SNHCSH */

/* Intrinsic functions called by ARCINT:  ABS, EXP */

/* *********************************************************** */


    dx = *x2 - *x1;
    dy = *y2 - *y1;
    ds = dx * dx + dy * dy;
    if (ds == 0.f) {
	goto L1;
    }
    *ier = 0;

/* Compute local coordinates B1 and B2, tangential deriva- */
/*   tives S1 and S2, slope S, and second differences D1 and */
/*   D2.  S1, S2, S, D1, and D2 are scaled by the separation */
/*   D between P1 and P2. */

    b1 = *b;
    b2 = 1.f - b1;
    if (b1 < 0.f || b2 < 0.f) {
	*ier = 1;
    }
    s1 = *hx1 * dx + *hy1 * dy;
    s2 = *hx2 * dx + *hy2 * dy;
    s = *h2 - *h1;
    d1 = s - s1;
    d2 = s2 - s;

/* Compute HP and, if required, the scaled tangential grad- */
/*   ient component GT. */

    sig = dabs(*sigma);
    if (sig < 1e-9f) {

/* SIG = 0:  use Hermite cubic interpolation. */

	*hp = *h1 + b2 * (s1 + b2 * (d1 + b1 * (d1 - d2)));
	if (! (*dflag)) {
	    return 0;
	}
	gt = s1 + b2 * (d1 + d2 + b1 * 3.f * (d1 - d2));
    } else if (sig <= .5f) {

/* 0 .LT. SIG .LE. .5:  use approximations designed to avoid */
/*   cancellation error in the hyperbolic functions. */

	sb2 = sig * b2;
	snhcsh_752(&sig, &sm, &cm, &cmm);
	snhcsh_752(&sb2, &sm2, &cm2, &dummy);
	e = sig * sm - cmm - cmm;
	*hp = *h1 + b2 * s1 + ((cm * sm2 - sm * cm2) * (d1 + d2) + sig * (cm *
		 cm2 - (sm + sig) * sm2) * d1) / (sig * e);
	if (! (*dflag)) {
	    return 0;
	}
	sinh2 = sm2 + sb2;
	gt = s1 + ((cm * cm2 - sm * sinh2) * (d1 + d2) + sig * (cm * sinh2 - (
		sm + sig) * cm2) * d1) / e;
    } else {

/* SIG > .5:  use negative exponentials in order to avoid */
/*   overflow.  Note that EMS = EXP(-SIG).  In the case of */
/*   extrapolation (negative B1 or B2), H is approximated */
/*   by a linear function if -SIG*B1 or -SIG*B2 is large. */

	sb1 = sig * b1;
	sb2 = sig - sb1;
	if (-(doublereal)sb1 > sbig || -(doublereal)sb2 > sbig) {
	    *hp = *h1 + b2 * s;
	    if (! (*dflag)) {
		return 0;
	    }
	    gt = s;
	} else {
	    e1 = exp(-(doublereal)sb1);
	    e2 = exp(-(doublereal)sb2);
	    ems = e1 * e2;
	    tm = 1.f - ems;
	    ts = tm * tm;
	    tm1 = 1.f - e1;
	    tm2 = 1.f - e2;
	    e = tm * (sig * (ems + 1.f) - tm - tm);
	    *hp = *h1 + b2 * s + (tm * tm1 * tm2 * (d1 + d2) + sig * ((e2 * 
		    tm1 * tm1 - b1 * ts) * d1 + (e1 * tm2 * tm2 - b2 * ts) * 
		    d2)) / (sig * e);
	    if (! (*dflag)) {
		return 0;
	    }
	    tp1 = e1 + 1.f;
	    tp2 = e2 + 1.f;
	    gt = s + (tm1 * (tm * tp2 - sig * e2 * tp1) * d1 - tm2 * (tm * 
		    tp1 - sig * e1 * tp2) * d2) / e;
	}
    }

/* Compute the gradient at P, (HXP,HYP) = (GT/D)T + (GN/D)N, */
/*   where T = (DX,DY)/D (unit tangent vector), N = (-DY,DX)/ */
/*   D (unit normal), and the scaled normal component is GN = */
/*   B1<(HX1,HY1),N> + B2<(HX2,HY2),N>. */

    gn = b1 * (*hy1 * dx - *hx1 * dy) + b2 * (*hy2 * dx - *hx2 * dy);
    *hxp = (gt * dx - gn * dy) / ds;
    *hyp = (gt * dy + gn * dx) / ds;
    return 0;

/* P1 and P2 coincide. */

L1:
    *ier = -1;
    return 0;
} /* arcint_752752 */

/* Subroutine */ int cntour_(integer *nx, integer *ny, real *x, real *y, real 
	*z, real *cval, integer *lc, integer *ncmax, integer *iwk, real *xc, 
	real *yc, integer *ilc, integer *nc, integer *ier)
{
    /* Initialized data */

    static integer lun = 0;

    /* Format strings */
    static char fmt_100[] = "(///5x,\002Error in CNTOUR:  Contour line L "
	    "\002,\002begins on the boundary\002/5x,\002and terminates \002"
	    ",\002in the interior for L =\002,i4/)";
    static char fmt_110[] = "(///5x,\002Error in CNTOUR:  Contour line L "
	    "\002,\002is open but\002/5x,\002does not intersect the \002,\002"
	    "boundary for L =\002,i4/)";

    /* System generated locals */
    integer iwk_dim1, iwk_offset, z_dim1, z_offset, i__1, i__2;

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void);

    /* Local variables */
    integer isid, lcon, ncon;
    logical bdry;
    integer ncmx, i, j, k;
    real w;
    integer isidb, isidn, i1, i2, j1, j2;
    real z1, z2;
    integer ib, jb, in, jn, ni, nj;
    real cv, xf, yf, xn, xp, yn, yp;
    integer ind, lmx, nim1, njm1;

    /* Fortran I/O blocks */
    static cilist io___65 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___70 = { 0, 0, 0, fmt_110, 0 };



/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   04/28/90 */

/*   Given a set of function values Z = F(X,Y) at the verti- */
/* ces of an NX by NY rectangular grid, this subroutine de- */
/* termines a set of contour lines associated with F = CVAL. */
/* A contour line is specified by an ordered sequence of */
/* points (XC,YC), each lying on a grid edge and computed */
/* from the linear interpolant of the function values at the */
/* endpoints of the edge.  The accuracy of the contour lines */
/* is thus directly related to the number of grid points.  If */
/* a contour line forms a closed curve, the first point coin- */
/* cides with the last point.  Otherwise, the first and last */
/* points lie on the grid boundary. */

/*   Note that the problem is ill-conditioned in the vicinity */
/* of a double zero of F-CVAL.  Thus, if a grid cell is */
/* crossed by two contour lines (all four sides intersected), */
/* three different configurations are possible, corresponding */
/* to a local minimum, a local maximum, or a saddle point. */
/* It is arbitrarily assumed in this case that the contour */
/* lines intersect, representing a saddle point.  Also, in */
/* order to treat the case of F = CVAL at a vertex in a con- */
/* sistent manner, this case is always treated as F > CVAL. */
/* Hence, if F takes on the same value at both ends of an */
/* edge, it is assumed that no contour line intersects that */
/* edge.  In particular, a constant function, including */
/* F = CVAL, results in no contour lines. */

/* On input: */

/*       NX = Number of grid points in the x direction. */
/*            NX .GE. 2. */

/*       NY = Number of grid points in the y direction. */
/*            NY .GE. 2. */

/*       X = Array of length NX containing a strictly in- */
/*           creasing sequence of values. */

/*       Y = Array of length NY containing a strictly in- */
/*           creasing sequence of values. */

/*       Z = Array of function values at the vertices of the */
/*           rectangular grid.  Z(I,J) = F(X(I),Y(J)) for */
/*           I = 1,...,NX and J = 1,...,NY. */

/*       CVAL = Constant function value defining a contour */
/*              line as the set of points (X,Y) such that */
/*              F(X,Y) = CVAL. */

/*       LC = Length of arrays XC and YC, and maximum allow- */
/*            able number of points defining contour lines. */
/*            LC = 2(NX-1)(NY-1) + (NX*NY+1)/2 is (probably */
/*            more than) sufficient.  LC .GE. 2. */

/*       NCMAX = Length of array ILC, and maximum allowable */
/*               number of contour lines.  NCMAX = (NX*NY+1)/ */
/*               2 is sufficient.  NCMAX .GE. 1. */

/* The above parameters are not altered by this routine. */

/*       IWK = Integer array of length .GE. NX*(NY-1) to be */
/*             used as work space. */

/*       XC,YC = Arrays of length LC. */

/*       ILC = Integer array of length NCMAX. */

/* On output: */

/*       XC,YC = Arrays containing the coordinates of NC con- */
/*               tour lines.  For K = 1,...,NC, contour line */
/*               K is defined by the sequence of points with */
/*               indexes ILC(K-1)+1,...,ILC(K) where ILC(0) = */
/*               0. */

/*       ILC = Array containing the indexes (to XC and YC) */
/*             associated with the terminal point of contour */
/*             line K in position K for K = 1,...,NC (if NC */
/*             .GT. 0). */

/*       NC = Number of contour lines whose points are stored */
/*            in XC and YC. */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered and all */
/*                     contour lines were found. */
/*             IER = 1 if NX, NY, LC, or NCMAX is outside its */
/*                     valid range.  NC = 0 and XC, YC, and */
/*                     ILC are not altered in this case. */
/*             IER = 2 if X or Y is not strictly increasing. */
/*                     NC = 0 and XC, YC, and ILC are not */
/*                     altered in this case. */
/*             IER = K for K > LC, where K is the required */
/*                     length of XC and YC, if more storage */
/*                     space is required to complete the */
/*                     specification of contour line NC and/ */
/*                     or additional contour lines up to a */
/*                     total of NCMAX.  NC .GE. 1 and ILC(NC) */
/*                     = LC in this case. */
/*            IER = -1 if more than NCMAX contour lines are */
/*                     present (more space is required in */
/*                     ILC).  NC = NCMAX, and LC may or may */
/*                     not be sufficient for the additional */
/*                     contour lines in this case.  (This is */
/*                     not determined.) */

/*   In the unlikely event of an internal failure, a message */
/* is printed on logical unit LUN (specified in the DATA */
/* statement below).  IER may be 0 in this case. */

/* Modules required by CNTOUR:  None */

/* *********************************************************** */

    /* Parameter adjustments */
    --ilc;
    --yc;
    --xc;
    iwk_dim1 = *nx;
    iwk_offset = iwk_dim1 + 1;
    iwk -= iwk_offset;
    z_dim1 = *nx;
    z_offset = z_dim1 + 1;
    z -= z_offset;
    --y;
    --x;

    /* Function Body */

/* Store parameters in local variables. */

    ni = *nx;
    nj = *ny;
    nim1 = ni - 1;
    njm1 = nj - 1;
    cv = *cval;
    lmx = *lc;
    ncmx = *ncmax;
    *nc = 0;

/* Test for invalid input parameters. */

    *ier = 1;
    if (ni < 2 || nj < 2 || lmx < 2 || ncmx < 1) {
	return 0;
    }

/* Test for nonincreasing values of X or Y. */

    *ier = 2;
    i__1 = ni;
    for (i = 2; i <= i__1; ++i) {
	if (x[i] <= x[i - 1]) {
	    return 0;
	}
/* L1: */
    }
    i__1 = nj;
    for (j = 2; j <= i__1; ++j) {
	if (y[j] <= y[j - 1]) {
	    return 0;
	}
/* L2: */
    }

/* Loop on grid cells, initializing edge indicators (stored */
/*   in IWK) to zeros.  For each cell, the indicator IND is a */
/*   4-bit integer with each bit corresponding to an edge of */
/*   the cell, and having value 1 iff the edge has been pro- */
/*   cessed.  Note that two IND values must be adjusted when */
/*   an interior edge is processed.  The cell sides (edges) */
/*   are numbered (1,2,4,8) in counterclockwise order start- */
/*   ing from the bottom.  This corresponds to an ordering of */
/*   the weighted IND bits from low order to high order. */
/*   Grid cells are identified with their lower left corners. */

    i__1 = njm1;
    for (j = 1; j <= i__1; ++j) {
	i__2 = nim1;
	for (i = 1; i <= i__2; ++i) {
	    iwk[i + j * iwk_dim1] = 0;
/* L3: */
	}
/* L4: */
    }

/* First determine open contours by looping on boundary edges */
/*   in counterclockwise order starting from the lower left. */
/*   For each unprocessed boundary edge intersected by a con- */
/*   tour line, the contour line is determined and IWK is up- */
/*   dated to reflect the edges intersected.  The boundary */
/*   cell (lower left corner) is indexed by (IB,JB) and the */
/*   boundary edge is specified by ISIDB.  NCON and LCON are */
/*   local variables containing the number of contour lines */
/*   encountered and the current length of XC and YC. */

    ncon = 0;
    lcon = 0;
    isidb = 1;
    ib = 1;
    jb = 1;

/* Top of loop on boundary edges.  The edge has been */
/*   processed iff IND/ISIDB is odd. */

L5:
    ind = iwk[ib + jb * iwk_dim1];
    if (ind / isidb != ind / isidb / 2 << 1) {
	goto L9;
    }

/* Update the edge indicator and store the vertex indexes of */
/*   the endpoints of the edge. */

    iwk[ib + jb * iwk_dim1] = ind + isidb;
    if (isidb == 1) {
	i1 = ib;
	j1 = jb;
	i2 = ib + 1;
	j2 = jb;
    } else if (isidb == 2) {
	i1 = ib + 1;
	j1 = jb;
	i2 = ib + 1;
	j2 = jb + 1;
    } else if (isidb == 4) {
	i1 = ib + 1;
	j1 = jb + 1;
	i2 = ib;
	j2 = jb + 1;
    } else {
	i1 = ib;
	j1 = jb + 1;
	i2 = ib;
	j2 = jb;
    }

/* Proceed to the next edge if there is no intersection. */

    z1 = z[i1 + j1 * z_dim1];
    z2 = z[i2 + j2 * z_dim1];
    if (z1 < cv && z2 < cv || z1 >= cv && z2 >= cv) {
	goto L9;
    }

/* Store the zero of the linear interpolant of Z1-CV and */
/*   Z2-CV as the first point of an open contour unless */
/*   NCMAX contour lines have been found or there is in- */
/*   sufficient space reserved for XC and YC. */

    if (ncon == ncmx) {
	*ier = -1;
	goto L16;
    }
    ++ncon;
    ++lcon;
    w = (cv - z1) / (z2 - z1);
    xp = x[i1] + w * (x[i2] - x[i1]);
    yp = y[j1] + w * (y[j2] - y[j1]);
    if (lcon <= lmx) {
	xc[lcon] = xp;
	yc[lcon] = yp;
    }

/* Initialize for loop on cells intersected by the open */
/*   contour line. */

    i = ib;
    j = jb;
    isid = isidb;

/* Traverse the contour line.  Cell (I,J) was entered on side */
/*   ISID = (I1,J1)->(I2,J2).  Find an exit edge E (unproces- */
/*   sed edge intersected by the contour) by looping on the */
/*   remaining three sides, starting with the side opposite */
/*   ISID. */

L6:
    ind = iwk[i + j * iwk_dim1];
    for (k = 1; k <= 3; ++k) {
	isid <<= 1;
	if (k != 2) {
	    isid <<= 1;
	}
	if (isid > 15) {
	    isid /= 16;
	}
	if (isid == 1) {
	    i1 = i;
	    j1 = j;
	    i2 = i + 1;
	    j2 = j;
	} else if (isid == 2) {
	    i1 = i + 1;
	    j1 = j;
	    i2 = i + 1;
	    j2 = j + 1;
	} else if (isid == 4) {
	    i1 = i + 1;
	    j1 = j + 1;
	    i2 = i;
	    j2 = j + 1;
	} else {
	    i1 = i;
	    j1 = j + 1;
	    i2 = i;
	    j2 = j;
	}

/* Test for a 1 in bit position ISID of cell (I,J) and bypass */
/*   the edge if it has been previously encountered. */

	if (ind / isid != ind / isid / 2 << 1) {
	    goto L7;
	}

/* Update IWK for edge E = (I1,J1)->(I2,J2).  (IN,JN) indexes */
/*   the cell which shares E with cell (I,J), and ISIDN is */
/*   the side number of E in (IN,JN).  BDRY is true iff E is */
/*   a boundary edge (with no neighboring cell). */

	iwk[i + j * iwk_dim1] += isid;
	if (isid <= 2) {
	    in = i1;
	    jn = j2 - 1;
	    isidn = isid << 2;
	} else {
	    in = i1 - 1;
	    jn = j2;
	    isidn = isid / 4;
	}
	bdry = in == 0 || in == ni || jn == 0 || jn == nj;
	if (! bdry) {
	    iwk[in + jn * iwk_dim1] += isidn;
	}

/* Exit the loop on sides if E is intersected by the contour. */

	z1 = z[i1 + j1 * z_dim1];
	z2 = z[i2 + j2 * z_dim1];
	if (z1 < cv && z2 >= cv || z1 >= cv && z2 < cv) {
	    goto L8;
	}
L7:
	;
    }
/* * */
/* Error -- No exit point found.  Print a message and exit */
/*          the contour traversal loop. */

    io___65.ciunit = lun;
    s_wsfe(&io___65);
    do_fio(&c__1, (char *)&ncon, (ftnlen)sizeof(integer));
    e_wsfe();
    ilc[ncon] = lcon;
    goto L9;
/* * */
/* Add the intersection point (XN,YN) to the list unless it */
/*   coincides with the previous point (XP,YP) or there is */
/*   not enough space in XC and YC. */

L8:
    w = (cv - z1) / (z2 - z1);
    xn = x[i1] + w * (x[i2] - x[i1]);
    yn = y[j1] + w * (y[j2] - y[j1]);
    if (xn != xp || yn != yp) {
	++lcon;
	xp = xn;
	yp = yn;
	if (lcon <= lmx) {
	    xc[lcon] = xn;
	    yc[lcon] = yn;
	}
    }

/* Bottom of contour traversal loop.  If E is not a boundary */
/*   edge, reverse the edge direction (endpoint indexes) and */
/*   update the cell index and side number. */

    if (! bdry) {
	i = i1;
	j = j1;
	i1 = i2;
	j1 = j2;
	i2 = i;
	j2 = j;
	i = in;
	j = jn;
	isid = isidn;
	goto L6;
    }

/* Update ILC with a pointer to the end of the contour line. */

    ilc[ncon] = lcon;

/* Bottom of loop on boundary edges.  Update the boundary */
/*   cell index and side number, and test for termination. */

L9:
    if (isidb == 1) {
	if (ib < nim1) {
	    ++ib;
	} else {
	    isidb = 2;
	}
    } else if (isidb == 2) {
	if (jb < njm1) {
	    ++jb;
	} else {
	    isidb = 4;
	}
    } else if (isidb == 4) {
	if (ib > 1) {
	    --ib;
	} else {
	    isidb = 8;
	}
    } else {
	if (jb > 1) {
	    --jb;
	} else {
	    isidb = 16;
	}
    }
    if (isidb < 16) {
	goto L5;
    }

/* Determine closed contours by looping on interior edges -- */
/*   the first two sides (bottom and right) of each cell, */
/*   excluding boundary edges.  The beginning cell is indexed */
/*   by (IB,JB), and the beginning side number is ISIDB. */

    i__1 = njm1;
    for (jb = 1; jb <= i__1; ++jb) {
	i__2 = nim1;
	for (ib = 1; ib <= i__2; ++ib) {
	    for (isidb = 1; isidb <= 2; ++isidb) {
		if (jb == 1 && isidb == 1) {
		    goto L13;
		}
		if (ib == nim1 && isidb == 2) {
		    goto L13;
		}

/* Bypass the edge if it was previously encountered */
/*   (IND/ISIDB odd). */

		ind = iwk[ib + jb * iwk_dim1];
		if (ind / isidb != ind / isidb / 2 << 1) {
		    goto L13;
		}

/* Determine the endpoint indexes of the beginning edge E = */
/*   (I1,J1)->(I2,J2), find the index (I,J) and side number */
/*   ISID of the cell which shares E with (IB,JB), and up- */
/*   date IWK. */

		if (isidb == 1) {
		    i1 = ib;
		    j1 = jb;
		    i2 = ib + 1;
		    j2 = jb;
		    i = ib;
		    j = jb - 1;
		    isid = 4;
		} else {
		    i1 = ib + 1;
		    j1 = jb;
		    i2 = ib + 1;
		    j2 = jb + 1;
		    i = i1;
		    j = j1;
		    isid = 8;
		}
		iwk[ib + jb * iwk_dim1] = ind + isidb;
		iwk[i + j * iwk_dim1] += isid;

/* Proceed to the next interior edge if there is no */
/*   intersection. */

		z1 = z[i1 + j1 * z_dim1];
		z2 = z[i2 + j2 * z_dim1];
		if (z1 < cv && z2 < cv || z1 >= cv && z2 >= cv) {
		    goto L13;
		}

/* Store the intersection point as the first point of a */
/*   closed contour unless NCMAX contour lines have been */
/*   found or there is insufficient space in XC and YC. */

		if (ncon == ncmx) {
		    *ier = -1;
		    goto L16;
		}
		++ncon;
		++lcon;
		w = (cv - z1) / (z2 - z1);
		xp = x[i1] + w * (x[i2] - x[i1]);
		yp = y[j1] + w * (y[j2] - y[j1]);
		if (lcon <= lmx) {
		    xc[lcon] = xp;
		    yc[lcon] = yp;
		}
		xf = xp;
		yf = yp;

/* Traverse the contour line.  Cell (I,J) was entered on side 
*/
/*   ISID = edge (I2,J2)->(I1,J1).  Reverse the edge direc- */
/*   tion. */

L10:
		in = i1;
		jn = j1;
		i1 = i2;
		j1 = j2;
		i2 = in;
		j2 = jn;
		ind = iwk[i + j * iwk_dim1];

/* Find an exit edge E by looping on the remaining three */
/*   sides, starting with the side opposite ISID. */

		for (k = 1; k <= 3; ++k) {
		    isid <<= 1;
		    if (k != 2) {
			isid <<= 1;
		    }
		    if (isid > 15) {
			isid /= 16;
		    }
		    if (isid == 1) {
			i1 = i;
			j1 = j;
			i2 = i + 1;
			j2 = j;
		    } else if (isid == 2) {
			i1 = i + 1;
			j1 = j;
			i2 = i + 1;
			j2 = j + 1;
		    } else if (isid == 4) {
			i1 = i + 1;
			j1 = j + 1;
			i2 = i;
			j2 = j + 1;
		    } else {
			i1 = i;
			j1 = j + 1;
			i2 = i;
			j2 = j;
		    }

/* Bypass the edge if it has been previously encountered. 
*/

		    if (ind / isid != ind / isid / 2 << 1) {
			goto L11;
		    }

/* Determine the index (IN,JN) and side number ISIDN of th
e */
/*   cell which shares edge E = (I1,J1)->(I2,J2) with cell
 */
/*   (I,J), and update IWK. */

		    if (isid <= 2) {
			in = i1;
			jn = j2 - 1;
			isidn = isid << 2;
		    } else {
			in = i1 - 1;
			jn = j2;
			isidn = isid / 4;
		    }
		    iwk[i + j * iwk_dim1] += isid;
		    iwk[in + jn * iwk_dim1] += isidn;

/* Exit the loop on sides if E is intersected. */

		    z1 = z[i1 + j1 * z_dim1];
		    z2 = z[i2 + j2 * z_dim1];
		    if (z1 < cv && z2 >= cv || z1 >= cv && z2 < cv) {
			goto L12;
		    }
L11:
		    ;
		}
/* * */
/* Error -- No exit point found.  Print a message and exit */
/*          the contour traversal loop. */

		io___70.ciunit = lun;
		s_wsfe(&io___70);
		do_fio(&c__1, (char *)&ncon, (ftnlen)sizeof(integer));
		e_wsfe();
		ilc[ncon] = lcon;
		goto L13;
/* * */
/* Add the intersection point to the list unless it coincides 
*/
/*   with the previous point or there is not enough space in 
*/
/*   XC and YC. */

L12:
		w = (cv - z1) / (z2 - z1);
		xn = x[i1] + w * (x[i2] - x[i1]);
		yn = y[j1] + w * (y[j2] - y[j1]);
		if (xn != xp || yn != yp) {
		    ++lcon;
		    xp = xn;
		    yp = yn;
		    if (lcon <= lmx) {
			xc[lcon] = xn;
			yc[lcon] = yn;
		    }
		}

/* Bottom of contour traversal loop.  If the next cell is not 
*/
/*   the beginning cell, update the cell index and side num- 
*/
/*   ber. */

		if (in != ib || jn != jb) {
		    i = in;
		    j = jn;
		    isid = isidn;
		    goto L10;
		}

/* Add the first point as the last point (unless the first */
/*   and last points already coincide), and update ILC. */

		if (xp != xf || yp != yf) {
		    ++lcon;
		    if (lcon <= lmx) {
			xc[lcon] = xf;
			yc[lcon] = yf;
		    }
		}
		ilc[ncon] = lcon;

/* Bottom of loop on interior edges. */

L13:
		;
	    }
/* L14: */
	}
/* L15: */
    }
    *ier = 0;

/* Test for insufficient storage reserved for XC and YC. */

L16:
    if (lcon > lmx) {
	*ier = lcon;
    }
    *nc = ncon;
    return 0;
} /* cntour_ */

/* Subroutine */ int coords_(real *xp, real *yp, real *x1, real *x2, real *x3,
	 real *y1, real *y2, real *y3, real *b1, real *b2, real *b3, integer *
	ier)
{
    real a, px, py, xp1, xp2, xp3, yp1, yp2, yp3;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   09/01/88 */

/*   This subroutine computes the barycentric (areal) coordi- */
/* nates B1, B2, and B3 of a point P with respect to the tri- */
/* angle with vertices P1, P2, and P3:  the solution to the */
/* linear system defined by B1 + B2 + B3 = 1 and B1*P1 + */
/* B2*P2 + B3*P3 = P.  Note that B1 is a linear function */
/* of P which satisfies B1 = 1 at P = P1 and B1 = 0 on */
/* the triangle side P2-P3.  Also, B1 < 0 if and only if */
/* P is to the right of P2->P3 (and thus exterior to the */
/* triangle).  B2 and B3 satisfy similar properties. */

/* On input: */

/*       XP,YP = Cartesian coordinates of P. */

/*       X1,X2,X3,Y1,Y2,Y3 = Coordinates of the vertices of */
/*                           the triangle P1, P2, and P3. */

/* Input parameters are not altered by this routine. */

/* On output: */

/*       B1,B2,B3 = Barycentric coordinates unless IER = 1, */
/*                  in which case the coordinates are not */
/*                  defined. */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered. */
/*             IER = 1 if the vertices of the triangle are */
/*                     collinear. */

/* Modules required by COORDS:  None */

/* *********************************************************** */


    px = *xp;
    py = *yp;

/* Compute components of the vectors P->P1, P->P2, and P->P3. */

    xp1 = *x1 - px;
    yp1 = *y1 - py;
    xp2 = *x2 - px;
    yp2 = *y2 - py;
    xp3 = *x3 - px;
    yp3 = *y3 - py;

/* Compute subtriangle areas B1 = P->P2 X P->P3, B2 = P->P3 X */
/*   P->P1, and B3 = P->P1 X P->P2. */

    *b1 = xp2 * yp3 - xp3 * yp2;
    *b2 = xp3 * yp1 - xp1 * yp3;
    *b3 = xp1 * yp2 - xp2 * yp1;

/* Compute twice the signed area of the triangle. */

    a = *b1 + *b2 + *b3;
    if (a == 0.f) {
	goto L1;
    }

/* Normalize the coordinates. */

    *b1 /= a;
    *b2 /= a;
    *b3 /= a;
    *ier = 0;
    return 0;

/* The vertices are collinear. */

L1:
    *ier = -1;
    return 0;
} /* coords_ */

/* Subroutine */ int crplot_(integer *lun, real *pltsiz, integer *nx, integer 
	*ny, real *px, real *py, real *pz, integer *ncon, integer *iwk, real *
	xc, real *yc, integer *ier)
{
    /* Format strings */
    static char fmt_100[] = "(\002%!PS-Adobe-3.0 EPSF-3.0\002/\002%%Bounding"
	    "Box:\002,4i4/\002%%Title:  Contour Plot\002/\002%%Creator:  SRFP"
	    "ACK\002/\002%%EndComments\002)";
    static char fmt_110[] = "(2i4,\002 moveto\002)";
    static char fmt_120[] = "(2i4,\002 lineto\002)";
    static char fmt_130[] = "(\002closepath\002)";
    static char fmt_140[] = "(\002stroke\002)";
    static char fmt_150[] = "(2f12.6,\002 translate\002/2f12.6,\002 scale"
	    "\002)";
    static char fmt_160[] = "(f12.6,\002 setlinewidth\002)";
    static char fmt_170[] = "(2f12.6,\002 moveto\002)";
    static char fmt_180[] = "(2f12.6,\002 lineto\002)";
    static char fmt_200[] = "(\002showpage\002/\002%%EOF\002)";
    static char fmt_210[] = "(a1)";

    /* System generated locals */
    integer pz_dim1, pz_offset, i__1, i__2;
    real r__1;

    /* Builtin functions */
    integer i_nint(real *), s_wsfe(cilist *), do_fio(integer *, char *, 
	    ftnlen), e_wsfe(void);

    /* Local variables */
    real cval;
    integer ierr;
    real pzij, zmin, zmax;
    integer i, j, k;
    real r, t;
    integer ncmax, ic, lc, ih, nc;
    real dx, dy, dz;
    integer iw, kv;
    real tx, ty;
    extern /* Subroutine */ int cntour_(integer *, integer *, real *, real *, 
	    real *, real *, integer *, integer *, integer *, real *, real *, 
	    integer *, integer *, integer *);
    real sfx, sfy;
    integer ipx1, ipx2, ipy1, ipy2;

    /* Fortran I/O blocks */
    static cilist io___94 = { 1, 0, 0, fmt_100, 0 };
    static cilist io___95 = { 1, 0, 0, fmt_110, 0 };
    static cilist io___96 = { 1, 0, 0, fmt_120, 0 };
    static cilist io___97 = { 1, 0, 0, fmt_120, 0 };
    static cilist io___98 = { 1, 0, 0, fmt_120, 0 };
    static cilist io___99 = { 1, 0, 0, fmt_130, 0 };
    static cilist io___100 = { 1, 0, 0, fmt_140, 0 };
    static cilist io___107 = { 1, 0, 0, fmt_150, 0 };
    static cilist io___108 = { 1, 0, 0, fmt_160, 0 };
    static cilist io___117 = { 1, 0, 0, fmt_170, 0 };
    static cilist io___118 = { 1, 0, 0, fmt_180, 0 };
    static cilist io___119 = { 1, 0, 0, fmt_140, 0 };
    static cilist io___120 = { 1, 0, 0, fmt_200, 0 };
    static cilist io___121 = { 1, 0, 0, fmt_210, 0 };



/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   04/12/97 */

/*   Given a set of function values PZ = F(X,Y) at the ver- */
/* tices of an NX by NY rectangular grid, this subroutine */
/* creates a level-2 Encapsulated PostScript (EPS) file */
/* containing a contour plot of the piecewise bilinear inter- */
/* polant of the function values. */

/*   The accuracy of the contour lines increases with the */
/* number of grid points.  Refer to Subroutine CNTOUR for */
/* further details. */


/* On input: */

/*       LUN = Logical unit number in the range 0 to 99. */
/*             The unit should be opened with an appropriate */
/*             file name before the call to this routine. */

/*       PLTSIZ = Plot size in inches.  A window containing */
/*                the plot is mapped, with aspect ratio */
/*                preserved, to a rectangular viewport with */
/*                maximum side-length PLTSIZ.  The viewport */
/*                is centered on the 8.5 by 11 inch page, and */
/*                its boundary is drawn.  1.0 .LE. PLTSIZ */
/*                .LE. 7.5. */

/*       NX = Number of grid points in the x direction. */
/*            NX .GE. 2. */

/*       NY = Number of grid points in the y direction. */
/*            NY .GE. 2. */

/*       PX = Array of length NX containing a strictly in- */
/*            creasing sequence of values. */

/*       PY = Array of length NY containing a strictly in- */
/*            creasing sequence of values. */

/*       PZ = Array of function values at the vertices of the */
/*            rectangular grid.  PZ(I,J) = F(PX(I),PY(J)) for */
/*            I = 1,...,NX and J = 1,...,NY. */

/*       NCON = Number of contour values.  The contour values */
/*              are uniformly distributed over the range of */
/*              PZ values.  NCON .GE. 1. */

/* The above parameters are not altered by this routine. */

/*       IWK = Integer array of length at least 1.5*NX*NY to */
/*             be used as work space. */

/*       XC,YC = Real arrays of length at least 2.5*NX*NY to */
/*               be used as work space. */

/* On output: */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered. */
/*             IER = 1 if LUN, PLTSIZ, NX, NY, or NCON is */
/*                     outside its valid range. */
/*             IER = 2 if PX or PY is not strictly */
/*                     increasing. */
/*             IER = 3 if the range of PZ values has zero */
/*                     width (F is constant). */
/*             IER = 4 if an error was encountered in writing */
/*                     to unit LUN. */
/*             IER = 5 if an unexpected error flag was re- */
/*                     turned by Subroutine CNTOUR.  This */
/*                     should not occur. */

/*   In the unlikely event of an internal failure, a message */
/* is printed on the standard output device.  IER may be 0 */
/* in this case. */

/* Module required by CRPLOT:  CNTOUR */

/* Intrinsic functions called by CRPLOT:  CHAR, REAL */

/* *********************************************************** */


/* Local parameters: */

/* CVAL =      Contour value between ZMIN and ZMAX */
/* DX =        Window width PX(NX)-PX(1)N */
/* DY =        Window height PY(NY)-PY(1) */
/* DZ =        Interval between contour values: */
/*               (ZMAX-ZMIN)/(NCON+1) */
/* I,J =       Row and column indexes for PZ */
/* IC =        Index (for IWK) of a contour line associated */
/*               with contour value CVAL:  1 to NC */
/* IERR =      Error flag for calls to CNTOUR */
/* IH =        Height of the bounding box (viewport) in */
/*               points */
/* IPX1,IPY1 = X and y coordinates (in points) of the lower */
/*               left corner of the bounding box */
/* IPX2,IPY2 = X and y coordinates (in points) of the upper */
/*               right corner of the bounding box */
/* IW =        Width of the bounding box in points */
/* K =         Index (for XC and YC) of a point on a contour */
/*               line */
/* KV =        DO-loop index for loop on contour values */
/* LC =        Length of arrays XC and YC */
/* NC =        Number of contour lines associated with */
/*               contour value CVAL */
/* NCMAX =     Maximum allowable value of NC */
/* PZIJ =      PZ(I,J) */
/* R =         Aspect ratio DX/DY */
/* SFX,SFY =   Scale factors for mapping window coordinates */
/*               to viewport coordinates */
/* T =         Temporary variable */
/* TX,TY =     Translation vector for mapping window coordi- */
/*               nates to viewport coordinates */
/* ZMIN,ZMAX = Minimum and maximum of the PZ values */


/* Test for error 1. */

    /* Parameter adjustments */
    --yc;
    --xc;
    --iwk;
    pz_dim1 = *nx;
    pz_offset = pz_dim1 + 1;
    pz -= pz_offset;
    --py;
    --px;

    /* Function Body */
    if (*lun < 0 || *lun > 99 || *pltsiz < 1.f || *pltsiz > 7.5f || *nx < 2 ||
	     *ny < 2 || *ncon < 1) {
	goto L11;
    }

/* Compute the aspect ratio of the window. */

    dx = px[*nx] - px[1];
    dy = py[*ny] - py[1];
    if (dx == 0.f || dy == 0.f) {
	goto L12;
    }
    r = dx / dy;

/* Compute the range of PZ values and the interval between */
/*   contour values. */

    zmin = pz[pz_dim1 + 1];
    zmax = zmin;
    i__1 = *ny;
    for (j = 1; j <= i__1; ++j) {
	i__2 = *nx;
	for (i = 1; i <= i__2; ++i) {
	    pzij = pz[i + j * pz_dim1];
	    if (pzij < zmin) {
		zmin = pzij;
	    }
	    if (pzij > zmax) {
		zmax = pzij;
	    }
/* L1: */
	}
/* L2: */
    }
    dz = (zmax - zmin) / (real) (*ncon + 1);
    if (dz <= 0.f) {
	goto L13;
    }

/* Compute the lower left (IPX1,IPY1) and upper right */
/*   (IPX2,IPY2) corner coordinates of the bounding box */
/*   (the viewport).  The coordinates, specified in default */
/*   user space units (points, at 72 points/inch with origin */
/*   at the lower left corner of the page), are chosen to */
/*   preserve the aspect ratio R, and to center the plot on */
/*   the 8.5 by 11 inch page.  The center of the page is */
/*   (306,396), and T = PLTSIZ/2 in points. */

    t = *pltsiz * 36.f;
    if (r >= 1.f) {
	ipx1 = 306 - i_nint(&t);
	ipx2 = i_nint(&t) + 306;
	r__1 = t / r;
	ipy1 = 396 - i_nint(&r__1);
	r__1 = t / r;
	ipy2 = i_nint(&r__1) + 396;
    } else {
	r__1 = t * r;
	ipx1 = 306 - i_nint(&r__1);
	r__1 = t * r;
	ipx2 = i_nint(&r__1) + 306;
	ipy1 = 396 - i_nint(&t);
	ipy2 = i_nint(&t) + 396;
    }

/* Output header comments. */

    io___94.ciunit = *lun;
    i__1 = s_wsfe(&io___94);
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ipx1, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ipy1, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ipx2, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ipy2, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = e_wsfe();
    if (i__1 != 0) {
	goto L14;
    }

/* Draw the bounding box. */

    io___95.ciunit = *lun;
    i__1 = s_wsfe(&io___95);
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ipx1, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ipy1, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = e_wsfe();
    if (i__1 != 0) {
	goto L14;
    }
    io___96.ciunit = *lun;
    i__1 = s_wsfe(&io___96);
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ipx1, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ipy2, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = e_wsfe();
    if (i__1 != 0) {
	goto L14;
    }
    io___97.ciunit = *lun;
    i__1 = s_wsfe(&io___97);
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ipx2, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ipy2, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = e_wsfe();
    if (i__1 != 0) {
	goto L14;
    }
    io___98.ciunit = *lun;
    i__1 = s_wsfe(&io___98);
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ipx2, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ipy1, (ftnlen)sizeof(integer));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = e_wsfe();
    if (i__1 != 0) {
	goto L14;
    }
    io___99.ciunit = *lun;
    i__1 = s_wsfe(&io___99);
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = e_wsfe();
    if (i__1 != 0) {
	goto L14;
    }
    io___100.ciunit = *lun;
    i__1 = s_wsfe(&io___100);
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = e_wsfe();
    if (i__1 != 0) {
	goto L14;
    }

/* Set up a mapping from the window to the viewport. */

    iw = ipx2 - ipx1;
    ih = ipy2 - ipy1;
    sfx = (real) iw / dx;
    sfy = (real) ih / dy;
    tx = ipx1 - sfx * px[1];
    ty = ipy1 - sfy * py[1];
    io___107.ciunit = *lun;
    i__1 = s_wsfe(&io___107);
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&tx, (ftnlen)sizeof(real));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&ty, (ftnlen)sizeof(real));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&sfx, (ftnlen)sizeof(real));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&sfy, (ftnlen)sizeof(real));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = e_wsfe();
    if (i__1 != 0) {
	goto L14;
    }

/* Set the line thickness to 2 points.  (Since the scale */
/*   factors are applied to everything, the width must be */
/*   specified in world coordinates.) */

    t = 4.f / (sfx + sfy);
    io___108.ciunit = *lun;
    i__1 = s_wsfe(&io___108);
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, (char *)&t, (ftnlen)sizeof(real));
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = e_wsfe();
    if (i__1 != 0) {
	goto L14;
    }

/* Compute parameters for CNTOUR: */

/*   NCMAX = Maximum allowable number of contour lines */
/*           associated with each contour value. */
/*   LC = Length of arrays XC and YC and maximum allowable */
/*        number of points defining all the contour lines */
/*        associated with a contour value. */

    ncmax = (*nx * *ny + 1) / 2;
    lc = (*nx - 1 << 1) * (*ny - 1) + ncmax;

/* Loop on contour values CVAL uniformly spaced in the open */
/*   interval (ZMIN,ZMAX). */

    cval = zmin;
    i__1 = *ncon;
    for (kv = 1; kv <= i__1; ++kv) {
	cval += dz;

/* Compute a sequence of NC contour lines associated with */
/*   F = CVAL.  For IC = 1 to NC, IWK(IC) is the index (for */
/*   XC and YC) of the last point of contour IC. */

	cntour_(nx, ny, &px[1], &py[1], &pz[pz_offset], &cval, &lc, &ncmax, &
		iwk[ncmax + 1], &xc[1], &yc[1], &iwk[1], &nc, &ierr);
	if (ierr == 2) {
	    goto L12;
	}
	if (ierr != 0) {
	    goto L15;
	}

/* Draw the NC contours. */

	ic = 0;
	k = 0;
L3:
	++ic;
	++k;

/*   Create a path consisting of contour IC. */

	io___117.ciunit = *lun;
	i__2 = s_wsfe(&io___117);
	if (i__2 != 0) {
	    goto L14;
	}
	i__2 = do_fio(&c__1, (char *)&xc[k], (ftnlen)sizeof(real));
	if (i__2 != 0) {
	    goto L14;
	}
	i__2 = do_fio(&c__1, (char *)&yc[k], (ftnlen)sizeof(real));
	if (i__2 != 0) {
	    goto L14;
	}
	i__2 = e_wsfe();
	if (i__2 != 0) {
	    goto L14;
	}
L4:
	++k;
	io___118.ciunit = *lun;
	i__2 = s_wsfe(&io___118);
	if (i__2 != 0) {
	    goto L14;
	}
	i__2 = do_fio(&c__1, (char *)&xc[k], (ftnlen)sizeof(real));
	if (i__2 != 0) {
	    goto L14;
	}
	i__2 = do_fio(&c__1, (char *)&yc[k], (ftnlen)sizeof(real));
	if (i__2 != 0) {
	    goto L14;
	}
	i__2 = e_wsfe();
	if (i__2 != 0) {
	    goto L14;
	}
	if (k != iwk[ic]) {
	    goto L4;
	}

/*   Paint the path. */

	io___119.ciunit = *lun;
	i__2 = s_wsfe(&io___119);
	if (i__2 != 0) {
	    goto L14;
	}
	i__2 = e_wsfe();
	if (i__2 != 0) {
	    goto L14;
	}
	if (ic != nc) {
	    goto L3;
	}
/* L5: */
    }

/* Output the showpage command and end-of-file indicator. */

    io___120.ciunit = *lun;
    i__1 = s_wsfe(&io___120);
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = e_wsfe();
    if (i__1 != 0) {
	goto L14;
    }

/* HP's interpreters require a one-byte End-of-PostScript-Job */
/*   indicator (to eliminate a timeout error message): */
/*   ASCII 4. */

    io___121.ciunit = *lun;
    i__1 = s_wsfe(&io___121);
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = do_fio(&c__1, "\004", 1L);
    if (i__1 != 0) {
	goto L14;
    }
    i__1 = e_wsfe();
    if (i__1 != 0) {
	goto L14;
    }

/* No error encountered. */

    *ier = 0;
    return 0;

/* Invalid input parameter. */

L11:
    *ier = 1;
    return 0;

/* PX or PY is not strictly increasing. */

L12:
    *ier = 2;
    return 0;

/* DZ = 0. */

L13:
    *ier = 3;
    return 0;

/* Error writing to unit LUN. */

L14:
    *ier = 4;
    return 0;

/* Error flag returned by CNTOUR. */

L15:
    *ier = 5;
    return 0;
} /* crplot_ */

/* Subroutine */ int fval_752(real *xp, real *yp, real *x1, real *x2, real *x3, 
	real *y1, real *y2, real *y3, real *f1, real *f2, real *f3, real *fx1,
	 real *fx2, real *fx3, real *fy1, real *fy2, real *fy3, real *sig1, 
	real *sig2, real *sig3, real *fp, integer *ier)
{
    integer ierr;
    real b, b1, b2, b3, c1, c2, c3, h1, h2, h3, fq, px, py, xq, yq;
    extern /* Subroutine */ int arcint_752752(real *, real *, real *, real *, real *
	    , real *, real *, real *, real *, real *, real *, real *, logical 
	    *, real *, real *, real *, integer *), coords_(real *, real *, 
	    real *, real *, real *, real *, real *, real *, real *, real *, 
	    real *, integer *);
    real sig, dum, fxq, fyq, sum;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   03/18/90 */

/*   Given function values and gradients at the three ver- */
/* tices of a triangle containing a point P, this routine */
/* computes the value of F at P where F interpolates the ver- */
/* tex data.  Along the triangle arcs, the interpolatory */
/* function F is the Hermite interpolatory tension spline de- */
/* fined by the values and tangential gradient components at */
/* the endpoints, and the derivative in the direction normal */
/* to the arc varies linearly between the normal gradient */
/* components at the endpoints.  A first-order C-1 blending */
/* method is used to extend F to the interior of the trian- */
/* gle.  Thus, since values and gradients on an arc depend */
/* only on the vertex data, the method results in C-1 contin- */
/* uity when used to interpolate over a triangulation. */

/*   The blending method consists of taking F(P) to be the */
/* weighted sum of the values at P of the three univariate */
/* Hermite interpolatory tension splines defined on the line */
/* segments which join the vertices to the opposite sides and */
/* pass through P.  The tension factors for these splines are */
/* obtained by linear interpolation between the pair of ten- */
/* sion factors associated with the triangle sides which join */
/* at the appropriate vertex. */

/*   A tension factor SIGMA associated with a Hermite interp- */
/* olatory tension spline is a nonnegative parameter which */
/* determines the curviness of the spline.  SIGMA = 0 results */
/* in a cubic spline, and the spline approaches the linear */
/* interpolant as SIGMA increases. */

/* On input: */

/*       XP,YP = Coordinates of a point P at which an interp- */
/*               olated value is to be computed. */

/*       X1,X2,X3,Y1,Y2,Y3 = Coordinates of the vertices of a */
/*                           triangle (V1,V2,V3) containing */
/*                           P.  V3 is strictly to the left */
/*                           of V1->V2. */

/*       F1,F2,F3 = Values of the interpolatory function at */
/*                  the vertices. */

/*       FX1,FX2,FX3 = x components of the gradients of F at */
/*                     the vertices. */

/*       FY1,FY2,FY3 = y components of the gradients of F at */
/*                     the vertices. */

/*       SIG1,SIG2,SIG3 = Tension factors associated with the */
/*                        arcs opposite V1, V2, and V3, re- */
/*                        spectively. */

/* Input parameters are not altered by this routine. */

/* On output: */

/*       FP = Interpolated value at P unless IER < 0, in */
/*            which case FP is not defined. */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered. */
/*             IER = 1 if P is not contained in the triangle. */
/*                     This may result from roundoff error */
/*                     when P lies near an arc, and the int- */
/*                     erpolated value FP is valid in that */
/*                     case. */
/*             IER = -1 if the triangle vertices are */
/*                      collinear. */

/* SRFPACK modules required by FVAL:  ARCINT, COORDS, SNHCSH */

/* *********************************************************** */


    px = *xp;
    py = *yp;

/* F(P) = C1*H1(P) + C2*H2(P) + C3*H3(P) where C1, C2, and C3 */
/*   are weight functions which sum to 1, and H1, H2, and H3 */
/*   are Hermite interpolatory tension splines on the line */
/*   segments which join vertices to opposite sides and con- */
/*   tain P. */

/* Compute barycentric coordinates of P with respect to the */
/*   triangle. */

    coords_(&px, &py, x1, x2, x3, y1, y2, y3, &b1, &b2, &b3, ier);
    if (*ier != 0) {
	return 0;
    }
    if (b1 < 0.f || b2 < 0.f || b3 < 0.f) {
	*ier = 1;
    }

/* Compute the coefficients of the partial interpolants. */
/*   C1 = 1 on the side opposite V1, and C1 = 0 on the other */
/*   arcs.  Similarly for C2 and C3. */

    c1 = b2 * b3;
    c2 = b3 * b1;
    c3 = b1 * b2;
    sum = c1 + c2 + c3;
    if (sum == 0.f) {

/* P coincides with a vertex. */

	*fp = b1 * *f1 + b2 * *f2 + b3 * *f3;
	return 0;
    }

/* Normalize the coefficients. */

    c1 /= sum;
    c2 /= sum;
    c3 /= sum;

/* For each vertex Vi, compute the intersection Q of the side */
/*   opposite Vi with the line defined by Vi and P, the value */
/*   and gradient at Q, and the partial interpolant value Hi */
/*   at P. */

/*   Side opposite V1: */

    b = b2 / (b2 + b3);
    xq = b * *x2 + (1.f - b) * *x3;
    yq = b * *y2 + (1.f - b) * *y3;
    sig = b * *sig3 + (1.f - b) * *sig2;
    arcint_752(&b, x2, x3, y2, y3, f2, f3, fx2, fx3, fy2, fy3, sig1, (logical*)&
	    c__1, &fq, &fxq, &fyq, &ierr);
    arcint_752(&b1, x1, &xq, y1, &yq, f1, &fq, fx1, &fxq, fy1, &fyq, &sig, (
	    logical*)&c__0, &h1, &dum, &dum, &ierr);

/*   Side opposite V2: */

    b = b3 / (b3 + b1);
    xq = b * *x3 + (1.f - b) * *x1;
    yq = b * *y3 + (1.f - b) * *y1;
    sig = b * *sig1 + (1.f - b) * *sig3;
    arcint_752(&b, x3, x1, y3, y1, f3, f1, fx3, fx1, fy3, fy1, sig2, (logical*)&
	    c__1, &fq, &fxq, &fyq, &ierr);
    arcint_752(&b2, x2, &xq, y2, &yq, f2, &fq, fx2, &fxq, fy2, &fyq, &sig, (
	    logical*)&c__0, &h2, &dum, &dum, &ierr);

/*   Side opposite V3: */

    b = b1 / (b1 + b2);
    xq = b * *x1 + (1.f - b) * *x2;
    yq = b * *y1 + (1.f - b) * *y2;
    sig = b * *sig2 + (1.f - b) * *sig1;
    arcint_752(&b, x1, x2, y1, y2, f1, f2, fx1, fx2, fy1, fy2, sig3, (logical*)&
	    c__1, &fq, &fxq, &fyq, &ierr);
    arcint_752(&b3, x3, &xq, y3, &yq, f3, &fq, fx3, &fxq, fy3, &fyq, &sig, (
	    logical*)&c__0, &h3, &dum, &dum, &ierr);

/* Accumulate the partial interpolant values. */

    *fp = c1 * h1 + c2 * h2 + c3 * h3;
    return 0;
} /* fval_752 */

/* Subroutine */ int getsig_752(integer *n, real *x, real *y, real *h, integer *
	list, integer *lptr, integer *lend, real *hxhy, real *tol, real *
	sigma, real *dsmax, integer *ier)
{
    /* Initialized data */

    static real sbig = 85.f;
    static integer lun = -1;

    /* Format strings */
    static char fmt_100[] = "(///13x,\002GETSIG:  N =\002,i4,\002, TOL = "
	    "\002,e10.3//)";
    static char fmt_110[] = "(/1x,\002Arc\002,i4,\002 -\002,i4)";
    static char fmt_120[] = "(1x,\002Convexity:  SIG = \002,e15.8,\002, F(SI"
	    "G) = \002,e15.8/1x,35x,\002FP(SIG) = \002,e15.8)";
    static char fmt_130[] = "(1x,\002Monotonicity:  DSIG = \002,e15.8)";
    static char fmt_140[] = "(1x,11x,i2,\002 -- SIG = \002,e15.8,\002, F ="
	    " \002,e15.8)";

    /* System generated locals */
    integer i__1, i__2;
    real r__1, r__2;

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void);
    double sqrt(doublereal), exp(doublereal), r_sign(real *, real *);

    /* Local variables */
    real d1pd2, fneg, dsig, dmax_, fmax;
    integer icnt;
    real ftol, rtol, stol, a, e, f, s, t, coshm, sigin, sinhm, c1, c2, d0, d1,
	     d2, f0, ssinh;
    extern doublereal store_(real *);
    integer n1, n2;
    real s1, s2, t0, t1, t2, fp, dt, dx, dy, tm, coshmm;
    extern /* Subroutine */ int snhcsh_752(real *, real *, real *, real *);
    integer nm1, lp1, lp2;
    real tp1;
    extern integer lstptr_(integer *, integer *, integer *, integer *);
    real d1d2, scm, dsm, ems, sig;
    integer lpl;
    real sgn;
    integer nit;
    real ssm, ems2;

    /* Fortran I/O blocks */
    static cilist io___148 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___155 = { 0, 0, 0, fmt_110, 0 };
    static cilist io___178 = { 0, 0, 0, fmt_120, 0 };
    static cilist io___189 = { 0, 0, 0, fmt_130, 0 };
    static cilist io___198 = { 0, 0, 0, fmt_140, 0 };



/* *********************************************************** */
/*               the adjacency list for N1) and LIST(J) = N1 */
/*               (in the list associated with N2).  SIGMA */
/*               should be set to all zeros if minimal ten- */
/*               sion is desired, and should be unchanged */
/*               from a previous call in order to ensure con- */
/*               vergence of the iterative procedure describ- */
/*               ed in the header comments. */

/* On output: */

/*       SIGMA = Array containing tension factors for which */
/*               H(T) preserves the local data properties on */
/*               each triangulation arc, with the restriction */
/*               that SIGMA(I) .LE. 85 for all I (unless the */
/*               input value is larger).  The factors are as */
/*               small as possible (within the tolerance) but */
/*               not less than their input values.  If infin- */
/*               ite tension is required on an arc, the cor- */
/*               responding factor is SIGMA(I) = 85 (and H */
/*               is an approximation to the linear inter- */
/*               polant on the arc), and if neither property */
/*               is satisfied by the data, then SIGMA(I) = 0 */
/*               (assuming its input value is 0), and thus H */
/*               is cubic on the arc. */

/*       DSMAX = Maximum increase in a component of SIGMA */
/*               from its input value. */

/*       IER = Error indicator and information flag: */
/*             IER = I if no errors were encountered and I */
/*                     components of SIGMA were altered from */
/*                     their input values for I .GE. 0. */
/*             IER = -1 if N < 3.  SIGMA is not altered in */
/*                      this case. */
/*             IER = -2 if duplicate nodes were encountered. */

/* TRIPACK modules required by GETSIG:  LSTPTR, STORE */

/* SRFPACK module required by GETSIG:  SNHCSH */

/* Intrinsic functions called by GETSIG:  ABS, EXP, MAX, MIN, */
/*                                          SIGN, SQRT */

/* *********************************************************** */


    /* Parameter adjustments */
    --sigma;
    hxhy -= 3;
    --lend;
    --lptr;
    --list;
    --h;
    --y;
    --x;

    /* Function Body */
    nm1 = *n - 1;
    if (nm1 < 2) {
	goto L11;
    }

/* Compute an absolute tolerance FTOL = abs(TOL) and a */
/*   relative tolerance RTOL = 100*Macheps. */

    ftol = dabs(*tol);
    rtol = 1.f;
L1:
    rtol /= 2.f;
    r__1 = rtol + 1.f;
    if (store_(&r__1) > 1.f) {
	goto L1;
    }
    rtol *= 200.f;

/* Print a heading. */

    if (lun >= 0) {
	io___148.ciunit = lun;
	s_wsfe(&io___148);
	do_fio(&c__1, (char *)&(*n), (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&ftol, (ftnlen)sizeof(real));
	e_wsfe();
    }

/* Initialize change counter ICNT and maximum change DSM for */
/*   the loop on arcs. */

    icnt = 0;
    dsm = 0.f;

/* Loop on arcs N1-N2 for which N2 > N1.  LPL points to the */
/*   last neighbor of N1. */

    i__1 = nm1;
    for (n1 = 1; n1 <= i__1; ++n1) {
	lpl = lend[n1];
	lp1 = lpl;

/*   Top of loop on neighbors N2 of N1. */

L2:
	lp1 = lptr[lp1];
	n2 = (i__2 = list[lp1], abs(i__2));
	if (n2 <= n1) {
	    goto L9;
	}

/* Print a message and compute parameters for the arc:  DT = */
/*   arc length and SIGIN = input SIGMA value. */

	if (lun >= 0) {
	    io___155.ciunit = lun;
	    s_wsfe(&io___155);
	    do_fio(&c__1, (char *)&n1, (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&n2, (ftnlen)sizeof(integer));
	    e_wsfe();
	}
	dx = x[n2] - x[n1];
	dy = y[n2] - y[n1];
	dt = sqrt(dx * dx + dy * dy);
	if (dt == 0.f) {
	    goto L12;
	}
	sigin = sigma[lp1];
	if (sigin >= sbig) {
	    goto L9;
	}

/* Compute scaled directional derivatives S1,S2 at the end- */
/*   points (for the direction N1->N2), first difference S, */
/*   and second differences D1,D2. */

	s1 = hxhy[(n1 << 1) + 1] * dx + hxhy[(n1 << 1) + 2] * dy;
	s2 = hxhy[(n2 << 1) + 1] * dx + hxhy[(n2 << 1) + 2] * dy;
	s = h[n2] - h[n1];
	d1 = s - s1;
	d2 = s2 - s;
	d1d2 = d1 * d2;

/* Test for infinite tension required to satisfy either */
/*   property. */

	sig = sbig;
	if (d1d2 == 0.f && s1 != s2 || s == 0.f && s1 * s2 > 0.f) {
	    goto L8;
	}

/* Test for SIGMA = 0 sufficient.  The data satisfies convex- */
/*   ity iff D1D2 .GE. 0, and D1D2 = 0 implies S1 = S = S2. */

	sig = 0.f;
	if (d1d2 < 0.f) {
	    goto L4;
	}
	if (d1d2 == 0.f) {
	    goto L8;
	}
/* Computing MAX */
	r__1 = d1 / d2, r__2 = d2 / d1;
	t = dmax(r__1,r__2);
	if (t <= 2.f) {
	    goto L8;
	}
	tp1 = t + 1.f;

/* Convexity:  find a zero of F(SIG) = SIG*COSHM(SIG)/ */
/*   SINHM(SIG) - TP1. */

/*   F(0) = 2-T < 0, F(TP1) .GE. 0, the derivative of F */
/*     vanishes at SIG = 0, and the second derivative of F is */
/*     .2 at SIG = 0.  A quadratic approximation is used to */
/*     obtain a starting point for the Newton method. */

	sig = sqrt(t * 10.f - 20.f);
	nit = 0;

/*   Top of loop: */

L3:
	if (sig <= .5f) {
	    snhcsh_752(&sig, &sinhm, &coshm, &coshmm);
	    t1 = coshm / sinhm;
	    fp = t1 + sig * (sig / sinhm - t1 * t1 + 1.f);
	} else {

/*   Scale SINHM and COSHM by 2*exp(-SIG) in order to avoid */
/*     overflow with large SIG. */

	    ems = exp(-(doublereal)sig);
	    ssm = 1.f - ems * (ems + sig + sig);
	    t1 = (1.f - ems) * (1.f - ems) / ssm;
	    fp = t1 + sig * (sig * 2.f * ems / ssm - t1 * t1 + 1.f);
	}

	f = sig * t1 - tp1;
	if (lun >= 0) {
	    io___178.ciunit = lun;
	    s_wsfe(&io___178);
	    do_fio(&c__1, (char *)&sig, (ftnlen)sizeof(real));
	    do_fio(&c__1, (char *)&f, (ftnlen)sizeof(real));
	    do_fio(&c__1, (char *)&fp, (ftnlen)sizeof(real));
	    e_wsfe();
	}
	++nit;

/*   Test for convergence. */

	if (fp <= 0.f) {
	    goto L8;
	}
	dsig = -(doublereal)f / fp;
	if (dabs(dsig) <= rtol * sig || f >= 0.f && f <= ftol || dabs(f) <= 
		rtol) {
	    goto L8;
	}

/*   Update SIG. */

	sig += dsig;
	goto L3;

/* Convexity cannot be satisfied.  Monotonicity can be satis- */
/*   fied iff S1*S .GE. 0 and S2*S .GE. 0 since S .NE. 0. */

L4:
	if (s1 * s < 0.f || s2 * s < 0.f) {
	    goto L8;
	}
	t0 = s * 3.f - s1 - s2;
	d0 = t0 * t0 - s1 * s2;

/* SIGMA = 0 is sufficient for monotonicity iff S*T0 .GE. 0 */
/*   or D0 .LE. 0. */

	if (d0 <= 0.f || s * t0 >= 0.f) {
	    goto L8;
	}

/* Monotonicity:  find a zero of F(SIG) = sign(S)*HP(R), */
/*   where HPP(R) = 0 and HP, HPP denote derivatives of H. */
/*   F has a unique zero, F(0) < 0, and F approaches */
/*   abs(S) as SIG increases. */

/*   Initialize parameters for the secant method.  The method */
/*     uses three points:  (SG0,F0), (SIG,F), and */
/*     (SNEG,FNEG), where SG0 and SNEG are defined implicitly */
/*     by DSIG = SIG - SG0 and DMAX = SIG - SNEG. */

	sgn = r_sign(&c_b114, &s);
	sig = sbig;
	fmax = sgn * (sig * s - s1 - s2) / (sig - 2.f);
	if (fmax <= 0.f) {
	    goto L8;
	}
	stol = rtol * sig;
	f = fmax;
	f0 = sgn * d0 / ((d1 - d2) * 3.f);
	fneg = f0;
	dsig = sig;
	dmax_ = sig;
	d1pd2 = d1 + d2;
	nit = 0;

/*   Top of loop:  compute the change in SIG by linear */
/*     interpolation. */

L5:
	dsig = -(doublereal)f * dsig / (f - f0);
	if (lun >= 0) {
	    io___189.ciunit = lun;
	    s_wsfe(&io___189);
	    do_fio(&c__1, (char *)&dsig, (ftnlen)sizeof(real));
	    e_wsfe();
	}
	if (dabs(dsig) > dabs(dmax_) || dsig * dmax_ > 0.f) {
	    goto L7;
	}

/*   Restrict the step-size such that abs(DSIG) .GE. STOL/2. */
/*     Note that DSIG and DMAX have opposite signs. */

	if (dabs(dsig) < stol / 2.f) {
	    r__1 = stol / 2.f;
	    dsig = -(doublereal)r_sign(&r__1, &dmax_);
	}

/*   Update SIG, F0, and F. */

	sig += dsig;
	f0 = f;
	if (sig <= .5f) {

/*   Use approximations to the hyperbolic functions designed */
/*     to avoid cancellation error with small SIG. */

	    snhcsh_752(&sig, &sinhm, &coshm, &coshmm);
	    c1 = sig * coshm * d2 - sinhm * d1pd2;
	    c2 = sig * (sinhm + sig) * d2 - coshm * d1pd2;
	    a = c2 - c1;
	    e = sig * sinhm - coshmm - coshmm;
	} else {

/*   Scale SINHM and COSHM by 2*exp(-SIG) in order to avoid */
/*     overflow with large SIG. */

	    ems = exp(-(doublereal)sig);
	    ems2 = ems + ems;
	    tm = 1.f - ems;
	    ssinh = tm * (ems + 1.f);
	    ssm = ssinh - sig * ems2;
	    scm = tm * tm;
	    c1 = sig * scm * d2 - ssm * d1pd2;
	    c2 = sig * ssinh * d2 - scm * d1pd2;

/*   R is in (0,1) and well-defined iff HPP(T1)*HPP(T2) < 0. */

	    f = fmax;
	    if (c1 * (sig * scm * d1 - ssm * d1pd2) >= 0.f) {
		goto L6;
	    }
	    a = ems2 * (sig * tm * d2 + (tm - sig) * d1pd2);
	    if (a * (c2 + c1) < 0.f) {
		goto L6;
	    }
	    e = sig * ssinh - scm - scm;
	}

	f = (sgn * (e * s2 - c2) + sqrt(a * (c2 + c1))) / e;

/*   Update the number of iterations NIT. */

L6:
	++nit;
	if (lun >= 0) {
	    io___198.ciunit = lun;
	    s_wsfe(&io___198);
	    do_fio(&c__1, (char *)&nit, (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&sig, (ftnlen)sizeof(real));
	    do_fio(&c__1, (char *)&f, (ftnlen)sizeof(real));
	    e_wsfe();
	}

/*   Test for convergence. */

	stol = rtol * sig;
	if (dabs(dmax_) <= stol || f >= 0.f && f <= ftol || dabs(f) <= rtol) {
	    goto L8;
	}
	dmax_ += dsig;
	if (f0 * f > 0.f && dabs(f) >= dabs(f0)) {
	    goto L7;
	}
	if (f0 * f <= 0.f) {

/*   F and F0 have opposite signs.  Update (SNEG,FNEG) to */
/*     (SG0,F0) so that F and FNEG always have opposite */
/*     signs.  If SIG is closer to SNEG than SG0 and abs(F) */
/*     < abs(FNEG), then swap (SNEG,FNEG) with (SG0,F0). */

	    t1 = dmax_;
	    t2 = fneg;
	    dmax_ = dsig;
	    fneg = f0;
	    if (dabs(dsig) > dabs(t1) && dabs(f) < dabs(t2)) {

		dsig = t1;
		f0 = t2;
	    }
	}
	goto L5;

/*   Bottom of loop:  F0*F > 0 and the new estimate would */
/*     be outside of the bracketing interval of length */
/*     abs(DMAX).  Reset (SG0,F0) to (SNEG,FNEG). */

L7:
	dsig = dmax_;
	f0 = fneg;
	goto L5;

/*  Update SIGMA, ICNT, and DSM if necessary. */

L8:
	sig = dmin(sig,sbig);
	if (sig > sigin) {
	    sigma[lp1] = sig;
	    lp2 = lstptr_(&lend[n2], &n1, &list[1], &lptr[1]);
	    sigma[lp2] = sig;
	    ++icnt;
/* Computing MAX */
	    r__1 = dsm, r__2 = sig - sigin;
	    dsm = dmax(r__1,r__2);
	}

/* Bottom of loop on neighbors N2 of N1. */

L9:
	if (lp1 != lpl) {
	    goto L2;
	}
/* L10: */
    }

/* No errors encountered. */

    *dsmax = dsm;
    *ier = icnt;
    return 0;

/* N < 3 */

L11:
    *dsmax = 0.f;
    *ier = -1;
    return 0;

/* Nodes N1 and N2 coincide. */

L12:
    *dsmax = dsm;
    *ier = -2;
    return 0;
} /* getsig_752 */

/* Subroutine */ int givens_752(real *a, real *b, real *c, real *s)
{
    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    real r, u, v, aa, bb;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   09/01/88 */

/*   This subroutine constructs the Givens plane rotation, */

/*           ( C  S) */
/*       G = (     ) , where C*C + S*S = 1, */
/*           (-S  C) */

/* which zeros the second component of the vector (A,B)**T */
/* (transposed).  Subroutine ROTATE may be called to apply */
/* the transformation to a 2 by N matrix. */

/*   This routine is identical to Subroutine SROTG from the */
/* LINPACK BLAS (Basic Linear Algebra Subroutines). */

/* On input: */

/*       A,B = Components of the vector defining the rota- */
/*             tion.  These are overwritten by values R */
/*             and Z (described below) which define C and S. */

/* On output: */

/*       A = Signed Euclidean norm R of the input vector: */
/*           R = +/-SQRT(A*A + B*B) */

/*       B = Value Z such that: */
/*             C = SQRT(1-Z*Z) and S=Z if ABS(Z) .LE. 1, and */
/*             C = 1/Z and S = SQRT(1-C*C) if ABS(Z) > 1. */

/*       C = +/-(A/R) or 1 if R = 0. */

/*       S = +/-(B/R) or 0 if R = 0. */

/* Modules required by GIVENS:  None */

/* Intrinsic functions called by GIVENS:  ABS, SQRT */

/* *********************************************************** */


/* Local parameters: */

/* AA,BB = Local copies of A and B */
/* R =     C*A + S*B = +/-SQRT(A*A+B*B) */
/* U,V =   Variables used to scale A and B for computing R */

    aa = *a;
    bb = *b;
    if (dabs(aa) <= dabs(bb)) {
	goto L1;
    }

/* ABS(A) > ABS(B). */

    u = aa + aa;
    v = bb / u;
    r = sqrt(v * v + .25f) * u;
    *c = aa / r;
    *s = v * (*c + *c);

/* Note that R has the sign of A, C > 0, and S has */
/*   SIGN(A)*SIGN(B). */

    *b = *s;
    *a = r;
    return 0;

/* ABS(A) .LE. ABS(B). */

L1:
    if (bb == 0.f) {
	goto L2;
    }
    u = bb + bb;
    v = aa / u;

/* Store R in A. */

    *a = sqrt(v * v + .25f) * u;
    *s = bb / *a;
    *c = v * (*s + *s);

/* Note that R has the sign of B, S > 0, and C has */
/*   SIGN(A)*SIGN(B). */

    *b = 1.f;
    if (*c != 0.f) {
	*b = 1.f / *c;
    }
    return 0;

/* A = B = 0. */

L2:
    *c = 1.f;
    *s = 0.f;
    return 0;
} /* givens_752 */

/* Subroutine */ int gradc_(integer *k, integer *ncc, integer *lcc, integer *
	n, real *x, real *y, real *z, integer *list, integer *lptr, integer *
	lend, real *dx, real *dy, real *dxx, real *dxy, real *dyy, integer *
	ier)
{
    /* Initialized data */

    static real rtol = 1e-5f;
    static real dtol = .01f;

    /* System generated locals */
    integer i__1;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    real dmin_;
    integer lmin, ierr, lmax;
    real dist[30];
    integer npts[30];
    real a[100]	/* was [10][10] */, c;
    integer i, j, l;
    real s, w;
    extern /* Subroutine */ int getnp_(integer *, integer *, integer *, real *
	    , real *, integer *, integer *, integer *, integer *, integer *, 
	    real *, integer *), setro3_(real *, real *, real *, real *, real *
	    , real *, real *, real *, real *, real *, real *);
    integer kk;
    real ds, sf;
    integer np;
    real xk, yk, rs, zk;
    extern /* Subroutine */ int givens_752(real *, real *, real *, real *), 
	    rotate_752(integer *, real *, real *, real *, real *);
    integer lm1, jp1;
    real sfc, rin;
    integer lnp;
    real sfs, stf, sum;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   02/22/97 */

/*   Given a Delaunay triangulation of N points in the plane */
/* with associated data values Z, this subroutine estimates */
/* first and second partial derivatives at node K.  The der- */
/* ivatives are taken to be the partials at K of a cubic */
/* function which interpolates Z(K) and fits the data values */
/* at a set of nearby nodes in a weighted least squares */
/* sense.  A Marquardt stabilization factor is used if neces- */
/* sary to ensure a well-conditioned system.  Thus, a unique */
/* solution exists if there are at least 10 noncollinear */
/* nodes. */

/*   The triangulation may include constraints introduced by */
/* Subroutine ADDCST, in which case the derivative estimates */
/* are influenced by the nonconvex geometry of the domain. */
/* Refer to Subroutine GETNP.  If data values at the con- */
/* straint nodes are not known, Subroutine ZGRADL, which */
/* computes approximate data values at constraint nodes along */
/* with gradients, should be called in place of this routine. */

/*   Subroutine GRADL uses a quadratic polynomial instead of */
/* the cubic and may be more accurate if the nodal distribu- */
/* tion is sparse.  Another alternative routine, GRADG, */
/* employs a global method to compute the first partial */
/* derivatives at all of the nodes at once.  That method */
/* is usually more efficient (when all first partials are */
/* needed) and may be more accurate, depending on the data. */

/* On input: */

/*       K = Index of the node at which derivatives are to be */
/*           estimated.  1 .LE. K .LE. N. */

/*       NCC = Number of constraint curves (refer to TRIPACK */
/*             Subroutine ADDCST).  NCC .GE. 0. */

/*       LCC = Array of length NCC (or dummy array of length */
/*             1 if NCC = 0) containing the index of the */
/*             first node of constraint I in LCC(I).  For I = */
/*             1 to NCC, LCC(I+1)-LCC(I) .GE. 3, where */
/*             LCC(NCC+1) = N+1. */

/*       N = Number of nodes in the triangulation. */
/*           N .GE. 10. */

/*       X,Y = Arrays of length N containing the coordinates */
/*             of the nodes with non-constraint nodes in the */
/*             first LCC(1)-1 locations, followed by NCC se- */
/*             quences of constraint nodes. */

/*       Z = Array of length N containing data values associ- */
/*           ated with the nodes. */

/*       LIST,LPTR,LEND = Data structure defining the trian- */
/*                        gulation.  Refer to TRIPACK */
/*                        Subroutine TRMESH. */

/* Input parameters are not altered by this routine. */

/* On output: */

/*       DX,DY = Estimated first partial derivatives at node */
/*               K unless IER < 0. */

/*       DXX,DXY,DYY = Estimated second partial derivatives */
/*                     at node K unless IER < 0. */

/*       IER = Error indicator: */
/*             IER = L > 0 if no errors were encountered and */
/*                         L nodes (including node K) were */
/*                         employed in the least squares fit. */
/*             IER = -1 if K, NCC, an LCC entry, or N is */
/*                      outside its valid range on input. */
/*             IER = -2 if all nodes are collinear. */

/* TRIPACK modules required by GRADC:  GETNP, INTSEC */

/* SRFPACK modules required by GRADC:  GIVENS, ROTATE, SETRO3 */

/* Intrinsic functions called by GRADC:  ABS, MIN, REAL, SQRT */

/* *********************************************************** */

    /* Parameter adjustments */
    --lend;
    --lptr;
    --list;
    --z;
    --y;
    --x;
    --lcc;

    /* Function Body */

/* Local parameters: */

/* A =         Transpose of the augmented regression matrix */
/* C =         First component of the plane rotation deter- */
/*               mined by Subroutine GIVENS */
/* DIST =      Array containing the distances between K and */
/*               the elements of NPTS (refer to GETNP) */
/* DMIN =      Minimum of the magnitudes of the diagonal */
/*               elements of the regression matrix after */
/*               zeros are introduced below the diagonal */
/* DS =        Squared distance between nodes K and NPTS(LNP) */
/* DTOL =      Tolerance for detecting an ill-conditioned */
/*               system.  The system is accepted when DMIN/W */
/*               .GE. DTOL. */
/* I =         DO-loop index */
/* IERR =      Error flag for calls to GETNP */
/* J =         DO-loop index */
/* JP1 =       J+1 */
/* KK =        Local copy of K */
/* L =         Number of columns of A**T to which a rotation */
/*               is applied */
/* LMAX,LMIN = Min(LMX,N), Min(LMN,N) */
/* LMN,LMX =   Minimum and maximum values of LNP for N */
/*               sufficiently large.  In most cases LMN-1 */
/*               nodes are used in the fit.  4 .LE. LMN .LE. */
/*               LMX. */
/* LM1 =       LMIN-1 or LNP-1 */
/* LNP =       Length of NPTS */
/* NP =        Element of NPTS to be added to the system */
/* NPTS =      Array containing the indexes of a sequence of */
/*               nodes ordered by distance from K.  NPTS(1)=K */
/*               and the first LNP-1 elements of NPTS are */
/*               used in the least squares fit.  Unless LNP */
/*               exceeds LMAX, NPTS(LNP) determines R. */
/* RIN =       Inverse of the distance R between node K and */
/*               NPTS(LNP) or some point further from K than */
/*               NPTS(LMAX) if NPTS(LMAX) is used in the fit. */
/*               R is a radius of influence which enters into */
/*               the weight W. */
/* RS =        R*R */
/* RTOL =      Tolerance for determining R.  If the relative */
/*               change in DS between two elements of NPTS is */
/*               not greater than RTOL, they are treated as */
/*               being the same distance from node K. */
/* S =         Second component of the plane rotation deter- */
/*               mined by Subroutine GIVENS */
/* SF =        Scale factor for the linear terms (columns 8 */
/*               and 9) in the least squares fit -- inverse */
/*               of the root-mean-square distance between K */
/*               and the nodes (other than K) in the least */
/*               squares fit */
/* SFS =       Scale factor for the quadratic terms (columns */
/*               5, 6, and 7) in the least squares fit -- */
/*               SF*SF */
/* SFC =       Scale factor for the cubic terms (first 4 */
/*               columns) in the least squares fit -- SF**3 */
/* STF =       Marquardt stabilization factor used to damp */
/*               out the first 4 solution components (third */
/*               partials of the cubic) when the system is */
/*               ill-conditioned.  As STF increases, the */
/*               fitting function approaches a quadratic */
/*               polynomial. */
/* SUM =       Sum of squared distances between node K and */
/*               the nodes used in the least squares fit */
/* W =         Weight associated with a row of the augmented */
/*               regression matrix -- 1/D - 1/R, where D < R */
/*               and D is the distance between K and a node */
/*               entering into the least squares fit */
/* XK,YK,ZK =  Coordinates and data value associated with K */

    kk = *k;

/* Test for errors and initialize LMIN and LMAX. */

    if (kk < 1 || kk > *n || *ncc < 0 || *n < 10) {
	goto L13;
    }
    lmin = min(14,*n);
    lmax = min(30,*n);

/* Compute NPTS, DIST, LNP, SF, SFS, SFC, and RIN -- */

/*   Set NPTS to the closest LMIN-1 nodes to K. */

    sum = 0.f;
    npts[0] = kk;
    dist[0] = 0.f;
    lm1 = lmin - 1;
    i__1 = lm1;
    for (lnp = 2; lnp <= i__1; ++lnp) {
	getnp_(ncc, &lcc[1], n, &x[1], &y[1], &list[1], &lptr[1], &lend[1], &
		lnp, npts, dist, &ierr);
	if (ierr != 0) {
	    goto L13;
	}
/* Computing 2nd power */
	r__1 = dist[lnp - 1];
	ds = r__1 * r__1;
	sum += ds;
/* L1: */
    }

/* Add additional nodes to NPTS until the relative increase */
/*   in DS is at least RTOL. */

    i__1 = lmax;
    for (lnp = lmin; lnp <= i__1; ++lnp) {
	getnp_(ncc, &lcc[1], n, &x[1], &y[1], &list[1], &lptr[1], &lend[1], &
		lnp, npts, dist, &ierr);
/* Computing 2nd power */
	r__1 = dist[lnp - 1];
	rs = r__1 * r__1;
	if ((rs - ds) / ds <= rtol) {
	    goto L2;
	}
	if (lnp > 10) {
	    goto L4;
	}
L2:
	sum += rs;
/* L3: */
    }

/* Use all LMAX nodes in the least squares fit.  RS is */
/*   arbitrarily increased by 10 per cent. */

    rs *= 1.1f;
    lnp = lmax + 1;

/* There are LNP-2 equations corresponding to nodes NPTS(2), */
/*   ...,NPTS(LNP-1). */

L4:
    sfs = (real) (lnp - 2) / sum;
    sf = sqrt(sfs);
    sfc = sf * sfs;
    rin = 1.f / sqrt(rs);
    xk = x[kk];
    yk = y[kk];
    zk = z[kk];

/* A Q-R decomposition is used to solve the least squares */
/*   system.  The transpose of the augmented regression */
/*   matrix is stored in A with columns (rows of A) defined */
/*   as follows:  1-4 are the cubic terms, 5-7 are the quad- */
/*   ratic terms with coefficients DXX/2, DXY, and DYY/2, */
/*   8 and 9 are the linear terms with coefficients DX and */
/*   DY, and the last column is the right hand side. */

/* Set up the first 9 equations and zero out the lower tri- */
/*   angle with Givens rotations. */

    for (i = 1; i <= 9; ++i) {
	np = npts[i];
	w = 1.f / dist[i] - rin;
	setro3_(&xk, &yk, &zk, &x[np], &y[np], &z[np], &sf, &sfs, &sfc, &w, &
		a[i * 10 - 10]);
	if (i == 1) {
	    goto L6;
	}
	i__1 = i - 1;
	for (j = 1; j <= i__1; ++j) {
	    jp1 = j + 1;
	    l = 10 - j;
	    givens_752(&a[j + j * 10 - 11], &a[j + i * 10 - 11], &c, &s);
	    rotate_752(&l, &c, &s, &a[jp1 + j * 10 - 11], &a[jp1 + i * 10 - 11]);
/* L5: */
	}
L6:
	;
    }

/* Add the additional equations to the system using */
/*   the last column of A.  I .LE. LNP. */

    i = 11;
L7:
    if (i < lnp) {
	np = npts[i - 1];
	w = 1.f / dist[i - 1] - rin;
	setro3_(&xk, &yk, &zk, &x[np], &y[np], &z[np], &sf, &sfs, &sfc, &w, &
		a[90]);
	for (j = 1; j <= 9; ++j) {
	    jp1 = j + 1;
	    l = 10 - j;
	    givens_752(&a[j + j * 10 - 11], &a[j + 89], &c, &s);
	    rotate_752(&l, &c, &s, &a[jp1 + j * 10 - 11], &a[jp1 + 89]);
/* L8: */
	}
	++i;
	goto L7;
    }

/* Test the system for ill-conditioning. */

/* Computing MIN */
    r__1 = dabs(a[0]), r__2 = dabs(a[11]), r__1 = min(r__1,r__2), r__2 = dabs(
	    a[22]), r__1 = min(r__1,r__2), r__2 = dabs(a[33]), r__1 = min(
	    r__1,r__2), r__2 = dabs(a[44]), r__1 = min(r__1,r__2), r__2 = 
	    dabs(a[55]), r__1 = min(r__1,r__2), r__2 = dabs(a[66]), r__1 = 
	    min(r__1,r__2), r__2 = dabs(a[77]), r__1 = min(r__1,r__2), r__2 = 
	    dabs(a[88]);
    dmin_ = dmin(r__1,r__2);
    if (dmin_ / w >= dtol) {
	goto L12;
    }
    if (lnp <= lmax) {

/*   Add another node to the system and increase R.  Note */
/*     that I = LNP. */

	++lnp;
	if (lnp <= lmax) {
	    getnp_(ncc, &lcc[1], n, &x[1], &y[1], &list[1], &lptr[1], &lend[1]
		    , &lnp, npts, dist, &ierr);
/* Computing 2nd power */
	    r__1 = dist[lnp - 1];
	    rs = r__1 * r__1;
	}
	rin = 1.f / sqrt(rs * 1.1f);
	goto L7;
    }

/* Stabilize the system by damping third partials -- add */
/*   multiples of the first four unit vectors to the first */
/*   four equations. */

    stf = w;
    for (i = 1; i <= 4; ++i) {
	a[i + 89] = stf;
	for (j = i + 1; j <= 10; ++j) {
	    a[j + 89] = 0.f;
/* L9: */
	}
	for (j = i; j <= 9; ++j) {
	    jp1 = j + 1;
	    l = 10 - j;
	    givens_752(&a[j + j * 10 - 11], &a[j + 89], &c, &s);
	    rotate_752(&l, &c, &s, &a[jp1 + j * 10 - 11], &a[jp1 + 89]);
/* L10: */
	}
/* L11: */
    }

/* Test the damped system for ill-conditioning. */

/* Computing MIN */
    r__1 = dabs(a[44]), r__2 = dabs(a[55]), r__1 = min(r__1,r__2), r__2 = 
	    dabs(a[66]), r__1 = min(r__1,r__2), r__2 = dabs(a[77]), r__1 = 
	    min(r__1,r__2), r__2 = dabs(a[88]);
    dmin_ = dmin(r__1,r__2);
    if (dmin_ / w < dtol) {
	goto L14;
    }

/* Solve the 9 by 9 triangular system for the last 5 */
/*   components (first and second partial derivatives). */

L12:
    *dy = a[89] / a[88];
    *dx = (a[79] - a[78] * *dy) / a[77];
    *dyy = (a[69] - a[67] * *dx - a[68] * *dy) / a[66];
    *dxy = (a[59] - a[56] * *dyy - a[57] * *dx - a[58] * *dy) / a[55];
    *dxx = (a[49] - a[45] * *dxy - a[46] * *dyy - a[47] * *dx - a[48] * *dy) /
	     a[44];

/* Scale the solution components. */

    *dx = sf * *dx;
    *dy = sf * *dy;
    *dxx = sfs * 2.f * *dxx;
    *dxy = sfs * *dxy;
    *dyy = sfs * 2.f * *dyy;
    *ier = lnp - 1;
    return 0;

/* Invalid input parameter. */

L13:
    *ier = -1;
    return 0;

/* No unique solution due to collinear nodes. */

L14:
    *ier = -2;
    return 0;
} /* gradc_ */

/* Subroutine */ int gradg_752(integer *ncc, integer *lcc, integer *n, real *x, 
	real *y, real *z, integer *list, integer *lptr, integer *lend, 
	integer *iflgs, real *sigma, integer *nit, real *dgmax, real *grad, 
	integer *ier)
{
    /* System generated locals */
    integer i__1, i__2;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    integer kbak;
    real dcub, delx, dely, dgmx;
    integer kfor, iter;
    real d;
    integer i, j, k;
    real t;
    integer ilast;
    real delxs, delys;
    integer maxit, ifrst;
    real r1, r2, a11, a12, a22, df;
    integer nb, lp, nn;
    real xk, yk, zk;
    extern /* Subroutine */ int grcoef_752(real *, real *, real *, real *);
    integer ifl;
    real det, sdf, sig;
    integer lpj, lpl;
    real dsq, tol, dzx, dzy, zxk, zyk;
    integer lcc1;


/* *********************************************************** */
/*             achieved if DGMAX is smaller than the machine */
/*             precision.  Note that complete convergence is */
/*             not necessary to achieve maximum accuracy of */
/*             the interpolant.  For SIGMA = 0, optimal ef- */
/*             ficiency was achieved in testing with DGMAX = */
/*             0, and NIT = 3 or 4.  NIT > 0. */

/*       DGMAX = Nonnegative convergence criterion.  The */
/*               method is terminated when the maximum change */
/*               in a gradient between iterations is at most */
/*               DGMAX.  The change in a gradient is taken to */
/*               be the Euclidean norm of the difference rel- */
/*               ative to 1 plus the norm of the old value. */
/*               DGMAX = 1.E-3 is sufficient for effective */
/*               convergence. */

/*       GRAD = 2 by N array whose columns contain initial */
/*              estimates of the partial derivatives.  Zero */
/*              vectors are sufficient. */

/* On output: */

/*       NIT = Number of Gauss-Seidel iterations employed. */

/*       DGMAX = Maximum relative change in a gradient at the */
/*               last iteration. */

/*       GRAD = Estimated X and Y partial derivatives at the */
/*              nodes with X partials in the first row.  Grad */
/*              is not altered if IER = -1. */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered and the */
/*                     convergence criterion was achieved. */
/*             IER = 1 if no errors were encountered but con- */
/*                     vergence was not achieved within NIT */
/*                     iterations. */
/*             IER = -1 if NCC, an LCC entry, N, NIT, or */
/*                      DGMAX is outside its valid range on */
/*                      input. */
/*             IER = -2 if all nodes are collinear or the */
/*                      triangulation data structure is in- */
/*                      valid. */
/*             IER = -3 if duplicate nodes were encountered. */

/* SRFPACK modules required by GRADG:  GRCOEF, SNHCSH */

/* Intrinsic functions called by GRADG:  ABS, MAX, SQRT */

/* *********************************************************** */


    /* Parameter adjustments */
    grad -= 3;
    --sigma;
    --lend;
    --lptr;
    --list;
    --z;
    --y;
    --x;
    --lcc;

    /* Function Body */
    nn = *n;
    ifl = *iflgs;
    maxit = *nit;
    tol = *dgmax;

/* Test for errors in input parameters. */

    if (*ncc < 0 || maxit < 1 || tol < 0.f) {
	goto L9;
    }
    lcc1 = nn + 1;
    if (*ncc == 0) {
	if (nn < 3) {
	    goto L9;
	}
    } else {
	for (i = *ncc; i >= 1; --i) {
	    if (lcc1 - lcc[i] < 3) {
		goto L9;
	    }
	    lcc1 = lcc[i];
/* L1: */
	}
	if (lcc1 < 1) {
	    goto L9;
	}
    }

/* Initialize iteration count and SIG (overwritten if */
/*   IFLGS > 0). */

    iter = 0;
    sig = sigma[1];

/* Top of iteration loop:  If K is a constraint node, I */
/*   indexes the constraint containing node K, IFRST and */
/*   ILAST are the first and last nodes of constraint I, */
/*   and (KBAK,K,KFOR) is a subsequence of constraint I. */

L2:
    if (iter == maxit) {
	goto L8;
    }
    dgmx = 0.f;
    i = 0;
    ifrst = 1;
    ilast = lcc1 - 1;
    kbak = 0;
    kfor = 0;

/* Loop on nodes. */

    i__1 = nn;
    for (k = 1; k <= i__1; ++k) {
	if (k >= lcc1) {
	    if (k > ilast) {
		++i;
		ifrst = k;
		if (i < *ncc) {
		    ilast = lcc[i + 1] - 1;
		} else {
		    ilast = nn;
		}
		kbak = ilast;
		kfor = k + 1;
	    } else {
		kbak = k - 1;
		if (k < ilast) {
		    kfor = k + 1;
		} else {
		    kfor = ifrst;
		}
	    }
	}
	xk = x[k];
	yk = y[k];
	zk = z[k];
	zxk = grad[(k << 1) + 1];
	zyk = grad[(k << 1) + 2];

/*   Initialize components of the order 2 system for the */
/*     change (DZX,DZY) in the K-th solution components */
/*     (symmetric matrix in A and residual in R). */

	a11 = 0.f;
	a12 = 0.f;
	a22 = 0.f;
	r1 = 0.f;
	r2 = 0.f;

/*   Loop on neighbors J of node K. */

	lpl = lend[k];
	lpj = lpl;
L3:
	lpj = lptr[lpj];
	j = (i__2 = list[lpj], abs(i__2));

/*   Arc K-J lies in a constraint region and is bypassed iff */
/*     K and J are nodes in the same constraint and J follows */
/*     KFOR and precedes KBAK as a neighbor of K. */

	if (k < lcc1 || j < ifrst || j > ilast) {
	    goto L5;
	}
	if (j == kbak || j == kfor) {
	    goto L5;
	}
	lp = lpj;

L4:
	lp = lptr[lp];
	nb = (i__2 = list[lp], abs(i__2));
	if (nb == kbak) {
	    goto L6;
	}
	if (nb != kfor) {
	    goto L4;
	}

/*   Compute parameters associated with edge */
/*     K->J, and test for duplicate nodes. */

L5:
	delx = x[j] - xk;
	dely = y[j] - yk;
	delxs = delx * delx;
	delys = dely * dely;
	dsq = delxs + delys;
	d = sqrt(dsq);
	dcub = d * dsq;
	if (d == 0.f) {
	    goto L11;
	}
	if (ifl >= 1) {
	    sig = sigma[lpj];
	}
	grcoef_752(&sig, &dcub, &df, &sdf);

/*   Update the system components for node J.  The contribu- */
/*     tion from edge K->J is weighted by 1/D, where D is */
/*     the arc length. */

	a11 += df * delxs / d;
	a12 += df * delx * dely / d;
	a22 += df * delys / d;
	t = ((df + sdf) * (z[j] - zk) - df * (zxk * delx + zyk * dely) - sdf *
		 (grad[(j << 1) + 1] * delx + grad[(j << 1) + 2] * dely)) / d;
	r1 += t * delx;
	r2 += t * dely;

/*   Bottom of loop on neighbors. */

L6:
	if (lpj != lpl) {
	    goto L3;
	}

/*   Solve the system associated with the K-th block. */

	det = a11 * a22 - a12 * a12;
	if (det == 0.f || a11 == 0.f) {
	    goto L10;
	}
	dzy = (a11 * r2 - a12 * r1) / det;
	dzx = (r1 - a12 * dzy) / a11;

/*   Update the partials at node K and the maximum relative */
/*     change DGMX. */

	grad[(k << 1) + 1] = zxk + dzx;
	grad[(k << 1) + 2] = zyk + dzy;
/* Computing MAX */
	r__1 = dgmx, r__2 = sqrt(dzx * dzx + dzy * dzy) / (sqrt(zxk * zxk + 
		zyk * zyk) + 1.f);
	dgmx = dmax(r__1,r__2);
/* L7: */
    }

/*   Increment ITER and test for convergence. */

    ++iter;
    if (dgmx > tol) {
	goto L2;
    }

/* Method converged. */

    *nit = iter;
    *dgmax = dgmx;
    *ier = 0;
    return 0;

/* Method failed to converge within NIT iterations. */

L8:
    *dgmax = dgmx;
    *ier = 1;
    return 0;

/* Invalid input parameter. */

L9:
    *nit = 0;
    *dgmax = 0.f;
    *ier = -1;
    return 0;

/* Node K and its neighbors are collinear, resulting in a */
/*   singular system. */

L10:
    *nit = 0;
    *dgmax = dgmx;
    *ier = -2;
    return 0;

/* Nodes K and J coincide. */

L11:
    *nit = 0;
    *dgmax = dgmx;
    *ier = -3;
    return 0;
} /* gradg_752 */

/* Subroutine */ int gradl_752(integer *k, integer *ncc, integer *lcc, integer *
	n, real *x, real *y, real *z, integer *list, integer *lptr, integer *
	lend, real *dx, real *dy, integer *ier)
{
    /* Initialized data */

    static real rtol = 1e-5f;
    static real dtol = .01f;

    /* System generated locals */
    integer i__1;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    real dmin_;
    integer lmin, ierr, lmax;
    real dist[30];
    integer npts[30];
    real a[36]	/* was [6][6] */, c;
    integer i, j, l;
    real s, w;
    extern /* Subroutine */ int getnp_(integer *, integer *, integer *, real *
	    , real *, integer *, integer *, integer *, integer *, integer *, 
	    real *, integer *), setro1_(real *, real *, real *, real *, real *
	    , real *, real *, real *, real *, real *);
    integer kk;
    real ds, sf;
    integer np;
    real xk, yk, rs, zk;
    extern /* Subroutine */ int givens_752(real *, real *, real *, real *), 
	    rotate_752(integer *, real *, real *, real *, real *);
    integer lm1, jp1;
    real rin;
    integer lnp;
    real sfs, stf, sum;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   02/22/97 */

/*   Given a Delaunay triangulation of N points in the plane */
/* with associated data values Z, this subroutine estimates */
/* X and Y partial derivatives at node K.  The derivatives */
/* are taken to be the partials at K of a quadratic function */
/* which interpolates Z(K) and fits the data values at a set */
/* of nearby nodes in a weighted least squares sense. A Mar- */
/* quardt stabilization factor is used if necessary to ensure */
/* a well-conditioned system.  Thus, a unique solution exists */
/* if there are at least 6 noncollinear nodes. */

/*   The triangulation may include constraints introduced by */
/* Subroutine ADDCST, in which case the gradient estimates */
/* are influenced by the nonconvex geometry of the domain. */
/* Refer to Subroutine GETNP.  If data values at the con- */
/* straint nodes are not known, Subroutine ZGRADL, which */
/* computes approximate data values at constraint nodes along */
/* with gradients, should be called in place of this routine. */

/*   Subroutine GRADC uses a cubic polynomial instead of the */
/* quadratic and is generally more accurate than this routine */
/* if the nodal distribution is sufficiently dense.  Another */
/* alternative routine, GRADG, employs a global method to */
/* compute the partial derivatives at all of the nodes at */
/* once.  That method is usually more efficient (when all */
/* partials are needed) and may be more accurate, depending */
/* on the data. */

/* On input: */

/*       K = Index of the node at which derivatives are to be */
/*           estimated.  1 .LE. K .LE. N. */

/*       NCC = Number of constraint curves (refer to TRIPACK */
/*             Subroutine ADDCST).  NCC .GE. 0. */

/*       LCC = Array of length NCC (or dummy array of length */
/*             1 if NCC = 0) containing the index of the */
/*             first node of constraint I in LCC(I).  For I = */
/*             1 to NCC, LCC(I+1)-LCC(I) .GE. 3, where */
/*             LCC(NCC+1) = N+1. */

/*       N = Number of nodes in the triangulation.  N .GE. 6. */

/*       X,Y = Arrays of length N containing the coordinates */
/*             of the nodes with non-constraint nodes in the */
/*             first LCC(1)-1 locations, followed by NCC se- */
/*             quences of constraint nodes. */

/*       Z = Array of length N containing data values associ- */
/*           ated with the nodes. */

/*       LIST,LPTR,LEND = Data structure defining the trian- */
/*                        gulation.  Refer to TRIPACK */
/*                        Subroutine TRMESH. */

/* Input parameters are not altered by this routine. */

/* On output: */

/*       DX,DY = Estimated partial derivatives at node K */
/*               unless IER < 0. */

/*       IER = Error indicator: */
/*             IER = L > 0 if no errors were encountered and */
/*                         L nodes (including node K) were */
/*                         employed in the least squares fit. */
/*             IER = -1 if K, NCC, an LCC entry, or N is */
/*                      outside its valid range on input. */
/*             IER = -2 if all nodes are collinear. */

/* TRIPACK modules required by GRADL:  GETNP, INTSEC */

/* SRFPACK modules required by GRADL:  GIVENS, ROTATE, SETRO1 */

/* Intrinsic functions called by GRADL:  ABS, MIN, REAL, SQRT */

/* *********************************************************** */

    /* Parameter adjustments */
    --lend;
    --lptr;
    --list;
    --z;
    --y;
    --x;
    --lcc;

    /* Function Body */

/* Local parameters: */

/* A =         Transpose of the augmented regression matrix */
/* C =         First component of the plane rotation deter- */
/*               mined by Subroutine GIVENS */
/* DIST =      Array containing the distances between K and */
/*               the elements of NPTS (refer to GETNP) */
/* DMIN =      Minimum of the magnitudes of the diagonal */
/*               elements of the regression matrix after */
/*               zeros are introduced below the diagonal */
/* DS =        Squared distance between nodes K and NPTS(LNP) */
/* DTOL =      Tolerance for detecting an ill-conditioned */
/*               system.  The system is accepted when DMIN/W */
/*               .GE. DTOL */
/* I =         DO-loop index */
/* IERR =      Error flag for calls to GETNP */
/* J =         DO-loop index */
/* JP1 =       J+1 */
/* KK =        Local copy of K */
/* L =         Number of columns of A**T to which a rotation */
/*               is applied */
/* LMAX,LMIN = Min(LMX,N), Min(LMN,N) */
/* LMN,LMX =   Minimum and maximum values of LNP for N */
/*               sufficiently large.  In most cases LMN-1 */
/*               nodes are used in the fit.  4 .LE. LMN .LE. */
/*               LMX. */
/* LM1 =       LMIN-1 or LNP-1 */
/* LNP =       Length of NPTS */
/* NP =        Element of NPTS to be added to the system */
/* NPTS =      Array containing the indexes of a sequence of */
/*               nodes ordered by distance from K.  NPTS(1)=K */
/*               and the first LNP-1 elements of NPTS are */
/*               used in the least squares fit.  Unless LNP */
/*               exceeds LMAX, NPTS(LNP) determines R. */
/* RIN =       Inverse of the distance R between node K and */
/*               NPTS(LNP) or some point further from K than */
/*               NPTS(LMAX) if NPTS(LMAX) is used in the fit. */
/*               R is a radius of influence which enters into */
/*               the weight W. */
/* RS =        R*R */
/* RTOL =      Tolerance for determining R.  If the relative */
/*               change in DS between two elements of NPTS is */
/*               not greater than RTOL, they are treated as */
/*               being the same distance from node K */
/* S =         Second component of the plane rotation deter- */
/*               mined by Subroutine GIVENS */
/* SF =        Scale factor for the linear terms (columns 4 */
/*               and 5) in the least squares fit -- inverse */
/*               of the root-mean-square distance between K */
/*               and the nodes (other than K) in the least */
/*               squares fit. */
/* SFS =       Scale factor for the quadratic terms (first 3 */
/*               columns) in the least squares fit -- SF*SF. */
/* STF =       Marquardt stabilization factor used to damp */
/*               out the first 3 solution components (second */
/*               partials of the quadratic) when the system */
/*               is ill-conditioned.  As STF increases, the */
/*               fitting function approaches a linear */
/* SUM =       Sum of squared distances between node K and */
/*               the nodes used in the least squares fit */
/* W =         Weight associated with a row of the augmented */
/*               regression matrix -- 1/R - 1/D, where D < R */
/*               and D is the distance between K and a node */
/*               entering into the least squares fit. */
/* XK,YK,ZK =  Coordinates and data value associated with K */

    kk = *k;

/* Test for errors and initialize LMIN and LMAX. */

    if (kk < 1 || kk > *n || *ncc < 0 || *n < 6) {
	goto L13;
    }
    lmin = min(10,*n);
    lmax = min(30,*n);

/* Compute NPTS, DIST, LNP, SF, SFS, and RIN -- */

/*   Set NPTS to the closest LMIN-1 nodes to K. */

    sum = 0.f;
    npts[0] = kk;
    dist[0] = 0.f;
    lm1 = lmin - 1;
    i__1 = lm1;
    for (lnp = 2; lnp <= i__1; ++lnp) {
	getnp_(ncc, &lcc[1], n, &x[1], &y[1], &list[1], &lptr[1], &lend[1], &
		lnp, npts, dist, &ierr);
	if (ierr != 0) {
	    goto L13;
	}
/* Computing 2nd power */
	r__1 = dist[lnp - 1];
	ds = r__1 * r__1;
	sum += ds;
/* L1: */
    }

/* Add additional nodes to NPTS until the relative increase */
/*   in DS is at least RTOL. */

    i__1 = lmax;
    for (lnp = lmin; lnp <= i__1; ++lnp) {
	getnp_(ncc, &lcc[1], n, &x[1], &y[1], &list[1], &lptr[1], &lend[1], &
		lnp, npts, dist, &ierr);
/* Computing 2nd power */
	r__1 = dist[lnp - 1];
	rs = r__1 * r__1;
	if ((rs - ds) / ds <= rtol) {
	    goto L2;
	}
	if (lnp > 6) {
	    goto L4;
	}
L2:
	sum += rs;
/* L3: */
    }

/* Use all LMAX nodes in the least squares fit.  RS is */
/*   arbitrarily increased by 10 per cent. */

    rs *= 1.1f;
    lnp = lmax + 1;

/* There are LNP-2 equations corresponding to nodes NPTS(2), */
/*   ...,NPTS(LNP-1). */

L4:
    sfs = (real) (lnp - 2) / sum;
    sf = sqrt(sfs);
    rin = 1.f / sqrt(rs);
    xk = x[kk];
    yk = y[kk];
    zk = z[kk];

/* A Q-R decomposition is used to solve the least squares */
/*   system.  The transpose of the augmented regression */
/*   matrix is stored in A with columns (rows of A) defined */
/*   as follows:  1-3 are the quadratic terms, 4 and 5 are */
/*   the linear terms with coefficients DX and DY, and the */
/*   last column is the right hand side. */

/* Set up the first 5 equations and zero out the lower tri- */
/*   angle with Givens rotations. */

    for (i = 1; i <= 5; ++i) {
	np = npts[i];
	w = 1.f / dist[i] - rin;
	setro1_(&xk, &yk, &zk, &x[np], &y[np], &z[np], &sf, &sfs, &w, &a[i * 
		6 - 6]);
	if (i == 1) {
	    goto L6;
	}
	i__1 = i - 1;
	for (j = 1; j <= i__1; ++j) {
	    jp1 = j + 1;
	    l = 6 - j;
	    givens_752(&a[j + j * 6 - 7], &a[j + i * 6 - 7], &c, &s);
	    rotate_752(&l, &c, &s, &a[jp1 + j * 6 - 7], &a[jp1 + i * 6 - 7]);
/* L5: */
	}
L6:
	;
    }

/* Add the additional equations to the system using */
/*   the last column of A.  I .LE. LNP. */

    i = 7;
L7:
    if (i < lnp) {
	np = npts[i - 1];
	w = 1.f / dist[i - 1] - rin;
	setro1_(&xk, &yk, &zk, &x[np], &y[np], &z[np], &sf, &sfs, &w, &a[30]);
	for (j = 1; j <= 5; ++j) {
	    jp1 = j + 1;
	    l = 6 - j;
	    givens_752(&a[j + j * 6 - 7], &a[j + 29], &c, &s);
	    rotate_752(&l, &c, &s, &a[jp1 + j * 6 - 7], &a[jp1 + 29]);
/* L8: */
	}
	++i;
	goto L7;
    }

/* Test the system for ill-conditioning. */

/* Computing MIN */
    r__1 = dabs(a[0]), r__2 = dabs(a[7]), r__1 = min(r__1,r__2), r__2 = dabs(
	    a[14]), r__1 = min(r__1,r__2), r__2 = dabs(a[21]), r__1 = min(
	    r__1,r__2), r__2 = dabs(a[28]);
    dmin_ = dmin(r__1,r__2);
    if (dmin_ / w >= dtol) {
	goto L12;
    }
    if (lnp <= lmax) {

/*   Add another node to the system and increase R.  Note */
/*     that I = LNP. */

	++lnp;
	if (lnp <= lmax) {
	    getnp_(ncc, &lcc[1], n, &x[1], &y[1], &list[1], &lptr[1], &lend[1]
		    , &lnp, npts, dist, &ierr);
/* Computing 2nd power */
	    r__1 = dist[lnp - 1];
	    rs = r__1 * r__1;
	}
	rin = 1.f / sqrt(rs * 1.1f);
	goto L7;
    }

/* Stabilize the system by damping second partials -- add */
/*   multiples of the first three unit vectors to the first */
/*   three equations. */

    stf = w;
    for (i = 1; i <= 3; ++i) {
	a[i + 29] = stf;
	for (j = i + 1; j <= 6; ++j) {
	    a[j + 29] = 0.f;
/* L9: */
	}
	for (j = i; j <= 5; ++j) {
	    jp1 = j + 1;
	    l = 6 - j;
	    givens_752(&a[j + j * 6 - 7], &a[j + 29], &c, &s);
	    rotate_752(&l, &c, &s, &a[jp1 + j * 6 - 7], &a[jp1 + 29]);
/* L10: */
	}
/* L11: */
    }

/* Test the damped system for ill-conditioning. */

/* Computing MIN */
    r__1 = dabs(a[21]), r__2 = dabs(a[28]);
    dmin_ = dmin(r__1,r__2);
    if (dmin_ / w < dtol) {
	goto L14;
    }

/* Solve the 2 by 2 triangular system for the partial */
/*   derivatives. */

L12:
    *dy = a[29] / a[28];
    *dx = sf * (a[23] - a[22] * *dy) / a[21];
    *dy = sf * *dy;
    *ier = lnp - 1;
    return 0;

/* Invalid input parameter. */

L13:
    *ier = -1;
    return 0;

/* No unique solution due to collinear nodes. */

L14:
    *ier = -2;
    return 0;
} /* gradl_752 */

/* Subroutine */ int grcoef_752(real *sigma, real *dcub, real *d, real *sd)
{
    /* Builtin functions */
    double exp(doublereal);

    /* Local variables */
    real e, coshm, sinhm, ssinh, coshmm;
    extern /* Subroutine */ int snhcsh_752(real *, real *, real *, real *);
    real scm, sig, ems, ssm;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   11/18/96 */

/*   This subroutine computes factors involved in the linear */
/* system solved by Subroutines GRADG and SMSGS. */

/* On input: */

/*       SIGMA = Nonnegative tension factor associated with a */
/*               triangulation arc. */

/*       DCUB = Cube of the positive arc length. */

/* Input parameters are not altered by this routine. */

/* On output: */

/*       D = Diagonal factor.  D = SIG*(SIG*COSHM(SIG) - */
/*           SINHM(SIG))/(E*DCUB), where E = SIG*SINH(SIG) - */
/*           2*COSHM(SIG).  D > 0. */

/*       SD = Off-diagonal factor.  SD = SIG*SINHM(SIG)/ */
/*            (E*DCUB).  SD > 0. */

/* SRFPACK module required by GRCOEF:  SNHCSH */

/* Intrinsic function called by GRCOEF:  EXP */

/* *********************************************************** */


    sig = *sigma;
    if (sig < 1e-9f) {

/* SIG = 0:  cubic interpolant. */

	*d = 4.f / *dcub;
	*sd = 2.f / *dcub;
    } else if (sig <= .5f) {

/* 0 .LT. SIG .LE. .5:  use approximations designed to avoid */
/*                      cancellation error in the hyperbolic */
/*                      functions when SIGMA is small. */

	snhcsh_752(&sig, &sinhm, &coshm, &coshmm);
	e = (sig * sinhm - coshmm - coshmm) * *dcub;
	*d = sig * (sig * coshm - sinhm) / e;
	*sd = sig * sinhm / e;
    } else {

/* SIG > .5:  scale SINHM and COSHM by 2*EXP(-SIG) in order */
/*            to avoid overflow when SIGMA is large. */

	ems = exp(-(doublereal)sig);
	ssinh = 1.f - ems * ems;
	ssm = ssinh - sig * 2.f * ems;
	scm = (1.f - ems) * (1.f - ems);
	e = (sig * ssinh - scm - scm) * *dcub;
	*d = sig * (sig * scm - ssm) / e;
	*sd = sig * ssm / e;
    }
    return 0;
} /* grcoef_752 */

/* Subroutine */ int intrc0_752(real *px, real *py, integer *ncc, integer *lcc, 
	integer *n, real *x, real *y, real *z, integer *list, integer *lptr, 
	integer *lend, integer *ist, real *pz, integer *ier)
{
    /* System generated locals */
    real r__1, r__2;

    /* Local variables */
    integer ierr;
    extern logical crtri_(integer *, integer *, integer *, integer *, integer 
	    *);
    real b1, b2, b3;
    integer i1, i2, i3, n1, n2;
    real x1, x2, y1, y2, dp, xp, yp;
    extern /* Subroutine */ int trfind_(integer *, real *, real *, integer *, 
	    real *, real *, integer *, integer *, integer *, integer *, 
	    integer *, integer *), coords_(real *, real *, real *, real *, 
	    real *, real *, real *, real *, real *, real *, real *, integer *)
	    ;
    integer lpl;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   07/03/98 */

/*   Given a triangulation of a set of nodes in the plane, */
/* along with data values at the nodes, this subroutine com- */
/* putes the value at P = (PX,PY) of the piecewise linear */
/* function which interpolates the data values.  The surface */
/* is extended in a continuous fashion beyond the boundary of */
/* the triangulation, allowing extrapolation. */

/* On input: */

/*       PX,PY = Coordinates of the point P at which the sur- */
/*               face is to be evaluated. */

/*       NCC = Number of constraint curves (refer to TRIPACK */
/*             Subroutine ADDCST).  NCC .GE. 0. */

/*       LCC = Array of length NCC (or dummy array of length */
/*             1 if NCC = 0) containing the index of the */
/*             first node of constraint I in LCC(I).  For I = */
/*             1 to NCC, LCC(I+1)-LCC(I) .GE. 3, where */
/*             LCC(NCC+1) = N+1. */

/*       N = Number of nodes in the triangulation.  N .GE. 3. */

/*       X,Y = Arrays of length N containing the coordinates */
/*             of the nodes with non-constraint nodes in the */
/*             first LCC(1)-1 locations, followed by NCC se- */
/*             quences of constraint nodes. */

/*       Z = Array of length N containing data values at the */
/*           nodes.  Refer to Subroutine ZGRADL. */

/*       LIST,LPTR,LEND = Data structure defining the trian- */
/*                        gulation.  Refer to TRIPACK */
/*                        Subroutine TRMESH. */

/* The above parameters are not altered by this routine. */

/*       IST = Index of the starting node in the search for a */
/*             triangle containing P.  1 .LE. IST .LE. N. */
/*             The output value of IST from a previous call */
/*             may be a good choice. */

/* On output: */

/*       IST = Index of one of the vertices of the triangle */
/*             containing P (or a boundary node which is vis- */
/*             ible from P) unless IER < 0. */

/*       PZ = Value of the interpolatory surface at P, or */
/*            zero if IER < 0. */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered and P is */
/*                     contained in a triangle but not in a */
/*                     constraint region. */
/*             IER = 1 if no errors were encountered and P */
/*                     lies in a constraint region triangle. */
/*                     PZ is effectively an extrapolated */
/*                     value in this case. */
/*             IER = 2 if no errors were encountered and P is */
/*                     exterior to the triangulation.  PZ is */
/*                     an extrapolated value in this case. */
/*             IER = -1 if NCC, N, or IST is outside its */
/*                      valid range on input.  LCC is not */
/*                      tested for validity. */
/*             IER = -2 if the nodes are collinear. */

/* TRIPACK modules required by INTRC0:  CRTRI, JRAND, LEFT, */
/*                                        LSTPTR, TRFIND */

/* SRFPACK module required by INTRC0:  COORDS */

/* *********************************************************** */


    /* Parameter adjustments */
    --lend;
    --lptr;
    --list;
    --z;
    --y;
    --x;
    --lcc;

    /* Function Body */
    xp = *px;
    yp = *py;
    *pz = 0.f;

/* Test for invalid input parameters. */

    if (*ncc < 0 || *n < 3 || *ist < 1 || *ist > *n) {
	*ier = -1;
	return 0;
    }

/* Find a triangle (I1,I2,I3) containing P, or a pair of */
/*   visible boundary nodes I1 and I2. */

    trfind_(ist, &xp, &yp, n, &x[1], &y[1], &list[1], &lptr[1], &lend[1], &i1,
	     &i2, &i3);
    if (i1 == 0) {
	*ier = -2;
	return 0;
    }
    *ist = i1;
    if (i3 == 0) {
	goto L1;
    }

/* P is in a triangle.  Compute its barycentric coordinates. */

    coords_(&xp, &yp, &x[i1], &x[i2], &x[i3], &y[i1], &y[i2], &y[i3], &b1, &
	    b2, &b3, &ierr);
    if (ierr != 0) {
	*ier = -2;
	return 0;
    }

/* Compute an interpolated value. */

    *pz = b1 * z[i1] + b2 * z[i2] + b3 * z[i3];
    *ier = 0;

    if (crtri_(ncc, &lcc[1], &i1, &i2, &i3)) {
	*ier = 1;
    } else {
	*ier = 0;
    }
    return 0;

/* P is exterior to the triangulation.  Extrapolate to P by */
/*   extending the interpolatory surface as a constant */
/*   beyond the boundary:  PZ is the function value at Q */
/*   where Q is the closest boundary point to P. */

/* Determine Q by traversing the boundary starting from the */
/*   rightmost visible node I1. */

L1:
    *ier = 2;
    n2 = i1;

/* Top of loop: */

/*   Set N1 to the last neighbor of N2, and compute the dot */
/*     product DP = (N2->N1,N2->P).  P FORWARD N2->N1 iff */
/*     DP > 0. */

L2:
    lpl = lend[n2];
    n1 = -list[lpl];
    x1 = x[n1];
    y1 = y[n1];
    x2 = x[n2];
    y2 = y[n2];
    dp = (x1 - x2) * (xp - x2) + (y1 - y2) * (yp - y2);
    if (dp <= 0.f) {

/*   N2 is the closest boundary point to P. */

	*pz = z[n2];
	return 0;
    }

/*   P FORWARD N2->N1.  Test for P FORWARD N1->N2. */

    if ((xp - x1) * (x2 - x1) + (yp - y1) * (y2 - y1) > 0.f) {

/*   The closest boundary point to P lies on N2-N1.  Compute */
/*     its local coordinates with respect to N2-N1. */

/* Computing 2nd power */
	r__1 = x2 - x1;
/* Computing 2nd power */
	r__2 = y2 - y1;
	b1 = dp / (r__1 * r__1 + r__2 * r__2);
	b2 = 1.f - b1;
	*pz = b1 * z[n1] + b2 * z[n2];
	return 0;
    }

/*   Bottom of boundary traversal loop. */

    n2 = n1;
    goto L2;
} /* intrc0_752 */

/* Subroutine */ int intrc1_752(real *px, real *py, integer *ncc, integer *lcc, 
	integer *n, real *x, real *y, real *z, integer *list, integer *lptr, 
	integer *lend, integer *iflgs, real *sigma, real *grad, logical *
	dflag, integer *ist, real *pz, real *pzx, real *pzy, integer *ier)
{
    /* System generated locals */
    real r__1;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    extern /* Subroutine */ int fval_752(real *, real *, real *, real *, real *, 
	    real *, real *, real *, real *, real *, real *, real *, real *, 
	    real *, real *, real *, real *, real *, real *, real *, real *, 
	    integer *);
    integer ierr;
    extern /* Subroutine */ int tval_(real *, real *, real *, real *, real *, 
	    real *, real *, real *, real *, real *, real *, real *, real *, 
	    real *, real *, real *, real *, logical *, real *, real *, real *,
	     integer *);
    real d, t, a1;
    extern logical crtri_(integer *, integer *, integer *, integer *, integer 
	    *);
    real a2, b1, b2;
    logical tensn;
    real c1, c2;
    integer i1, i2, i3;
    real d1, d2;
    integer n1, n2, n3;
    real d3, f1, f2, r1, r2, t1, t2, x1, x2, x3, y1, y2, y3, z1, z2, z3, dp, 
	    r12, x12;
    integer lp;
    real x23, y12, y23, xp, xq, yp, yq, zq;
    extern /* Subroutine */ int arcint_752(real *, real *, real *, real *, real *
	    , real *, real *, real *, real *, real *, real *, real *, logical 
	    *, real *, real *, real *, integer *), trfind_(integer *, real *, 
	    real *, integer *, real *, real *, integer *, integer *, integer *
	    , integer *, integer *, integer *);
    real dp1, dp3;
    extern integer lstptr_(integer *, integer *, integer *, integer *);
    real x2p, y2p, zx1, zx2, zx3, zy1, zy2, zy3, sig;
    integer lpl;
    real xqp, yqp, zxq, zyq, sig1, sig2, sig3;


/* *********************************************************** */
/*       IST = Index of the starting node in the search for a */
/*             triangle containing P.  1 .LE. IST .LE. N. */
/*             The output value of IST from a previous call */
/*             may be a good choice. */

/* On output: */

/*       IST = Index of one of the vertices of the triangle */
/*             containing P (or a boundary node which is vis- */
/*             ible from P) unless IER = -1 or IER = -2. */

/*       PZ = Value of the interpolatory surface at P, or */
/*            zero if IER < 0. */

/*       PZX,PZY = X and Y partials at P if DFLAG = .TRUE. */
/*                 and IER .GE. 0, unaltered otherwise. */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered and P is */
/*                     contained in a triangle but not in a */
/*                     constraint region. */
/*             IER = 1 if no errors were encountered and P */
/*                     lies in a constraint region triangle. */
/*                     PZ is effectively an extrapolated */
/*                     value in this case. */
/*             IER = 2 if no errors were encountered and P is */
/*                     exterior to the triangulation.  PZ is */
/*                     an extrapolated value in this case. */
/*             IER = -1 if NCC, N, or IST is outside its */
/*                      valid range on input.  LCC is not */
/*                      tested for validity. */
/*             IER = -2 if the nodes are collinear. */
/*             IER = -3 if P is contained in a triangle and */
/*                      DFLAG = TRUE, but IFLGS > 0 or */
/*                      SIGMA(1) .NE. 0. */

/* TRIPACK modules required by INTRC1:  CRTRI, JRAND, LEFT, */
/*                                        LSTPTR, TRFIND */

/* SRFPACK modules required by INTRC1:  ARCINT, COORDS, FVAL, */
/*                                        SNHCSH, TVAL */

/* Intrinsic function called by INTRC1:  SQRT */

/* *********************************************************** */


    /* Parameter adjustments */
    grad -= 3;
    --sigma;
    --lend;
    --lptr;
    --list;
    --z;
    --y;
    --x;
    --lcc;

    /* Function Body */
    xp = *px;
    yp = *py;
    *pz = 0.f;

/* Test for invalid input parameters. */

    if (*ncc < 0 || *n < 3 || *ist < 1 || *ist > *n) {
	*ier = -1;
	return 0;
    }

/* Find a triangle (I1,I2,I3) containing P, or a pair of */
/*   visible boundary nodes I1 and I2. */

    trfind_(ist, &xp, &yp, n, &x[1], &y[1], &list[1], &lptr[1], &lend[1], &i1,
	     &i2, &i3);
    if (i1 == 0) {
	*ier = -2;
	return 0;
    }
    *ist = i1;
    tensn = *iflgs >= 1 || sigma[1] != 0.f;
    if (i3 == 0) {
	goto L1;
    }
    if (*dflag && tensn) {
	*ier = -3;
	return 0;
    }

/* P is in a triangle.  Store local parameters for the */
/*   call to FVAL or TVAL. */

    x1 = x[i1];
    y1 = y[i1];
    x2 = x[i2];
    y2 = y[i2];
    x3 = x[i3];
    y3 = y[i3];
    z1 = z[i1];
    z2 = z[i2];
    z3 = z[i3];
    zx1 = grad[(i1 << 1) + 1];
    zx2 = grad[(i2 << 1) + 1];
    zx3 = grad[(i3 << 1) + 1];
    zy1 = grad[(i1 << 1) + 2];
    zy2 = grad[(i2 << 1) + 2];
    zy3 = grad[(i3 << 1) + 2];
    if (tensn) {

/* Set SIG1, SIG2, and SIG3 to the tension factors associated */
/*   with the sides opposite I1, I2, and I3, respectively, */
/*   and compute a value from FVAL. */

	if (*iflgs <= 0) {
	    sig1 = sigma[1];
	    sig2 = sig1;
	    sig3 = sig1;
	} else {
	    lp = lstptr_(&lend[i2], &i3, &list[1], &lptr[1]);
	    sig1 = sigma[lp];
	    lp = lstptr_(&lend[i3], &i1, &list[1], &lptr[1]);
	    sig2 = sigma[lp];
	    lp = lstptr_(&lend[i1], &i2, &list[1], &lptr[1]);
	    sig3 = sigma[lp];
	}
	fval_752(&xp, &yp, &x1, &x2, &x3, &y1, &y2, &y3, &z1, &z2, &z3, &zx1, &
		zx2, &zx3, &zy1, &zy2, &zy3, &sig1, &sig2, &sig3, pz, &ierr);
	if (ierr < 0) {
	    *ier = -2;
	    return 0;
	}
    } else {

/* Compute an interpolated value from TVAL for no tension. */

	tval_(&xp, &yp, &x1, &x2, &x3, &y1, &y2, &y3, &z1, &z2, &z3, &zx1, &
		zx2, &zx3, &zy1, &zy2, &zy3, dflag, pz, pzx, pzy, &ierr);
	if (ierr != 0) {
	    *ier = -2;
	    return 0;
	}
    }

    if (crtri_(ncc, &lcc[1], &i1, &i2, &i3)) {
	*ier = 1;
    } else {
	*ier = 0;
    }
    return 0;

/* P is exterior to the triangulation.  Extrapolate to P by */
/*   passing a linear function of one variable through the */
/*   value and directional derivative (in the direction */
/*   Q->P) of the interpolatory surface F at Q, where Q is */
/*   the closest boundary point to P. */

/* Determine Q by traversing the boundary starting from the */
/*   rightmost visible node I1. */

L1:
    *ier = 2;
    n2 = i1;

/* Top of loop: */

/*   Set N1 to the last neighbor of N2, and compute the dot */
/*     product DP = (N2->N1,N2->P).  P FORWARD N2->N1 iff */
/*     DP > 0. */

L2:
    lpl = lend[n2];
    n1 = -list[lpl];
    x1 = x[n1];
    y1 = y[n1];
    x2 = x[n2];
    y2 = y[n2];
    dp = (x1 - x2) * (xp - x2) + (y1 - y2) * (yp - y2);
    if (dp <= 0.f) {

/*   N2 is the closest boundary point to P:  P lies in a */
/*     wedge with sides orthogonal to N1-N2 and N2-N3, where */
/*     N3 is the first neighbor of N2.  The linear interpo- */
/*     lant must be modified by a correction term which */
/*     provides for continuity of the derivative across the */
/*     sides of the wedge. */

	lp = lptr[lpl];
	n3 = list[lp];
	zx1 = grad[(n1 << 1) + 1];
	zx2 = grad[(n2 << 1) + 1];
	zx3 = grad[(n3 << 1) + 1];
	zy1 = grad[(n1 << 1) + 2];
	zy2 = grad[(n2 << 1) + 2];
	zy3 = grad[(n3 << 1) + 2];
	x12 = x2 - x1;
	y12 = y2 - y1;
	x23 = x[n3] - x2;
	y23 = y[n3] - y2;
	x2p = xp - x2;
	y2p = yp - y2;
	dp1 = -(doublereal)dp;
	dp3 = x23 * x2p + y23 * y2p;
	d2 = x2p * x2p + y2p * y2p;
	d1 = sqrt((x12 * x12 + y12 * y12) * d2);
	d3 = sqrt((x23 * x23 + y23 * y23) * d2);
/* Computing 2nd power */
	r__1 = x12 * y23 - y12 * x23;
	d = r__1 * r__1;
	t1 = dp3 * (x12 * (zy2 - zy1) - y12 * (zx2 - zx1)) / d1;
	t2 = dp1 * (x23 * (zy3 - zy2) - y23 * (zx3 - zx2)) / d3;
	t = dp1 * dp3 * (t1 + t2);
	*pz = z[n2] + x2p * zx2 + y2p * zy2;
	if (d != 0.f) {
	    *pz -= t / d;
	}
	if (*dflag) {
	    t /= d2;
	    d1 = dp3 * (t1 + t2 + t2);
	    d2 = dp1 * (t1 + t1 + t2);
	    *pzx = zx2;
	    if (d != 0.f) {
		*pzx += (t * x2p - d1 * x12 - d2 * x23) / d;
	    }
	    *pzy = zy2;
	    if (d != 0.f) {
		*pzy += (t * y2p - d1 * y12 - d2 * y23) / d;
	    }
	}
	return 0;
    }

/*   P FORWARD N2->N1.  Test for P FORWARD N1->N2. */

    if ((xp - x1) * (x2 - x1) + (yp - y1) * (y2 - y1) <= 0.f) {

/*   Bottom of boundary traversal loop. */

	n2 = n1;
	goto L2;
    }

/* The closest boundary point Q lies on N2-N1.  Store par- */
/*   tials at N1 and N2, and compute Q and its barycentric */
/*   coordinates R1 and R2. */

    zx1 = grad[(n1 << 1) + 1];
    zy1 = grad[(n1 << 1) + 2];
    zx2 = grad[(n2 << 1) + 1];
    zy2 = grad[(n2 << 1) + 2];
    x12 = x2 - x1;
    y12 = y2 - y1;
    d2 = x12 * x12 + y12 * y12;
    r1 = dp / d2;
    r2 = 1.f - r1;
    xq = r1 * x1 + r2 * x2;
    yq = r1 * y1 + r2 * y2;
    if (tensn) {

/*   Set SIG to the tension factor associated with N1-N2 and */
/*     compute an interpolated value ZQ at Q from FVAL. */

	if (*iflgs <= 0) {
	    sig = sigma[1];
	} else {
	    sig = sigma[lpl];
	}
	arcint_752(&r1, &x1, &x2, &y1, &y2, &z[n1], &z[n2], &zx1, &zx2, &zy1, &
		zy2, &sig, (logical*)&c__1, &zq, &zxq, &zyq, &ierr);

/*   Compute the extrapolated value at P. */

	xqp = xp - xq;
	yqp = yp - yq;
	*pz = zq + zxq * xqp + zyq * yqp;
	if (*dflag) {
	    t = ((zx2 - zx1) * xqp + (zy2 - zy1) * yqp) / d2;
	    *pzx = zxq + x12 * t;
	    *pzy = zyq + y12 * t;
	}
    } else {

/*   Compute the cardinal function values and interpolated */
/*     value at Q associated with TVAL. */

	r12 = r1 * r2;
	f1 = r1 * r12;
	f2 = r2 * r12;
	a1 = r1 + (f1 - f2);
	a2 = r2 - (f1 - f2);
	b1 = x12 * f1;
	b2 = -(doublereal)x12 * f2;
	c1 = y12 * f1;
	c2 = -(doublereal)y12 * f2;
	zq = a1 * z[n1] + a2 * z[n2] + b1 * zx1 + b2 * zx2 + c1 * zy1 + c2 * 
		zy2;

/*   Compute the extrapolated value at P. */

	xqp = xp - xq;
	yqp = yp - yq;
	t1 = r1 * zx1 + r2 * zx2;
	t2 = r1 * zy1 + r2 * zy2;
	*pz = zq + t1 * xqp + t2 * yqp;
	if (*dflag) {
	    t = (r12 * 3.f * ((z[n2] - z[n1]) * 2.f - x12 * (zx1 + zx2) - y12 
		    * (zy1 + zy2)) + (zx2 - zx1) * xqp + (zy2 - zy1) * yqp) / 
		    d2;
	    *pzx = t1 + x12 * t;
	    *pzy = t2 + y12 * t;
	}
    }
    return 0;
} /* intrc1_752 */

/* Subroutine */ int rotate_752(integer *n, real *c, real *s, real *x, real *y)
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    integer i;
    real xi, yi;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   09/01/88 */

/*                                                ( C  S) */
/*   This subroutine applies the Givens rotation  (     )  to */
/*                                                (-S  C) */
/*                    (X(1) ... X(N)) */
/* the 2 by N matrix  (             ) . */
/*                    (Y(1) ... Y(N)) */

/*   This routine is identical to Subroutine SROT from the */
/* LINPACK BLAS (Basic Linear Algebra Subroutines). */

/* On input: */

/*       N = Number of columns to be rotated. */

/*       C,S = Elements of the Givens rotation.  Refer to */
/*             Subroutine GIVENS. */

/* The above parameters are not altered by this routine. */

/*       X,Y = Arrays of length .GE. N containing the compo- */
/*             nents of the vectors to be rotated. */

/* On output: */

/*       X,Y = Arrays containing the rotated vectors (not */
/*             altered if N < 1). */

/* Modules required by ROTATE:  None */

/* *********************************************************** */


    /* Parameter adjustments */
    --y;
    --x;

    /* Function Body */
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	xi = x[i];
	yi = y[i];
	x[i] = *c * xi + *s * yi;
	y[i] = -(doublereal)(*s) * xi + *c * yi;
/* L1: */
    }
    return 0;
} /* rotate_752 */

/* Subroutine */ int setro1_(real *xk, real *yk, real *zk, real *xi, real *yi,
	 real *zi, real *s1, real *s2, real *w, real *row)
{
    real w1, w2, dx, dy;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   09/01/88 */

/*   This subroutine sets up the I-th row of an augmented re- */
/* gression matrix for a weighted least squares fit of a */
/* quadratic function Q(X,Y) to a set of data values Z, where */
/* Q(XK,YK) = ZK.  The first three columns (quadratic terms) */
/* are scaled by S2, and the fourth and fifth columns (lin- */
/* ear terms) are scaled by S1. */

/* On input: */

/*       XK,YK = Coordinates of node K. */

/*       ZK = Data value at node K to be interpolated by Q. */

/*       XI,YI,ZI = Coordinates and data value at node I. */

/*       S1,S2 = Scale factors. */

/*       W = Weight associated with node I. */

/* The above parameters are not altered by this routine. */

/*       ROW = Array of length 6. */

/* On output: */

/*       ROW = Array containing a row of the augmented re- */
/*             gression matrix. */

/* Modules required by SETRO1:  None */

/* *********************************************************** */


    /* Parameter adjustments */
    --row;

    /* Function Body */
    dx = *xi - *xk;
    dy = *yi - *yk;
    w1 = *s1 * *w;
    w2 = *s2 * *w;
    row[1] = dx * dx * w2;
    row[2] = dx * dy * w2;
    row[3] = dy * dy * w2;
    row[4] = dx * w1;
    row[5] = dy * w1;
    row[6] = (*zi - *zk) * *w;
    return 0;
} /* setro1_ */

/* Subroutine */ int setro2_(real *xk, real *yk, real *zk, real *xi, real *yi,
	 real *zi, real *s1, real *s2, real *w, real *row)
{
    real w1, w2, dx, dy;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   09/01/88 */

/*   This subroutine sets up the I-th row of an augmented re- */
/* gression matrix for a weighted least squares fit of a */
/* quadratic function Q(X,Y) to a set of data values Z.  The */
/* first 3 columns (quadratic terms) are scaled by S2, and */
/* the fourth and fifth columns (linear terms) are scaled by */
/* S1. */

/* On input: */

/*       XK,YK = Coordinates of node K. */

/*       ZK = Data value at node K to be interpolated by Q */
/*            (Q(XK,YK) = ZK) if the constant term, ROW(6), */
/*            is to be ignored, or zero if Q(XK,YK) is to be */
/*            a parameter (coefficient of ROW(6)). */

/*       XI,YI,ZI = Coordinates and data value at node I. */

/*       S1,S2 = Scale factors. */

/*       W = Weight associated with node I. */

/* The above parameters are not altered by this routine. */

/*       ROW = Array of length 7. */

/* On output: */

/*       ROW = Array containing a row of the augmented re- */
/*             gression matrix. */

/* Modules required by SETRO2:  None */

/* *********************************************************** */


    /* Parameter adjustments */
    --row;

    /* Function Body */
    dx = *xi - *xk;
    dy = *yi - *yk;
    w1 = *s1 * *w;
    w2 = *s2 * *w;
    row[1] = dx * dx * w2;
    row[2] = dx * dy * w2;
    row[3] = dy * dy * w2;
    row[4] = dx * w1;
    row[5] = dy * w1;
    row[6] = *w;
    row[7] = (*zi - *zk) * *w;
    return 0;
} /* setro2_ */

/* Subroutine */ int setro3_(real *xk, real *yk, real *zk, real *xi, real *yi,
	 real *zi, real *s1, real *s2, real *s3, real *w, real *row)
{
    real w1, w2, w3, dx, dy;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   01/25/97 */

/*   This subroutine sets up the I-th row of an augmented re- */
/* gression matrix for a weighted least squares fit of a */
/* cubic function f(x,y) to a set of data values z, where */
/* f(XK,YK) = ZK.  The first four columns (cubic terms) are */
/* scaled by S3, the next three columns (quadratic terms) */
/* are scaled by S2, and the eighth and ninth columns (lin- */
/* ear terms) are scaled by S1. */

/* On input: */

/*       XK,YK = Coordinates of node K. */

/*       ZK = Data value at node K to be interpolated by f. */

/*       XI,YI,ZI = Coordinates and data value at node I. */

/*       S1,S2,S3 = Scale factors. */

/*       W = Weight associated with node I. */

/* The above parameters are not altered by this routine. */

/*       ROW = Array of length 10. */

/* On output: */

/*       ROW = Array containing a row of the augmented re- */
/*             gression matrix. */

/* Modules required by SETRO3:  None */

/* *********************************************************** */


    /* Parameter adjustments */
    --row;

    /* Function Body */
    dx = *xi - *xk;
    dy = *yi - *yk;
    w1 = *s1 * *w;
    w2 = *s2 * *w;
    w3 = *s3 * *w;
    row[1] = dx * dx * dx * w3;
    row[2] = dx * dx * dy * w3;
    row[3] = dx * dy * dy * w3;
    row[4] = dy * dy * dy * w3;
    row[5] = dx * dx * w2;
    row[6] = dx * dy * w2;
    row[7] = dy * dy * w2;
    row[8] = dx * w1;
    row[9] = dy * w1;
    row[10] = (*zi - *zk) * *w;
    return 0;
} /* setro3_ */

/* Subroutine */ int sgprnt_752(integer *n, integer *lunit, integer *list, 
	integer *lptr, integer *lend, real *sigma)
{
    /* Initialized data */

    static integer nmax = 9999;
    static integer nlmax = 60;

    /* Format strings */
    static char fmt_100[] = "(///14x,\002Tension Factors,  N =\002,i5,\002 N"
	    "odes\002//1x,18x,\002N1\002,5x,\002N2\002,8x,\002Tension\002//)";
    static char fmt_110[] = "(1x,16x,i4,3x,i4,5x,f12.8)";
    static char fmt_120[] = "(1x,16x,i4,3x,i4,5x,f12.8,3x,f12.8,\002 *\002)";
    static char fmt_130[] = "(///)";
    static char fmt_200[] = "(//1x,10x,\002*\002,i5,\002 Errors in SIGMA\002)"
	    ;
    static char fmt_140[] = "(//1x,10x,\002NA =\002,i5,\002 Arcs\002)";
    static char fmt_210[] = "(/1x,10x,\002*** Error in triangulation:  \002"
	    ",\0023N-NB-3 = \002,i5,\002 ***\002)";
    static char fmt_220[] = "(1x,10x,\002*** N is outside its valid range: "
	    " \002,\002NMAX = \002,i4,\002 ***\002)";

    /* System generated locals */
    integer i__1, i__2;

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void);

    /* Local variables */
    logical error;
    integer n1, n2, na, nb, ne, nl, nm1, lp1, lp2;
    extern integer lstptr_(integer *, integer *, integer *, integer *);
    integer nat;
    real sig;
    integer lpl, lun;

    /* Fortran I/O blocks */
    static cilist io___419 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___432 = { 0, 0, 0, fmt_110, 0 };
    static cilist io___433 = { 0, 0, 0, fmt_120, 0 };
    static cilist io___434 = { 0, 0, 0, fmt_130, 0 };
    static cilist io___435 = { 0, 0, 0, fmt_200, 0 };
    static cilist io___436 = { 0, 0, 0, fmt_140, 0 };
    static cilist io___438 = { 0, 0, 0, fmt_210, 0 };
    static cilist io___439 = { 0, 0, 0, fmt_220, 0 };



/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   07/03/98 */

/*   Given a triangulation of a set of nodes in the plane, */
/* along with an array of tension factors associated with the */
/* triangulation arcs, this subroutine prints the list of */
/* arcs (with tension factors) ordered by endpoint nodal in- */
/* dexes.  An arc is identified with its smaller endpoint */
/* index:  N1-N2, where N1 < N2. */

/* On input: */

/*       N = Number of nodes in the triangulation.  3 .LE. N */
/*           .LE. 9999. */

/*       LUNIT = Logical unit for output.  0 .LE. LUNIT .LE. */
/*               99.  Output is printed on unit 6 if LUNIT is */
/*               outside its valid range. */

/*       LIST,LPTR,LEND = Data structure defining the trian- */
/*                        gulation.  Refer to TRIPACK */
/*                        Subroutine TRMESH. */

/*       SIGMA = Array of length 2*NA = 6*(N-1)-2*NB, where */
/*               NA and NB are the numbers of arcs and boun- */
/*               dary nodes, respectively, containing tension */
/*               factors associated with arcs in one-to-one */
/*               correspondence with LIST entries.  Note that */
/*               each arc N1-N2 has two LIST entries and */
/*               thus, SIGMA(I) and SIGMA(J) should be iden- */
/*               tical, where LIST(I) = N2 (in the adjacency */
/*               list for N1) and LIST(J) = N1 (in the list */
/*               associated with N2).  Both SIGMA(I) and */
/*               SIGMA(J) are printed if they are not iden- */
/*               tical. */

/* None of the parameters are altered by this routine. */

/* TRIPACK module required by SGPRNT:  LSTPTR */

/* Intrinsic function called by SGPRNT:  ABS */

/* *********************************************************** */

    /* Parameter adjustments */
    --sigma;
    --lend;
    --lptr;
    --list;

    /* Function Body */

    lun = *lunit;
    if (lun < 0 || lun > 99) {
	lun = 6;
    }

/* Print a heading, test for invalid N, and initialize coun- */
/*   ters: */

/* NL = Number of lines printed on the current page */
/* NA = Number of arcs encountered */
/* NE = Number of errors in SIGMA encountered */
/* NB = Number of boundary nodes encountered */

    io___419.ciunit = lun;
    s_wsfe(&io___419);
    do_fio(&c__1, (char *)&(*n), (ftnlen)sizeof(integer));
    e_wsfe();
    if (*n < 3 || *n > nmax) {
	goto L4;
    }
    nl = 6;
    na = 0;
    ne = 0;
    nb = 0;

/* Outer loop on nodes N1.  LPL points to the last neighbor */
/*   of N1. */

    nm1 = *n - 1;
    i__1 = nm1;
    for (n1 = 1; n1 <= i__1; ++n1) {
	lpl = lend[n1];
	if (list[lpl] < 0) {
	    ++nb;
	}
	lp1 = lpl;

/* Inner loop on neighbors N2 of N1 such that N1 < N2. */

L1:
	lp1 = lptr[lp1];
	n2 = (i__2 = list[lp1], abs(i__2));
	if (n2 < n1) {
	    goto L2;
	}
	++na;
	sig = sigma[lp1];

/*   Test for an invalid SIGMA entry. */

	lp2 = lstptr_(&lend[n2], &n1, &list[1], &lptr[1]);
	error = sigma[lp2] != sig;
	if (error) {
	    ++ne;
	}

/*   Print a line and update the counters. */

	if (! error) {
	    io___432.ciunit = lun;
	    s_wsfe(&io___432);
	    do_fio(&c__1, (char *)&n1, (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&n2, (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&sig, (ftnlen)sizeof(real));
	    e_wsfe();
	}
	if (error) {
	    io___433.ciunit = lun;
	    s_wsfe(&io___433);
	    do_fio(&c__1, (char *)&n1, (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&n2, (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&sig, (ftnlen)sizeof(real));
	    do_fio(&c__1, (char *)&sigma[lp2], (ftnlen)sizeof(real));
	    e_wsfe();
	}
	++nl;
	if (nl >= nlmax) {
	    io___434.ciunit = lun;
	    s_wsfe(&io___434);
	    e_wsfe();
	    nl = 1;
	}

/* Bottom of loop on neighbors N2 of N1. */

L2:
	if (lp1 != lpl) {
	    goto L1;
	}
/* L3: */
    }
    lpl = lend[*n];
    if (list[lpl] < 0) {
	++nb;
    }

/* Test for errors in SIGMA. */

    if (ne > 0) {
	io___435.ciunit = lun;
	s_wsfe(&io___435);
	do_fio(&c__1, (char *)&ne, (ftnlen)sizeof(integer));
	e_wsfe();
    }

/* Print NA and test for an invalid triangulation. */

    io___436.ciunit = lun;
    s_wsfe(&io___436);
    do_fio(&c__1, (char *)&na, (ftnlen)sizeof(integer));
    e_wsfe();
    nat = nm1 * 3 - nb;
    if (nat != na) {
	io___438.ciunit = lun;
	s_wsfe(&io___438);
	do_fio(&c__1, (char *)&nat, (ftnlen)sizeof(integer));
	e_wsfe();
    }
    return 0;

/* N is outside its valid range. */

L4:
    io___439.ciunit = lun;
    s_wsfe(&io___439);
    do_fio(&c__1, (char *)&nmax, (ftnlen)sizeof(integer));
    e_wsfe();
    return 0;

/* Print formats: */


/* Error messages: */

} /* sgprnt_752 */

doublereal sig0_752(integer *n1, integer *n2, integer *n, real *x, real *y, real 
	*h, integer *list, integer *lptr, integer *lend, real *hxhy, integer *
	iflgb, real *hbnd, real *tol, integer *iflgs, real *sigma, integer *
	ier)
{
    /* Initialized data */

    static real sbig = 85.f;
    static integer lun = -1;

    /* Format strings */
    static char fmt_100[] = "(//1x,\002SIG0 -- N1 =\002,i4,\002, N2 =\002,"
	    "i4,\002, Lower bound = \002,e15.8)";
    static char fmt_110[] = "(//1x,\002SIG0 -- N1 =\002,i4,\002, N2 =\002,"
	    "i4,\002, Upper bound = \002,e15.8)";
    static char fmt_120[] = "(1x,8x,\002SIG = \002,e15.8,\002, SNEG = \002,e"
	    "15.8/1x,9x,\002F0 = \002,e15.8,\002, FMAX = \002,e15.8/)";
    static char fmt_130[] = "(1x,3x,i2,\002 -- SIG = \002,e15.8,\002, F ="
	    " \002,e15.8)";
    static char fmt_140[] = "(1x,8x,\002DSIG = \002,e15.8)";

    /* System generated locals */
    integer i__1;
    real ret_val, r__1, r__2, r__3, r__4, r__5, r__6;

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void);
    double sqrt(doublereal), r_sign(real *, real *), exp(doublereal), log(
	    doublereal);

    /* Local variables */
    real d1pd2, fneg, dsig, dmax_, fmax, sneg, ftol, rsig, rtol, stol, a, b, 
	    c, d, e, f, r, s, t, coshm, sinhm, a0, b0, c1, c2, d0, d2, f0, h1,
	     h2, ssinh;
    extern doublereal store_(real *);
    real s1, s2, t0, t1, t2, aa, rf, dx, dy, tm, coshmm;
    extern /* Subroutine */ int snhcsh_752(real *, real *, real *, real *);
    integer lp1, lp2;
    real bnd, scm, sig, ems;
    integer lpl, nit;
    real ssm;

    /* Fortran I/O blocks */
    static cilist io___444 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___445 = { 0, 0, 0, fmt_110, 0 };
    static cilist io___467 = { 0, 0, 0, fmt_120, 0 };
    static cilist io___494 = { 0, 0, 0, fmt_130, 0 };
    static cilist io___497 = { 0, 0, 0, fmt_140, 0 };



/* *********************************************************** */
/*             IER = -1 if N1, N2, N, or IFLGB is outside its */
/*                      valid range. */
/*             IER = -2 if nodes N1 and N2 coincide or IFLGS */
/*                      .GE. 1 and the nodes are not adja- */
/*                      cent. */
/*             IER = -3 if HBND is outside its valid range. */

/*       SIG0 = Minimum tension factor defined above unless */
/*              IER < 0, in which case SIG0 = -1.  If IER */
/*              = 1, SIG0 is set to 85, resulting in an */
/*              approximation to the linear interpolant of */
/*              the endpoint values. */

/* TRIPACK module required by SIG0:  STORE */

/* SRFPACK module required by SIG0:  SNHCSH */

/* Intrinsic functions called by SIG0:  ABS, EXP, LOG, MAX, */
/*                                        MIN, REAL, SIGN, */
/*                                        SQRT */

/* *********************************************************** */

    /* Parameter adjustments */
    --sigma;
    hxhy -= 3;
    --lend;
    --lptr;
    --list;
    --h;
    --y;
    --x;

    /* Function Body */
    rf = (real) (*iflgb);
    bnd = *hbnd;

/* Print a heading. */

    if (lun >= 0) {
	if (rf < 0.f) {
	    io___444.ciunit = lun;
	    s_wsfe(&io___444);
	    do_fio(&c__1, (char *)&(*n1), (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&(*n2), (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&bnd, (ftnlen)sizeof(real));
	    e_wsfe();
	}
	if (rf > 0.f) {
	    io___445.ciunit = lun;
	    s_wsfe(&io___445);
	    do_fio(&c__1, (char *)&(*n1), (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&(*n2), (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&bnd, (ftnlen)sizeof(real));
	    e_wsfe();
	}
    }

/* Test for errors and store local parameters. */

    *ier = -1;
/* Computing MAX */
    i__1 = max(*n1,*n2);
    if (min(*n1,*n2) < 1 || *n1 == *n2 || max(i__1,3) > *n || dabs(rf) != 1.f)
	     {
	goto L11;
    }
    *ier = -2;
    if (*iflgs > 0) {

/*   Set LP1 and LP2 to the pointers to N2 as a neighbor of */
/*     N1 and N1 as a neighbor of N2, respectively. */

	lpl = lend[*n1];
	lp1 = lptr[lpl];
L1:
	if (list[lp1] == *n2) {
	    goto L2;
	}
	lp1 = lptr[lp1];
	if (lp1 != lpl) {
	    goto L1;
	}
	if ((i__1 = list[lp1], abs(i__1)) != *n2) {
	    goto L11;
	}

L2:
	lpl = lend[*n2];
	lp2 = lptr[lpl];
L3:
	if (list[lp2] == *n1) {
	    goto L4;
	}
	lp2 = lptr[lp2];
	if (lp2 != lpl) {
	    goto L3;
	}
	if ((i__1 = list[lp2], abs(i__1)) != *n1) {
	    goto L11;
	}
    }

/* Test for arc length DT = SQRT(DX**2+DY**2) = 0. */

L4:
    dx = x[*n2] - x[*n1];
    dy = y[*n2] - y[*n1];
    if (dx == 0.f && dy == 0.f) {
	goto L11;
    }

/* Store endpoint values and test for a valid constraint. */

    h1 = h[*n1];
    h2 = h[*n2];
    *ier = -3;
    if (rf < 0.f && dmin(h1,h2) < bnd || rf > 0.f && bnd < dmax(h1,h2)) {
	goto L11;
    }

/* Compute scaled directional derivatives S1,S2 at the end- */
/*   points (for the direction N1->N2) and test for infinite */
/*   tension required. */

    s1 = hxhy[(*n1 << 1) + 1] * dx + hxhy[(*n1 << 1) + 2] * dy;
    s2 = hxhy[(*n2 << 1) + 1] * dx + hxhy[(*n2 << 1) + 2] * dy;
    *ier = 1;
    sig = sbig;
    if (h1 == bnd && rf * s1 > 0.f || h2 == bnd && rf * s2 < 0.f) {
	goto L10;
    }

/* Test for SIG = 0 sufficient. */

    *ier = 0;
    sig = 0.f;
    if (rf * s1 <= 0.f && rf * s2 >= 0.f) {
	goto L10;
    }

/*   Compute first difference S and coefficients A0 and B0 */
/*     of the Hermite cubic interpolant H0(T) = H2 - (S2*R + */
/*     B0*R**2 + A0*R**3), where R = (T2-T)/DT. */

    s = h2 - h1;
    t0 = s * 3.f - s1 - s2;
    a0 = (s - t0) * 3.f;
    b0 = t0 - s2;
    d0 = t0 * t0 - s1 * s2;

/*   H0 has local extrema in (T1,T2) iff S1*S2 < 0 or */
/*     (T0*(S1+S2) < 0 and D0 .GE. 0). */

    if (s1 * s2 >= 0.f && (t0 * (s1 + s2) >= 0.f || d0 < 0.f)) {
	goto L10;
    }
    if (a0 == 0.f) {

/*   H0 is quadratic and has an extremum at R = -S2/(2*B0). */
/*     H0(R) = H2 + S2**2/(4*B0).  Note that A0 = 0 implies */
/*     2*B0 = S1-S2, and S1*S2 < 0 implies B0 .NE. 0. */
/*     Also, the extremum is a min iff HBND is a lower bound. */

	f0 = (bnd - h2 - s2 * s2 / (b0 * 4.f)) * rf;
    } else {

/*   A0 .NE. 0 and H0 has extrema at R = (-B0 +/- SQRT(D0))/ */
/*     A0 = S2/(-B0 -/+ SQRT(D0)), where the negative root */
/*     corresponds to a min.  The expression for R is chosen */
/*     to avoid cancellation error.  H0(R) = H2 + (S2*B0 + */
/*     2*D0*R)/(3*A0). */

	r__1 = sqrt(d0);
	t = -(doublereal)b0 - r_sign(&r__1, &b0);
	r = t / a0;
	if (rf * b0 > 0.f) {
	    r = s2 / t;
	}
	f0 = (bnd - h2 - (s2 * b0 + d0 * 2.f * r) / (a0 * 3.f)) * rf;
    }

/*   F0 .GE. 0 iff SIG = 0 is sufficient to satisfy the */
/*     constraint. */

    if (f0 >= 0.f) {
	goto L10;
    }

/* Find a zero of F(SIG) = (BND-H(R))*RF where the derivative */
/*   of H, HP, vanishes at R.  F is a nondecreasing function, */
/*   F(0) < 0, and F = FMAX for SIG sufficiently large. */

/* Initialize parameters for the secant method.  The method */
/*   uses three points:  (SG0,F0), (SIG,F), and (SNEG,FNEG), */
/*   where SG0 and SNEG are defined implicitly by DSIG = SIG */
/*   - SG0 and DMAX = SIG - SNEG.  SG0 is initially zero and */
/*   SNEG is initialized to a sufficiently large value that */
/*   FNEG > 0.  This value is used only if the initial value */
/*   of F is negative. */

/* Computing MAX */
/* Computing MIN */
    r__5 = (r__1 = h1 - bnd, dabs(r__1)), r__6 = (r__2 = h2 - bnd, dabs(r__2))
	    ;
    r__3 = .001f, r__4 = dmin(r__5,r__6);
    fmax = dmax(r__3,r__4);
/* Computing MAX */
    r__3 = (r__1 = h1 - bnd, dabs(r__1)), r__4 = (r__2 = h2 - bnd, dabs(r__2))
	    ;
    t = dmax(r__3,r__4);
/* Computing MAX */
    r__1 = dabs(s1), r__2 = dabs(s2);
    sig = dmax(r__1,r__2) / t;
    dmax_ = sig * (1.f - t / fmax);
    sneg = sig - dmax_;
    if (lun >= 0) {
	io___467.ciunit = lun;
	s_wsfe(&io___467);
	do_fio(&c__1, (char *)&sig, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&sneg, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&f0, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&fmax, (ftnlen)sizeof(real));
	e_wsfe();
    }
    dsig = sig;
    fneg = fmax;
    d2 = s2 - s;
    d1pd2 = s2 - s1;
    nit = 0;

/* Compute an absolute tolerance FTOL = abs(TOL) and a */
/*   relative tolerance RTOL = 100*Macheps. */

    ftol = dabs(*tol);
    rtol = 1.f;
L5:
    rtol /= 2.f;
    r__1 = rtol + 1.f;
    if (store_(&r__1) > 1.f) {
	goto L5;
    }
    rtol *= 200.f;

/* Top of loop:  compute F. */

L6:
    ems = exp(-(doublereal)sig);
    if (sig <= .5f) {

/*   Use approximations designed to avoid cancellation error */
/*     (associated with small SIG) in the modified hyperbolic */
/*     functions. */

	snhcsh_752(&sig, &sinhm, &coshm, &coshmm);
	c1 = sig * coshm * d2 - sinhm * d1pd2;
	c2 = sig * (sinhm + sig) * d2 - coshm * d1pd2;
	a = c2 - c1;
	aa = a / ems;
	e = sig * sinhm - coshmm - coshmm;
    } else {

/*   Scale SINHM and COSHM by 2*exp(-SIG) in order to avoid */
/*     overflow. */

	tm = 1.f - ems;
	ssinh = tm * (ems + 1.f);
	ssm = ssinh - sig * 2.f * ems;
	scm = tm * tm;
	c1 = sig * scm * d2 - ssm * d1pd2;
	c2 = sig * ssinh * d2 - scm * d1pd2;
	aa = (sig * tm * d2 + (tm - sig) * d1pd2) * 2.f;
	a = ems * aa;
	e = sig * ssinh - scm - scm;
    }

/*   HP(R) = (S2 - (C1*SINH(SIG*R) - C2*COSHM(SIG*R))/E)/DT */
/*     = 0 for ESR = (-B +/- SQRT(D))/A = C/(-B -/+ SQRT(D)) */
/*     where ESR = exp(SIG*R), A = C2-C1, D = B**2 - A*C, and */
/*     B and C are defined below. */

    b = e * s2 - c2;
    c = c2 + c1;
    d = b * b - a * c;
    f = 0.f;
    if (aa * c == 0.f && b == 0.f) {
	goto L7;
    }
    f = fmax;
    if (d < 0.f) {
	goto L7;
    }
    t1 = sqrt(d);
    t = -(doublereal)b - r_sign(&t1, &b);
    rsig = 0.f;
    if (rf * b < 0.f && aa != 0.f) {
	if (t / aa > 0.f) {
	    rsig = sig + log(t / aa);
	}
    }
    if ((rf * b > 0.f || aa == 0.f) && c / t > 0.f) {
	rsig = log(c / t);
    }
    if ((rsig <= 0.f || rsig >= sig) && b != 0.f) {
	goto L7;
    }

/*   H(R) = H2 - (B*SIG*R + C1 + RF*SQRT(D))/(SIG*E). */

    f = (bnd - h2 + (b * rsig + c1 + rf * t1) / (sig * e)) * rf;

/*   Update the number of iterations NIT. */

L7:
    ++nit;
    if (lun >= 0) {
	io___494.ciunit = lun;
	s_wsfe(&io___494);
	do_fio(&c__1, (char *)&nit, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&sig, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&f, (ftnlen)sizeof(real));
	e_wsfe();
    }
    if (f0 * f < 0.f) {

/*   F0*F < 0.  Update (SNEG,FNEG) to (SG0,F0) so that F and */
/*     FNEG always have opposite signs.  If SIG is closer to */
/*     SNEG than SG0, then swap (SNEG,FNEG) with (SG0,F0). */

	t1 = dmax_;
	t2 = fneg;
	dmax_ = dsig;
	fneg = f0;
	if (dabs(dsig) > dabs(t1)) {

	    dsig = t1;
	    f0 = t2;
	}
    }

/*   Test for convergence. */

    stol = rtol * sig;
    if (dabs(dmax_) <= stol || f >= 0.f && f <= ftol || dabs(f) <= rtol) {
	goto L10;
    }

/*   Test for F0 = F = FMAX or F < 0 on the first iteration. */

    if (f0 != f && (nit > 1 || f > 0.f)) {
	goto L9;
    }

/*   F*F0 > 0 and either the new estimate would be outside */
/*     of the bracketing interval of length abs(DMAX) or */
/*     F < 0 on the first iteration.  Reset (SG0,F0) to */
/*     (SNEG,FNEG). */

L8:
    dsig = dmax_;
    f0 = fneg;

/*   Compute the change in SIG by linear interpolation */
/*     between (SG0,F0) and (SIG,F). */

L9:
    dsig = -(doublereal)f * dsig / (f - f0);
    if (lun >= 0) {
	io___497.ciunit = lun;
	s_wsfe(&io___497);
	do_fio(&c__1, (char *)&dsig, (ftnlen)sizeof(real));
	e_wsfe();
    }
    if (dabs(dsig) > dabs(dmax_) || dsig * dmax_ > 0.f) {
	goto L8;
    }

/*   Restrict the step-size such that abs(DSIG) .GE. STOL/2. */
/*     Note that DSIG and DMAX have opposite signs. */

    if (dabs(dsig) < stol / 2.f) {
	r__1 = stol / 2.f;
	dsig = -(doublereal)r_sign(&r__1, &dmax_);
    }

/*   Bottom of loop:  Update SIG, DMAX, and F0. */

    sig += dsig;
    dmax_ += dsig;
    f0 = f;
    goto L6;

/* No errors encountered. */

L10:
    ret_val = sig;
    if (*iflgs <= 0) {
	return ret_val;
    }
    sigma[lp1] = sig;
    sigma[lp2] = sig;
    return ret_val;

/* Error termination. */

L11:
    ret_val = -1.f;
    return ret_val;
} /* sig0_752 */

doublereal sig1_752(integer *n1, integer *n2, integer *n, real *x, real *y, real 
	*h, integer *list, integer *lptr, integer *lend, real *hxhy, integer *
	iflgb, real *hpbnd, real *tol, integer *iflgs, real *sigma, integer *
	ier)
{
    /* Initialized data */

    static real sbig = 85.f;
    static integer lun = -1;

    /* Format strings */
    static char fmt_100[] = "(//1x,\002SIG1 -- N1 =\002,i4,\002, N2 =\002,"
	    "i4,\002, Lower bound = \002,e15.8)";
    static char fmt_110[] = "(//1x,\002SIG1 -- N1 =\002,i4,\002, N2 =\002,"
	    "i4,\002, Upper bound = \002,e15.8)";
    static char fmt_120[] = "(1x,9x,\002F0 = \002,e15.8,\002, FMAX = \002,e1"
	    "5.8/1x,8x,\002SIG = \002,e15.8/)";
    static char fmt_130[] = "(1x,3x,i2,\002 -- SIG = \002,e15.8,\002, F ="
	    " \002,e15.8)";
    static char fmt_140[] = "(1x,8x,\002DSIG = \002,e15.8)";

    /* System generated locals */
    integer i__1;
    real ret_val, r__1, r__2;

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void);
    double sqrt(doublereal), exp(doublereal), r_sign(real *, real *);

    /* Local variables */
    real d1pd2, fneg, dsig, dmax_, fmax, sinh_, ftol, rtol, stol, a, e, f, s, 
	    coshm, sinhm, a0, b0, c0, c1, c2, d0, d1, d2, f0;
    extern doublereal store_(real *);
    real s1, s2, t0, t1, t2, dt, rf, dx, dy, tm, coshmm;
    extern /* Subroutine */ int snhcsh_752(real *, real *, real *, real *);
    integer lp1, lp2;
    real bnd, sig, ems;
    integer lpl, nit;
    real ems2;

    /* Fortran I/O blocks */
    static cilist io___502 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___503 = { 0, 0, 0, fmt_110, 0 };
    static cilist io___521 = { 0, 0, 0, fmt_120, 0 };
    static cilist io___544 = { 0, 0, 0, fmt_130, 0 };
    static cilist io___547 = { 0, 0, 0, fmt_140, 0 };



/* *********************************************************** */
/*                     the constraint (e.g., IFLGB = -1, */
/*                     HPBND = S, and HP1 > S). */
/*             IER = -1 if N1, N2, N, or IFLGB is outside its */
/*                      valid range. */
/*             IER = -2 if nodes N1 and N2 coincide or IFLGS */
/*                      .GE. 1 and the nodes are not adja- */
/*                      cent. */
/*             IER = -3 if HPBND is outside its valid range. */

/*       SIG1 = Minimum tension factor defined above unless */
/*              IER < 0, in which case SIG1 = -1.  If IER */
/*              = 1, SIG1 is set to 85, resulting in an */
/*              approximation to the linear interpolant of */
/*              the endpoint values. */

/* TRIPACK module required by SIG1:  STORE */

/* SRFPACK module required by SIG1:  SNHCSH */

/* Intrinsic functions called by SIG1:  ABS, EXP, MAX, MIN, */
/*                                        REAL, SIGN, SQRT */

/* *********************************************************** */

    /* Parameter adjustments */
    --sigma;
    hxhy -= 3;
    --lend;
    --lptr;
    --list;
    --h;
    --y;
    --x;

    /* Function Body */
    rf = (real) (*iflgb);
    bnd = *hpbnd;

/* Print a heading. */

    if (lun >= 0) {
	if (rf < 0.f) {
	    io___502.ciunit = lun;
	    s_wsfe(&io___502);
	    do_fio(&c__1, (char *)&(*n1), (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&(*n2), (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&bnd, (ftnlen)sizeof(real));
	    e_wsfe();
	}
	if (rf > 0.f) {
	    io___503.ciunit = lun;
	    s_wsfe(&io___503);
	    do_fio(&c__1, (char *)&(*n1), (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&(*n2), (ftnlen)sizeof(integer));
	    do_fio(&c__1, (char *)&bnd, (ftnlen)sizeof(real));
	    e_wsfe();
	}
    }

/* Test for errors and store local parameters. */

    *ier = -1;
/* Computing MAX */
    i__1 = max(*n1,*n2);
    if (min(*n1,*n2) < 1 || *n1 == *n2 || max(i__1,3) > *n || dabs(rf) != 1.f)
	     {
	goto L10;
    }
    *ier = -2;
    if (*iflgs > 0) {

/*   Set LP1 and LP2 to the pointers to N2 as a neighbor of */
/*     N1 and N1 as a neighbor of N2, respectively. */

	lpl = lend[*n1];
	lp1 = lptr[lpl];
L1:
	if (list[lp1] == *n2) {
	    goto L2;
	}
	lp1 = lptr[lp1];
	if (lp1 != lpl) {
	    goto L1;
	}
	if ((i__1 = list[lp1], abs(i__1)) != *n2) {
	    goto L10;
	}

L2:
	lpl = lend[*n2];
	lp2 = lptr[lpl];
L3:
	if (list[lp2] == *n1) {
	    goto L4;
	}
	lp2 = lptr[lp2];
	if (lp2 != lpl) {
	    goto L3;
	}
	if ((i__1 = list[lp2], abs(i__1)) != *n1) {
	    goto L10;
	}
    }

/* Test for arc length DT = SQRT(DX**2+DY**2) = 0. */

L4:
    dx = x[*n2] - x[*n1];
    dy = y[*n2] - y[*n1];
    if (dx == 0.f && dy == 0.f) {
	goto L10;
    }

/* Compute first difference S and scaled directional deriva- */
/*   tives S1,S2 at the endpoints (for the direction N1->N2). */

    s = h[*n2] - h[*n1];
    s1 = hxhy[(*n1 << 1) + 1] * dx + hxhy[(*n1 << 1) + 2] * dy;
    s2 = hxhy[(*n2 << 1) + 1] * dx + hxhy[(*n2 << 1) + 2] * dy;

/* Test for a valid constraint. */

    *ier = -3;
/* Computing MIN */
    r__1 = min(s1,s2);
/* Computing MAX */
    r__2 = max(s1,s2);
    if (rf < 0.f && dmin(r__1,s) < bnd || rf > 0.f && bnd < dmax(r__2,s)) {
	goto L10;
    }

/* Test for infinite tension required. */

    *ier = 1;
    sig = sbig;
    if (s == bnd && (s1 != s || s2 != s)) {
	goto L9;
    }

/* Test for SIG = 0 sufficient.  The Hermite cubic interpo- */
/*   lant H0 has derivative HP0(T) = (S2 + 2*B0*R + A0*R**2)/ */
/*   DT, where R = (T2-T)/DT. */

    *ier = 0;
    sig = 0.f;
    t0 = s * 3.f - s1 - s2;
    b0 = t0 - s2;
    c0 = t0 - s1;
    a0 = -(doublereal)b0 - c0;

/*   HP0(R) has an extremum (at R = -B0/A0) in (0,1) iff */
/*     B0*C0 > 0 and the third derivative of H0 has the */
/*     sign of A0. */

    if (b0 * c0 <= 0.f || a0 * rf > 0.f) {
	goto L9;
    }

/*   A0*RF < 0 and HP0(R) = -D0/(DT*A0) at R = -B0/A0. */

    dt = sqrt(dx * dx + dy * dy);
    d0 = t0 * t0 - s1 * s2;
    f0 = (bnd + d0 / (a0 * dt)) * rf;
    if (f0 >= 0.f) {
	goto L9;
    }

/* Find a zero of F(SIG) = (BND-HP(R))*RF, where HP has an */
/*   extremum at R.  F has a unique zero, F(0) = F0 < 0, and */
/*   F = (BND-S)*RF > 0 for SIG sufficiently large. */

/* Initialize parameters for the secant method.  The method */
/*   uses three points:  (SG0,F0), (SIG,F), and (SNEG,FNEG), */
/*   where SG0 and SNEG are defined implicitly by DSIG = SIG */
/*   - SG0 and DMAX = SIG - SNEG.  SG0 is initially zero and */
/*   SIG is initialized to the zero of (BND - (SIG*S-S1-S2)/ */
/*   (DT*(SIG-2.)))*RF -- a value for which F(SIG) .GE. 0 and */
/*   F(SIG) = 0 for SIG sufficiently large that 2*SIG is in- */
/*   significant relative to exp(SIG). */

    fmax = (bnd - s / dt) * rf;
    sig = 2.f - a0 / ((dt * bnd - s) * 3.f);
    if (lun >= 0) {
	io___521.ciunit = lun;
	s_wsfe(&io___521);
	do_fio(&c__1, (char *)&f0, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&fmax, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&sig, (ftnlen)sizeof(real));
	e_wsfe();
    }
    r__1 = sig * exp(-(doublereal)sig) + .5f;
    if (store_(&r__1) == .5f) {
	goto L9;
    }
    dsig = sig;
    dmax_ = sig * -2.f;
    fneg = fmax;
    d1 = s - s1;
    d2 = s2 - s;
    d1pd2 = d1 + d2;
    nit = 0;

/* Compute an absolute tolerance FTOL = abs(TOL), and a */
/*   relative tolerance RTOL = 100*Macheps. */

    ftol = dabs(*tol);
    rtol = 1.f;
L5:
    rtol /= 2.f;
    r__1 = rtol + 1.f;
    if (store_(&r__1) > 1.f) {
	goto L5;
    }
    rtol *= 200.f;

/* Top of loop:  compute F. */

L6:
    if (sig <= .5f) {

/*   Use approximations designed to avoid cancellation */
/*     error (associated with small SIG) in the modified */
/*     hyperbolic functions. */

	snhcsh_752(&sig, &sinhm, &coshm, &coshmm);
	c1 = sig * coshm * d2 - sinhm * d1pd2;
	c2 = sig * (sinhm + sig) * d2 - coshm * d1pd2;
	a = c2 - c1;
	e = sig * sinhm - coshmm - coshmm;
    } else {

/*   Scale SINHM and COSHM by 2*exp(-SIG) in order to avoid */
/*     overflow. */

	ems = exp(-(doublereal)sig);
	ems2 = ems + ems;
	tm = 1.f - ems;
	sinh_ = tm * (ems + 1.f);
	sinhm = sinh_ - sig * ems2;
	coshm = tm * tm;
	c1 = sig * coshm * d2 - sinhm * d1pd2;
	c2 = sig * sinh_ * d2 - coshm * d1pd2;
	a = ems2 * (sig * tm * d2 + (tm - sig) * d1pd2);
	e = sig * sinh_ - coshm - coshm;
    }

/*   The second derivative HPP of H(R) has a zero at exp(SIG* */
/*     R) = SQRT((C2+C1)/A) and R is in (0,1) and well- */
/*     defined iff HPP(T1)*HPP(T2) < 0. */

    f = fmax;
    t1 = a * (c2 + c1);
    if (t1 >= 0.f) {
	if (c1 * (sig * coshm * d1 - sinhm * d1pd2) < 0.f) {

/*   HP(R) = (B+SIGN(A)*SQRT(A*C))/(DT*E) at the critical */
/*     value of R, where A = C2-C1, B = E*S2-C2, and C = C2 + */
/*     C1.  Note that RF*A < 0. */

	    f = (bnd - (e * s2 - c2 - rf * sqrt(t1)) / (dt * e)) * rf;
	}
    }

/*   Update the number of iterations NIT. */

    ++nit;
    if (lun >= 0) {
	io___544.ciunit = lun;
	s_wsfe(&io___544);
	do_fio(&c__1, (char *)&nit, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&sig, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&f, (ftnlen)sizeof(real));
	e_wsfe();
    }
    if (f0 * f < 0.f) {

/*   F0*F < 0.  Update (SNEG,FNEG) to (SG0,F0) so that F */
/*     and FNEG always have opposite signs.  If SIG is closer */
/*     to SNEG than SG0 and abs(F) < abs(FNEG), then swap */
/*     (SNEG,FNEG) with (SG0,F0). */

	t1 = dmax_;
	t2 = fneg;
	dmax_ = dsig;
	fneg = f0;
	if (dabs(dsig) > dabs(t1) && dabs(f) < dabs(t2)) {

	    dsig = t1;
	    f0 = t2;
	}
    }

/*   Test for convergence. */

    stol = rtol * sig;
    if (dabs(dmax_) <= stol || f >= 0.f && f <= ftol || dabs(f) <= rtol) {
	goto L9;
    }
    if (f0 * f < 0.f || dabs(f) < dabs(f0)) {
	goto L8;
    }

/*   F*F0 > 0 and the new estimate would be outside of the */
/*     bracketing interval of length abs(DMAX).  Reset */
/*     (SG0,F0) to (SNEG,FNEG). */

L7:
    dsig = dmax_;
    f0 = fneg;

/*   Compute the change in SIG by linear interpolation */
/*     between (SG0,F0) and (SIG,F). */

L8:
    dsig = -(doublereal)f * dsig / (f - f0);
    if (lun >= 0) {
	io___547.ciunit = lun;
	s_wsfe(&io___547);
	do_fio(&c__1, (char *)&dsig, (ftnlen)sizeof(real));
	e_wsfe();
    }
    if (dabs(dsig) > dabs(dmax_) || dsig * dmax_ > 0.f) {
	goto L7;
    }

/*   Restrict the step-size such that abs(DSIG) .GE. STOL/2. */
/*     Note that DSIG and DMAX have opposite signs. */

    if (dabs(dsig) < stol / 2.f) {
	r__1 = stol / 2.f;
	dsig = -(doublereal)r_sign(&r__1, &dmax_);
    }

/*   Bottom of loop:  update SIG, DMAX, and F0. */

    sig += dsig;
    dmax_ += dsig;
    f0 = f;
    goto L6;

/* No errors encountered. */

L9:
    ret_val = sig;
    if (*iflgs <= 0) {
	return ret_val;
    }
    sigma[lp1] = sig;
    sigma[lp2] = sig;
    return ret_val;

/* Error termination. */

L10:
    ret_val = -1.f;
    return ret_val;
} /* sig1_752 */

doublereal sig2_752(integer *n1, integer *n2, integer *n, real *x, real *y, real 
	*h, integer *list, integer *lptr, integer *lend, real *hxhy, real *
	tol, integer *iflgs, real *sigma, integer *ier)
{
    /* Initialized data */

    static real sbig = 85.f;
    static integer lun = -1;

    /* Format strings */
    static char fmt_100[] = "(//1x,\002SIG2 -- N1 =\002,i4,\002, N2 =\002,i4)"
	    ;
    static char fmt_110[] = "(1x,3x,i2,\002 -- SIG = \002,e15.8,\002, F ="
	    " \002,e15.8/1x,31x,\002FP = \002,e15.8)";

    /* System generated locals */
    integer i__1;
    real ret_val, r__1, r__2;

    /* Builtin functions */
    integer s_wsfe(cilist *), do_fio(integer *, char *, ftnlen), e_wsfe(void);
    double sqrt(doublereal), exp(doublereal);

    /* Local variables */
    real dsig, ftol, rtol, f, s, t, coshm, sinhm, d1, d2, dummy;
    extern doublereal store_(real *);
    real t1, fp, dx, dy;
    extern /* Subroutine */ int snhcsh_752(real *, real *, real *, real *);
    integer lp1, lp2;
    real tp1, d1d2, sig, ems;
    integer lpl, nit;
    real ssm;

    /* Fortran I/O blocks */
    static cilist io___550 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___574 = { 0, 0, 0, fmt_110, 0 };



/* *********************************************************** */
/*                      range. */
/*             IER = -2 if nodes N1 and N2 coincide or IFLGS */
/*                      .GE. 1 and the nodes are not adja- */
/*                      cent. */

/*       SIG2 = Minimum tension factor defined above unless */
/*              IER < 0, in which case SIG2 = -1.  If IER */
/*              = 1, SIG2 is set to 85, resulting in an */
/*              approximation to the linear interpolant of */
/*              the endpoint values.  If IER = 2, SIG2 = 0, */
/*              resulting in the Hermite cubic interpolant. */

/* TRIPACK module required by SIG2:  STORE */

/* SRFPACK module required by SIG2:  SNHCSH */

/* Intrinsic functions called by SIG2:  ABS, EXP, MAX, MIN, */
/*                                        SQRT */

/* *********************************************************** */

    /* Parameter adjustments */
    --sigma;
    hxhy -= 3;
    --lend;
    --lptr;
    --list;
    --h;
    --y;
    --x;

    /* Function Body */

/* Print a heading. */

    if (lun >= 0) {
	io___550.ciunit = lun;
	s_wsfe(&io___550);
	do_fio(&c__1, (char *)&(*n1), (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&(*n2), (ftnlen)sizeof(integer));
	e_wsfe();
    }

/* Test for errors and store local parameters. */

    *ier = -1;
/* Computing MAX */
    i__1 = max(*n1,*n2);
    if (min(*n1,*n2) < 1 || *n1 == *n2 || max(i__1,3) > *n) {
	goto L8;
    }
    *ier = -2;
    if (*iflgs > 0) {

/*   Set LP1 and LP2 to the pointers to N2 as a neighbor of */
/*     N1 and N1 as a neighbor of N2, respectively. */

	lpl = lend[*n1];
	lp1 = lptr[lpl];
L1:
	if (list[lp1] == *n2) {
	    goto L2;
	}
	lp1 = lptr[lp1];
	if (lp1 != lpl) {
	    goto L1;
	}
	if ((i__1 = list[lp1], abs(i__1)) != *n2) {
	    goto L8;
	}

L2:
	lpl = lend[*n2];
	lp2 = lptr[lpl];
L3:
	if (list[lp2] == *n1) {
	    goto L4;
	}
	lp2 = lptr[lp2];
	if (lp2 != lpl) {
	    goto L3;
	}
	if ((i__1 = list[lp2], abs(i__1)) != *n1) {
	    goto L8;
	}
    }

/* Test for arc length DT = SQRT(DX**2+DY**2) = 0. */

L4:
    dx = x[*n2] - x[*n1];
    dy = y[*n2] - y[*n1];
    if (dx == 0.f && dy == 0.f) {
	goto L8;
    }

/* Compute first and second differences and test for infinite */
/*   tension required. */

    s = h[*n2] - h[*n1];
    d1 = s - hxhy[(*n1 << 1) + 1] * dx - hxhy[(*n1 << 1) + 2] * dy;
    d2 = hxhy[(*n2 << 1) + 1] * dx + hxhy[(*n2 << 1) + 2] * dy - s;
    d1d2 = d1 * d2;
    *ier = 1;
    sig = sbig;
    if (d1d2 == 0.f && d1 != d2) {
	goto L7;
    }

/* Test for a valid constraint. */

    *ier = 2;
    sig = 0.f;
    if (d1d2 < 0.f) {
	goto L7;
    }

/* Test for SIG = 0 sufficient. */

    *ier = 0;
    if (d1d2 == 0.f) {
	goto L7;
    }
/* Computing MAX */
    r__1 = d1 / d2, r__2 = d2 / d1;
    t = dmax(r__1,r__2);
    if (t <= 2.f) {
	goto L7;
    }

/* Find a zero of F(SIG) = SIG*COSHM(SIG)/SINHM(SIG) - (T+1). */
/*   Since the derivative of F vanishes at the origin, a */
/*   quadratic approximation is used to obtain an initial */
/*   estimate for the Newton method. */

    tp1 = t + 1.f;
    sig = sqrt(t * 10.f - 20.f);
    nit = 0;

/*   Compute an absolute tolerance FTOL = abs(TOL) and a */
/*     relative tolerance RTOL = 100*Macheps. */

    ftol = dabs(*tol);
    rtol = 1.f;
L5:
    rtol /= 2.f;
    r__1 = rtol + 1.f;
    if (store_(&r__1) > 1.f) {
	goto L5;
    }
    rtol *= 200.f;

/* Top of loop:  evaluate F and its derivative FP. */

L6:
    if (sig <= .5f) {

/*   Use approximations designed to avoid cancellation error */
/*     in the hyperbolic functions. */

	snhcsh_752(&sig, &sinhm, &coshm, &dummy);
	t1 = coshm / sinhm;
	fp = t1 + sig * (sig / sinhm - t1 * t1 + 1.f);
    } else {

/*   Scale SINHM and COSHM by 2*exp(-SIG) in order to avoid */
/*     overflow. */

	ems = exp(-(doublereal)sig);
	ssm = 1.f - ems * (ems + sig + sig);
	t1 = (1.f - ems) * (1.f - ems) / ssm;
	fp = t1 + sig * (sig * 2.f * ems / ssm - t1 * t1 + 1.f);
    }

    f = sig * t1 - tp1;

/*   Update the number of iterations NIT. */

    ++nit;
    if (lun >= 0) {
	io___574.ciunit = lun;
	s_wsfe(&io___574);
	do_fio(&c__1, (char *)&nit, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&sig, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&f, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&fp, (ftnlen)sizeof(real));
	e_wsfe();
    }

/*   Test for convergence. */

    if (fp <= 0.f) {
	goto L7;
    }
    dsig = -(doublereal)f / fp;
    if (dabs(dsig) <= rtol * sig || f >= 0.f && f <= ftol || dabs(f) <= rtol) 
	    {
	goto L7;
    }

/*   Bottom of loop:  update SIG. */

    sig += dsig;
    goto L6;

/* No errors encountered. */

L7:
    ret_val = sig;
    if (*iflgs <= 0) {
	return ret_val;
    }
    sigma[lp1] = sig;
    sigma[lp2] = sig;
    return ret_val;

/* Error termination. */

L8:
    ret_val = -1.f;
    return ret_val;
} /* sig2_752 */

/* Subroutine */ int smsgs_752(integer *ncc, integer *lcc, integer *n, real *x, 
	real *y, real *z, integer *list, integer *lptr, integer *lend, 
	integer *iflgs, real *sigma, real *w, real *p, integer *nit, real *
	dfmax, real *f, real *fxfy, integer *ier)
{
    /* System generated locals */
    integer i__1, i__2;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    integer kbak;
    real dcub, dfmx;
    integer kfor, lplj, iter;
    real dxdy, trmx, trmy;
    integer i, j, k;
    real t;
    integer ilast, itmax, ifrst;
    real r1, r2, r3, t1, t2, t3, c11, c12, c13, c22, c23, c33, df;
    integer nb;
    real fk;
    integer lp, nn;
    real dx, dy, pp, xk, yk;
    extern /* Subroutine */ int grcoef_752(real *, real *, real *, real *);
    real rr2, rr3, cc22, cc23, cc33;
    integer ifl;
    real det, dfx, dfy, sig;
    integer lpj, lpl;
    real dsq, fxj, fxk, fyj, fyk, dxs, dys, tol;
    integer lcc1;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   08/26/91 */

/*   This subroutine employs the block Gauss-Seidel method */
/* (3 by 3 blocks) to solve the order 3N symmetric positive */
/* definite linear system associated with minimizing the */
/* quadratic functional Q(F,FX,FY) described in Subroutine */
/* SMSURF. */

/*   Note that small relative changes in F can cause large */
/* relative changes in FX and FY, resulting in an ill- */
/* conditioned system.  However, good F values should be */
/* achieved with a small number of iterations, and the */
/* gradients (with fixed F) can then be improved by a call */
/* to Subroutine GRADG. */

/* On input: */

/*   NCC,LCC,N,X,Y,Z,LIST,LPTR,LEND,IFLGS,SIGMA,W = */
/* Parameters defined in Subroutine SMSURF. */

/*       P = Positive smoothing parameter defining Q. */

/* The above parameters are not altered by this routine. */

/*       NIT = Maximum number of Gauss-Seidel iterations to */
/*             be employed.  This maximum will likely be */
/*             achieved if DFMAX is smaller than the machine */
/*             precision.  NIT .GE. 0. */

/*       DFMAX = Nonnegative convergence criterion.  The */
/*               method is terminated when the maximum */
/*               change in a solution F-component between */
/*               iterations is at most DFMAX.  The change in */
/*               a component is taken to be the absolute */
/*               difference relative to 1 plus the old value. */

/*       F = Initial estimate of the first N solution compo- */
/*           nents. */

/*       FXFY = 2 by N array containing initial estimates of */
/*              the last 2N solution components. */

/* On output: */

/*       NIT = Number of Gauss-Seidel iterations employed. */

/*       DFMAX = Maximum relative change in a solution F- */
/*               component at the last iteration. */

/*       F = First N solution components -- function values */
/*           at the nodes. */

/*       FXFY = Last 2N solution components -- gradients at */
/*              the nodes with X partials in the first row. */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered and the */
/*                     convergence criterion was achieved. */
/*             IER = 1 if no errors were encountered but con- */
/*                     vergence was not achieved within NIT */
/*                     iterations. */
/*             IER = -1 if NCC, N, P, NIT, or DFMAX is out- */
/*                      side its valid range on input.  F */
/*                      and FXFY are not altered in this */
/*                      case.  LCC is not tested for valid- */
/*                      ity. */
/*             IER = -2 if all nodes are collinear or the */
/*                      triangulation data structure is not */
/*                      valid. */
/*             IER = -3 if duplicate nodes were encountered. */

/* SRFPACK modules required by SMSGS:  GRCOEF, SNHCSH */

/* Intrinsic functions called by SMSGS:  ABS, MAX, SQRT */

/* *********************************************************** */


    /* Parameter adjustments */
    fxfy -= 3;
    --f;
    --w;
    --sigma;
    --lend;
    --lptr;
    --list;
    --z;
    --y;
    --x;
    --lcc;

    /* Function Body */
    nn = *n;
    ifl = *iflgs;
    pp = *p;
    itmax = *nit;
    tol = *dfmax;
    if (*ncc == 0) {
	lcc1 = nn + 1;
    } else {
	lcc1 = lcc[1];
    }

/* Test for errors in input and initialize the iteration */
/*   count ITER, tension factor SIG, and output value of */
/*   DFMAX. */

    if (*ncc < 0 || nn < 3 || pp <= 0.f || itmax < 0 || tol < 0.f) {
	goto L8;
    }
    iter = 0;
    sig = sigma[1];
    dfmx = 0.f;

/* Top of iteration loop:  If K is a constraint node, I */
/*   indexes the constraint containing node K, IFRST and */
/*   ILAST are the first and last nodes of constraint I, */
/*   and (KBAK,K,KFOR) is a subsequence of constraint I. */

L1:
    if (iter == itmax) {
	goto L7;
    }
    dfmx = 0.f;
    i = 0;
    ilast = lcc1 - 1;
    kbak = 0;
    kfor = 0;

/*   Loop on nodes. */

    i__1 = nn;
    for (k = 1; k <= i__1; ++k) {
	if (k >= lcc1) {
	    if (k > ilast) {
		++i;
		ifrst = k;
		if (i < *ncc) {
		    ilast = lcc[i + 1] - 1;
		} else {
		    ilast = nn;
		}
		kbak = ilast;
		kfor = k + 1;
	    } else {
		kbak = k - 1;
		if (k < ilast) {
		    kfor = k + 1;
		} else {
		    kfor = ifrst;
		}
	    }
	}
	xk = x[k];
	yk = y[k];
	fk = f[k];
	fxk = fxfy[(k << 1) + 1];
	fyk = fxfy[(k << 1) + 2];

/*   Initialize components of the order 3 system for the */
/*     change (DF,DFX,DFY) in the K-th solution components */
/*     (symmetric matrix in C and residual in R). */

	c11 = pp * w[k];
	c12 = 0.f;
	c13 = 0.f;
	c22 = 0.f;
	c23 = 0.f;
	c33 = 0.f;
	r1 = c11 * (z[k] - fk);
	r2 = 0.f;
	r3 = 0.f;

/*   Loop on neighbors J of node K. */

	lpl = lend[k];
	lpj = lpl;
L2:
	lpj = lptr[lpj];
	j = (i__2 = list[lpj], abs(i__2));

/*   Arc K-J lies in a constraint region and is bypassed iff */
/*     K and J are nodes in the same constraint and J follows */
/*     KFOR and precedes KBAK as a neighbor of K.  Also, K-J */
/*     is bypassed if it is both a constraint arc and a */
/*     boundary arc of the triangulation. */

	if (k < lcc1 || j < ifrst || j > ilast) {
	    goto L4;
	}
	if (j == kbak || j == kfor) {
	    lplj = lend[j];
	    if (list[lpl] == -j || list[lplj] == -k) {
		goto L5;
	    } else {
		goto L4;
	    }
	}
	lp = lpj;

L3:
	lp = lptr[lp];
	nb = (i__2 = list[lp], abs(i__2));
	if (nb == kbak) {
	    goto L5;
	}
	if (nb != kfor) {
	    goto L3;
	}

/*   Compute parameters associated with edge K->J, and test */
/*     for duplicate nodes. */

L4:
	dx = x[j] - xk;
	dy = y[j] - yk;
	dxs = dx * dx;
	dxdy = dx * dy;
	dys = dy * dy;
	dsq = dxs + dys;
	dcub = dsq * sqrt(dsq);
	if (dcub == 0.f) {
	    goto L10;
	}
	if (ifl >= 1) {
	    sig = sigma[lpj];
	}
	grcoef_752(&sig, &dcub, &t3, &t2);
	t1 = t2 + t3;

/*   T1 = SIG*SIG*COSHM/(DCUB*E), T2 = SIG*SINHM/(DCUB*E), */
/*     and T3 = SIG*(SIG*COSHM-SINHM)/(DCUB*E) for E = */
/*     SIG*SINH - 2*COSHM. */

	t = t1 * (fk - f[j]);
	fxj = fxfy[(j << 1) + 1];
	fyj = fxfy[(j << 1) + 2];

/*   Update the system components for node J. */

	c11 = c11 + t1 + t1;
	c12 += t1 * dx;
	c13 += t1 * dy;
	c22 += t3 * dxs;
	c23 += t3 * dxdy;
	c33 += t3 * dys;
	r1 = r1 - t - t - t1 * (dx * (fxk + fxj) + dy * (fyk + fyj));
	trmx = t3 * fxk + t2 * fxj;
	trmy = t3 * fyk + t2 * fyj;
	r2 = r2 - t * dx - trmx * dxs - trmy * dxdy;
	r3 = r3 - t * dy - trmx * dxdy - trmy * dys;

/*   Bottom of loop on neighbors. */

L5:
	if (lpj != lpl) {
	    goto L2;
	}

/*   Solve the system associated with the K-th block. */

	cc22 = c11 * c22 - c12 * c12;
	cc23 = c11 * c23 - c12 * c13;
	cc33 = c11 * c33 - c13 * c13;
	rr2 = c11 * r2 - c12 * r1;
	rr3 = c11 * r3 - c13 * r1;
	det = cc22 * cc33 - cc23 * cc23;
	if (det == 0.f || cc22 == 0.f || c11 == 0.f) {
	    goto L9;
	}
	dfy = (cc22 * rr3 - cc23 * rr2) / det;
	dfx = (rr2 - cc23 * dfy) / cc22;
	df = (r1 - c12 * dfx - c13 * dfy) / c11;

/*   Update the solution components for node K and the */
/*     maximum relative change in F. */

	f[k] = fk + df;
	fxfy[(k << 1) + 1] = fxk + dfx;
	fxfy[(k << 1) + 2] = fyk + dfy;
/* Computing MAX */
	r__1 = dfmx, r__2 = dabs(df) / (dabs(fk) + 1.f);
	dfmx = dmax(r__1,r__2);
/* L6: */
    }

/*   Increment ITER and test for convergence. */

    ++iter;
    if (dfmx > tol) {
	goto L1;
    }

/* Method converged. */

    *nit = iter;
    *dfmax = dfmx;
    *ier = 0;
    return 0;

/* Method failed to converge within NIT iterations. */

L7:
    *dfmax = dfmx;
    *ier = 1;
    return 0;

/* Invalid input parameter. */

L8:
    *nit = 0;
    *dfmax = 0.f;
    *ier = -1;
    return 0;

/* Node K and its neighbors are collinear, resulting in a */
/*   singular system. */

L9:
    *nit = 0;
    *dfmax = dfmx;
    *ier = -2;
    return 0;

/* Nodes J and K coincide. */

L10:
    *nit = 0;
    *dfmax = dfmx;
    *ier = -3;
    return 0;
} /* smsgs_752 */

/* Subroutine */ int smsurf_752(integer *ncc, integer *lcc, integer *n, real *x, 
	real *y, real *z, integer *list, integer *lptr, integer *lend, 
	integer *iflgs, real *sigma, real *w, real *sm, real *smtol, real *
	gstol, real *f, real *fxfy, integer *ier)
{
    /* Initialized data */

    static integer nitmax = 40;
    static integer lun = -1;

    /* Format strings */
    static char fmt_100[] = "(///1x,\002SMSURF:  The constraint is not \002"
	    ",\002active and the surface is linear.\002/)";
    static char fmt_110[] = "(///1x,\002SMSURF -- SM = \002,e10.4,\002, GSTO"
	    "L = \002,e7.1,\002, NITMAX = \002,i2,\002, G(0) = \002,e15.8)";
    static char fmt_120[] = "(/1x,i2,\002 -- P = \002,e15.8,\002, G = \002,e"
	    "15.8,\002, NIT = \002,i2,\002, DFMAX = \002,e12.6)";
    static char fmt_130[] = "(1x,5x,\002DP = \002,e15.8)";

    /* System generated locals */
    integer i__1;
    real r__1;

    /* Builtin functions */
    integer s_wsfe(cilist *), e_wsfe(void);
    double sqrt(doublereal);
    integer do_fio(integer *, char *, ftnlen);

    /* Local variables */
    real gneg, dmax_;
    integer ierr, iter;
    real wixi, wiyi, wizi, q2min, q2max, g;
    integer i;
    real p, s, dfmax, f0, g0;
    extern /* Subroutine */ int smsgs_752(integer *, integer *, integer *, real *
	    , real *, real *, integer *, integer *, integer *, integer *, 
	    real *, real *, real *, integer *, real *, real *, real *, 
	    integer *);
    real q2, r1, r2, r3;
    integer lccip1;
    real c11, c12, c13, c22, c23, c33, dp;
    integer nn;
    real fx, fy, wi, xi, yi, rr2, rr3, cc22, cc23, cc33, det;
    integer nit;
    real tol;

    /* Fortran I/O blocks */
    static cilist io___668 = { 0, 0, 0, fmt_100, 0 };
    static cilist io___671 = { 0, 0, 0, fmt_110, 0 };
    static cilist io___680 = { 0, 0, 0, fmt_120, 0 };
    static cilist io___682 = { 0, 0, 0, fmt_130, 0 };



/* *********************************************************** */
/*           standard deviation associated with Z(I).  DZ**2 */
/*           is the expected value of the squared error in */
/*           the measurement of Z(I).  (The mean error is */
/*           assumed to be zero.) */

/*       SM = Positive parameter specifying an upper bound on */
/*            Q2(F).  Note that F(X,Y) is linear (and Q2(F) */
/*            is minimized) if SM is sufficiently large that */
/*            the constraint is not active.  It is recommend- */
/*            ed that SM satisfy N-SQRT(2N) .LE. SM .LE. N+ */
/*            SQRT(2N). */

/*       SMTOL = Parameter in the open interval (0,1) speci- */
/*               fying the relative error allowed in satisfy- */
/*               ing the constraint -- the constraint is */
/*               assumed to be satisfied if SM*(1-SMTOL) .LE. */
/*               Q2 .LE. SM*(1+SMTOL).  A reasonable value */
/*               for SMTOL is SQRT(2/N). */

/*       GSTOL = Nonnegative tolerance defining the conver- */
/*               gence criterion for the Gauss-Seidel method. */
/*               Refer to parameter DFMAX in Subroutine */
/*               SMSGS.  A recommended value is .05*DU**2, */
/*               where DU is an average standard deviation */
/*               in the data values. */

/* Input parameters are not altered by this routine. */

/* On output: */

/*       F = Array of length N containing nodal function val- */
/*           ues unless IER < 0. */

/*       FXFY = 2 by N array whose columns contain partial */
/*              derivatives of F at the nodes unless IER < 0, */
/*              with FX in the first row, FY in the second. */

/*       IER = Error indicator and information flag: */
/*             IER = 0 if no errors were encountered and the */
/*                     constraint is active -- Q2(F) is ap- */
/*                     proximately equal to SM. */
/*             IER = 1 if no errors were encountered but the */
/*                     constraint is not active -- F, FX, and */
/*                     FY are the values and partials of a */
/*                     linear function which minimizes Q2(F), */
/*                     and Q1 = 0. */
/*             IER = -1 if NCC, an LCC entry, N, W, SM, */
/*                      SMTOL, or GSTOL is outside its */
/*                      valid range on input. */
/*             IER = -2 if all nodes are collinear or the */
/*                      triangulation data structure is not */
/*                      valid. */
/*             IER = -3 if duplicate nodes were encountered. */

/* SRFPACK modules required by SMSURF:  GRCOEF, SMSGS, SNHCSH */

/* Intrinsic functions called by SMSURF:  ABS, SQRT */

/* *********************************************************** */


    /* Parameter adjustments */
    fxfy -= 3;
    --f;
    --w;
    --sigma;
    --lend;
    --lptr;
    --list;
    --z;
    --y;
    --x;
    --lcc;

    /* Function Body */

/* LUN = Logical unit on which diagnostic messages are print- */
/*       ed (unless LUN < 0).  For each secant iteration, the */
/*       following values are printed:  P, G(P), NIT, DFMAX, */
/*       and DP, where NIT denotes the number of Gauss-Seidel */
/*       iterations used in the computation of G, DFMAX de- */
/*       notes the maximum relative change in a solution */
/*       component in the last Gauss-Seidel iteration, and */
/*       DP is the change in P computed by linear interpola- */
/*       tion between the current point (P,G) and a previous */
/*       point. */

    nn = *n;
    tol = *gstol;

/* Test for errors in input parameters. */

    *ier = -1;
    if (*ncc < 0 || *sm <= 0.f || *smtol <= 0.f || *smtol >= 1.f || tol <= 
	    0.f) {
	return 0;
    }
    if (*ncc == 0) {
	if (nn < 3) {
	    return 0;
	}
    } else {
	lccip1 = nn + 1;
	for (i = *ncc; i >= 1; --i) {
	    if (lccip1 - lcc[i] < 3) {
		return 0;
	    }
	    lccip1 = lcc[i];
/* L1: */
	}
	if (lccip1 < 1) {
	    return 0;
	}
    }

/* Compute the components of the 3 by 3 system (normal */
/*   equations) for the weighted least squares linear fit. */

    c11 = 0.f;
    c12 = 0.f;
    c13 = 0.f;
    c22 = 0.f;
    c23 = 0.f;
    c33 = 0.f;
    r1 = 0.f;
    r2 = 0.f;
    r3 = 0.f;
    i__1 = nn;
    for (i = 1; i <= i__1; ++i) {
	wi = w[i];
	if (wi <= 0.f) {
	    return 0;
	}
	xi = x[i];
	yi = y[i];
	wixi = wi * xi;
	wiyi = wi * yi;
	wizi = wi * z[i];
	c11 += wixi * xi;
	c12 += wixi * yi;
	c13 += wixi;
	c22 += wiyi * yi;
	c23 += wiyi;
	c33 += wi;
	r1 += wizi * xi;
	r2 += wizi * yi;
	r3 += wizi;
/* L2: */
    }

/* Solve the system for (FX,FY,F0) where (FX,FY) is the */
/*   gradient (constant) and F0 = F(0,0). */

    cc22 = c11 * c22 - c12 * c12;
    cc23 = c11 * c23 - c12 * c13;
    cc33 = c11 * c33 - c13 * c13;
    rr2 = c11 * r2 - c12 * r1;
    rr3 = c11 * r3 - c13 * r1;
    det = cc22 * cc33 - cc23 * cc23;
    *ier = -2;
    if (det == 0.f || cc22 == 0.f || c11 == 0.f) {
	return 0;
    }
    f0 = (cc22 * rr3 - cc23 * rr2) / det;
    fy = (rr2 - cc23 * f0) / cc22;
    fx = (r1 - c12 * fy - c13 * f0) / c11;

/* Compute nodal values and gradients, and accumulate Q2 = */
/*   (Z-F)**T*W*(Z-F). */

    q2 = 0.f;
    i__1 = nn;
    for (i = 1; i <= i__1; ++i) {
	f[i] = fx * x[i] + fy * y[i] + f0;
	fxfy[(i << 1) + 1] = fx;
	fxfy[(i << 1) + 2] = fy;
/* Computing 2nd power */
	r__1 = z[i] - f[i];
	q2 += w[i] * (r__1 * r__1);
/* L3: */
    }

/* Compute bounds on Q2 defined by SMTOL, and test for the */
/*   constraint satisfied by the linear fit. */

    q2min = *sm * (1.f - *smtol);
    q2max = *sm * (*smtol + 1.f);
    if (q2 <= q2max) {

/*   The constraint is satisfied by a planar surface. */

	*ier = 1;
	if (lun >= 0) {
	    io___668.ciunit = lun;
	    s_wsfe(&io___668);
	    e_wsfe();
	}
	return 0;
    }

/* Compute G0 = G(0) and print a heading. */

    *ier = 0;
    s = 1.f / sqrt(*sm);
    g0 = 1.f / sqrt(q2) - s;
    if (lun >= 0) {
	io___671.ciunit = lun;
	s_wsfe(&io___671);
	do_fio(&c__1, (char *)&(*sm), (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&tol, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&nitmax, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&g0, (ftnlen)sizeof(real));
	e_wsfe();
    }

/* G(P) is strictly increasing and concave, and G(0) < 0. */
/*   Initialize parameters for the secant method.  The method */
/*   uses three points:  (P0,G0), (P,G), and (PNEG,GNEG), */
/*   where P0 and PNEG are defined implicitly by DP = P - P0 */
/*   and DMAX = P - PNEG. */

    p = *sm * 10.f;
    dp = p;
    dmax_ = 0.f;
    iter = 0;

/* Top of loop -- compute G. */

L4:
    nit = nitmax;
    dfmax = tol;
    smsgs_752(ncc, &lcc[1], &nn, &x[1], &y[1], &z[1], &list[1], &lptr[1], &lend[
	    1], iflgs, &sigma[1], &w[1], &p, &nit, &dfmax, &f[1], &fxfy[3], &
	    ierr);
    if (ierr < 0) {
	*ier = ierr;
	return 0;
    }
    q2 = 0.f;
    i__1 = nn;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	r__1 = z[i] - f[i];
	q2 += w[i] * (r__1 * r__1);
/* L5: */
    }
    g = 1.f / sqrt(q2) - s;
    ++iter;
    if (lun >= 0) {
	io___680.ciunit = lun;
	s_wsfe(&io___680);
	do_fio(&c__1, (char *)&iter, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&p, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&g, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&nit, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&dfmax, (ftnlen)sizeof(real));
	e_wsfe();
    }

/*   Test for convergence. */

    if (g == g0 || q2min <= q2 && q2 <= q2max) {
	return 0;
    }
    if (dmax_ != 0.f || g > 0.f) {
	goto L6;
    }

/*   Increase P until G(P) > 0. */

    p *= 10.f;
    dp = p;
    goto L4;

/*   A bracketing interval [P0,P] has been found. */

L6:
    if (g0 * g <= 0.f) {

/*   G0*G < 0.  Update (PNEG,GNEG) to (P0,G0) so that G */
/*     and GNEG always have opposite signs. */

	dmax_ = dp;
	gneg = g0;
    }

/*   Compute the change in P by linear interpolation between */
/*     (P0,G0) and (P,G). */

L7:
    dp = -(doublereal)g * dp / (g - g0);
    if (lun >= 0) {
	io___682.ciunit = lun;
	s_wsfe(&io___682);
	do_fio(&c__1, (char *)&dp, (ftnlen)sizeof(real));
	e_wsfe();
    }
    if (dabs(dp) > dabs(dmax_)) {

/*   G0*G > 0 and the new estimate would be outside of the */
/*     bracketing interval of length abs(DMAX).  Reset */
/*     (P0,G0) to (PNEG,GNEG). */

	dp = dmax_;
	g0 = gneg;
	goto L7;
    }

/*   Bottom of loop -- update P, DMAX, and G0. */

    p += dp;
    dmax_ += dp;
    g0 = g;
    goto L4;
} /* smsurf_752 */

/* Subroutine */ int snhcsh_752(real *x, real *sinhm, real *coshm, real *coshmm)
{
    /* Initialized data */

    static real c1 = .1666666666659f;
    static real c2 = .008333333431546f;
    static real c3 = 1.984107350948e-4f;
    static real c4 = 2.768286868175e-6f;

    /* Builtin functions */
    double exp(doublereal);

    /* Local variables */
    real expx, f, ax, xc, xs, xsd2, xsd4;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   03/18/90 */

/*   This subroutine computes approximations to the modified */
/* hyperbolic functions defined below with relative error */
/* bounded by 4.7E-12 for a floating point number system with */
/* sufficient precision.  For IEEE standard single precision, */
/* the relative error is less than 1.E-5 for all x. */

/*   Note that the 13-digit constants in the data statements */
/* below may not be acceptable to all compilers. */

/* On input: */

/*       X = Point at which the functions are to be */
/*           evaluated. */

/* X is not altered by this routine. */

/* On output: */

/*       SINHM = sinh(X) - X. */

/*       COSHM = cosh(X) - 1. */

/*       COSHMM = cosh(X) - 1 - X*X/2. */

/* Modules required by SNHCSH:  None */

/* Intrinsic functions called by SNHCSH:  ABS, EXP */

/* *********************************************************** */


    ax = dabs(*x);
    xs = ax * ax;
    if (ax <= .5f) {

/* Approximations for small X: */

	xc = *x * xs;
	*sinhm = xc * (((c4 * xs + c3) * xs + c2) * xs + c1);
	xsd4 = xs * .25f;
	xsd2 = xsd4 + xsd4;
	f = (((c4 * xsd4 + c3) * xsd4 + c2) * xsd4 + c1) * xsd4;
	*coshmm = xsd2 * f * (f + 2.f);
	*coshm = *coshmm + xsd2;
    } else {

/* Approximations for large X: */

	expx = exp(ax);
	*sinhm = -(doublereal)(1.f / expx + ax + ax - expx) / 2.f;
	if (*x < 0.f) {
	    *sinhm = -(doublereal)(*sinhm);
	}
	*coshm = (1.f / expx - 2.f + expx) / 2.f;
	*coshmm = *coshm - xs / 2.f;
    }
    return 0;
} /* snhcsh_752 */

doublereal trvol_(real *x1, real *x2, real *x3, real *y1, real *y2, real *y3, 
	real *z1, real *z2, real *z3)
{
    /* System generated locals */
    real ret_val;

    /* Local variables */
    real area;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   09/01/88 */

/*   This function computes the integral over a triangle of */
/* the linear (planar) surface which interpolates data */
/* values at the vertices. */

/* On input: */

/*       X1,X2,X3 = X coordinates of the vertices of the tri- */
/*                  angle in counterclockwise order. */

/*       Y1,Y2,Y3 = Y coordinates of the vertices of the tri- */
/*                  angle in one-to-one correspondence with */
/*                  X1, X2, and X3. */

/*       Z1,Z2,Z3 = Data values at the vertices (X1,Y1), */
/*                  (X2,Y2), (X3,Y3), respectively. */

/* Input parameters are not altered by this function. */

/* On output: */

/*       TRVOL = Integral over the triangle of the linear */
/*               interpolant.  Note that TRVOL will have */
/*               the wrong sign if the vertices are speci- */
/*               fied in clockwise order. */

/* Modules required by TRVOL:  None */

/* *********************************************************** */


    area = (*x2 - *x1) * (*y3 - *y1) - (*x3 - *x1) * (*y2 - *y1);

/* AREA is twice the (signed) area of the triangle. */
/* TRVOL is the mean of the data values times the area of the */
/*   triangle. */

    ret_val = (*z1 + *z2 + *z3) * area / 6.f;
    return ret_val;
} /* trvol_ */

/* Subroutine */ int tval_(real *x, real *y, real *x1, real *x2, real *x3, 
	real *y1, real *y2, real *y3, real *z1, real *z2, real *z3, real *zx1,
	 real *zx2, real *zx3, real *zy1, real *zy2, real *zy3, logical *
	dflag, real *f, real *fx, real *fy, integer *ier)
{
    real area, rmin, phix[3], phiy[3], a[3], b[3], c[3], g[3];
    integer i;
    real p[3], q[3], r[3], u[3], v[3], c1, c2, ff[3], ax[3], ay[3], bx[3], by[
	    3], cx[3], cy[3], gx[3], gy[3], ro[3], sl[3], px[3], py[3], qx[3],
	     qy[3], rx[3], ry[3], xp, yp;
    integer ip1, ip2, ip3;
    real phi[3], rox[3], roy[3];


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   06/12/90 */

/*   Given function values and first partial derivatives at */
/* the vertices of a triangle, along with a point P in the */
/* triangle, this subroutine computes an interpolated value */
/* F(P) and, optionally, the first partial derivatives of F */
/* at P. */

/*   The interpolant F of the vertex values and gradients is */
/* the Clough-Tocher finite element.  F is cubic in each of */
/* the three subtriangles of equal area obtained by joining */
/* the vertices to the barycenter, but has only quadratic */
/* precision (exact for values and partials from a quadratic */
/* polynomial).  Along each triangle side, F is the Hermite */
/* cubic interpolant of the endpoint values and tangential */
/* gradient components, and the normal gradient component of */
/* F varies linearly between the interpolated endpoint nor- */
/* mal components.  Thus, since values and first partials on */
/* a triangle side depend only on the endpoint data, the */
/* method results in a C-1 interpolant over a triangulation. */
/* Second derivatives are discontinuous across subtriangle */
/* boundaries. */

/*   The computational procedure, due to Charles Lawson, has */
/* the following operation counts:  62 adds, 54 multiplies, */
/* 8 divides, and 6 compares for an interpolated value, and */
/* 170 adds, 142 multiplies, 14 divides, and 6 compares for */
/* both a value and a pair of first partial derivatives. */

/* On input: */

/*       X,Y = Coordinates of the point P at which F is to */
/*             be evaluated. */

/*       X1,X2,X3 = X coordinates of the vertices of the tri- */
/*                  angle in counterclockwise order. */

/*       Y1,Y2,Y3 = Y coordinates of the vertices of the tri- */
/*                  angle in one-to-one correspondence with */
/*                  X1, X2, and X3. */

/*       Z1,Z2,Z3 = Data values at the vertices (X1,Y1), */
/*                  (X2,Y2), (X3,Y3), respectively. */

/*       ZX1,ZX2,ZX3 = X-derivative values at the vertices. */

/*       ZY1,ZY2,ZY3 = Y-derivative values at the vertices. */

/*       DFLAG = Logical flag which specifies whether first */
/*               partial derivatives at P are to be computed: */
/*               DFLAG = .TRUE. if and only if partials are */
/*               to be returned. */

/* Input parameters are not altered by this routine. */

/* On output: */

/*       F = Value of the interpolatory function at P if */
/*           IER = 0, or zero if IER = 1.  Note that, if */
/*           P is not contained in the triangle, F is an */
/*           extrapolated value. */

/*       FX,FY = Partial derivatives of F at P if DFLAG = */
/*               .TRUE. and IER = 0, unaltered otherwise. */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered. */
/*             IER = 1 if the vertices of the triangle are */
/*                     collinear. */

/* Modules required by TVAL:  None */

/* *********************************************************** */


/* Local parameters: */

/* A(K) =            Cardinal function whose coefficient is */
/*                     Z(K) */
/* AREA =            Twice the area of the triangle */
/* AX(K),AY(K) =     X,Y partials of A(K) -- cardinal */
/*                     functions for FX and FY */
/* B(K) =            Twice the cardinal function whose */
/*                     coefficient is ZX(K) */
/* BX(K),BY(K) =     X,Y partials of B(K) */
/* C(K) =            Twice the cardinal function whose */
/*                     coefficient is ZY(K) */
/* CX(K),CY(K) =     X,Y partials of C(K) */
/* C1,C2 =           Factors for computing RO */
/* FF(K) =           Factors for computing G, GX, and GY -- */
/*                     constant */
/* G(K) =            Factors for computing the cardinal */
/*                     functions -- cubic */
/* GX(K),GY(K) =     X,Y partials of G(K) */
/* I =               DO-loop index */
/* IP1,IP2,IP3 =     Permuted indexes for computing RO, ROX, */
/*                     and ROY */
/* P(K) =            G(K) + PHI(K) */
/* PHI(K)            R(K-1)*R(K+1) -- quadratic */
/* PHIX(K),PHIY(K) = X,Y partials of PHI(K) */
/* PX(K),PY(K) =     X,Y partials of P(K) */
/* Q(K) =            G(K) - PHI(K) */
/* QX(K),QY(K) =     X,Y partials of Q(K) */
/* R(K) =            K-th barycentric coordinate */
/* RMIN =            Min(R1,R2,R3) */
/* RO(K) =           Factors for computing G -- cubic */
/*                     correction terms */
/* ROX(K),ROY(K) =   X,Y partials of RO(K) */
/* RX(K),RY(K) =     X,Y partial derivatives of R(K) */
/* SL(K) =           Square of the length of the side */
/*                     opposite vertex K */
/* U(K) =            X-component of the vector representing */
/*                     the side opposite vertex K */
/* V(K) =            Y-component of the vector representing */
/*                     the side opposite vertex K */
/* XP,YP =           X-X1, Y-Y1 */

    u[0] = *x3 - *x2;
    u[1] = *x1 - *x3;
    u[2] = *x2 - *x1;

    v[0] = *y3 - *y2;
    v[1] = *y1 - *y3;
    v[2] = *y2 - *y1;

    for (i = 1; i <= 3; ++i) {
	sl[i - 1] = u[i - 1] * u[i - 1] + v[i - 1] * v[i - 1];
/* L1: */
    }

/* AREA = 3->1 X 3->2. */

    area = u[0] * v[1] - u[1] * v[0];
    if (area == 0.f) {
	goto L9;
    }
    *ier = 0;

/* R(1) = (2->3 X 2->P)/AREA, R(2) = (1->P X 1->3)/AREA, */
/*   R(3) = (1->2 X 1->P)/AREA. */

    r[0] = (u[0] * (*y - *y2) - v[0] * (*x - *x2)) / area;
    xp = *x - *x1;
    yp = *y - *y1;
    r[1] = (u[1] * yp - v[1] * xp) / area;
    r[2] = (u[2] * yp - v[2] * xp) / area;

    phi[0] = r[1] * r[2];
    phi[1] = r[2] * r[0];
    phi[2] = r[0] * r[1];

    if (r[0] > r[1] || r[0] > r[2]) {
	goto L3;
    }
    rmin = r[0];
    ip1 = 1;
    ip2 = 2;
    ip3 = 3;
    goto L5;
L3:
    if (r[1] > r[2]) {
	goto L4;
    }
    rmin = r[1];
    ip1 = 2;
    ip2 = 3;
    ip3 = 1;
    goto L5;
L4:
    rmin = r[2];
    ip1 = 3;
    ip2 = 1;
    ip3 = 2;

L5:
    c1 = rmin * rmin / 2.f;
    c2 = rmin / 3.f;
    ro[ip1 - 1] = (phi[ip1 - 1] + c1 * 5.f / 3.f) * r[ip1 - 1] - c1;
    ro[ip2 - 1] = c1 * (r[ip3 - 1] - c2);
    ro[ip3 - 1] = c1 * (r[ip2 - 1] - c2);

    ff[0] = (sl[1] - sl[2]) * 3.f / sl[0];
    ff[1] = (sl[2] - sl[0]) * 3.f / sl[1];
    ff[2] = (sl[0] - sl[1]) * 3.f / sl[2];

    g[0] = (r[1] - r[2]) * phi[0] + ff[0] * ro[0] - ro[1] + ro[2];
    g[1] = (r[2] - r[0]) * phi[1] + ff[1] * ro[1] - ro[2] + ro[0];
    g[2] = (r[0] - r[1]) * phi[2] + ff[2] * ro[2] - ro[0] + ro[1];

    for (i = 1; i <= 3; ++i) {
	p[i - 1] = g[i - 1] + phi[i - 1];
	q[i - 1] = g[i - 1] - phi[i - 1];
/* L6: */
    }

    a[0] = r[0] + g[2] - g[1];
    a[1] = r[1] + g[0] - g[2];
    a[2] = r[2] + g[1] - g[0];

    b[0] = u[2] * p[2] + u[1] * q[1];
    b[1] = u[0] * p[0] + u[2] * q[2];
    b[2] = u[1] * p[1] + u[0] * q[0];

    c[0] = v[2] * p[2] + v[1] * q[1];
    c[1] = v[0] * p[0] + v[2] * q[2];
    c[2] = v[1] * p[1] + v[0] * q[0];

/* F is a linear combination of the cardinal functions. */

    *f = a[0] * *z1 + a[1] * *z2 + a[2] * *z3 + (b[0] * *zx1 + b[1] * *zx2 + 
	    b[2] * *zx3 + c[0] * *zy1 + c[1] * *zy2 + c[2] * *zy3) / 2.f;
    if (! (*dflag)) {
	return 0;
    }

/* Compute FX and FY. */

    for (i = 1; i <= 3; ++i) {
	rx[i - 1] = -(doublereal)v[i - 1] / area;
	ry[i - 1] = u[i - 1] / area;
/* L7: */
    }

    phix[0] = r[1] * rx[2] + rx[1] * r[2];
    phiy[0] = r[1] * ry[2] + ry[1] * r[2];
    phix[1] = r[2] * rx[0] + rx[2] * r[0];
    phiy[1] = r[2] * ry[0] + ry[2] * r[0];
    phix[2] = r[0] * rx[1] + rx[0] * r[1];
    phiy[2] = r[0] * ry[1] + ry[0] * r[1];

    rox[ip1 - 1] = rx[ip1 - 1] * (phi[ip1 - 1] + c1 * 5.f) + r[ip1 - 1] * (
	    phix[ip1 - 1] - rx[ip1 - 1]);
    roy[ip1 - 1] = ry[ip1 - 1] * (phi[ip1 - 1] + c1 * 5.f) + r[ip1 - 1] * (
	    phiy[ip1 - 1] - ry[ip1 - 1]);
    rox[ip2 - 1] = rx[ip1 - 1] * (phi[ip2 - 1] - c1) + c1 * rx[ip3 - 1];
    roy[ip2 - 1] = ry[ip1 - 1] * (phi[ip2 - 1] - c1) + c1 * ry[ip3 - 1];
    rox[ip3 - 1] = rx[ip1 - 1] * (phi[ip3 - 1] - c1) + c1 * rx[ip2 - 1];
    roy[ip3 - 1] = ry[ip1 - 1] * (phi[ip3 - 1] - c1) + c1 * ry[ip2 - 1];

    gx[0] = (rx[1] - rx[2]) * phi[0] + (r[1] - r[2]) * phix[0] + ff[0] * rox[
	    0] - rox[1] + rox[2];
    gy[0] = (ry[1] - ry[2]) * phi[0] + (r[1] - r[2]) * phiy[0] + ff[0] * roy[
	    0] - roy[1] + roy[2];
    gx[1] = (rx[2] - rx[0]) * phi[1] + (r[2] - r[0]) * phix[1] + ff[1] * rox[
	    1] - rox[2] + rox[0];
    gy[1] = (ry[2] - ry[0]) * phi[1] + (r[2] - r[0]) * phiy[1] + ff[1] * roy[
	    1] - roy[2] + roy[0];
    gx[2] = (rx[0] - rx[1]) * phi[2] + (r[0] - r[1]) * phix[2] + ff[2] * rox[
	    2] - rox[0] + rox[1];
    gy[2] = (ry[0] - ry[1]) * phi[2] + (r[0] - r[1]) * phiy[2] + ff[2] * roy[
	    2] - roy[0] + roy[1];

    for (i = 1; i <= 3; ++i) {
	px[i - 1] = gx[i - 1] + phix[i - 1];
	py[i - 1] = gy[i - 1] + phiy[i - 1];
	qx[i - 1] = gx[i - 1] - phix[i - 1];
	qy[i - 1] = gy[i - 1] - phiy[i - 1];
/* L8: */
    }

    ax[0] = rx[0] + gx[2] - gx[1];
    ay[0] = ry[0] + gy[2] - gy[1];
    ax[1] = rx[1] + gx[0] - gx[2];
    ay[1] = ry[1] + gy[0] - gy[2];
    ax[2] = rx[2] + gx[1] - gx[0];
    ay[2] = ry[2] + gy[1] - gy[0];

    bx[0] = u[2] * px[2] + u[1] * qx[1];
    by[0] = u[2] * py[2] + u[1] * qy[1];
    bx[1] = u[0] * px[0] + u[2] * qx[2];
    by[1] = u[0] * py[0] + u[2] * qy[2];
    bx[2] = u[1] * px[1] + u[0] * qx[0];
    by[2] = u[1] * py[1] + u[0] * qy[0];

    cx[0] = v[2] * px[2] + v[1] * qx[1];
    cy[0] = v[2] * py[2] + v[1] * qy[1];
    cx[1] = v[0] * px[0] + v[2] * qx[2];
    cy[1] = v[0] * py[0] + v[2] * qy[2];
    cx[2] = v[1] * px[1] + v[0] * qx[0];
    cy[2] = v[1] * py[1] + v[0] * qy[0];

/* FX and FY are linear combinations of the cardinal */
/*   functions. */

    *fx = ax[0] * *z1 + ax[1] * *z2 + ax[2] * *z3 + (bx[0] * *zx1 + bx[1] * *
	    zx2 + bx[2] * *zx3 + cx[0] * *zy1 + cx[1] * *zy2 + cx[2] * *zy3) /
	     2.f;
    *fy = ay[0] * *z1 + ay[1] * *z2 + ay[2] * *z3 + (by[0] * *zx1 + by[1] * *
	    zx2 + by[2] * *zx3 + cy[0] * *zy1 + cy[1] * *zy2 + cy[2] * *zy3) /
	     2.f;
    return 0;

/* The vertices are collinear. */

L9:
    *ier = 1;
    *f = 0.f;
    return 0;
} /* tval_ */

/* Subroutine */ int unif_752(integer *ncc, integer *lcc, integer *n, real *x, 
	real *y, real *z, real *grad, integer *list, integer *lptr, integer *
	lend, integer *iflgs, real *sigma, integer *nrow, integer *nx, 
	integer *ny, real *px, real *py, logical *sflag, real *sval, real *zz,
	 integer *ier)
{
    /* Initialized data */

    static logical dflag = FALSE_;
    static integer nst = 1;

    /* System generated locals */
    integer zz_dim1, zz_offset, i__1, i__2;

    /* Local variables */
    integer ierr, i, j;
    extern /* Subroutine */ int intrc1_752(real *, real *, integer *, integer *, 
	    integer *, real *, real *, real *, integer *, integer *, integer *
	    , integer *, real *, real *, logical *, integer *, real *, real *,
	     real *, integer *);
    integer ni, nj;
    logical sfl;
    real dum;
    integer nex, ist;


/* *********************************************************** */
/*                        points exterior to the triangula- */
/*                        tion or contained in a constraint */
/*                        region triangle (extrapolated */
/*                        values). */
/*             IER = -1 if NCC, N, NROW, NX, or NY is */
/*                      outside its valid range on input. */
/*                      LCC is not tested for validity. */
/*             IER = -2 if the nodes are collinear or the */
/*                      triangulation is invalid. */

/* TRIPACK modules required by UNIF:  CRTRI, JRAND, LEFT, */
/*                                      LSTPTR, TRFIND */

/* SRFPACK modules required by UNIF:  ARCINT, COORDS, FVAL, */
/*                                      INTRC1, SNHCSH, TVAL */

/* *********************************************************** */

    /* Parameter adjustments */
    zz_dim1 = *nrow;
    zz_offset = zz_dim1 + 1;
    zz -= zz_offset;
    --py;
    --px;
    --sigma;
    --lend;
    --lptr;
    --list;
    grad -= 3;
    --z;
    --y;
    --x;
    --lcc;

    /* Function Body */

/* Local parameters: */

/* DFLAG = Derivative flag for INTRC1 */
/* DUM =   Dummy INTRC1 parameter */
/* I,J =   DO-loop indexes */
/* IERR =  Error flag for calls to INTRC1 */
/* IST =   Parameter for INTRC1 */
/* NEX =   Number of grid points exterior to the triangula- */
/*           tion boundary (number of extrapolated values) */
/* NI,NJ = Local copies of NX and NY */
/* NST =   Initial value for IST */
/* SFL =   Local copy of SFLAG */

    ni = *nx;
    nj = *ny;
    if (*ncc < 0 || *n < 3 || ni < 1 || ni > *nrow || nj < 1) {
	goto L3;
    }
    sfl = *sflag;
    ist = nst;

/* Compute interpolated values. */

    nex = 0;
    i__1 = nj;
    for (j = 1; j <= i__1; ++j) {
	i__2 = ni;
	for (i = 1; i <= i__2; ++i) {
	    intrc1_752(&px[i], &py[j], ncc, &lcc[1], n, &x[1], &y[1], &z[1], &
		    list[1], &lptr[1], &lend[1], iflgs, &sigma[1], &grad[3], &
		    dflag, &ist, &zz[i + j * zz_dim1], &dum, &dum, &ierr);
	    if (ierr < 0) {
		goto L4;
	    }
	    if (ierr > 0) {
		++nex;
	    }
	    if (sfl && ierr == 1) {
		zz[i + j * zz_dim1] = *sval;
	    }
/* L1: */
	}
/* L2: */
    }
    *ier = nex;
    return 0;

/* Invalid input parameter. */

L3:
    *ier = -1;
    return 0;

/* Triangulation nodes are collinear. */

L4:
    *ier = -2;
    return 0;
} /* unif_752 */

doublereal volume_(integer *ncc, integer *lcc, integer *n, real *x, real *y, 
	real *z, integer *list, integer *lptr, integer *lend)
{
    /* System generated locals */
    integer i__1, i__2;
    real ret_val;

    /* Local variables */
    integer i, ilast, n1, n2, n3;
    extern doublereal trvol_(real *, real *, real *, real *, real *, real *, 
	    real *, real *, real *);
    integer nn, nm2, lp2, lp3;
    real xn1, yn1, zn1;
    integer lpl;
    real sum;
    integer lcc1;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   08/26/91 */

/*   Given a triangulation of a set of N nodes, along with */
/* data values at the nodes, this function computes the int- */
/* egral over a region R of the piecewise linear interpolant */
/* of the data values.  R is the convex hull of the nodes */
/* with constraint regions excluded. */

/* On input: */

/*       NCC = Number of constraint curves (refer to TRIPACK */
/*             Subroutine ADDCST).  NCC .GE. 0. */

/*       LCC = Array of length NCC (or dummy array of length */
/*             1 if NCC = 0) containing the index of the */
/*             first node of constraint I in LCC(I).  For I = */
/*             1 to NCC, LCC(I+1)-LCC(I) .GE. 3, where */
/*             LCC(NCC+1) = N+1. */

/*       N = Number of nodes in the triangulation.  N .GE. 3. */

/*       X,Y = Arrays of length N containing the coordinates */
/*             of the nodes with non-constraint nodes in the */
/*             first LCC(1)-1 locations, followed by NCC se- */
/*             quences of constraint nodes. */

/*       Z = Array of length N containing data values at the */
/*           nodes.  Refer to Subroutine ZGRADL. */

/*       LIST,LPTR,LEND = Data structure defining the trian- */
/*                        gulation.  Refer to TRIPACK */
/*                        Subroutine TRMESH. */

/* Input parameters are not altered by this function. */

/* On output: */

/*       VOLUME = Sum of the volumes of the linear interpo- */
/*                lants on the non-constraint triangles, or */
/*                zero if a parameter is outside its valid */
/*                range on input. */

/* SRFPACK module required by VOLUME:  TRVOL */

/* Intrinsic function called by VOLUME:  ABS */

/* *********************************************************** */


/* Test for invalid input parameters. */

    /* Parameter adjustments */
    --lend;
    --lptr;
    --list;
    --z;
    --y;
    --x;
    --lcc;

    /* Function Body */
    if (*ncc < 0) {
	goto L5;
    }
    nn = *n;
    lcc1 = nn + 1;
    if (*ncc == 0) {
	if (nn < 3) {
	    goto L5;
	}
    } else {
	for (i = *ncc; i >= 1; --i) {
	    if (lcc1 - lcc[i] < 3) {
		goto L5;
	    }
	    lcc1 = lcc[i];
/* L1: */
	}
	if (lcc1 < 1) {
	    goto L5;
	}
    }

/* Initialize for loop on triangles (N1,N2,N3) such that N2 */
/*   and N3 have larger indexes than N1.  SUM contains the */
/*   accumulated volume, I is the index of the constraint */
/*   containing N1 if N1 is a constraint node, and ILAST is */
/*   the last node of constraint I. */

    i = 0;
    ilast = lcc1 - 1;
    sum = 0.f;
    nm2 = nn - 2;
    i__1 = nm2;
    for (n1 = 1; n1 <= i__1; ++n1) {
	xn1 = x[n1];
	yn1 = y[n1];
	zn1 = z[n1];
	if (n1 > ilast) {
	    ++i;
	    if (i < *ncc) {
		ilast = lcc[i + 1] - 1;
	    } else {
		ilast = nn;
	    }
	}

/* Top of loop on neighbors of N1. */

	lpl = lend[n1];
	lp2 = lpl;
L2:
	lp2 = lptr[lp2];
	n2 = list[lp2];
	lp3 = lptr[lp2];
	n3 = (i__2 = list[lp3], abs(i__2));
	if (n2 < n1 || n3 < n1) {
	    goto L3;
	}

/*   (N1,N2,N3) lies in a constraint region iff the vertices */
/*     are nodes of the same constraint and N2 < N3. */

	if (n1 < lcc1 || n2 > n3 || n3 > ilast) {
	    sum += trvol_(&xn1, &x[n2], &x[n3], &yn1, &y[n2], &y[n3], &zn1, &
		    z[n2], &z[n3]);
	}

/*   Bottom of loop on neighbors. */

L3:
	if (lp2 != lpl) {
	    goto L2;
	}
/* L4: */
    }

    ret_val = sum;
    return ret_val;

/* Invalid input parameter. */

L5:
    ret_val = 0.f;
    return ret_val;
} /* volume_ */

/* Subroutine */ int zgradg_752(integer *ncc, integer *lcc, integer *n, real *x, 
	real *y, integer *list, integer *lptr, integer *lend, integer *iflgs, 
	real *sigma, integer *nit, real *dzmax, real *z, real *grad, integer *
	ier)
{
    /* System generated locals */
    integer i__1, i__2;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    integer kbak;
    real dcub;
    integer kfor, iter;
    real dzmx, d;
    integer i, j, k;
    real areaj, t, arean, w, areap;
    integer ilast, maxit, ifrst;
    real r1, r2, r3, a11, a12, a13, a22, a23, a33, df;
    integer nb, jn, lp, nn;
    real dx, dy, dz, xk, yk, zk;
    extern /* Subroutine */ int grcoef_752(real *, real *, real *, real *);
    integer ifl;
    real sdf;
    integer lpf;
    real sig;
    integer lpj, lpl;
    real dsq;
    integer lpn;
    real dzj, dzk, dxs, dys, tol, dzx, dzy, zxk, zyk;
    integer lcc1;


/* *********************************************************** */
/*           sufficient, but Subroutine ZINIT may be called */
/*           to provide better initial estimates. */

/*       GRAD = 2 by N array whose columns contain initial */
/*              estimates of the gradients with X partial */
/*              derivatives in the first row, Y partials in */
/*              the second.  Zeros are sufficient. */

/* On output: */

/*       NIT = Number of Gauss-Seidel iterations employed. */

/*       DZMAX = Maximum relative change in a solution Z- */
/*               component at the last iteration. */

/*       Z = Array updated with approximate data values in */
/*           the last NCN = N-LCC(1)+1 locations if IER .GE. */
/*           0.  Z is not altered if IER = -1. */

/*       GRAD = Estimated gradients at the nodes if IER .GE. */
/*              0.  GRAD is not altered if IER = -1. */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered and the */
/*                     convergence criterion was achieved. */
/*             IER = 1 if no errors were encountered but con- */
/*                     vergence was not achieved within NIT */
/*                     iterations. */
/*             IER = -1 if NCC, an LCC entry, N, NIT, or */
/*                      DZMAX is outside its valid range */
/*                      on input. */
/*             IER = -2 if all nodes are collinear or the */
/*                      triangulation data structure is in- */
/*                      valid. */
/*             IER = -3 if duplicate nodes were encountered. */

/* SRFPACK modules required by ZGRADG:  GRCOEF, SNHCSH */

/* Intrinsic functions called by ZGRADG:  ABS, MAX, SQRT */

/* *********************************************************** */


    /* Parameter adjustments */
    grad -= 3;
    --z;
    --sigma;
    --lend;
    --lptr;
    --list;
    --y;
    --x;
    --lcc;

    /* Function Body */
    nn = *n;
    ifl = *iflgs;
    maxit = *nit;
    tol = *dzmax;

/* Test for errors in input parameters. */

    if (*ncc <= 0 || maxit < 1 || tol < 0.f) {
	goto L9;
    }
    lcc1 = nn + 1;
    for (i = *ncc; i >= 1; --i) {
	if (lcc1 - lcc[i] < 3) {
	    goto L9;
	}
	lcc1 = lcc[i];
/* L1: */
    }
    if (lcc1 < 4) {
	goto L9;
    }

/* Initialize iteration count and SIG (overwritten if */
/*   IFLGS > 0). */

    iter = 0;
    sig = sigma[1];

/* Top of iteration loop:  If K is a constraint node, I */
/*   indexes the constraint containing node K, IFRST and */
/*   ILAST are the first and last nodes of constraint I, and */
/*   (KBAK,K,KFOR) is a subsequence of constraint I. */

L2:
    if (iter == maxit) {
	goto L8;
    }
    dzmx = 0.f;
    i = 0;
    ilast = lcc1 - 1;
    kbak = 0;
    kfor = 0;

/* Loop on nodes. */

    i__1 = nn;
    for (k = 1; k <= i__1; ++k) {
	if (k >= lcc1) {
	    if (k > ilast) {
		++i;
		ifrst = k;
		if (i < *ncc) {
		    ilast = lcc[i + 1] - 1;
		} else {
		    ilast = nn;
		}
		kbak = ilast;
		kfor = k + 1;
	    } else {
		kbak = k - 1;
		if (k < ilast) {
		    kfor = k + 1;
		} else {
		    kfor = ifrst;
		}
	    }
	}
	xk = x[k];
	yk = y[k];
	zk = z[k];
	zxk = grad[(k << 1) + 1];
	zyk = grad[(k << 1) + 2];

/* Initialize components of the 2 by 2 (or 3 by 3) block -- */
/*   symmetric matrix in A and residual in R.  The unknowns */
/*   are ordered (DZX,DZY,DZ). */

	a11 = 0.f;
	a12 = 0.f;
	a13 = 0.f;
	a22 = 0.f;
	a23 = 0.f;
	a33 = 0.f;
	r1 = 0.f;
	r2 = 0.f;
	r3 = 0.f;

/* Loop on neighbors J of node K.  The equation associated */
/*   with K->J (and hence its contribution to the functional) */
/*   is weighted by AREAJ/D, where AREAJ is twice the sum of */
/*   the areas of the triangles containing K-J (excluding */
/*   those which lie in a constraint region) and D is the arc */
/*   length.  JN is the neighbor of K following J.  AREAP is */
/*   to the right of K->J and AREAN is to the left. */

	lpl = lend[k];
	j = list[lpl];
	lpf = lptr[lpl];
	jn = list[lpf];
	arean = 0.f;
	if (j > 0) {
	    arean = (x[j] - xk) * (y[jn] - yk) - (y[j] - yk) * (x[jn] - xk);
	}
	lpn = lpf;

/* Top of loop:  LPF and LPL point to the first and last */
/*   neighbors of K, and LPN points to JN. */

L3:
	lpj = lpn;
	lpn = lptr[lpn];
	j = jn;
	areap = arean;
	jn = (i__2 = list[lpn], abs(i__2));

/* Arc K-J lies in a constraint region and is bypassed iff K */
/*   and J are nodes in the same constraint and J follows */
/*   KFOR and precedes KBAK as a neighbor of K. */

	if (k < lcc1 || j < ifrst || j > ilast) {
	    goto L5;
	}
	if (j == kbak) {
	    areap = 0.f;
	}
	if (j == kbak || j == kfor) {
	    goto L5;
	}

	lp = lpn;
L4:
	nb = (i__2 = list[lp], abs(i__2));
	if (nb == kfor) {
	    goto L5;
	}
	if (nb == kbak) {
	    goto L6;
	}
	lp = lptr[lp];
	goto L4;

/*   Compute parameters associated with the edge K->J, and */
/*     test for duplicate nodes.  Note that AREAJ = 0 and */
/*     K->J is bypassed if K-J is both a constraint arc and */
/*     a boundary arc of the triangulation. */

L5:
	dx = x[j] - xk;
	dy = y[j] - yk;
	arean = 0.f;
	if (list[lpl] != -j && j != kfor) {
	    arean = dx * (y[jn] - yk) - dy * (x[jn] - xk);
	}
	areaj = areap + arean;
	if (areaj == 0.f) {
	    goto L6;
	}
	dxs = dx * dx;
	dys = dy * dy;
	dsq = dxs + dys;
	d = sqrt(dsq);
	dcub = d * dsq;
	if (d == 0.f) {
	    goto L11;
	}
	if (ifl >= 1) {
	    sig = sigma[lpj];
	}
	grcoef_752(&sig, &dcub, &df, &sdf);
	w = areaj / d;

/*   Update the 2 by 2 system components for node J. */

	a11 += df * dxs * w;
	a12 += df * dx * dy * w;
	a22 += df * dys * w;
	dz = z[j] - zk;
	dzj = grad[(j << 1) + 1] * dx + grad[(j << 1) + 2] * dy;
	dzk = zxk * dx + zyk * dy;
	t = ((df + sdf) * dz - sdf * dzj - df * dzk) * w;
	r1 += t * dx;
	r2 += t * dy;
	if (k >= lcc1) {

/*   K is a constraint node.  Update the remaining components. */

	    w = (df + sdf) * w;
	    a13 += dx * w;
	    a23 += dy * w;
	    a33 += w * 2.f;
	    r3 += (dz * 2.f - dzj - dzk) * w;
	}

/*   Bottom of loop on J. */

L6:
	if (lpn != lpf) {
	    goto L3;
	}

/* Solve the linear system associated with the K-th block. */

	a22 = a11 * a22 - a12 * a12;
	r2 = a11 * r2 - a12 * r1;
	if (a11 == 0.f || a22 == 0.f) {
	    goto L10;
	}
	if (k >= lcc1) {
	    a23 = a11 * a23 - a12 * a13;
	    a33 = a22 * (a11 * a33 - a13 * a13) - a23 * a23;
	    r3 = a22 * (a11 * r3 - a13 * r1) - a23 * r2;
	    if (a33 == 0.f) {
		goto L10;
	    }
	    dz = r3 / a33;
	}
	dzy = (r2 - a23 * dz) / a22;
	dzx = (r1 - a12 * dzy - a13 * dz) / a11;

/* Update the solution components for node K and the maxi- */
/*   mum relative change DZMX. */

	grad[(k << 1) + 1] = zxk + dzx;
	grad[(k << 1) + 2] = zyk + dzy;
	if (k >= lcc1) {
	    z[k] = zk + dz;
/* Computing MAX */
	    r__1 = dzmx, r__2 = dabs(dz) / (dabs(zk) + 1.f);
	    dzmx = dmax(r__1,r__2);
	}
/* L7: */
    }

/* Increment ITER and test for convergence. */

    ++iter;
    if (dzmx > tol) {
	goto L2;
    }

/* Method converged. */

    *nit = iter;
    *dzmax = dzmx;
    *ier = 0;
    return 0;

/* Method failed to converge within NIT iterations. */

L8:
    *dzmax = dzmx;
    *ier = 1;
    return 0;

/* Invalid input parameter. */

L9:
    *nit = 0;
    *dzmax = 0.f;
    *ier = -1;
    return 0;

/* Node K and its neighbors are collinear, resulting in a */
/*   singular system. */

L10:
    *nit = 0;
    *dzmax = dzmx;
    *ier = -2;
    return 0;

/* Nodes J and K coincide. */

L11:
    *nit = 0;
    *dzmax = dzmx;
    *ier = -3;
    return 0;
} /* zgradg_752 */

/* Subroutine */ int zgradl_752(integer *k, integer *ncc, integer *lcc, integer *
	n, real *x, real *y, integer *list, integer *lptr, integer *lend, 
	integer *ndv, real *z, integer *npts, real *ds, real *dx, real *dy, 
	integer *ier)
{
    /* Initialized data */

    static real rfac = 1.05f;
    static real dtol = .01f;

    /* System generated locals */
    integer i__1, i__2;
    real r__1, r__2, r__3;

    /* Local variables */
    real dmin_;
    integer npar, ierr;
    logical init;
    integer irow1;
    real a[49]	/* was [7][7] */, c;
    integer i, j, l;
    real s, w;
    integer ndmin;
    logical stabl;
    extern /* Subroutine */ int getnp_(integer *, integer *, integer *, real *
	    , real *, integer *, integer *, integer *, integer *, integer *, 
	    real *, integer *), setro2_(real *, real *, real *, real *, real *
	    , real *, real *, real *, real *, real *);
    integer nd, kk;
    real sf;
    integer ir, jr, lr, np;
    real xk, yk, zk;
    extern /* Subroutine */ int givens_752(real *, real *, real *, real *), 
	    rotate_752(integer *, real *, real *, real *, real *);
    integer jp1;
    real rin;
    integer lnp;
    real sfs, stf;
    integer lcc1, npm1, npp1;


/* *********************************************************** */
/*              sequence of L closest nodes to node K (with K */
/*              in the first position) unless IER .NE. 0.  L */
/*              is the smallest integer such that the se- */
/*              quence contains NDV (output value) non- */
/*              constraint nodes.  NPTS(L+1) = 0 if L < N. */

/*       DS = Array containing the distance between node K */
/*            and NPTS(I) in DS(I) for I = 1,...,L unless */
/*            IER .NE. 0.  Distance is measured within the */
/*            non-constraint region (refer to Subroutine */
/*            GETNP). */

/*       DX,DY = Estimated X and Y partial derivatives at */
/*               node K unless IER .NE. 0. */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered. */
/*             IER = 1 if K, NCC, an LCC entry, N, or NDV is */
/*                     outside its valid range on input. */
/*             IER = 2 if all non-constraint nodes are col- */
/*                     linear. */

/* TRIPACK modules required by ZGRADL:  GETNP, INTSEC */

/* SRFPACK modules required by ZGRADL:  GIVENS, ROTATE, */
/*                                        SETRO2 */

/* Intrinsic functions called by ZGRADL:  ABS, MIN */

/* *********************************************************** */

    /* Parameter adjustments */
    --ds;
    --npts;
    --z;
    --lend;
    --lptr;
    --list;
    --y;
    --x;
    --lcc;

    /* Function Body */

/* Store parameters in local variables, test for errors, and */
/*   initialize switches. */

    kk = *k;
    if (*ncc > 0) {
	lcc1 = lcc[1];
    } else {
	lcc1 = *n + 1;
    }
    ndmin = *ndv;
    if (kk < 1 || kk > *n || *ncc < 0 || lcc1 < 4 || ndmin < 3 || ndmin >= 
	    lcc1) {
	goto L13;
    }
    xk = x[kk];
    yk = y[kk];
    zk = 0.f;
    if (kk < lcc1) {
	zk = z[kk];
    }
    init = FALSE_;
    stabl = FALSE_;

/* Set NPTS to the closest LNP nodes to K, where LNP is the */
/*   smallest integer such that NPTS contains NDMIN non- */
/*   constraint nodes.  ND is the number of non-constraint */
/*   nodes currently in NPTS. */

    lnp = 1;
    npts[1] = kk;
    ds[1] = 0.f;
    nd = 0;
    if (kk < lcc1) {
	nd = 1;
    }

/*   Get a new non-constraint node. */

L1:
    ++lnp;
    getnp_(ncc, &lcc[1], n, &x[1], &y[1], &list[1], &lptr[1], &lend[1], &lnp, 
	    &npts[1], &ds[1], &ierr);
    if (ierr != 0) {
	goto L13;
    }
    if (npts[lnp] >= lcc1) {
	goto L1;
    }
    ++nd;
    if (nd < ndmin) {
	goto L1;
    }

/* Compute an inverse radius of influence to be used in the */
/*   weights, and test the initialization switch -- INIT = */
/*   .TRUE. iff A has been initialized with the first NPAR */
/*   equations. */

    rin = 1.f / (rfac * ds[lnp]);
    if (init) {
	goto L5;
    }

/* A Q-R decomposition is used to solve the least squares */
/*   system.  For a quadratic fit there are NPAR = 5 or */
/*   NPAR = 6 parameters, depending on whether or not K is */
/*   a constraint node.  (At least 6 data values are needed */
/*   in either case.)  The transpose of the augmented regres- */
/*   sion matrix is stored in A with columns (rows of A) de- */
/*   fined as follows -- 1-3 are the quadratic terms, 4 and 5 */
/*   are the linear terms with coefficients DX and DY, column */
/*   6 is the constant term with coefficient Z(K) (extraneous */
/*   if NPAR = 5), and the last column is the right hand */
/*   side.  In the case of a linear fit, the first 3 columns */
/*   are ignored and the first 3 rows are omitted.  The lin- */
/*   ear terms are scaled by SF = 1/DMAX, where DMAX is the */
/*   maximum distance between K and a non-constraint node in */
/*   NPTS, and the quadratic terms are scaled by SF**2. */

    sf = 1.f / ds[lnp];
    sfs = sf * sf;
    irow1 = 1;
    if (nd < 6) {
	irow1 = 4;
    }
    npar = 5;
    if (kk >= lcc1) {
	npar = 6;
    }
    npm1 = npar - 1;
    npp1 = npar + 1;

/* Set up the first NPAR equations and zero out the lower */
/*   triangle (upper triangle of A) with Givens rotations -- */

    l = 1;
    i__1 = npar;
    for (ir = irow1; ir <= i__1; ++ir) {
L2:
	++l;
	np = npts[l];
	if (np >= lcc1) {
	    goto L2;
	}
	w = 1.f / ds[l] - rin;
	setro2_(&xk, &yk, &zk, &x[np], &y[np], &z[np], &sf, &sfs, &w, &a[ir * 
		7 - 7]);
	if (ir == irow1) {
	    goto L4;
	}
	i__2 = ir - 1;
	for (jr = irow1; jr <= i__2; ++jr) {
	    jp1 = jr + 1;
	    lr = 7 - jr;
	    givens_752(&a[jr + jr * 7 - 8], &a[jr + ir * 7 - 8], &c, &s);
	    rotate_752(&lr, &c, &s, &a[jp1 + jr * 7 - 8], &a[jp1 + ir * 7 - 8]);
/* L3: */
	}
L4:
	;
    }
    init = TRUE_;

/* Incorporate additional equations into the system using the */
/*   last column of A (or next to last if NPAR = 5). */

L5:
    if (l == lnp) {
	goto L7;
    }
    ++l;
    np = npts[l];
    if (np >= lcc1) {
	goto L5;
    }
    w = 1.f / ds[l] - rin;
    setro2_(&xk, &yk, &zk, &x[np], &y[np], &z[np], &sf, &sfs, &w, &a[npp1 * 7 
	    - 7]);
    i__1 = npar;
    for (jr = irow1; jr <= i__1; ++jr) {
	jp1 = jr + 1;
	lr = 7 - jr;
	givens_752(&a[jr + jr * 7 - 8], &a[jr + npp1 * 7 - 8], &c, &s);
	rotate_752(&lr, &c, &s, &a[jp1 + jr * 7 - 8], &a[jp1 + npp1 * 7 - 8]);
/* L6: */
    }
    goto L5;

/* Test the system for ill-conditioning. */

L7:
    dmin_ = (r__1 = a[npar + npar * 7 - 8], dabs(r__1));
    i__1 = npm1;
    for (i = irow1; i <= i__1; ++i) {
/* Computing MIN */
	r__2 = dmin_, r__3 = (r__1 = a[i + i * 7 - 8], dabs(r__1));
	dmin_ = dmin(r__2,r__3);
/* L8: */
    }
    if (dmin_ / w >= dtol) {
	goto L12;
    }
    if (nd < lcc1) {

/*   Add another equation to the system and increase the */
/*     radius R. */

	++ndmin;
	goto L1;
    }

/* The system is ill-conditioned and all non-constraint nodes */
/*   have been used.  Stabilize the system by damping out the */
/*   second partials (coefficients of the quadratic terms) */
/*   unless the system has already been stabilized or a */
/*   linear fitting function is being used.  Add multiples */
/*   of the first 3 unit vectors to the first 3 equations. */

    if (stabl || irow1 == 4) {
	goto L14;
    }
    stf = w;
    for (i = 1; i <= 3; ++i) {
	a[i + npp1 * 7 - 8] = stf;
	for (j = i + 1; j <= 7; ++j) {
	    a[j + npp1 * 7 - 8] = 0.f;
/* L9: */
	}
	i__1 = npar;
	for (jr = i; jr <= i__1; ++jr) {
	    jp1 = jr + 1;
	    lr = 7 - jr;
	    givens_752(&a[jr + jr * 7 - 8], &a[jr + npp1 * 7 - 8], &c, &s);
	    rotate_752(&lr, &c, &s, &a[jp1 + jr * 7 - 8], &a[jp1 + npp1 * 7 - 8])
		    ;
/* L10: */
	}
/* L11: */
    }
    stabl = TRUE_;
    goto L7;

/* Solve the 2 by 2 (or 3 by 3 if K is a constraint node) */
/*   lower triangular system. */

L12:
    zk = 0.f;
    if (kk >= lcc1) {
	zk = a[41] / a[40];
    }
    *dy = (a[34] - a[33] * zk) / a[32];
    *dx = sf * (a[27] - a[26] * zk - a[25] * *dy) / a[24];
    *dy = sf * *dy;
    if (kk >= lcc1) {
	z[*k] = zk;
    }
    *ndv = nd;
    if (l < *n) {
	npts[l + 1] = 0;
    }
    *ier = 0;
    return 0;

/* Invalid input parameter. */

L13:
    *ndv = 0;
    *ier = 1;
    return 0;

/* No unique solution due to collinear non-constraint nodes. */

L14:
    *ndv = 0;
    *ier = 2;
    return 0;
} /* zgradl_752 */

/* Subroutine */ int zinit_(integer *ncc, integer *lcc, integer *n, real *x, 
	real *y, integer *list, integer *lptr, integer *lend, real *z, 
	integer *ier)
{
    /* System generated locals */
    integer i__1, i__2, i__3;
    real r__1, r__2;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    real dmin_;
    integer ierr, npts[12];
    real d;
    integer i, k, ilast;
    extern /* Subroutine */ int getnp_(integer *, integer *, integer *, real *
	    , real *, integer *, integer *, integer *, integer *, integer *, 
	    real *, integer *);
    integer ifrst;
    real h1, h2;
    integer ilstm1;
    real ds[12];
    integer kn, lp;
    real xk, yk, zn;
    integer km1, km2, lpl, lnp, lcc1;


/* *********************************************************** */

/*                                               From SRFPACK */
/*                                            Robert J. Renka */
/*                                  Dept. of Computer Science */
/*                                       Univ. of North Texas */
/*                                           renka@cs.unt.edu */
/*                                                   08/27/91 */

/*   Given a triangulation of N nodes, along with data values */
/* at non-constraint nodes, this subroutine computes approxi- */
/* mate data values at the constraint nodes.  The approximate */
/* values are intended only to serve as initial estimates for */
/* Subroutine ZGRADG which computes refined estimates. */

/*   For each subsequence (KM2,KM1,K) of a constraint, the */
/* approximate value at node KM1 is taken to be the closest- */
/* point value (data value at the closest non-constraint */
/* node) at KM1 averaged with the value at KM1 of the linear */
/* interpolant (along the constraint boundary) of the approx- */
/* imate value at KM2 and the closest-point value at K. */

/* On input: */

/*       NCC = Number of constraint curves (refer to TRIPACK */
/*             Subroutine ADDCST).  NCC .GE. 0. */

/*       LCC = Array of length NCC (or dummy array of length */
/*             1 if NCC = 0) containing the index of the */
/*             first node of constraint I in LCC(I).  For I = */
/*             1 to NCC, LCC(I+1)-LCC(I) .GE. 3, where */
/*             LCC(NCC+1) = N+1, and LCC(1) .GE. 4. */

/*       N = Number of nodes in the triangulation.  N .GE. 3. */

/*       X,Y = Arrays of length N containing the coordinates */
/*             of the nodes with non-constraint nodes in the */
/*             first LCC(1)-1 locations, followed by NCC se- */
/*             quences of constraint nodes. */

/*       LIST,LPTR,LEND = Data structure defining the trian- */
/*                        gulation.  Refer to TRIPACK */
/*                        Subroutine TRMESH. */

/* The above parameters are not altered by this routine. */

/*       Z = Array of length N containing data values in the */
/*           first LCC(1)-1 locations. */

/* On output: */

/*       Z = Array updated with approximate data values in */
/*           the last N-LCC(1)+1 locations if IER = 0. */

/*       IER = Error indicator: */
/*             IER = 0 if no errors were encountered. */
/*             IER = 1 if NCC, N, or an LCC entry is outside */
/*                     its valid range on input. */

/* TRIPACK modules required by ZINIT:  GETNP, INTSEC */

/* Intrinsic functions called by ZINIT:  ABS, SQRT */

/* *********************************************************** */


/* Test for errors in input parameters.  (LCC is tested by */
/*   Subroutine GETNP.) */

    /* Parameter adjustments */
    --z;
    --lend;
    --lptr;
    --list;
    --y;
    --x;
    --lcc;

    /* Function Body */
    *ier = 1;
    if (*ncc > 0) {
	lcc1 = lcc[1];
    } else {
	lcc1 = *n + 1;
    }
    if (*ncc < 0 || lcc1 < 4) {
	return 0;
    }

/* Outer loop on constraint I with first and last nodes IFRST */
/*   and ILAST. */

    i__1 = *ncc;
    for (i = 1; i <= i__1; ++i) {
	ifrst = lcc[i];
	if (i < *ncc) {
	    ilast = lcc[i + 1] - 1;
	} else {
	    ilast = *n;
	}

/* Initialize Z(ILAST) with the data value at the closest */
/*   non-constraint node to ILAST.  Unless the LMAX closest */
/*   nodes to ILAST (including ILAST) are all constraint */
/*   nodes, NPTS is set to the closest LNP nodes (with */
/*   distance measured in the non-constraint region), where */
/*   LNP is the smallest integer such that NPTS contains a */
/*   non-constraint node.  The value at LCC(1)-1 is used if */
/*   LMAX is too small. */

	lnp = 1;
	npts[0] = ilast;
	ds[0] = 0.f;
L1:
	++lnp;
	getnp_(ncc, &lcc[1], n, &x[1], &y[1], &list[1], &lptr[1], &lend[1], &
		lnp, npts, ds, &ierr);
	if (ierr != 0) {
	    return 0;
	}
	kn = npts[lnp - 1];
	if (kn >= lcc1 && lnp < 12) {
	    goto L1;
	}
	if (kn >= lcc1) {
	    kn = lcc1 - 1;
	}
	z[ilast] = z[kn];

/* Loop on constraint nodes K.  LPL points to the last */
/*   neighbor of K.  At each step, Z(K) is set to the */
/*   closest-point value at K, and Z(KM1) is set to the */
/*   (final) approximate data value at KM1 (except when */
/*   K = IFRST). */

	km1 = ilast;
	ilstm1 = ilast - 1;
	i__2 = ilstm1;
	for (k = ifrst; k <= i__2; ++k) {
	    xk = x[k];
	    yk = y[k];
	    lpl = lend[k];

/*   Set LP to point to KM1 as a neighbor of K. */

	    lp = lpl;
L2:
	    lp = lptr[lp];
	    if ((i__3 = list[lp], abs(i__3)) != km1) {
		goto L2;
	    }

/*   Initialize for loop on non-constraint node neighbors of */
/*     K.  If K has no such neighbors, the closest non- */
/*     constraint node to K is (implicitly) taken to be the */
/*     closest non-constraint node to KM1. */

	    dmin_ = -1.f;
	    zn = z[km1];
L3:
	    lp = lptr[lp];
	    kn = (i__3 = list[lp], abs(i__3));
	    if (kn == k + 1) {
		goto L4;
	    }
	    if (kn >= lcc1) {
		goto L3;
	    }
/* Computing 2nd power */
	    r__1 = x[kn] - xk;
/* Computing 2nd power */
	    r__2 = y[kn] - yk;
	    d = r__1 * r__1 + r__2 * r__2;
	    if (dmin_ >= 0.f && dmin_ < d) {
		goto L3;
	    }
	    dmin_ = d;
	    zn = z[kn];
	    goto L3;

/*   ZN is the closest-point value at K.  Set H2 to the arc */
/*     length of KM1-K, and compute Z(KM1) if K > IFRST. */
/*     (H1 is the arc length of KM2-KM1). */

L4:
/* Computing 2nd power */
	    r__1 = xk - x[km1];
/* Computing 2nd power */
	    r__2 = yk - y[km1];
	    h2 = sqrt(r__1 * r__1 + r__2 * r__2);
	    if (k != ifrst) {
		z[km1] = (z[km1] + (h1 * zn + h2 * z[km2]) / (h1 + h2)) * .5f;
	    }
	    z[k] = zn;

/*   Bottom of loop on K. */

	    h1 = h2;
	    km2 = km1;
	    km1 = k;
/* L5: */
	}

/* For K = ILAST, the closest-point value has already been */
/*   computed. */

/* Computing 2nd power */
	r__1 = x[ilast] - x[ilstm1];
/* Computing 2nd power */
	r__2 = y[ilast] - y[ilstm1];
	h2 = sqrt(r__1 * r__1 + r__2 * r__2);
	z[ilstm1] = (z[ilstm1] + (h1 * z[ilast] + h2 * z[km2]) / (h1 + h2)) * 
		.5f;

/* Compute the final value at ILAST. */

	h1 = h2;
/* Computing 2nd power */
	r__1 = x[ifrst] - x[ilast];
/* Computing 2nd power */
	r__2 = y[ifrst] - y[ilast];
	h2 = sqrt(r__1 * r__1 + r__2 * r__2);
	z[ilast] = (z[ilast] + (h1 * z[ifrst] + h2 * z[ilstm1]) / (h1 + h2)) *
		 .5f;
/* L6: */
    }

/* No errors encountered. */

    *ier = 0;
    return 0;
} /* zinit_ */

