/* toms642.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/*     ALGORITHM 642 COLLECTED ALGORITHMS FROM ACM. */
/*     ALGORITHM APPEARED IN ACM-TRANS. MATH. SOFTWARE, VOL.12, NO. 2, */
/*     JUN., 1986, P. 150. */
/*   SUBROUTINE NAME     - CUBGCV */

/*--------------------------------------------------------------------------*/

/*   COMPUTER            - VAX/DOUBLE */

/*   AUTHOR              - M.F.HUTCHINSON */
/*                         CSIRO DIVISION OF MATHEMATICS AND STATISTICS */
/*                         P.O. BOX 1965 */
/*                         CANBERRA, ACT 2601 */
/*                         AUSTRALIA */

/*   LATEST REVISION     - 15 AUGUST 1985 */

/*   PURPOSE             - CUBIC SPLINE DATA SMOOTHER */

/*   USAGE               - CALL CUBGCV (X,F,DF,N,Y,C,IC,VAR,JOB,SE,WK,IER) */

/*   ARGUMENTS    X      - VECTOR OF LENGTH N CONTAINING THE */
/*                           ABSCISSAE OF THE N DATA POINTS */
/*                           (X(I),F(I)) I=1..N. (INPUT) X */
/*                           MUST BE ORDERED SO THAT */
/*                           X(I) .LT. X(I+1). */
/*                F      - VECTOR OF LENGTH N CONTAINING THE */
/*                           ORDINATES (OR FUNCTION VALUES) */
/*                           OF THE N DATA POINTS (INPUT). */
/*                DF     - VECTOR OF LENGTH N. (INPUT/OUTPUT) */
/*                           DF(I) IS THE RELATIVE STANDARD DEVIATION */
/*                           OF THE ERROR ASSOCIATED WITH DATA POINT I. */
/*                           EACH DF(I) MUST BE POSITIVE.  THE VALUES IN */
/*                           DF ARE SCALED BY THE SUBROUTINE SO THAT */
/*                           THEIR MEAN SQUARE VALUE IS 1, AND UNSCALED */
/*                           AGAIN ON NORMAL EXIT. */
/*                          THE MEAN SQUARE VALUE OF THE DF(I) IS RETURNED*/
/*                           IN WK(7) ON NORMAL EXIT. */
/*                          IF THE ABSOLUTE STANDARD DEVIATIONS ARE KNOWN,*/
/*                           THESE SHOULD BE PROVIDED IN DF AND THE ERROR */
/*                          VARIANCE PARAMETER VAR (SEE BELOW) SHOULD THEN*/
/*                           BE SET TO 1. */
/*                          IF THE RELATIVE STANDARD DEVIATIONS ARE UNKNOWN,*/
/*                           SET EACH DF(I)=1. */
/*                N      - NUMBER OF DATA POINTS (INPUT). */
/*                           N MUST BE .GE. 3. */
/*                Y,C    - SPLINE COEFFICIENTS. (OUTPUT) Y */
/*                           IS A VECTOR OF LENGTH N. C IS */
/*                           AN N-1 BY 3 MATRIX. THE VALUE */
/*                           OF THE SPLINE APPROXIMATION AT T IS */
/*                           S(T)=((C(I,3)*D+C(I,2))*D+C(I,1))*D+Y(I) */
/*                           WHERE X(I).LE.T.LT.X(I+1) AND */
/*                           D = T-X(I). */
/*                IC     - ROW DIMENSION OF MATRIX C EXACTLY */
/*                           AS SPECIFIED IN THE DIMENSION */
/*                           STATEMENT IN THE CALLING PROGRAM. (INPUT) */
/*                VAR    - ERROR VARIANCE. (INPUT/OUTPUT) */
/*                           IF VAR IS NEGATIVE (I.E. UNKNOWN) THEN */
/*                           THE SMOOTHING PARAMETER IS DETERMINED */
/*                          BY MINIMIZING THE GENERALIZED CROSS VALIDATION*/
/*                           AND AN ESTIMATE OF THE ERROR VARIANCE IS */
/*                           RETURNED IN VAR. */
/*                           IF VAR IS NON-NEGATIVE (I.E. KNOWN) THEN THE */
/*                           SMOOTHING PARAMETER IS DETERMINED TO MINIMIZE */
/*                          AN ESTIMATE, WHICH DEPENDS ON VAR, OF THE TRUE*/
/*                           MEAN SQUARE ERROR, AND VAR IS UNCHANGED. */
/*                           IN PARTICULAR, IF VAR IS ZERO, THEN AN */
/*                          INTERPOLATING NATURAL CUBIC SPLINE IS CALCULATED.
*/
/*                           VAR SHOULD BE SET TO 1 IF ABSOLUTE STANDARD */
/*                          DEVIATIONS HAVE BEEN PROVIDED IN DF (SEE ABOVE).*/
/*                JOB    - JOB SELECTION PARAMETER. (INPUT) */
/*                        JOB = 0 SHOULD BE SELECTED IF POINT STANDARD ERROR*/
/*                           ESTIMATES ARE NOT REQUIRED IN SE. */
/*                        JOB = 1 SHOULD BE SELECTED IF POINT STANDARD ERROR*/
/*                           ESTIMATES ARE REQUIRED IN SE. */
/*                SE     - VECTOR OF LENGTH N CONTAINING BAYESIAN STANDARD */
/*                          ERROR ESTIMATES OF THE FITTED SPLINE VALUES IN Y.
*/
/*                           SE IS NOT REFERENCED IF JOB=0. (OUTPUT) */
/*               WK     - WORK VECTOR OF LENGTH 7*(N + 2). ON NORMAL EXIT THE
*/
/*                          FIRST 7 VALUES OF WK ARE ASSIGNED AS FOLLOWS:-*/

/*                           WK(1) = SMOOTHING PARAMETER (= RHO/(RHO + 1)) */
/*                           WK(2) = ESTIMATE OF THE NUMBER OF DEGREES OF */
/*                                  FREEDOM OF THE RESIDUAL SUM OF SQUARES*/
/*                           WK(3) = GENERALIZED CROSS VALIDATION */
/*                           WK(4) = MEAN SQUARE RESIDUAL */
/*                          WK(5) = ESTIMATE OF THE TRUE MEAN SQUARE ERROR*/
/*                                   AT THE DATA POINTS */
/*                           WK(6) = ESTIMATE OF THE ERROR VARIANCE */
/*                           WK(7) = MEAN SQUARE VALUE OF THE DF(I) */

/*                          IF WK(1)=0 (RHO=0) AN INTERPOLATING NATURAL CUBIC
*/
/*                           SPLINE HAS BEEN CALCULATED. */
/*                           IF WK(1)=1 (RHO=INFINITE) A LEAST SQUARES */
/*                           REGRESSION LINE HAS BEEN CALCULATED. */
/*                          WK(2) IS AN ESTIMATE OF THE NUMBER OF DEGREES OF*/
/*                           FREEDOM OF THE RESIDUAL WHICH REDUCES TO THE */
/*                          USUAL VALUE OF N-2 WHEN A LEAST SQUARES REGRESSION
*/
/*                           LINE IS CALCULATED. */
/*                          WK(3),WK(4),WK(5) ARE CALCULATED WITH THE DF(I)*/
/*                           SCALED TO HAVE MEAN SQUARE VALUE 1.  THE */
/*                           UNSCALED VALUES OF WK(3),WK(4),WK(5) MAY BE */
/*                           CALCULATED BY DIVIDING BY WK(7). */
/*                          WK(6) COINCIDES WITH THE OUTPUT VALUE OF VAR IF*/
/*                          VAR IS NEGATIVE ON INPUT.  IT IS CALCULATED WITH*/
/*                          THE UNSCALED VALUES OF THE DF(I) TO FACILITATE*/
/*                           COMPARISONS WITH A PRIORI VARIANCE ESTIMATES. */

/*                IER    - ERROR PARAMETER. (OUTPUT) */
/*                         TERMINAL ERROR */
/*                           IER = 129, IC IS LESS THAN N-1. */
/*                           IER = 130, N IS LESS THAN 3. */
/*                           IER = 131, INPUT ABSCISSAE ARE NOT */
/*                             ORDERED SO THAT X(I).LT.X(I+1). */
/*                           IER = 132, DF(I) IS NOT POSITIVE FOR SOME I. */
/*                           IER = 133, JOB IS NOT 0 OR 1. */

/*   PRECISION/HARDWARE  - DOUBLE */

/*   REQUIRED ROUTINES   - SPINT1,SPFIT1,SPCOF1,SPERR1 */

/*   REMARKS      THE NUMBER OF ARITHMETIC OPERATIONS REQUIRED BY THE */
/*                SUBROUTINE IS PROPORTIONAL TO N.  THE SUBROUTINE */
/*                USES AN ALGORITHM DEVELOPED BY M.F. HUTCHINSON AND */
/*                F.R. DE HOOG, 'SMOOTHING NOISY DATA WITH SPLINE */
/*                FUNCTIONS', NUMER. MATH. (IN PRESS) */

/* ----------------------------------------------------------------------- */

/* Subroutine */ int cubgcv_(doublereal *x, doublereal *f, doublereal *df, 
	integer *n, doublereal *y, doublereal *c, integer *ic, doublereal *
	var, integer *job, doublereal *se, doublereal *wk, integer *ier)
{
    /* Initialized data */

    static doublereal ratio = 2.;
    static doublereal tau = 1.618033989;
    static doublereal zero = 0.;
    static doublereal one = 1.;

    /* System generated locals */
    integer c_dim1, c_offset, wk_dim1, wk_offset, i__1;

    /* Local variables */
    doublereal avdf, avar, stat[6];
    integer i;
    doublereal p, q, delta, r1, r2, r3, r4;
    extern /* Subroutine */ int spcof1_(doublereal *, doublereal *, 
	    doublereal *, doublereal *, integer *, doublereal *, doublereal *,
	     doublereal *, doublereal *, integer *, doublereal *, doublereal *
	    ), spfit1_(doublereal *, doublereal *, doublereal *, integer *, 
	    doublereal *, doublereal *, doublereal *, doublereal *, 
	    doublereal *, doublereal *, doublereal *, doublereal *, integer *,
	     doublereal *, doublereal *, doublereal *, doublereal *), sperr1_(
	    doublereal *, doublereal *, doublereal *, integer *, doublereal *,
	     doublereal *, doublereal *, doublereal *), spint1_(doublereal *, 
	    doublereal *, doublereal *, doublereal *, doublereal *, integer *,
	     doublereal *, doublereal *, integer *, doublereal *, doublereal *
	    , integer *);
    doublereal gf1, gf2, gf3, gf4, avh, err;


/* ---SPECIFICATIONS FOR ARGUMENTS--- */

/* ---SPECIFICATIONS FOR LOCAL VARIABLES--- */

    /* Parameter adjustments */
    wk_dim1 = *n + 2;
    wk_offset = wk_dim1;
    wk -= wk_offset;
    --se;
    c_dim1 = *ic;
    c_offset = c_dim1 + 1;
    c -= c_offset;
    --y;
    --df;
    --f;
    --x;

    /* Function Body */

/* ---INITIALIZE--- */
    *ier = 133;
    if (*job < 0 || *job > 1) {
	goto L140;
    }
    spint1_(&x[1], &avh, &f[1], &df[1], &avdf, n, &y[1], &c[c_offset], ic, &
	    wk[wk_offset], &wk[wk_dim1 * 4], ier);
    if (*ier != 0) {
	goto L140;
    }
    avar = *var;
    if (*var > zero) {
	avar = *var * avdf * avdf;
    }

/* ---CHECK FOR ZERO VARIANCE--- */
    if (*var != zero) {
	goto L10;
    }
    r1 = zero;
    goto L90;

/* ---FIND LOCAL MINIMUM OF GCV OR THE EXPECTED MEAN SQUARE ERROR--- */
L10:
    r1 = one;
    r2 = ratio * r1;
    spfit1_(&x[1], &avh, &df[1], n, &r2, &p, &q, &gf2, &avar, stat, &y[1], &c[
	    c_offset], ic, &wk[wk_offset], &wk[wk_dim1 * 4], &wk[wk_dim1 * 6],
	     &wk[wk_dim1 * 7]);
L20:
    spfit1_(&x[1], &avh, &df[1], n, &r1, &p, &q, &gf1, &avar, stat, &y[1], &c[
	    c_offset], ic, &wk[wk_offset], &wk[wk_dim1 * 4], &wk[wk_dim1 * 6],
	     &wk[wk_dim1 * 7]);
    if (gf1 > gf2) {
	goto L30;
    }

/* ---EXIT IF P ZERO--- */
    if (p <= zero) {
	goto L100;
    }
    r2 = r1;
    gf2 = gf1;
    r1 /= ratio;
    goto L20;
L30:
    r3 = ratio * r2;
L40:
    spfit1_(&x[1], &avh, &df[1], n, &r3, &p, &q, &gf3, &avar, stat, &y[1], &c[
	    c_offset], ic, &wk[wk_offset], &wk[wk_dim1 * 4], &wk[wk_dim1 * 6],
	     &wk[wk_dim1 * 7]);
    if (gf3 > gf2) {
	goto L50;
    }

/* ---EXIT IF Q ZERO--- */
    if (q <= zero) {
	goto L100;
    }
    r2 = r3;
    gf2 = gf3;
    r3 = ratio * r3;
    goto L40;
L50:
    r2 = r3;
    gf2 = gf3;
    delta = (r2 - r1) / tau;
    r4 = r1 + delta;
    r3 = r2 - delta;
    spfit1_(&x[1], &avh, &df[1], n, &r3, &p, &q, &gf3, &avar, stat, &y[1], &c[
	    c_offset], ic, &wk[wk_offset], &wk[wk_dim1 * 4], &wk[wk_dim1 * 6],
	     &wk[wk_dim1 * 7]);
    spfit1_(&x[1], &avh, &df[1], n, &r4, &p, &q, &gf4, &avar, stat, &y[1], &c[
	    c_offset], ic, &wk[wk_offset], &wk[wk_dim1 * 4], &wk[wk_dim1 * 6],
	     &wk[wk_dim1 * 7]);

/* ---GOLDEN SECTION SEARCH FOR LOCAL MINIMUM--- */
L60:
    if (gf3 > gf4) {
	goto L70;
    }
    r2 = r4;
    gf2 = gf4;
    r4 = r3;
    gf4 = gf3;
    delta /= tau;
    r3 = r2 - delta;
    spfit1_(&x[1], &avh, &df[1], n, &r3, &p, &q, &gf3, &avar, stat, &y[1], &c[
	    c_offset], ic, &wk[wk_offset], &wk[wk_dim1 * 4], &wk[wk_dim1 * 6],
	     &wk[wk_dim1 * 7]);
    goto L80;
L70:
    r1 = r3;
    gf1 = gf3;
    r3 = r4;
    gf3 = gf4;
    delta /= tau;
    r4 = r1 + delta;
    spfit1_(&x[1], &avh, &df[1], n, &r4, &p, &q, &gf4, &avar, stat, &y[1], &c[
	    c_offset], ic, &wk[wk_offset], &wk[wk_dim1 * 4], &wk[wk_dim1 * 6],
	     &wk[wk_dim1 * 7]);
L80:
    err = (r2 - r1) / (r1 + r2);
    if (err * err + one > one && err > 1e-6) {
	goto L60;
    }
    r1 = (r1 + r2) * .5;

/* ---CALCULATE SPLINE COEFFICIENTS--- */
L90:
    spfit1_(&x[1], &avh, &df[1], n, &r1, &p, &q, &gf1, &avar, stat, &y[1], &c[
	    c_offset], ic, &wk[wk_offset], &wk[wk_dim1 * 4], &wk[wk_dim1 * 6],
	     &wk[wk_dim1 * 7]);
L100:
    spcof1_(&x[1], &avh, &f[1], &df[1], n, &p, &q, &y[1], &c[c_offset], ic, &
	    wk[wk_dim1 * 6], &wk[wk_dim1 * 7]);

/* ---OPTIONALLY CALCULATE STANDARD ERROR ESTIMATES--- */
    if (*var >= zero) {
	goto L110;
    }
    avar = stat[5];
    *var = avar / (avdf * avdf);
L110:
    if (*job == 1) {
	sperr1_(&x[1], &avh, &df[1], n, &wk[wk_offset], &p, &avar, &se[1]);
    }

/* ---UNSCALE DF--- */
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	df[i] *= avdf;
/* L120: */
    }

/* --PUT STATISTICS IN WK--- */
    for (i = 0; i <= 5; ++i) {
	wk[i + wk_dim1] = stat[i];
/* L130: */
    }
    wk[wk_dim1 + 5] = stat[5] / (avdf * avdf);
    wk[wk_dim1 + 6] = avdf * avdf;
    goto L150;

/* ---CHECK FOR ERROR CONDITION--- */
L140:
/*     IF (IER.NE.0) CONTINUE */
L150:
    return 0;
} /* cubgcv_ */

/* Subroutine */ int spint1_(doublereal *x, doublereal *avh, doublereal *y, 
	doublereal *dy, doublereal *avdy, integer *n, doublereal *a, 
	doublereal *c, integer *ic, doublereal *r, doublereal *t, integer *
	ier)
{
    /* Initialized data */

    static doublereal zero = 0.;

    /* System generated locals */
    integer c_dim1, c_offset, r_dim1, r_offset, t_dim1, t_offset, i__1;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    doublereal e, f, g, h;
    integer i;


/* INITIALIZES THE ARRAYS C, R AND T FOR ONE DIMENSIONAL CUBIC */
/* SMOOTHING SPLINE FITTING BY SUBROUTINE SPFIT1.  THE VALUES */
/* DF(I) ARE SCALED SO THAT THE SUM OF THEIR SQUARES IS N */
/* AND THE AVERAGE OF THE DIFFERENCES X(I+1) - X(I) IS CALCULATED */
/* IN AVH IN ORDER TO AVOID UNDERFLOW AND OVERFLOW PROBLEMS IN */
/* SPFIT1. */

/* SUBROUTINE SETS IER IF ELEMENTS OF X ARE NON-INCREASING, */
/* IF N IS LESS THAN 3, IF IC IS LESS THAN N-1 OR IF DY(I) IS */
/* NOT POSITIVE FOR SOME I. */

/* ---SPECIFICATIONS FOR ARGUMENTS--- */

/* ---SPECIFICATIONS FOR LOCAL VARIABLES--- */
    /* Parameter adjustments */
    t_dim1 = *n + 2;
    t_offset = t_dim1;
    t -= t_offset;
    r_dim1 = *n + 2;
    r_offset = r_dim1;
    r -= r_offset;
    c_dim1 = *ic;
    c_offset = c_dim1 + 1;
    c -= c_offset;
    --a;
    --dy;
    --y;
    --x;

    /* Function Body */

/* ---INITIALIZATION AND INPUT CHECKING--- */
    *ier = 0;
    if (*n < 3) {
	goto L60;
    }
    if (*ic < *n - 1) {
	goto L70;
    }

/* ---GET AVERAGE X SPACING IN AVH--- */
    g = zero;
    i__1 = *n - 1;
    for (i = 1; i <= i__1; ++i) {
	h = x[i + 1] - x[i];
	if (h <= zero) {
	    goto L80;
	}
	g += h;
/* L10: */
    }
    *avh = g / (*n - 1);

/* ---SCALE RELATIVE WEIGHTS--- */
    g = zero;
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	if (dy[i] <= zero) {
	    goto L90;
	}
	g += dy[i] * dy[i];
/* L20: */
    }
    *avdy = sqrt(g / *n);

    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	dy[i] /= *avdy;
/* L30: */
    }

/* ---INITIALIZE H,F--- */
    h = (x[2] - x[1]) / *avh;
    f = (y[2] - y[1]) / h;

/* ---CALCULATE A,T,R--- */
    i__1 = *n - 1;
    for (i = 2; i <= i__1; ++i) {
	g = h;
	h = (x[i + 1] - x[i]) / *avh;
	e = f;
	f = (y[i + 1] - y[i]) / h;
	a[i] = f - e;
	t[i + t_dim1] = (g + h) * 2. / 3.;
	t[i + (t_dim1 << 1)] = h / 3.;
	r[i + r_dim1 * 3] = dy[i - 1] / g;
	r[i + r_dim1] = dy[i + 1] / h;
	r[i + (r_dim1 << 1)] = -dy[i] / g - dy[i] / h;
/* L40: */
    }

/* ---CALCULATE C = R'*R--- */
    r[*n + (r_dim1 << 1)] = zero;
    r[*n + r_dim1 * 3] = zero;
    r[*n + 1 + r_dim1 * 3] = zero;
    i__1 = *n - 1;
    for (i = 2; i <= i__1; ++i) {
	c[i + c_dim1] = r[i + r_dim1] * r[i + r_dim1] + r[i + (r_dim1 << 1)] *
		 r[i + (r_dim1 << 1)] + r[i + r_dim1 * 3] * r[i + r_dim1 * 3];
	c[i + (c_dim1 << 1)] = r[i + r_dim1] * r[i + 1 + (r_dim1 << 1)] + r[i 
		+ (r_dim1 << 1)] * r[i + 1 + r_dim1 * 3];
	c[i + c_dim1 * 3] = r[i + r_dim1] * r[i + 2 + r_dim1 * 3];
/* L50: */
    }
    return 0;

/* ---ERROR CONDITIONS--- */
L60:
    *ier = 130;
    return 0;
L70:
    *ier = 129;
    return 0;
L80:
    *ier = 131;
    return 0;
L90:
    *ier = 132;
    return 0;
} /* spint1_ */

/* Subroutine */ int spfit1_(doublereal *x, doublereal *avh, doublereal *dy, 
	integer *n, doublereal *rho, doublereal *p, doublereal *q, doublereal 
	*fun, doublereal *var, doublereal *stat, doublereal *a, doublereal *c,
	 integer *ic, doublereal *r, doublereal *t, doublereal *u, doublereal 
	*v)
{
    /* Initialized data */

    static doublereal zero = 0.;
    static doublereal one = 1.;
    static doublereal two = 2.;

    /* System generated locals */
    integer c_dim1, c_offset, r_dim1, r_offset, t_dim1, t_offset, i__1;
    doublereal d__1;

    /* Local variables */
    doublereal e, f, g, h;
    integer i;
    doublereal rho1;


/* FITS A CUBIC SMOOTHING SPLINE TO DATA WITH RELATIVE */
/* WEIGHTING DY FOR A GIVEN VALUE OF THE SMOOTHING PARAMETER */
/* RHO USING AN ALGORITHM BASED ON THAT OF C.H. REINSCH (1967), */
/* NUMER. MATH. 10, 177-183. */

/* THE TRACE OF THE INFLUENCE MATRIX IS CALCULATED USING AN */
/* ALGORITHM DEVELOPED BY M.F.HUTCHINSON AND F.R.DE HOOG (NUMER. */
/* MATH., IN PRESS), ENABLING THE GENERALIZED CROSS VALIDATION */
/* AND RELATED STATISTICS TO BE CALCULATED IN ORDER N OPERATIONS. */

/* THE ARRAYS A, C, R AND T ARE ASSUMED TO HAVE BEEN INITIALIZED */
/* BY THE SUBROUTINE SPINT1.  OVERFLOW AND UNDERFLOW PROBLEMS ARE */
/* AVOIDED BY USING P=RHO/(1 + RHO) AND Q=1/(1 + RHO) INSTEAD OF */
/* RHO AND BY SCALING THE DIFFERENCES X(I+1) - X(I) BY AVH. */

/* THE VALUES IN DF ARE ASSUMED TO HAVE BEEN SCALED SO THAT THE */
/* SUM OF THEIR SQUARED VALUES IS N.  THE VALUE IN VAR, WHEN IT IS */
/* NON-NEGATIVE, IS ASSUMED TO HAVE BEEN SCALED TO COMPENSATE FOR */
/* THE SCALING OF THE VALUES IN DF. */

/* THE VALUE RETURNED IN FUN IS AN ESTIMATE OF THE TRUE MEAN SQUARE */
/* WHEN VAR IS NON-NEGATIVE, AND IS THE GENERALIZED CROSS VALIDATION */
/* WHEN VAR IS NEGATIVE. */

/* ---SPECIFICATIONS FOR ARGUMENTS--- */

/* ---LOCAL VARIABLES--- */
    /* Parameter adjustments */
    t_dim1 = *n + 2;
    t_offset = t_dim1;
    t -= t_offset;
    r_dim1 = *n + 2;
    r_offset = r_dim1;
    r -= r_offset;
    c_dim1 = *ic;
    c_offset = c_dim1 + 1;
    c -= c_offset;
    --a;
    --stat;
    --dy;
    --x;

    /* Function Body */

/* ---USE P AND Q INSTEAD OF RHO TO PREVENT OVERFLOW OR UNDERFLOW--- */
    rho1 = one + *rho;
    *p = *rho / rho1;
    *q = one / rho1;
    if (rho1 == one) {
	*p = zero;
    }
    if (rho1 == *rho) {
	*q = zero;
    }

/* ---RATIONAL CHOLESKY DECOMPOSITION OF P*C + Q*T--- */
    f = zero;
    g = zero;
    h = zero;
    for (i = 0; i <= 1; ++i) {
	r[i + r_dim1] = zero;
/* L10: */
    }
    i__1 = *n - 1;
    for (i = 2; i <= i__1; ++i) {
	r[i - 2 + r_dim1 * 3] = g * r[i - 2 + r_dim1];
	r[i - 1 + (r_dim1 << 1)] = f * r[i - 1 + r_dim1];
	r[i + r_dim1] = one / (*p * c[i + c_dim1] + *q * t[i + t_dim1] - f * 
		r[i - 1 + (r_dim1 << 1)] - g * r[i - 2 + r_dim1 * 3]);
	f = *p * c[i + (c_dim1 << 1)] + *q * t[i + (t_dim1 << 1)] - h * r[i - 
		1 + (r_dim1 << 1)];
	g = h;
	h = *p * c[i + c_dim1 * 3];
/* L20: */
    }

/* ---SOLVE FOR U--- */
    u[0] = zero;
    u[1] = zero;
    i__1 = *n - 1;
    for (i = 2; i <= i__1; ++i) {
	u[i] = a[i] - r[i - 1 + (r_dim1 << 1)] * u[i - 1] - r[i - 2 + r_dim1 *
		 3] * u[i - 2];
/* L30: */
    }
    u[*n] = zero;
    u[*n + 1] = zero;
    for (i = *n - 1; i >= 2; --i) {
	u[i] = r[i + r_dim1] * u[i] - r[i + (r_dim1 << 1)] * u[i + 1] - r[i + 
		r_dim1 * 3] * u[i + 2];
/* L40: */
    }

/* ---CALCULATE RESIDUAL VECTOR V--- */
    e = zero;
    h = zero;
    i__1 = *n - 1;
    for (i = 1; i <= i__1; ++i) {
	g = h;
	h = (u[i + 1] - u[i]) / ((x[i + 1] - x[i]) / *avh);
	v[i] = dy[i] * (h - g);
	e += v[i] * v[i];
/* L50: */
    }
    v[*n] = dy[*n] * (-h);
    e += v[*n] * v[*n];

/* ---CALCULATE UPPER THREE BANDS OF INVERSE MATRIX--- */
    r[*n + r_dim1] = zero;
    r[*n + (r_dim1 << 1)] = zero;
    r[*n + 1 + r_dim1] = zero;
    for (i = *n - 1; i >= 2; --i) {
	g = r[i + (r_dim1 << 1)];
	h = r[i + r_dim1 * 3];
	r[i + (r_dim1 << 1)] = -g * r[i + 1 + r_dim1] - h * r[i + 1 + (r_dim1 
		<< 1)];
	r[i + r_dim1 * 3] = -g * r[i + 1 + (r_dim1 << 1)] - h * r[i + 2 + 
		r_dim1];
	r[i + r_dim1] = r[i + r_dim1] - g * r[i + (r_dim1 << 1)] - h * r[i + 
		r_dim1 * 3];
/* L60: */
    }

/* ---CALCULATE TRACE--- */
    f = zero;
    g = zero;
    h = zero;
    i__1 = *n - 1;
    for (i = 2; i <= i__1; ++i) {
	f += r[i + r_dim1] * c[i + c_dim1];
	g += r[i + (r_dim1 << 1)] * c[i + (c_dim1 << 1)];
	h += r[i + r_dim1 * 3] * c[i + c_dim1 * 3];
/* L70: */
    }
    f += two * (g + h);

/* ---CALCULATE STATISTICS--- */
    stat[1] = *p;
    stat[2] = f * *p;
    stat[3] = *n * e / (f * f);
    stat[4] = e * *p * *p / *n;
    stat[6] = e * *p / f;
    if (*var >= zero) {
	goto L80;
    }
    stat[5] = stat[6] - stat[4];
    *fun = stat[3];
    goto L90;
L80:
/* Computing MAX */
    d__1 = stat[4] - two * *var * stat[2] / *n + *var;
    stat[5] = max(d__1,zero);
    *fun = stat[5];
L90:
    return 0;
} /* spfit1_ */

/* Subroutine */ int sperr1_(doublereal *x, doublereal *avh, doublereal *dy, 
	integer *n, doublereal *r, doublereal *p, doublereal *var, doublereal 
	*se)
{
    /* Initialized data */

    static doublereal zero = 0.;
    static doublereal one = 1.;

    /* System generated locals */
    integer r_dim1, r_offset, i__1;
    doublereal d__1;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    doublereal f, g, h;
    integer i;
    doublereal f1, g1, h1;


/* CALCULATES BAYESIAN ESTIMATES OF THE STANDARD ERRORS OF THE FITTED */
/* VALUES OF A CUBIC SMOOTHING SPLINE BY CALCULATING THE DIAGONAL ELEMENTS
 */
/* OF THE INFLUENCE MATRIX. */

/* ---SPECIFICATIONS FOR ARGUMENTS--- */

/* ---SPECIFICATIONS FOR LOCAL VARIABLES--- */
    /* Parameter adjustments */
    --se;
    r_dim1 = *n + 2;
    r_offset = r_dim1;
    r -= r_offset;
    --dy;
    --x;

    /* Function Body */

/* ---INITIALIZE--- */
    h = *avh / (x[2] - x[1]);
    se[1] = one - *p * dy[1] * dy[1] * h * h * r[r_dim1 + 2];
    r[r_dim1 + 1] = zero;
    r[(r_dim1 << 1) + 1] = zero;
    r[r_dim1 * 3 + 1] = zero;

/* ---CALCULATE DIAGONAL ELEMENTS--- */
    i__1 = *n - 1;
    for (i = 2; i <= i__1; ++i) {
	f = h;
	h = *avh / (x[i + 1] - x[i]);
	g = -f - h;
	f1 = f * r[i - 1 + r_dim1] + g * r[i - 1 + (r_dim1 << 1)] + h * r[i - 
		1 + r_dim1 * 3];
	g1 = f * r[i - 1 + (r_dim1 << 1)] + g * r[i + r_dim1] + h * r[i + (
		r_dim1 << 1)];
	h1 = f * r[i - 1 + r_dim1 * 3] + g * r[i + (r_dim1 << 1)] + h * r[i + 
		1 + r_dim1];
	se[i] = one - *p * dy[i] * dy[i] * (f * f1 + g * g1 + h * h1);
/* L10: */
    }
    se[*n] = one - *p * dy[*n] * dy[*n] * h * h * r[*n - 1 + r_dim1];

/* ---CALCULATE STANDARD ERROR ESTIMATES--- */
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
/* Computing MAX */
	d__1 = se[i] * *var;
	se[i] = sqrt((max(d__1,zero))) * dy[i];
/* L20: */
    }
    return 0;
} /* sperr1_ */

/* Subroutine */ int spcof1_(doublereal *x, doublereal *avh, doublereal *y, 
	doublereal *dy, integer *n, doublereal *p, doublereal *q, doublereal *
	a, doublereal *c, integer *ic, doublereal *u, doublereal *v)
{
    /* System generated locals */
    integer c_dim1, c_offset, i__1;

    /* Local variables */
    doublereal h;
    integer i;
    doublereal qh;


/* CALCULATES COEFFICIENTS OF A CUBIC SMOOTHING SPLINE FROM */
/* PARAMETERS CALCULATED BY SUBROUTINE SPFIT1. */

/* ---SPECIFICATIONS FOR ARGUMENTS--- */

/* ---SPECIFICATIONS FOR LOCAL VARIABLES--- */

/* ---CALCULATE A--- */
    /* Parameter adjustments */
    c_dim1 = *ic;
    c_offset = c_dim1 + 1;
    c -= c_offset;
    --a;
    --dy;
    --y;
    --x;

    /* Function Body */
    qh = *q / (*avh * *avh);
    i__1 = *n;
    for (i = 1; i <= i__1; ++i) {
	a[i] = y[i] - *p * dy[i] * v[i];
	u[i] = qh * u[i];
/* L10: */
    }

/* ---CALCULATE C--- */
    i__1 = *n - 1;
    for (i = 1; i <= i__1; ++i) {
	h = x[i + 1] - x[i];
	c[i + c_dim1 * 3] = (u[i + 1] - u[i]) / (h * 3.);
	c[i + c_dim1] = (a[i + 1] - a[i]) / h - (h * c[i + c_dim1 * 3] + u[i])
		 * h;
	c[i + (c_dim1 << 1)] = u[i];
/* L20: */
    }
    return 0;
} /* spcof1_ */

