#include "matrixtmp-new.h"
#include "matrix-new.h"
#include "api.h"

#include <math.h>
#include <stdlib.h>
#include <vector>

#define SWAP(a,b) {double swap=(a);(a)=(b);(b)=swap;}

#define D2R				0.017453292519943 
#define EXLARGE			1.e32

#pragma warning(disable: 4244)
#pragma warning(disable: 4715)
#pragma warning(disable: 4018)

static
void *num2_sphd(void *ctx, int nargs, void **args)
{
	if (nargs<3) api_input_error(ctx);
	zoMatrixTmp<double> *me=reinterpret_cast<zoMatrixTmp<double>*>(api_get_user(ctx,args[0],MAT_DOUBLE));
	double ys=api_get_number(ctx,args[1]);
	double xs=api_get_number(ctx,args[2]);

	if (me->ncol()!=2 || me->nrow()<2 ||
		ys<-90 || ys>90 ||
		xs<-180 || xs>360) api_input_error(ctx);

	zoMatrixTmp<double> *p=new zoMatrixTmp<double>;
	p->resize(me->nrow(),1);
	ys*=D2R;
	xs*=D2R;

	for (size_t i=0; i<me->nrow(); i++) {
		double yf=(*me)(i,0)*D2R;
		double xf=(*me)(i,1)*D2R;
		double cos_ys=cos(ys);
		double cos_yf=cos(yf);
		double sin_ys=sin(ys);
		double sin_yf=sin(yf);
		double cos_dx=cos(xf-xs);
		double sin_dx=sin(xf-xs);
		double a=cos_yf*sin_dx;
		double b=cos_ys*sin_yf-sin_ys*cos_yf*cos_dx;
		double c=sqrt(a*a+b*b);
		double d=sin_ys*sin_yf+cos_ys*cos_yf*cos_dx;
		(*p)(i)=atan2(c,d);
	}

	return api_create_user(ctx,p,mat_opfunc_double,mat_destroy_double,MAT_DOUBLE);
}

static
void *num2_dwsm(void *ctx, int nargs, void **args)
{
	if (nargs<3) api_input_error(ctx);
	zoMatrixTmp<double> *me=reinterpret_cast<zoMatrixTmp<double>*>(api_get_user(ctx,args[0],MAT_DOUBLE));
	zoMatrixTmp<double> *ds=reinterpret_cast<zoMatrixTmp<double>*>(api_get_user(ctx,args[1],MAT_DOUBLE));
	int np=api_get_integer(ctx,args[2]);
	double rt=0.001;
	if (nargs>3) rt=api_get_number(ctx,args[3]);

	if (me->ndat()!=ds->ndat() ||
		np<1 || np>me->ndat() ||
		rt<1.e-9 || rt>0.9) api_input_error(ctx);

	std::vector<size_t> idx(me->ndat());
	std::vector<double> wgt(np);
	double v=0.0;

	HeapSort(ds->ptr(),&idx[0],ds->ndat(),1);

	if ((*ds)(np-1)==0.0) {
		for (int i=0; i<np; i++) {
			v+=(*me)(i);
		}
		v/=np;
	}
	else {
		rt=log(rt)/(*ds)(np-1);
		double w=0.0;
		for (int i=0; i<np; i++) {
			wgt[i]=exp(rt*(*ds)(i));
			w+=wgt[i];
		}
		for (int i=0; i<np; i++) {
			wgt[i]/=w;
			v+=wgt[i]*(*me)(idx[i]);
		}
	}

	return api_create_real(ctx,v);
}

static
void* num2_imgacc(void *ctx, int nargs, void** args)
{
	if (nargs < 4) api_input_error(ctx);
	zoMatrixTmp<double> *me = reinterpret_cast<zoMatrixTmp<double>*>(api_get_user(ctx, args[0], MAT_DOUBLE));
	zoMatrixTmp<unsigned char> *r = reinterpret_cast<zoMatrixTmp<unsigned char>*>(api_get_user(ctx, args[1], MAT_UCHAR));
	zoMatrixTmp<unsigned char> *g = reinterpret_cast<zoMatrixTmp<unsigned char>*>(api_get_user(ctx, args[2], MAT_UCHAR));
	zoMatrixTmp<unsigned char> *b = reinterpret_cast<zoMatrixTmp<unsigned char>*>(api_get_user(ctx, args[3], MAT_UCHAR));
	
	if (r->ndat()!=g->ndat() ||r->ndat()!=b->ndat()) api_runtime_error(ctx, "color matrixes have different length");
	if (me->ndat()<256*256*256) api_runtime_error(ctx, "spectrum matrix length < 256*256*256");

	for (int i=0; i<r->ndat(); i++) {
		int k=(*r)(i)*65536+(*g)(i)*256+(*b)(i);
		(*me)(k)++;
	}
	return 0;
}

static
void* num2_imgcnv(void *ctx, int nargs, void** args)
{
	if (nargs < 5) api_input_error(ctx);
	zoMatrixTmp<double> *me = reinterpret_cast<zoMatrixTmp<double>*>(api_get_user(ctx, args[0], MAT_DOUBLE));
	zoMatrixTmp<unsigned char> *r = reinterpret_cast<zoMatrixTmp<unsigned char>*>(api_get_user(ctx, args[1], MAT_UCHAR));
	zoMatrixTmp<unsigned char> *g = reinterpret_cast<zoMatrixTmp<unsigned char>*>(api_get_user(ctx, args[2], MAT_UCHAR));
	zoMatrixTmp<unsigned char> *b = reinterpret_cast<zoMatrixTmp<unsigned char>*>(api_get_user(ctx, args[3], MAT_UCHAR));
	int dxy = api_get_integer(ctx, args[4]);
	
	if (r->ndat()!=g->ndat() ||r->ndat()!=b->ndat()) api_runtime_error(ctx, "color matrixes have different length");
	if (me->ndat()<256*256*256) api_runtime_error(ctx, "spectrum matrix length < 256*256*256");
	if (dxy<1 || dxy>=r->nrow() || dxy>=r->ncol()) api_runtime_error(ctx, "bad sub-image size");

	zoMatrixTmp<double> *p = new zoMatrixTmp<double>;
	p->resize(r->nrow(),r->ncol());
	memset(p->ptr(),0,p->ndat()*sizeof(double));

	zoMatrixTmp<double> ac;
	ac.resize(me->ndat(),1);

	for (int i=dxy; i<r->nrow()-dxy; i++) {
		for (int j=dxy; j<r->ncol()-dxy; j++) {
			memset(ac.ptr(),0,ac.ndat()*sizeof(double));
			for (int ii=i-dxy; ii<=i+dxy; ii++) {
				for (int jj=j-dxy; jj<=j+dxy; jj++) {
					int k=ii*r->ncol()+jj;
					k=(*r)(k)*65536+(*g)(k)*256+(*b)(k);
					ac(k)++;
				}
			}
			double d=0;
			double c=(2*dxy+1)*(2*dxy+1);
			for (int k=0; k<me->ndat(); k++) {
				d+=sqrt((*me)(k)*ac(k)/c);
			}
			(*p)(i,j)=d;
		}
	}

	return api_create_user(ctx, p, mat_opfunc_double, mat_destroy_double, MAT_DOUBLE);
}

static
void* num2_minidx(void *ctx, int nargs, void** args)
{
	if (nargs < 3) api_input_error(ctx);
	zoMatrixTmp<double> *me = reinterpret_cast<zoMatrixTmp<double>*>(api_get_user(ctx, args[0], MAT_DOUBLE));
	int n = api_get_integer(ctx, args[1]);
	double missing = api_get_number(ctx, args[2]);
	
	if (n<2) api_runtime_error(ctx, "window size < 2");
	if (me->ndat()<n) api_runtime_error(ctx, "matrix size is smaller then window size");
	
	zoMatrixTmp<char> *p = new zoMatrixTmp<char>;
	p->resize(me->nrow(),me->ncol());
	p->fill(0,0);

	for (int i=n; i<me->ndat(); i++) {
		double vmin = fabs(missing);
		int k = 0;
		int count = 0;
		for (int j=i-n; j<i; j++) {
			double v = (*me)(j);
			if (missing > 0) {
				if (v < missing) {
					count++;
					if (v < vmin) {
						vmin = v;
						k = j;
					}
				}
			}
			else {
				if (v > missing) {
					count++;
					if (v < vmin) {
						vmin = v;
						k = j;
					}
				}
			}
		}
		if (count > n/2) (*p)(k) = 1;
	}

	return api_create_user(ctx, p, mat_opfunc_char, mat_destroy_char, MAT_CHAR);
}


/////////////////////////////////////////////////////////////////////

class mnumeric2RegNumeric
{
public:
	mnumeric2RegNumeric()
	{
		api_add_primitive("sphd",	MAT_DOUBLE, num2_sphd);
		api_add_primitive("dwsm",	MAT_DOUBLE, num2_dwsm);
		api_add_primitive("imgacc", MAT_DOUBLE, num2_imgacc);
		api_add_primitive("imgcnv", MAT_DOUBLE, num2_imgcnv);
		api_add_primitive("minidx", MAT_DOUBLE, num2_minidx);
	}
};

static mnumeric2RegNumeric regster_numeric2_primitive;
