#include "matrixtmp.h"
#include "matrix.h"
#include "api.h"
#include "gshhs1.5.h"

#include <ctype.h>
#include <vector>

extern char *scan_number(char *p);

void* io_readtext(void *ctx, int nargs, void** args)
{
	if (nargs < 2) api_input_error(ctx);
	zoDOUBLE *me = reinterpret_cast<zoDOUBLE*>(api_get_user(ctx, args[0], MAT_DOUBLE));

	FILE *f = fopen(api_get_string(ctx, args[1]), "r");
	if (!f) api_runtime_error(ctx, "failed to open file");

	std::vector<double> tmp;
	int nrow = 0, ncol = 0;

	while (!feof(f)) {
		char buf[8192];
		if (!fgets(buf, 8190, f)) continue;
		char *tok = &buf[0];
		char *cur = &buf[0];
		int i = 0;
		while (cur[i]) {
			// csv
			if (cur[i] == ',') cur[i] = ' ';
			i++;
		}
		cur = &buf[0];
		bool flag = false;
		while (cur = scan_number(cur)) {
			if (!isspace(tok[0])) {
				int n = cur-tok;
				char str[64];
				strncpy(str, tok, n);
				str[n] = 0;
				tmp.push_back(atof(str));
				if (nrow == 0) ncol++;
				flag = true;
			}
			tok = cur;
		}
		if (flag && strlen(tok) == 0) nrow++;
	}
	fclose(f);

	if (nrow == 0) return 0;

	if (nrow * ncol != tmp.size()) api_runtime_error(ctx, "failed to read numbers");

	me->resize(nrow, ncol);
	nrow *= ncol;
	for (int i = 0; i < nrow; i++) (*me)(i) = tmp[i];

	return 0;
}
static zsRegPrimitive io1("readtext", MAT_DOUBLE, io_readtext);


void* io_readgshhs(void *ctx, int nargs, void** args)
{
	if (nargs < 3) api_input_error(ctx);
	zoDOUBLE *me = reinterpret_cast<zoDOUBLE*>(api_get_user(ctx, args[0], MAT_DOUBLE));

	FILE *fp = fopen(api_get_string(ctx, args[1]), "rb");
	if (!fp) api_runtime_error(ctx, "failed to open file");

	GSHHS_XY p, pm = {-360000000, -360000000};
	GSHHS1 h1;
	GSHHS3 h3;
	void *h = (void*)&h1;

	fread((void*)&h3, sizeof(GSHHS3), 1, fp);
	fseek(fp, 0, SEEK_SET);

	int west = 0, east = 360000000, south = -90000000, north = 90000000;
	int n, level, version = swabi4((unsigned int)h3.version);
	size_t size = sizeof(GSHHS1);

	if (version == 3) {
		h = (void*)&h3;
		size = sizeof(GSHHS3);
	}

	const char* str = api_get_string(ctx, args[2]);

	if      (!strcmp(str, "land"))   level = 1;
	else if (!strcmp(str, "lake"))   level = 2;
	else if (!strcmp(str, "island")) level = 3;
	else if (!strcmp(str, "pond"))   level = 4;
	else api_input_error(ctx);

	if (nargs > 3 && api_is_string(args[3])) {

		void *func = api_get_func(ctx, api_get_string(ctx, args[3]));

		while (fread(h, size, 1, fp) == 1) {

			void *params[4];

			short greenwich;

			if (version == 3) {
				n = swabi4((unsigned int)h3.n);
				if (swabi4((unsigned int)h3.level) != level) {
					fseek(fp, sizeof(GSHHS_XY)*n, SEEK_CUR);
					continue;
				}
				west = swabi4((unsigned int)h3.west);
				east = swabi4((unsigned int)h3.east);
				south = swabi4((unsigned int)h3.south);
				north = swabi4((unsigned int)h3.north);
				greenwich = swabi2((unsigned short)h3.greenwich);
			}
			else {
				n = swabi4((unsigned int)h1.n);
				if (swabi4((unsigned int)h1.level) != level) {
					fseek(fp, sizeof(GSHHS_XY)*n, SEEK_CUR);
					continue;
				}
				west = swabi4((unsigned int)h1.west);
				east = swabi4((unsigned int)h1.east);
				south = swabi4((unsigned int)h1.south);
				north = swabi4((unsigned int)h1.north);
				greenwich = swabi2((unsigned short)h1.greenwich);
			}

			me->resize(n, 2);

			for (size_t k = 0; k < n; k++) {
				if (fread((void*)&p, sizeof(GSHHS_XY), 1, fp) != 1) api_runtime_error(ctx, "failed to read gshhs data");
				(*me)(k, 0) = 1.e-6*int(swabi4((unsigned int)p.x));
				(*me)(k, 1) = 1.e-6*int(swabi4((unsigned int)p.y));
				if (greenwich == 1 && (*me)(k,0) > 200) (*me)(k,0) += -360;
			}

			params[0] = api_create_real(ctx, 1.e-6*west);
			params[1] = api_create_real(ctx, 1.e-6*east);
			params[2] = api_create_real(ctx, 1.e-6*south);
			params[3] = api_create_real(ctx, 1.e-6*north);

			api_call_func(ctx, func, 4, params);
		}

		fclose(fp);
		return 0;
	}

	if (nargs > 6) {
		west  = api_get_integer(ctx, args[3]) * 1000000;
		east  = api_get_integer(ctx, args[4]) * 1000000;
		south = api_get_integer(ctx, args[5]) * 1000000;
		north = api_get_integer(ctx, args[6]) * 1000000;
	}

	int flag = 0;
	if (nargs > 7) flag = api_get_integer(ctx, args[7]);

	if (west >= east ||
		south >= north ||
		west < 0 ||
		east >  360000000 ||
		south < -90000000 ||
		north >  90000000) api_input_error(ctx);

	std::vector<GSHHS_XY> xy;
	xy.reserve(1024);

	while (fread(h, size, 1, fp) == 1) {
		if (version == 3) {
			n = swabi4((unsigned int)h3.n);
			h3.level = swabi4((unsigned int)h3.level);
			h3.west = swabi4((unsigned int)h3.west);
			h3.east = swabi4((unsigned int)h3.east);
			h3.south = swabi4((unsigned int)h3.south);
			h3.north = swabi4((unsigned int)h3.north);
			if (h3.level != level || h3.west > east || h3.east < west || h3.south > north || h3.north < south) {
				fseek(fp, sizeof(GSHHS_XY)*n, SEEK_CUR);
				continue;
			}
		}
		else {
			n = swabi4((unsigned int)h1.n);
			h1.level = swabi4((unsigned int)h1.level);
			h1.west = swabi4((unsigned int)h1.west);
			h1.east = swabi4((unsigned int)h1.east);
			h1.south = swabi4((unsigned int)h1.south);
			h1.north = swabi4((unsigned int)h1.north);
			if (h1.level != level || h1.west > east || h1.east < west || h1.south > north || h1.north < south) {
				fseek(fp, sizeof(GSHHS_XY)*n, SEEK_CUR);
				continue;
			}
		}

		xy.push_back(pm);

		for (int k = 0; k < n; k++) {
			if (fread ((void *)&p, sizeof(struct GSHHS_XY), 1, fp) != 1) api_runtime_error(ctx, "failed to read gshhs data");
			p.x = swabi4 ((unsigned int)p.x);
			p.y = swabi4 ((unsigned int)p.y);
			if (p.x < west ||
				p.x > east ||
				p.y < south ||
				p.y > north) {
				p.x = -360000000;
				p.y = -360000000;
			}
			if (p.y == pm.y) {
				if (xy[xy.size()-1].y !=  pm.y) xy.push_back(p);
			}
			else {
				xy.push_back(p);
			}
		}
	}
	
	size = xy.size();

	if (flag > 0) {
		// get line strips instead of line segments
		me->resize(size, 2);
		for (size_t k = 0; k < size; k++) {
			GSHHS_XY p = xy[k];
			(*me)(k,0) = 1.e-6*p.x;
			(*me)(k,1) = 1.e-6*p.y;
		}
		return 0;
	}

	std::vector<GSHHS_XY> tmp;
	tmp.reserve(2*size);

	level = 0;

	for (size_t k = 0; k < size; k++) {
		if (xy[k].y > -300000000) {
			level++;
			if (level == 2) {
				GSHHS_XY p1 = {xy[k-1].x, xy[k-1].y};
				tmp.push_back(p1);
				GSHHS_XY p2 = {xy[k].x, xy[k].y};
				tmp.push_back(p2);
				if (abs(xy[k].x - xy[k-1].x) > 90000000 ||
					xy[k-1].x >= 180000000 && xy[k].x <= 180000000  ||
					xy[k-1].x <= 180000000 && xy[k].x >= 180000000) {
					tmp.pop_back();
					tmp.pop_back();
					level = 0;
				}
			}
			else if (level == 3) {
				tmp.push_back(tmp[tmp.size()-1]);
				GSHHS_XY p3 = {xy[k].x, xy[k].y};
				tmp.push_back(p3);
				level--;
				if (abs(xy[k].x - xy[k-1].x) > 90000000 ||
					xy[k-1].x >= 180000000 && xy[k].x <= 180000000  ||
					xy[k-1].x <= 180000000 && xy[k].x >= 180000000) {
					tmp.pop_back();
					tmp.pop_back();
					level = 0;
				}
			}
		}
		else {
			level = 0;
		}
	}

	me->resize(tmp.size(), 2);
	for (k = 0; k < tmp.size(); k++) {
		p = tmp[k];
		(*me)(k,0) = 1.e-6*p.x;
		(*me)(k,1) = 1.e-6*p.y;
	}

	fclose(fp);
	return 0;
}
static zsRegPrimitive io2("readgshhs", MAT_DOUBLE, io_readgshhs);