#include "matrixtmp-new.h"
#include "matrix-new.h"
#include "api.h"

#include <ctype.h>
#include <vector>

#define MISSING		-1.e32

extern char *scan_number3(char *p);
extern int math_cal2jul(int yy, int mm, int dd);

int parse_string(char *buf, std::vector<double> &v, void *ctx)
{
	char *cur = buf;
	char *tok = cur;
	char str[256];
	int count = 0;

	while (cur = scan_number3(cur)) {
		int n = cur - tok - 1;
		strncpy(str, tok, n);
		str[n] = 0;
		int i, flag = 0;
		for (i = 1; i < n; i++) {
			if (str[i] == ':') {
				if (str[i-1] >= '0' && str[i-1] <= '9') {
					// time
					flag = 1;
					break;
				}
			}
			else if (str[i] == '/' || str[i] == '-') {
				if (str[i-1] >= '0' && str[i-1] <= '9') {
					// date
					flag = 2;
					break;
				}
			}
		}
		if (flag == 0) {
			v.push_back(atof(str));
			count++;
		}
		else {
			int yy = 1900, mm = 1, dd = 1, hr = 0, mn = 0, sc = 0;
			int ymd = 0, hms = 0;
			char *s = str;
			for (i = 1; i < n; i++) {
				if (str[i] == ':') {
					str[i] = 0;
					if (hms == 0)
						hr = atoi(s);
					else if (hms == 1)
						mn = atoi(s);
					else
						sc = atoi(s);
					s = str + i + 1;
					hms++;
				}
				else if (str[i] == '/' || str[i] == '-') {
					str[i] = 0;
					if (ymd == 0)
						yy = atoi(s);
					else if (ymd == 1)
						mm = atoi(s);
					else
						dd = atoi(s);
					s = str + i + 1;
					ymd++;
				}
				else if (str[i] == ' ' || str[i] == '\t') {
					str[i] = 0;
					s = str + i + 1;
				}
			}
			v.push_back(math_cal2jul(yy,mm,dd)+hr/24.0+mn/1440.0+sc/86400.0);
			count++;
		}
		while (cur[0] == ' ' || cur[0] == '\t') {
			cur++;
		}
		if (cur[0] == ',' || cur[0] == '\n') {
			v.push_back(MISSING);
			count++;
			cur++;
		}
		tok = cur;
	}
	return count;
}

void* io_readtext(void *ctx, int nargs, void** args)
{
	if (nargs < 2) api_input_error(ctx);
	zoMatrixTmp<double> *me = reinterpret_cast<zoMatrixTmp<double>*>(api_get_user(ctx, args[0], MAT_DOUBLE));

	FILE *f = fopen(api_get_string(ctx, args[1]), "r");
	if (!f) api_runtime_error(ctx, "failed to open file");

	char buf[10*8192];
	zoMatrixTmp<double> tmp;
	tmp.resize(1048576,1);
	int nrow = 0, ncol = 0, ndat=0;

	if (nargs > 2) {
		// skip lines
		int n = api_get_integer(ctx,args[2]);
		for (int i = 0; i < n; i++) {
			fgets(buf, sizeof(buf)-1, f);
		}
	}

	while (!feof(f)) {
		if (!fgets(buf, sizeof(buf)-2, f)) continue;
		int len = strlen(buf);
		if (len == 0) continue;
		if (buf[0] == '#') continue;
		if (buf[len-1]!='\n') {
			// last line before eof
			buf[len] = '\n';
			buf[len+1] = 0;
		}
		std::vector<double> vec;
		parse_string(buf, vec, ctx);
		if (vec.size() > 0) {
			if (nrow == 0) ncol = vec.size();
			while (vec.size()>tmp.ndat()-ndat) {
				tmp.resize(tmp.ndat()+1048576,1);
			}
			for (size_t k = 0; k < vec.size(); k++) tmp(ndat++)=vec[k];
			nrow++;
		}
	}
	fclose(f);

	if (nrow == 0) return api_create_integer(ctx, 0);

	if (nrow*ncol == ndat) {
		me->resize(nrow, ncol);
	}
	else {
		me->resize(ndat,1);
	}
	for (int i = 0; i < ndat; i++) (*me)(i) = tmp(i);

	return api_create_integer(ctx, ndat);
}

class mioRegPrimitive
{
public:
	mioRegPrimitive()
	{
		api_add_primitive("readtext", MAT_DOUBLE, io_readtext);
	}
};

static mioRegPrimitive regster_matrixio_primitve;

