#include <math.h>
#include <vector>

void* MAT_FUNC(rand)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	long seed = 10;
	if (nargs > 1) seed = abs(api_get_integer(ctx, args[1]));
	seed ^= 123459876;
	size_t i, n = me->ndat();
	for (i = 0; i < n; i++) {
		long m = seed / 127773;
		seed = 16807 * (seed - 127773 * m) - 2836 * m;
		if (seed < 0) seed += 2147483647;
		(*me)(i) = double(seed) / 2147483647;
	}
	return 0;
}
REG_PRIM(rand, 50);


void* MAT_FUNC(cos)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(cos);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(cos, 51);


void* MAT_FUNC(cosh)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(cosh);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(cosh, 52);


void* MAT_FUNC(acos)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(acos);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(acos, 53);


void* MAT_FUNC(sin)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(sin);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(sin, 54);


void* MAT_FUNC(sinh)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(sinh);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(sinh, 55);


void* MAT_FUNC(asin)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(asin);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(asin, 56);


void* MAT_FUNC(tan)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(tan);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(tan, 57);


void* MAT_FUNC(tanh)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(tanh);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(tanh, 58);


void* MAT_FUNC(atan)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(atan);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(atan, 59);


void* MAT_FUNC(atan2)(void *ctx, int nargs, void** args)
{
	if (nargs < 2) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	if (api_get_type(args[1]) == MAT_TYPE) {
		OBJ_TYPE *ma = reinterpret_cast<OBJ_TYPE*>(api_get_ptr(ctx, args[1]));
		if (p->apply2(atan2, *ma) == 0) index_error(ctx);
	}
	else {
		double value = api_get_number(ctx, args[1]);
		p->apply2(atan2, value);
	}
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(atan2, 59a);


void* MAT_FUNC(sqrt)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	for (int i = 0; i < me->ndat(); i++) { if ((*me)(i) < 0) api_runtime_error(ctx, "sqrt(v < 0)"); }
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(sqrt);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(sqrt, 60);


void* MAT_FUNC(exp)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(exp);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(exp, 61);


void* MAT_FUNC(log)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	for (int i = 0; i < me->ndat(); i++) { if ((*me)(i) <= 0) api_runtime_error(ctx, "log(v <= 0)"); }
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(log);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(log, 62);


void* MAT_FUNC(log10)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	for (int i = 0; i < me->ndat(); i++) { if ((*me)(i) <= 0) api_runtime_error(ctx, "log10(v <= 0)"); }
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(log10);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(log10, 63);


void* MAT_FUNC(ceil)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(ceil);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(ceil, 64);


void* MAT_FUNC(floor)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(floor);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(floor, 65);


void* MAT_FUNC(abs)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	p->apply1(fabs);
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(abs, 66);


void* MAT_FUNC(pow)(void *ctx, int nargs, void** args)
{
	if (nargs < 2) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *p = new OBJ_TYPE(*me);
	if (api_get_type(args[1]) == MAT_TYPE) {
		OBJ_TYPE *ma = reinterpret_cast<OBJ_TYPE*>(api_get_ptr(ctx, args[1]));
		if (p->apply2(pow, *ma) == 0) index_error(ctx);
	}
	else {
		double value = api_get_number(ctx, args[1]);
		p->apply2(pow, value);
	}
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(pow, 67);


void* MAT_FUNC(prod)(void *ctx, int nargs, void** args)
{
	if (nargs < 2) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	OBJ_TYPE *m2 = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[1], MAT_TYPE));
	if (!me->concat(*m2)) index_error(ctx);
	return 0;
}
REG_PRIM(prod, 68);


void* MAT_FUNC(cal2jul)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	int m = me->nrow();
	int n = me->ncol();
	if (n < 3) api_input_error(ctx);
	OBJ_TYPE *p = new OBJ_TYPE;
	p->resize(m, 1);
	for (int i = 0; i < m; i++) {
		double d = math_cal2jul((*me)(i, 0), (*me)(i, 1), (*me)(i, 2));
		if (n > 3) {
			d += (*me)(i, 3) / 24.0;
			if (n > 4) d += (*me)(i, 4) / 1440.0;
			if (n > 5) d += (*me)(i, 5) / 86400.0;
		}
		(*p)(i) = d;
	}
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(cal2jul, 69);


void* MAT_FUNC(jul2cal)(void *ctx, int nargs, void** args)
{
	if (nargs < 1) api_input_error(ctx);
	OBJ_TYPE *me = reinterpret_cast<OBJ_TYPE*>(api_get_user(ctx, args[0], MAT_TYPE));
	int n = me->ndat();
	OBJ_TYPE *p = new OBJ_TYPE;
	p->resize(n, 6);
	int i, yy, mm, dd, hh, mn, sc;
	for (i = 0; i < n; i++) {
		double d = (*me)(i);
		d = math_jul2cal(&yy, &mm, &dd, d);
		math_jul2tim(&hh, &mn, &sc, d);
		(*p)(i, 0) = yy;
		(*p)(i, 1) = mm;
		(*p)(i, 2) = dd;
		(*p)(i, 3) = hh;
		(*p)(i, 4) = mn;
		(*p)(i, 5) = sc;
	}
	return api_create_user(ctx, p, OP_FUNC, MAT_DESTROY, MAT_TYPE);
}
REG_PRIM(jul2cal, 70);
