#ifndef __ZO_MATRIX__
#define __ZO_MATRIX__

#ifdef WIN32
#define MAT_API __declspec(dllexport)
#else
#define MAT_API
#endif


class MAT_API zsRegPrimitive
{
public:
	zsRegPrimitive(const char* name, int type, void* func);
};

void MAT_API input_error(void* caller);
void MAT_API index_error(void* caller);
void MAT_API divide_error(void* caller);
void MAT_API operand_error(void* caller);

void MAT_API mat_destroy_CHAR(void* mat);
void MAT_API mat_destroy_UCHAR(void* mat);
void MAT_API mat_destroy_SHORT(void* mat);
void MAT_API mat_destroy_USHORT(void* mat);
void MAT_API mat_destroy_INT(void* mat);
void MAT_API mat_destroy_UINT(void* mat);
void MAT_API mat_destroy_FLOAT(void* mat);
void MAT_API mat_destroy_DOUBLE(void* mat);

void MAT_API *mat_opfunc_CHAR(void *caller, int nargs, void** args);
void MAT_API *mat_opfunc_UCHAR(void *caller, int nargs, void** args);
void MAT_API *mat_opfunc_SHORT(void *caller, int nargs, void** args);
void MAT_API *mat_opfunc_USHORT(void *caller, int nargs, void** args);
void MAT_API *mat_opfunc_INT(void *caller, int nargs, void** args);
void MAT_API *mat_opfunc_UINT(void *caller, int nargs, void** args);
void MAT_API *mat_opfunc_FLOAT(void *caller, int nargs, void** args);
void MAT_API *mat_opfunc_DOUBLE(void *caller, int nargs, void** args);

void mat_clone(void *caller, void* m1, int type1, void* m2, int type2);
void mat_import(void *caller, void* ptr1, int type, void* ptr2);

void MAT_API *mat_create(void *caller, int nargs, void** args);

int math_cal2jul(int yy, int mm, int dd);
double math_jul2cal(int *yy, int *mm, int *dd, double jul);
int math_jul2tim(int *hh, int *mn, int *sc, double jul);

#endif